/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.budget.modular;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.BudgetAssociate;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularIdc;

public class BudgetModular
extends BudgetAssociate {
    private Long budgetPeriodId;
    private Integer budgetPeriod;
    private BudgetDecimal directCostLessConsortiumFna;
    private BudgetDecimal consortiumFna;
    private BudgetDecimal totalDirectCost;
    private BudgetDecimal totalRequestedCost;
    private BudgetDecimal totalFnaRequested;
    private List<BudgetModularIdc> budgetModularIdcs = new ArrayList<BudgetModularIdc>();

    public BudgetModular() {
        this.directCostLessConsortiumFna = new BudgetDecimal(0);
        this.consortiumFna = new BudgetDecimal(0);
        this.totalDirectCost = new BudgetDecimal(0);
    }

    public BudgetModular(Long budgetId, Integer budgetPeriod) {
        this();
        this.setBudgetId(budgetId);
        this.setBudgetPeriod(budgetPeriod);
    }

    public Integer getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public void setBudgetPeriod(Integer budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    public BudgetDecimal getConsortiumFna() {
        return this.consortiumFna;
    }

    public void setConsortiumFna(BudgetDecimal consortiumFna) {
        this.consortiumFna = consortiumFna;
    }

    public BudgetDecimal getDirectCostLessConsortiumFna() {
        return this.directCostLessConsortiumFna;
    }

    public void setDirectCostLessConsortiumFna(BudgetDecimal directCostLessConsortiumFna) {
        this.directCostLessConsortiumFna = directCostLessConsortiumFna;
    }

    public BudgetDecimal getTotalDirectCost() {
        return this.totalDirectCost;
    }

    public void setTotalDirectCost(BudgetDecimal totalDirectCost) {
        this.totalDirectCost = totalDirectCost;
    }

    public BudgetDecimal getTotalFnaRequested() {
        return this.totalFnaRequested;
    }

    public void setTotalFnaRequested(BudgetDecimal totalFnaRequested) {
        this.totalFnaRequested = totalFnaRequested;
    }

    public BudgetDecimal getTotalRequestedCost() {
        return this.totalRequestedCost;
    }

    public void setTotalRequestedCost(BudgetDecimal totalRequestedCost) {
        this.totalRequestedCost = totalRequestedCost;
    }

    public List<BudgetModularIdc> getBudgetModularIdcs() {
        return this.budgetModularIdcs;
    }

    public void setBudgetModularIdcs(List<BudgetModularIdc> budgetModularIdcs) {
        this.budgetModularIdcs = budgetModularIdcs;
    }

    public BudgetModularIdc getBudgetModularIdc(int index) {
        while (this.getBudgetModularIdcs().size() <= index) {
            this.getBudgetModularIdcs().add(new BudgetModularIdc());
        }
        return this.getBudgetModularIdcs().get(index);
    }

    public void calculateAllTotals() {
        this.calculateTotalDirectCost();
        this.calculateTotalFnaRequested();
        this.calculateTotalRequestedCost();
    }

    public void calculateTotalDirectCost() {
        BudgetDecimal totalDirectCost = new BudgetDecimal(0);
        if (this.getDirectCostLessConsortiumFna() != null) {
            totalDirectCost = (BudgetDecimal)totalDirectCost.add(this.getDirectCostLessConsortiumFna());
        }
        if (this.getConsortiumFna() != null) {
            totalDirectCost = (BudgetDecimal)totalDirectCost.add(this.getConsortiumFna());
        }
        this.setTotalDirectCost(totalDirectCost);
    }

    public void calculateTotalFnaRequested() {
        BudgetDecimal fnaRequested = new BudgetDecimal(0);
        for (BudgetModularIdc budgetModularIdc : this.getBudgetModularIdcs()) {
            budgetModularIdc.calculateFundsRequested();
            if (budgetModularIdc.getFundsRequested() == null) continue;
            fnaRequested = (BudgetDecimal)fnaRequested.add(budgetModularIdc.getFundsRequested());
        }
        this.setTotalFnaRequested(fnaRequested);
    }

    public void calculateTotalRequestedCost() {
        BudgetDecimal requestedCost = new BudgetDecimal(0);
        if (this.getTotalDirectCost() != null) {
            requestedCost = (BudgetDecimal)requestedCost.add(this.getTotalDirectCost());
        }
        if (this.getTotalFnaRequested() != null) {
            requestedCost = (BudgetDecimal)requestedCost.add(this.getTotalFnaRequested());
        }
        this.setTotalRequestedCost(requestedCost);
    }

    public void addNewBudgetModularIdc(BudgetModularIdc budgetModularIdc) {
        budgetModularIdc.setBudgetId(this.getBudgetId());
        budgetModularIdc.setBudgetPeriod(this.getBudgetPeriod());
        for (BudgetModularIdc testBudgetModularIdc : this.getBudgetModularIdcs()) {
            if (!testBudgetModularIdc.getIdcRate().equals((Object)budgetModularIdc.getIdcRate()) || !testBudgetModularIdc.getDescription().equals(budgetModularIdc.getDescription())) continue;
            if (testBudgetModularIdc.getIdcBase() == null) {
                testBudgetModularIdc.setIdcBase(budgetModularIdc.getIdcBase());
            } else {
                testBudgetModularIdc.setIdcBase((BudgetDecimal)testBudgetModularIdc.getIdcBase().add(budgetModularIdc.getIdcBase()));
            }
            if (testBudgetModularIdc.getFundsRequested() == null) {
                testBudgetModularIdc.setFundsRequested(budgetModularIdc.getFundsRequested());
            } else {
                testBudgetModularIdc.setFundsRequested((BudgetDecimal)testBudgetModularIdc.getFundsRequested().add(budgetModularIdc.getFundsRequested()));
            }
            return;
        }
        this.getBudgetModularIdcs().add(budgetModularIdc);
    }

    public Long getBudgetPeriodId() {
        return this.budgetPeriodId;
    }

    public void setBudgetPeriodId(Long budgetPeriodId) {
        this.budgetPeriodId = budgetPeriodId;
    }
}

