/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.budget.modular;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetRateAndBase;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModular;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularIdc;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularService;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularSummary;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.ObjectUtils;

public class BudgetModularServiceImpl
implements BudgetModularService {
    private static final String RATE_CLASS_PROPERTY_NAME = "rateClass";
    private static final String RATE_NUMBER_PROPERTY_NAME = "rateNumber";
    private static final BudgetDecimal TDC_NEXT_INCREMENT = new BudgetDecimal(25000);
    private BudgetCalculationService budgetCalculationService;
    private ParameterService parameterService;

    @Override
    public void generateModularPeriod(BudgetPeriod budgetPeriod) {
        if (ObjectUtils.isNull((Object)budgetPeriod.getBudgetModular())) {
            BudgetModular budgetModular = new BudgetModular(budgetPeriod.getBudgetId(), budgetPeriod.getBudgetPeriod());
            budgetModular.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
            budgetPeriod.setBudgetModular(budgetModular);
        }
        budgetPeriod.getBudgetModular().calculateAllTotals();
    }

    @Override
    public BudgetModularSummary generateModularSummary(Budget budget) {
        BudgetModularSummary modularSummary = new BudgetModularSummary();
        BudgetDecimal directCostLessConsortiumFna = new BudgetDecimal(0);
        BudgetDecimal consortiumFna = new BudgetDecimal(0);
        BudgetDecimal totalDirectCost = new BudgetDecimal(0);
        BudgetDecimal totalFnaRequested = new BudgetDecimal(0);
        BudgetDecimal totalRequestedCost = new BudgetDecimal(0);
        ArrayList<BudgetModularIdc> budgetModularIdcs = new ArrayList<BudgetModularIdc>();
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            BudgetModular budgetModular = budgetPeriod.getBudgetModular();
            if (ObjectUtils.isNull((Object)budgetModular)) continue;
            budgetModular.calculateAllTotals();
            directCostLessConsortiumFna = (BudgetDecimal)directCostLessConsortiumFna.add(budgetModular.getDirectCostLessConsortiumFna());
            consortiumFna = (BudgetDecimal)consortiumFna.add(budgetModular.getConsortiumFna());
            totalDirectCost = (BudgetDecimal)totalDirectCost.add(budgetModular.getTotalDirectCost());
            totalFnaRequested = (BudgetDecimal)totalFnaRequested.add(budgetModular.getTotalFnaRequested());
            totalRequestedCost = (BudgetDecimal)totalRequestedCost.add(budgetModular.getTotalRequestedCost());
            budgetModularIdcs.addAll(budgetModular.getBudgetModularIdcs());
        }
        modularSummary.setDirectCostLessConsortiumFna(directCostLessConsortiumFna);
        modularSummary.setConsortiumFna(consortiumFna);
        modularSummary.setTotalDirectCost(totalDirectCost);
        modularSummary.setTotalFnaRequested(totalFnaRequested);
        modularSummary.setTotalRequestedCost(totalRequestedCost);
        modularSummary.setBudgetModularIdcs(budgetModularIdcs);
        return modularSummary;
    }

    @Override
    public void synchModularBudget(Budget budget) {
        if (budget == null) {
            throw new NullPointerException("the budget is null");
        }
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (ObjectUtils.isNull((Object)budgetPeriod.getBudgetModular())) {
                BudgetModular tmpBudgetModular = new BudgetModular(budgetPeriod.getBudgetId(), budgetPeriod.getBudgetPeriod());
                tmpBudgetModular.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
                budgetPeriod.setBudgetModular(tmpBudgetModular);
            }
            BudgetModular budgetModular = budgetPeriod.getBudgetModular();
            budgetModular.setBudgetModularIdcs(new ArrayList<BudgetModularIdc>());
            BudgetDecimal directCostLessConsortiumFna = new BudgetDecimal(0);
            BudgetDecimal consortiumFna = new BudgetDecimal(0);
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                this.budgetCalculationService.calculateBudgetLineItem(budget, budgetLineItem);
                Collection consortiumFnaCostElements = this.parameterService.getParameterValuesAsString(BudgetDocument.class, "consortiumFnaCostElements");
                if (consortiumFnaCostElements.contains(budgetLineItem.getCostElement())) {
                    consortiumFna = (BudgetDecimal)consortiumFna.add(budgetLineItem.getDirectCost());
                } else {
                    directCostLessConsortiumFna = (BudgetDecimal)directCostLessConsortiumFna.add(budgetLineItem.getDirectCost());
                }
                for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
                    budgetRateAndBase.refreshReferenceObject(RATE_CLASS_PROPERTY_NAME);
                    String fnaRateClassType = this.parameterService.getParameterValueAsString(BudgetDocument.class, "fnaRateClassTypeCode");
                    if (!budgetRateAndBase.getRateClass().getRateClassType().equals(fnaRateClassType)) continue;
                    BudgetModularIdc budgetModularIdc = new BudgetModularIdc();
                    budgetModularIdc.setRateNumber(budget.getBudgetDocument().getHackedDocumentNextValue(RATE_NUMBER_PROPERTY_NAME));
                    budgetModularIdc.setDescription(budgetRateAndBase.getRateClassCode());
                    budgetModularIdc.setIdcRate(budgetRateAndBase.getAppliedRate());
                    budgetModularIdc.setFundsRequested(budgetRateAndBase.getCalculatedCost());
                    budgetModularIdc.setIdcBase(budgetRateAndBase.getBaseCost());
                    budgetModular.addNewBudgetModularIdc(budgetModularIdc);
                }
            }
            BudgetDecimal modularTdc = BudgetDecimal.ZERO;
            while (directCostLessConsortiumFna.isGreaterThan(modularTdc)) {
                modularTdc = (BudgetDecimal)modularTdc.add(TDC_NEXT_INCREMENT);
            }
            budgetModular.setDirectCostLessConsortiumFna(modularTdc);
            budgetModular.setConsortiumFna(consortiumFna);
            budgetModular.calculateAllTotals();
        }
    }

    protected List<BudgetModularIdc> generateBudgetModularIdcsForLineItem(BudgetLineItem budgetLineItem) {
        ArrayList<BudgetModularIdc> budgetModularIdcs = new ArrayList<BudgetModularIdc>();
        return budgetModularIdcs;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }
}

