/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.budget.service.impl;

import java.sql.Date;
import java.util.GregorianCalendar;
import org.kuali.kra.proposaldevelopment.budget.service.ProposalBudgetNumberOfMonthsService;

public class ProposalBudgetNumberOfMonthsServiceImpl
implements ProposalBudgetNumberOfMonthsService {
    protected static final double[] THIRTY_ONE_DAY_COUNT = new double[]{0.03, 0.06, 0.1, 0.13, 0.16, 0.19, 0.23, 0.26, 0.29, 0.32, 0.35, 0.39, 0.42, 0.45, 0.48, 0.52, 0.55, 0.58, 0.61, 0.65, 0.68, 0.71, 0.74, 0.77, 0.81, 0.84, 0.87, 0.9, 0.94, 0.97, 1.0};
    protected static final double[] THIRTY_DAY_COUNT = new double[]{0.03, 0.07, 0.1, 0.13, 0.17, 0.2, 0.23, 0.27, 0.3, 0.33, 0.37, 0.4, 0.43, 0.47, 0.5, 0.53, 0.57, 0.6, 0.63, 0.67, 0.7, 0.73, 0.77, 0.8, 0.83, 0.87, 0.9, 0.93, 0.97, 1.0};
    protected static final double[] TWENTY_NINE_DAY_COUNT = new double[]{0.03, 0.07, 0.1, 0.14, 0.17, 0.21, 0.24, 0.28, 0.31, 0.34, 0.38, 0.41, 0.45, 0.48, 0.52, 0.55, 0.59, 0.62, 0.66, 0.69, 0.72, 0.76, 0.79, 0.83, 0.86, 0.9, 0.93, 0.97, 1.0};
    protected static final double[] TWENTY_EIGHT_DAY_COUNT = new double[]{0.04, 0.07, 0.11, 0.14, 0.18, 0.21, 0.25, 0.29, 0.32, 0.36, 0.39, 0.43, 0.46, 0.5, 0.54, 0.57, 0.61, 0.64, 0.68, 0.71, 0.75, 0.79, 0.82, 0.86, 0.89, 0.93, 0.96, 1.0};

    @Override
    public double getNumberOfMonth(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0.0;
        }
        return this.countMonthsStepOne(startDate, endDate);
    }

    protected double countMonthsStepOne(Date startDate, Date endDate) {
        double numberOfMonths = 0.0;
        Date startDateAdded = ProposalBudgetNumberOfMonthsServiceImpl.rollMonths(startDate, 1);
        startDateAdded = ProposalBudgetNumberOfMonthsServiceImpl.rollDays(startDateAdded, -1);
        while (startDateAdded.before(endDate) || startDateAdded.equals(endDate)) {
            startDateAdded = ProposalBudgetNumberOfMonthsServiceImpl.rollDays(startDateAdded, 1);
            numberOfMonths += 1.0;
            startDateAdded = ProposalBudgetNumberOfMonthsServiceImpl.rollMonths(startDateAdded, 1);
            startDateAdded = ProposalBudgetNumberOfMonthsServiceImpl.rollDays(startDateAdded, -1);
        }
        startDateAdded = ProposalBudgetNumberOfMonthsServiceImpl.rollMonths(startDateAdded, -1);
        startDateAdded = ProposalBudgetNumberOfMonthsServiceImpl.rollDays(startDateAdded, 1);
        double numberOfPartialMonths = this.countMonthsStepTwo(startDateAdded, endDate);
        return numberOfMonths + numberOfPartialMonths;
    }

    protected double countMonthsStepTwo(Date startDate, Date endDate) {
        double totalPartialMonthCount = 0.0;
        int yearEnd = endDate.getYear();
        boolean isLeapYear = yearEnd % 4 == 0 && yearEnd % 100 != 0 || yearEnd % 400 == 0;
        Date startDateAdded = ProposalBudgetNumberOfMonthsServiceImpl.rollDays(startDate, 1);
        int previousMonth = startDateAdded.getMonth();
        int previousMonthDayCount = 0;
        while (startDateAdded.before(endDate)) {
            int currentMonth = (startDateAdded = ProposalBudgetNumberOfMonthsServiceImpl.rollDays(startDateAdded, 1)).getMonth();
            if (previousMonth != currentMonth) {
                double[] dailyPercentageArray = this.getMonthDailyPercentageArray(previousMonth, isLeapYear);
                totalPartialMonthCount += dailyPercentageArray[previousMonthDayCount];
                previousMonthDayCount = 0;
            }
            ++previousMonthDayCount;
        }
        if (previousMonthDayCount > 0) {
            double[] dailyPercentageArray = this.getMonthDailyPercentageArray(previousMonth, isLeapYear);
            totalPartialMonthCount += dailyPercentageArray[previousMonthDayCount];
        }
        return totalPartialMonthCount;
    }

    protected final double[] getMonthDailyPercentageArray(int month, boolean isLeapYear) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return THIRTY_ONE_DAY_COUNT;
            }
            case 1: {
                if (isLeapYear) {
                    return TWENTY_NINE_DAY_COUNT;
                }
                return TWENTY_EIGHT_DAY_COUNT;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return THIRTY_DAY_COUNT;
            }
        }
        throw new IllegalArgumentException("Illegal Month '" + month + "' passed in.");
    }

    public static Date rollMonths(Date startDate, int months) {
        return ProposalBudgetNumberOfMonthsServiceImpl.rollDate(startDate, 2, months);
    }

    public static Date rollDays(Date startDate, int days) {
        return ProposalBudgetNumberOfMonthsServiceImpl.rollDate(startDate, 5, days);
    }

    public static Date rollDate(Date startDate, int period, int amount) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(startDate);
        gc.add(period, amount);
        return new Date(gc.getTime().getTime());
    }
}

