/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.document;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalColumnsToAlter;
import org.kuali.kra.service.KraPersistenceStructureService;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalColumnsToAlterMaintainableImpl
extends KraMaintainableImpl {
    private static Map<String, String> validationClassesMap = new HashMap<String, String>();

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        ProposalColumnsToAlter proposalCol = (ProposalColumnsToAlter)this.businessObject;
        KraPersistenceStructureService persistenceStructureService = KraServiceLocator.getService(KraPersistenceStructureService.class);
        Map<String, String> columnToAttrMap = persistenceStructureService.getDBColumnToObjectAttributeMap(DevelopmentProposal.class);
        DataDictionaryService dataDictionaryService = KraServiceLocator.getService(DataDictionaryService.class);
        AttributeDefinition attrDefinition = dataDictionaryService.getDataDictionary().getBusinessObjectEntry(DevelopmentProposal.class.getName()).getAttributeDefinition(columnToAttrMap.get(proposalCol.getColumnName()));
        if (attrDefinition == null) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.columnName", "error.proposalcolumnstoalter.attributeNotFound", new String[0]);
            return;
        }
        if (attrDefinition.getLabel().length() > 30) {
            proposalCol.setColumnLabel(attrDefinition.getLabel().substring(0, 29));
        } else {
            proposalCol.setColumnLabel(attrDefinition.getLabel());
        }
        proposalCol.setDataLength(attrDefinition.getMaxLength());
        String dataType = null;
        if (attrDefinition.getValidationPattern() != null) {
            String validationPattern = attrDefinition.getValidationPattern().getClass().getName();
            dataType = validationClassesMap.get(validationPattern);
            if (dataType == null) {
                dataType = "STRING";
            }
        } else {
            dataType = "STRING";
        }
        proposalCol.setDataType(dataType);
    }

    static {
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.charlevel.AnyCharacterValidationPattern", "STRING");
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaNumericValidationPattern", "STRING");
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaValidationPattern", "STRING");
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.fieldlevel.DateValidationPattern", "DATE");
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.charlevel.NumericValidationPattern", "NUMBER");
    }
}

