/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.document.authorizer;

import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.document.authorization.ProposalTask;
import org.kuali.kra.proposaldevelopment.document.authorizer.ProposalAuthorizer;
import org.kuali.rice.krad.document.Document;

public class ModifyProposalPermissionsAuthorizer
extends ProposalAuthorizer {
    @Override
    public boolean isAuthorized(String userId, ProposalTask task) {
        return this.hasFullAuthorization(userId, task) || this.hasAddViewerAuthorization(userId, task);
    }

    private boolean hasFullAuthorization(String userId, ProposalTask task) {
        ProposalDevelopmentDocument doc = task.getDocument();
        boolean hasPermission = !doc.isViewOnly() && this.hasProposalPermission(userId, doc, "Modify ProposalPermissions") && !this.kraWorkflowService.isInWorkflow((Document)doc) && doc.getDevelopmentProposal().getSubmitFlag() == false;
        return hasPermission;
    }

    private boolean hasAddViewerAuthorization(String userId, ProposalTask task) {
        boolean hasPermission = false;
        ProposalDevelopmentDocument doc = task.getDocument();
        if (this.hasProposalPermission(userId, doc, "Add Proposal Viewer") && this.kraWorkflowService.isInWorkflow((Document)doc)) {
            hasPermission = true;
        } else if (this.kraWorkflowService.hasWorkflowPermission(userId, (Document)doc) && this.kraWorkflowService.isEnRoute((Document)doc)) {
            hasPermission = true;
        }
        return hasPermission;
    }
}

