/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonRole;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KeyValuesService;

public class ProposalPersonRoleValuesFinder
extends KeyValuesBase {
    private String forAddedPerson;
    private ParameterService parameterService;

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public List getKeyValues() {
        Collection roles = this.getKeyValuesService().findAll(ProposalPersonRole.class);
        ProposalDevelopmentDocument document = ((ProposalDevelopmentForm)KNSGlobalVariables.getKualiForm()).getProposalDevelopmentDocument();
        DevelopmentProposal developmentProposal = document.getDevelopmentProposal();
        boolean hasPrincipalInvestigator = this.getKeyPersonnelService().hasPrincipalInvestigator(document);
        ArrayList<ConcreteKeyValue> keyValues = new ArrayList<ConcreteKeyValue>();
        keyValues.add(new ConcreteKeyValue("", "select"));
        for (ProposalPersonRole role : roles) {
            BufferedLogger.info("Adding role ", role.getProposalPersonRoleId());
            BufferedLogger.info("With description ", this.findRoleDescription(role, developmentProposal));
            boolean showRole = true;
            if (this.isPersonAdded().booleanValue()) {
                showRole = !"KP".equals(role.getProposalPersonRoleId());
            }
            BufferedLogger.info("showRole = ", showRole);
            if (showRole) {
                keyValues.add(new ConcreteKeyValue(role.getProposalPersonRoleId(), this.findRoleDescription(role, developmentProposal)));
            }
            BufferedLogger.info("Returning ", keyValues);
        }
        return keyValues;
    }

    protected String getRoleIdPrefix(DevelopmentProposal proposal) {
        return proposal.isSponsorNihMultiplePi() ? "nih." : "";
    }

    protected String findRoleDescription(ProposalPersonRole role, DevelopmentProposal proposal) {
        return this.getParameterService().getParameterValueAsString("KC-GEN", "All", "personrole." + this.getRoleIdPrefix(proposal) + role.getProposalPersonRoleId().toLowerCase());
    }

    private boolean isNewProposalPersonRoleRendered() {
        return ((ProposalDevelopmentForm)KNSGlobalVariables.getKualiForm()).isNewProposalPersonRoleRendered();
    }

    private KeyPersonnelService getKeyPersonnelService() {
        return KraServiceLocator.getService(KeyPersonnelService.class);
    }

    private KeyValuesService getKeyValuesService() {
        return KraServiceLocator.getService(KeyValuesService.class);
    }

    private Boolean isPersonAdded() {
        return new Boolean(this.getForAddedPerson());
    }

    public String getForAddedPerson() {
        return this.forAddedPerson;
    }

    public void setForAddedPerson(String forAddedPerson) {
        this.forAddedPerson = forAddedPerson;
    }
}

