/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.printing.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.SponsorFormTemplate;
import org.kuali.kra.bo.SponsorFormTemplateList;
import org.kuali.kra.bo.SponsorForms;
import org.kuali.kra.bo.SponsorHierarchy;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.AbstractPrint;
import org.kuali.kra.printing.service.PrintingService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.printing.print.PrintCertificationPrint;
import org.kuali.kra.proposaldevelopment.printing.print.ProposalSponsorFormsPrint;
import org.kuali.kra.proposaldevelopment.printing.service.ProposalDevelopmentPrintingService;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProposalDevelopmentPrintingServiceImpl
implements ProposalDevelopmentPrintingService {
    private PrintCertificationPrint printCertificationPrint;
    private ProposalSponsorFormsPrint proposalSponsorFormsPrint;
    private PrintingService printingService;
    private S2SUtilService s2SUtilService;
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private static final String SPONSOR_CODE_DB_KEY = "sponsorCode";
    private static final String PAGE_NUMBER_DB_KEY = "pageNumber";

    @Override
    public AttachmentDataSource printProposalDevelopmentReport(KraPersistableBusinessObjectBase printableBusinessObject, String reportName, Map<String, Object> reportParameters) throws PrintingException {
        AttachmentDataSource source = null;
        AbstractPrint printable = null;
        if (reportName.equals("Print Certification")) {
            printable = this.getPrintCertificationPrint();
        } else if (reportName.equals("Print Proposal Sponsor Forms")) {
            printable = this.getProposalSponsorFormsPrint();
        }
        printable.setPrintableBusinessObject(printableBusinessObject);
        printable.setReportParameters(reportParameters);
        source = this.getPrintingService().print(printable);
        source.setFileName(this.getReportName(printableBusinessObject, reportName));
        source.setContentType("application/pdf");
        return source;
    }

    protected String getReportName(KraPersistableBusinessObjectBase printableBusinessObject, String reportName) {
        DevelopmentProposal developmentProposal = (DevelopmentProposal)printableBusinessObject;
        String proposalNumber = developmentProposal.getProposalNumber();
        StringBuilder reportFullName = new StringBuilder(proposalNumber).append("_").append(reportName.replace(' ', '_')).append(".pdf");
        return reportFullName.toString();
    }

    @Override
    public void populateSponsorForms(List<SponsorFormTemplateList> sponsorFormTemplates, String sponsorCode) {
        if (!sponsorFormTemplates.isEmpty()) {
            if (StringUtils.equalsIgnoreCase((String)sponsorCode, (String)sponsorFormTemplates.get(0).getSponsorForms().getSponsorCode())) {
                sponsorFormTemplates.clear();
            }
            sponsorFormTemplates.clear();
        }
        if (sponsorFormTemplates.isEmpty()) {
            Collection<SponsorFormTemplateList> clsponsorFormTemplates = this.getSponsorTemplatesList(sponsorCode);
            sponsorFormTemplates.addAll(clsponsorFormTemplates);
            if (!this.s2SUtilService.getParameterValue("LOCAL_PRINT_FORM_SPONSOR_CODE").equals(sponsorCode)) {
                String genericSponsorCode = this.s2SUtilService.getParameterValue("GENERIC_SPONSOR_CODE");
                clsponsorFormTemplates = this.getSponsorTemplatesList(genericSponsorCode);
            }
            sponsorFormTemplates.addAll(clsponsorFormTemplates);
        } else {
            this.resetSelectedFormList(sponsorFormTemplates);
        }
        HashSet<SponsorFormTemplateList> set = new HashSet<SponsorFormTemplateList>();
        set.addAll(sponsorFormTemplates);
        sponsorFormTemplates.clear();
        sponsorFormTemplates.addAll(set);
        Collections.sort(sponsorFormTemplates);
    }

    protected Collection<SponsorFormTemplateList> getSponsorTemplatesList(String sponsorCode) {
        HashMap<String, String> sponsorCodeMap = new HashMap<String, String>();
        sponsorCodeMap.put(SPONSOR_CODE_DB_KEY, sponsorCode);
        Collection sponsorForms = this.getBusinessObjectService().findMatching(SponsorForms.class, sponsorCodeMap);
        ArrayList<SponsorFormTemplateList> retval = new ArrayList<SponsorFormTemplateList>();
        for (SponsorForms sponsorForm : sponsorForms) {
            retval.addAll(sponsorForm.getSponsorFormTemplates());
        }
        String hierarchyName = this.getParameterService().getParameterValueAsString("KC-GEN", "All", "SPONSOR_HIERARCHY_FOR_PRINTING");
        sponsorCodeMap.put("hierarchyName", hierarchyName);
        SponsorHierarchy hierarchyEntry = (SponsorHierarchy)this.getBusinessObjectService().findByPrimaryKey(SponsorHierarchy.class, sponsorCodeMap);
        if (hierarchyEntry != null) {
            sponsorCodeMap.clear();
            sponsorCodeMap.put("sponsorHierarchyName", hierarchyEntry.getLevel1());
            sponsorForms = this.getBusinessObjectService().findMatching(SponsorForms.class, sponsorCodeMap);
            for (SponsorForms sponsorForm : sponsorForms) {
                retval.addAll(sponsorForm.getSponsorFormTemplates());
            }
        }
        return retval;
    }

    protected void resetSelectedFormList(List<SponsorFormTemplateList> sponsorFormTemplates) {
        for (SponsorFormTemplateList sponsorFormTemplateList : sponsorFormTemplates) {
            sponsorFormTemplateList.setSelectToPrint(false);
        }
    }

    @Override
    public List<SponsorFormTemplate> getSponsorFormTemplates(List<SponsorFormTemplateList> sponsorFormTemplateLists) {
        ArrayList<SponsorFormTemplate> printFormTemplates = new ArrayList<SponsorFormTemplate>();
        for (SponsorFormTemplateList sponsorFormTemplateList : sponsorFormTemplateLists) {
            if (!sponsorFormTemplateList.getSelectToPrint().booleanValue()) continue;
            printFormTemplates.add((SponsorFormTemplate)this.getBusinessObjectService().findBySinglePrimaryKey(SponsorFormTemplate.class, (Object)sponsorFormTemplateList.getSponsorFormTemplateId()));
        }
        Collections.sort(printFormTemplates);
        this.resetSelectedFormList(sponsorFormTemplateLists);
        return printFormTemplates;
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public PrintCertificationPrint getPrintCertificationPrint() {
        return this.printCertificationPrint;
    }

    public void setPrintCertificationPrint(PrintCertificationPrint printCertificationPrint) {
        this.printCertificationPrint = printCertificationPrint;
    }

    public S2SUtilService getS2SUtilService() {
        return this.s2SUtilService;
    }

    public void setS2SUtilService(S2SUtilService utilService) {
        this.s2SUtilService = utilService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ProposalSponsorFormsPrint getProposalSponsorFormsPrint() {
        return this.proposalSponsorFormsPrint;
    }

    public void setProposalSponsorFormsPrint(ProposalSponsorFormsPrint proposalSponsorFormsPrint) {
        this.proposalSponsorFormsPrint = proposalSponsorFormsPrint;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

