/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.printing.xmlstream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import noNamespace.Certification;
import noNamespace.Investigator;
import noNamespace.OrganizationType;
import noNamespace.PCschoolInfoType;
import noNamespace.PrintCertificationDocument;
import noNamespace.Sponsor;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.ArgValueLookup;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.SponsorHierarchy;
import org.kuali.kra.printing.util.PrintingUtils;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonUnit;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonYnq;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.printing.xmlstream.ProposalBaseStream;

public class PrintCertificationXmlStream
extends ProposalBaseStream {
    private static final String NSF_SPONSOR_CODE = "000100";
    private static final String NSF_SPONSOR_ACRONYM = "NSF";
    private static final String SPONSOR_GROUPS = "SPONSOR GROUPS";
    private static final String PI_QUESTION = "PI_QUESTION";
    private static final String ARGUMENT_NAME = "argumentName";
    private static final String IMAGES_PATH = "/images/";
    private static final String QUESTION_ID_Z6 = "Z6";
    private static final String QUESTION_ID_Z5 = "Z5";
    private static final String QUESTION_ID_Z4 = "Z4";
    private static final String QUESTION_ID_Z3 = "Z3";
    private static final String QUESTION_ID_Z2 = "Z2";
    private static final String QUESTION_ID_Z1 = "Z1";
    private static final String EMPTY_STRING = "";
    private static final String SPONSOR_TYPE_CODE_ZERO = "0";
    private static final String SPONSOR_TYPE_FED = "FED";
    private static final String SPONSOR_TYPE_NONFED = "NONFED";
    private static final String SCHOOL_NAME = "SCHOOL_NAME";
    private static final String SCHOOL_ACRONYM = "SCHOOL_ACRONYM";
    private static final String KEY_ROLODEX_ID = "rolodexId";
    private static final String STATEMENT_CONFLICT = "I have indicated whether or not there is any potential for a real or perceived conflict of interest as defined in MIT Policies and Procedures, 4.4:  http://web.mit.edu/afs/athena.mit.edu/org/p/policies/4.4.html";
    private static final String STATEMENT_CERTIFICATION_NOT_NEEDED = "Certification is not needed";
    private static final String STATEMENT_NIH_PROPOSAL = "For NSF & NIH proposals, only: I have submitted the required financial conflict of interest documentation to the Director, Office of Sponsored Programs: http://web.mit.edu/osp/www/resources_policy.htm";
    private static final String STATEMENT_NOT_DEBARRED = "I am not debarred, suspended or proposed for debarment or suspended by any agency of the U.S. government: http://web.mit.edu/osp/www/debarmen.htm";
    private static final String STATEMENT_FEDERAL_AGENCY_LOBBY = "I certify that I have not and will not lobby any federal agency on behalf of this award: http://web.mit.edu/osp/www/fedlobrg.htm";
    private static final String STATEMENT_REQUIREMENT_FAMILIARITY = "I am familiar with the requirements of the Procurement Integrity Act [OFPP, Section 27 (a-e)] and will report any violations to the Office of Sponsored Programs: http://web.mit.edu/osp/www/Procuint.htm";

    @Override
    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, XmlObject> xmlObjectList = new LinkedHashMap<String, XmlObject>();
        DevelopmentProposal developmentProposal = (DevelopmentProposal)printableBusinessObject;
        ProposalPerson personToPrint = (ProposalPerson)reportParameters.get("Print Certification Person");
        for (ProposalPerson proposalPerson : developmentProposal.getProposalPersons()) {
            if (personToPrint != null && !personToPrint.equals(proposalPerson)) continue;
            PrintCertificationDocument printCertDocument = PrintCertificationDocument.Factory.newInstance();
            PrintCertificationDocument.PrintCertification printCertification = PrintCertificationDocument.PrintCertification.Factory.newInstance();
            printCertification = this.getPrintCertification(developmentProposal, proposalPerson);
            printCertDocument.setPrintCertification(printCertification);
            xmlObjectList.put(this.getPersonName(proposalPerson), (XmlObject)printCertDocument);
        }
        return xmlObjectList;
    }

    private PrintCertificationDocument.PrintCertification getPrintCertification(DevelopmentProposal developmentProposal, ProposalPerson proposalPerson) {
        PrintCertificationDocument.PrintCertification printCertification = PrintCertificationDocument.PrintCertification.Factory.newInstance();
        printCertification.setProposalNumber(developmentProposal.getProposalNumber());
        printCertification.setProposalTitle(developmentProposal.getTitle());
        printCertification.setInvestigator(this.getInvestigator(proposalPerson));
        Sponsor sponsor = this.getSponsor(developmentProposal.getSponsorCode(), developmentProposal.getPrimeSponsorCode(), developmentProposal.getSponsorName(), developmentProposal.getSponsor());
        printCertification.setSponsor(sponsor);
        printCertification.setSchoolInfo(this.getSchoolInfoType());
        printCertification.setOrganizationInfo(this.getOrganizationType(developmentProposal.getApplicantOrganization()));
        Certification[] certifications = this.getCertifications(proposalPerson.getProposalPersonYnqs(), developmentProposal.getSponsor().getSponsorTypeCode(), developmentProposal.getSponsorCode(), developmentProposal.getPrimeSponsorCode());
        printCertification.setCertificationsArray(certifications);
        printCertification.setLogoPath(IMAGES_PATH);
        printCertification.setCurrentDate(this.getDateTimeService().getCurrentCalendar());
        printCertification.setOfficeName(this.getOfficeName(proposalPerson));
        return printCertification;
    }

    private String getOfficeName(ProposalPerson proposalPerson) {
        String officeName = EMPTY_STRING;
        for (ProposalPersonUnit proposalPersonUnit : proposalPerson.getUnits()) {
            if (proposalPerson.getPerson() == null || proposalPersonUnit.getUnit() == null || !proposalPersonUnit.isLeadUnit() || proposalPersonUnit.getUnit().getUnitName() == null) continue;
            officeName = proposalPersonUnit.getUnit().getUnitName();
            break;
        }
        return officeName;
    }

    private Certification[] getCertifications(List<ProposalPersonYnq> proposalPersonYnqs, String sponsorTypeCode, String sponsorCode, String primeSponsorCode) {
        ArrayList<Certification> certificationList = new ArrayList<Certification>();
        int statementNumber = 1;
        for (ProposalPersonYnq proposalPersonYnq : proposalPersonYnqs) {
            if (proposalPersonYnq.getQuestionId() == null) continue;
            Certification certification = Certification.Factory.newInstance();
            certification.setQuestionID(proposalPersonYnq.getQuestionId());
            if (proposalPersonYnq.getAnswer() != null) {
                certification.setAnswer(proposalPersonYnq.getAnswer());
            }
            certificationList.add(certification);
        }
        List<String> questionIds = this.getQuestionIdsForCertification(sponsorTypeCode, sponsorCode, primeSponsorCode);
        for (String questionId : questionIds) {
            Certification certification = Certification.Factory.newInstance();
            String statement = this.getStatementForCertification(questionId);
            certification.setStmtNumber(statementNumber++);
            certification.setStatement(statement);
            certificationList.add(certification);
        }
        return certificationList.toArray(new Certification[0]);
    }

    private List<String> getQuestionIdsForCertification(String sponsorTypeCode, String sponsorCode, String primeSponsorCode) {
        ArrayList<String> questionIds = new ArrayList<String>();
        String primSponsorTypeCode = this.getSponsorTypeCodeFromSponsor(primeSponsorCode);
        List<String> questionIdsList = this.getQuestionIdsFromArgValueLookup();
        if (sponsorTypeCode.equals(SPONSOR_TYPE_CODE_ZERO) || primSponsorTypeCode.equals(SPONSOR_TYPE_CODE_ZERO)) {
            if (this.isSponsorCodeInSponsorHierarchy()) {
                for (String questionId : questionIdsList) {
                    if (!questionId.equals(QUESTION_ID_Z2) && !questionId.equals(QUESTION_ID_Z3) && !questionId.equals(QUESTION_ID_Z4) && !questionId.equals(QUESTION_ID_Z5)) continue;
                    questionIds.add(questionId);
                }
            } else {
                for (String questionId : questionIdsList) {
                    if (!questionId.equals(QUESTION_ID_Z2) && !questionId.equals(QUESTION_ID_Z4) && !questionId.equals(QUESTION_ID_Z5)) continue;
                    questionIds.add(questionId);
                }
            }
        } else {
            for (String questionId : questionIdsList) {
                if (!questionId.equals(QUESTION_ID_Z1)) continue;
                questionIds.add(questionId);
            }
        }
        return questionIds;
    }

    private String getStatementForCertification(String questionId) {
        String statement = EMPTY_STRING;
        if (questionId.equals(QUESTION_ID_Z1)) {
            statement = STATEMENT_CERTIFICATION_NOT_NEEDED;
        }
        if (questionId.equals(QUESTION_ID_Z2)) {
            statement = STATEMENT_CONFLICT;
        }
        if (questionId.equals(QUESTION_ID_Z3)) {
            statement = STATEMENT_NIH_PROPOSAL;
        }
        if (questionId.equals(QUESTION_ID_Z4)) {
            statement = STATEMENT_NOT_DEBARRED;
        }
        if (questionId.equals(QUESTION_ID_Z5)) {
            statement = STATEMENT_FEDERAL_AGENCY_LOBBY;
        }
        if (questionId.equals(QUESTION_ID_Z6)) {
            statement = STATEMENT_REQUIREMENT_FAMILIARITY;
        }
        return statement;
    }

    private OrganizationType getOrganizationType(ProposalSite proposalSite) {
        OrganizationType organizationType = OrganizationType.Factory.newInstance();
        Rolodex rolodex = proposalSite.getRolodex();
        String organizationId = proposalSite.getOrganizationId();
        Organization organization = proposalSite.getOrganization();
        if (organizationId != null) {
            String contactName;
            organizationType.setOrganizationID(organizationId);
            if (organization.getOrganizationName() != null) {
                organizationType.setOrganizationName(organization.getOrganizationName());
            }
            if (rolodex != null && (contactName = rolodex.getOrganization()) != null && !contactName.equalsIgnoreCase(organization.getOrganizationName())) {
                organizationType.setContactName(contactName);
            }
        }
        this.setRolodexDetailsToOrganizationType(organizationType, rolodex);
        return organizationType;
    }

    private void setRolodexDetailsToOrganizationType(OrganizationType organizationType, Rolodex rolodox) {
        if (rolodox != null) {
            String county;
            String postalCode;
            String state;
            String city;
            String addressLine3;
            String addressLine2;
            organizationType.setContactName(rolodox.getOrganization());
            String addressLine1 = rolodox.getAddressLine1();
            if (addressLine1 != null) {
                organizationType.setAddress1(addressLine1);
            }
            if ((addressLine2 = rolodox.getAddressLine2()) != null) {
                organizationType.setAddress2(addressLine2);
            }
            if ((addressLine3 = rolodox.getAddressLine3()) != null) {
                organizationType.setAddress3(addressLine3);
            }
            if ((city = rolodox.getCity()) != null) {
                organizationType.setCity(city);
            }
            if ((state = rolodox.getState()) != null) {
                organizationType.setState(state);
            }
            if ((postalCode = rolodox.getPostalCode()) != null) {
                organizationType.setPostCode(postalCode);
            }
            if ((county = rolodox.getCounty()) != null) {
                organizationType.setCountry(county);
            }
        }
    }

    private PCschoolInfoType getSchoolInfoType() {
        PCschoolInfoType schoolInfoType = PCschoolInfoType.Factory.newInstance();
        String schoolName = this.getCertificationParameterValue(SCHOOL_NAME);
        String schoolAcronym = this.getCertificationParameterValue(SCHOOL_ACRONYM);
        if (schoolName != null) {
            schoolInfoType.setSchoolName(schoolName);
        }
        if (schoolAcronym != null) {
            schoolInfoType.setAcronym(schoolAcronym);
        }
        return schoolInfoType;
    }

    private Investigator getInvestigator(ProposalPerson proposalPerson) {
        Investigator investigator = Investigator.Factory.newInstance();
        investigator.setPersonID(proposalPerson.getPersonId());
        investigator.setPersonName(this.getPersonName(proposalPerson));
        investigator.setPrincipalInvFlag(proposalPerson.getProposalPersonRoleId().equals("PI"));
        return investigator;
    }

    private Sponsor getSponsor(String sponsorCode, String primeSponsorCode, String sponsorName, org.kuali.kra.bo.Sponsor sponsorBO) {
        Sponsor sponsor = Sponsor.Factory.newInstance();
        sponsor.setSponsorName(sponsorName);
        sponsor.setSponsorCode(sponsorCode);
        String sponsorType = SPONSOR_TYPE_NONFED;
        if (sponsorBO.getSponsorTypeCode().equals(SPONSOR_TYPE_CODE_ZERO) || this.getSponsorTypeCodeFromSponsor(primeSponsorCode).equals(SPONSOR_TYPE_CODE_ZERO)) {
            sponsorType = SPONSOR_TYPE_FED;
        }
        sponsor.setSponsorType(sponsorType);
        return sponsor;
    }

    private String getSponsorTypeCodeFromSponsor(String sponsorCode) {
        HashMap<String, String> sponsorCodeMap = new HashMap<String, String>();
        sponsorCodeMap.put("sponsorCode", sponsorCode);
        String sponsorTypeCode = EMPTY_STRING;
        org.kuali.kra.bo.Sponsor sponsor = (org.kuali.kra.bo.Sponsor)this.getBusinessObjectService().findByPrimaryKey(org.kuali.kra.bo.Sponsor.class, sponsorCodeMap);
        if (sponsor != null) {
            sponsorTypeCode = sponsor.getSponsorTypeCode();
        }
        return sponsorTypeCode;
    }

    private List<String> getQuestionIdsFromArgValueLookup() {
        HashMap<String, String> questionMap = new HashMap<String, String>();
        questionMap.put(ARGUMENT_NAME, PI_QUESTION);
        List argValueLookupList = (List)this.getBusinessObjectService().findMatching(ArgValueLookup.class, questionMap);
        ArrayList<String> questionIds = new ArrayList<String>();
        for (ArgValueLookup argValueLookup : argValueLookupList) {
            questionIds.add(argValueLookup.getValue());
        }
        return questionIds;
    }

    private boolean isSponsorCodeInSponsorHierarchy() {
        boolean available = false;
        HashMap<String, String> sponsorHirarchyMap = new HashMap<String, String>();
        sponsorHirarchyMap.put("hierarchyName", SPONSOR_GROUPS);
        List sponsorHierarchyList = (List)this.getBusinessObjectService().findMatching(SponsorHierarchy.class, sponsorHirarchyMap);
        for (SponsorHierarchy sponsorHierarchy : sponsorHierarchyList) {
            String sponsorCode = sponsorHierarchy.getSponsorCode();
            String level1 = sponsorHierarchy.getLevel1();
            if (!sponsorCode.equals("000340") && !sponsorCode.equals(NSF_SPONSOR_CODE) || !level1.equalsIgnoreCase("NIH") && !level1.equalsIgnoreCase(NSF_SPONSOR_ACRONYM)) continue;
            available = true;
        }
        return available;
    }

    private String getPersonName(ProposalPerson proposalPerson) {
        String personName = null;
        if (proposalPerson.getPerson() != null) {
            personName = proposalPerson.getPerson().getFullName();
        } else {
            HashMap<String, String> conditionMap = new HashMap<String, String>();
            conditionMap.put(KEY_ROLODEX_ID, proposalPerson.getRolodexId().toString());
            Rolodex rolodex = (Rolodex)this.getBusinessObjectService().findByPrimaryKey(Rolodex.class, conditionMap);
            if (rolodex != null) {
                personName = rolodex.getFullName();
            }
        }
        return personName;
    }

    private String getCertificationParameterValue(String param) {
        String value = null;
        try {
            value = PrintingUtils.getParameterValue(param);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

