/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.printing.xmlstream;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.xmlstream.XmlStream;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.service.S2SBudgetCalculatorService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class ProposalBaseStream
implements XmlStream {
    private static final Log LOG = LogFactory.getLog(ProposalBaseStream.class);
    private DateTimeService dateTimeService;
    private BusinessObjectService businessObjectService;
    private AwardService awardService;

    protected Budget getBudget(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        BudgetDocument bdDoc = null;
        try {
            bdDoc = KraServiceLocator.getService(S2SBudgetCalculatorService.class).getFinalBudgetVersion(proposalDevelopmentDocument);
        }
        catch (S2SException e) {
            LOG.error((Object)"Error while fetching final Budget Version", (Throwable)e);
        }
        Budget budget = null;
        if (bdDoc != null) {
            budget = bdDoc.getBudget();
        }
        return budget;
    }

    protected Award getAward(String currentAwardNumber) {
        List<Award> awards = this.getAwardService().findAwardsForAwardNumber(currentAwardNumber);
        return awards.isEmpty() ? null : awards.get(awards.size() - 1);
    }

    protected AwardAmountInfo getMaxAwardAmountInfo(Award award) {
        Integer highestSequenceNumber = 0;
        Long highestAwardAmountInfoId = 0L;
        AwardAmountInfo higeshSequenceAwarAmountInfo = null;
        for (AwardAmountInfo amountInfo : award.getAwardAmountInfos()) {
            if (highestSequenceNumber < amountInfo.getSequenceNumber()) {
                higeshSequenceAwarAmountInfo = amountInfo;
                highestSequenceNumber = amountInfo.getSequenceNumber();
                highestAwardAmountInfoId = amountInfo.getAwardAmountInfoId();
                continue;
            }
            if (highestSequenceNumber != amountInfo.getSequenceNumber() || highestAwardAmountInfoId >= amountInfo.getAwardAmountInfoId()) continue;
            higeshSequenceAwarAmountInfo = amountInfo;
            highestSequenceNumber = amountInfo.getSequenceNumber();
            highestAwardAmountInfoId = amountInfo.getAwardAmountInfoId();
        }
        return higeshSequenceAwarAmountInfo;
    }

    @Override
    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    @Override
    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    @Override
    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    @Override
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public AwardService getAwardService() {
        return this.awardService;
    }
}

