/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rule.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.event.AddProposalCongressionalDistrictEvent;
import org.kuali.kra.proposaldevelopment.rules.ProposalSiteRule;
import org.kuali.kra.rule.event.KraDocumentEventBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;

public class BasicProposalSiteEvent
extends KraDocumentEventBase {
    private static final Log LOG = LogFactory.getLog(AddProposalCongressionalDistrictEvent.class);
    private List<ProposalSite> proposalSites;
    private String siteIndex;

    public BasicProposalSiteEvent(String errorPathPrefix, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this("Creating a rule event that only checks the proposal site index. Document Id = " + BasicProposalSiteEvent.getDocumentId((Document)proposalDevelopmentDocument), errorPathPrefix, proposalDevelopmentDocument);
    }

    public BasicProposalSiteEvent(String description, String errorPathPrefix, ProposalDevelopmentDocument proposalDevelopmentDocument, ProposalSite proposalSite) {
        this(description, errorPathPrefix, proposalDevelopmentDocument);
        this.proposalSites = new ArrayList<ProposalSite>();
        this.proposalSites.add(proposalSite);
        this.siteIndex = "0";
    }

    public BasicProposalSiteEvent(String description, String errorPathPrefix, ProposalDevelopmentDocument proposalDevelopmentDocument, List<ProposalSite> proposalSites, String siteIndex) {
        this(description, errorPathPrefix, proposalDevelopmentDocument);
        this.proposalSites = proposalSites;
        this.siteIndex = siteIndex;
    }

    private BasicProposalSiteEvent(String description, String errorPathPrefix, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        super(description, errorPathPrefix, (Document)proposalDevelopmentDocument);
    }

    public List<ProposalSite> getProposalSites() {
        return this.proposalSites;
    }

    public String getSiteIndex() {
        return this.siteIndex;
    }

    public ProposalSite getProposalSite() {
        return this.proposalSites.get(new Integer(this.siteIndex));
    }

    @Override
    protected void logEvent() {
        StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)((Object)((Object)this)).getClass().getName(), (String)"."));
        logMessage.append("with site index ");
        logMessage.append(this.siteIndex);
        logMessage.append(", ");
        logMessage.append(this.proposalSites == null ? "null" : Integer.valueOf(this.proposalSites.size()));
        logMessage.append(" proposal sites");
        LOG.debug((Object)logMessage);
    }

    public Class getRuleInterfaceClass() {
        return ProposalSiteRule.class;
    }

    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((ProposalSiteRule)rule).processBasicProposalSiteRules(this);
    }
}

