/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rule.event;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.event.KeyPersonEvent;
import org.kuali.kra.rule.event.KraDocumentEventBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class KeyPersonEventBase
extends KraDocumentEventBase
implements KeyPersonEvent {
    private static final Log LOG = LogFactory.getLog(KeyPersonEventBase.class);
    private ProposalPerson person;

    protected KeyPersonEventBase(String description, ProposalDevelopmentDocument document, ProposalPerson person) {
        this(description, "", document, person);
    }

    protected KeyPersonEventBase(String description, String errorPathPrefix, ProposalDevelopmentDocument document, ProposalPerson person) {
        super(description, errorPathPrefix, (Document)document);
        this.person = (ProposalPerson)((Object)ObjectUtils.deepCopy((Serializable)((Object)person)));
        this.logEvent();
    }

    @Override
    public ProposalPerson getProposalPerson() {
        return this.person;
    }

    public void validate() {
        super.validate();
        if (this.getProposalPerson() == null) {
            throw new IllegalArgumentException("invalid (null) proposal person");
        }
    }

    @Override
    protected void logEvent() {
        StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)"."));
        logMessage.append(" with ");
        if (this.getProposalPerson() == null) {
            logMessage.append("null proposalPerson");
        } else {
            logMessage.append(this.getProposalPerson().toString());
        }
        LOG.debug((Object)logMessage);
    }
}

