/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.List;
import java.util.Set;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModular;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public final class BudgetModularTotalDirectCostRule {
    private final DocumentService documentService;
    private final ConfigurationService configService;
    private final ParameterService paramService;
    private final String budgetStatusCompleteCode;
    private final String tdcWarning;

    public BudgetModularTotalDirectCostRule() {
        this(KRADServiceLocator.getKualiConfigurationService(), KRADServiceLocatorWeb.getDocumentService(), CoreFrameworkServiceLocator.getParameterService());
    }

    BudgetModularTotalDirectCostRule(ConfigurationService configService, DocumentService documentService, ParameterService paramService) {
        if (configService == null) {
            throw new NullPointerException("the configService is null");
        }
        if (documentService == null) {
            throw new NullPointerException("the documentService is null");
        }
        if (paramService == null) {
            throw new NullPointerException("the paramService is null");
        }
        this.documentService = documentService;
        this.configService = configService;
        this.paramService = paramService;
        this.budgetStatusCompleteCode = this.paramService.getParameterValueAsString(BudgetDocument.class, "budgetStatusCompleteCode");
        this.tdcWarning = this.configService.getPropertyValueAsString("warning.budgetVersion.Modular.InvalidTotalDirectCost");
    }

    public boolean validateTotalDirectCost(BudgetParentDocument parentDocument, boolean reportErrors, Set<String> warningMessages) {
        if (parentDocument == null) {
            throw new NullPointerException("the document is null");
        }
        if (warningMessages == null) {
            throw new NullPointerException("the warningMessages is null");
        }
        boolean passed = true;
        List budgetDocumentOverviews = parentDocument.getBudgetDocumentVersions();
        for (int i = 0; i < budgetDocumentOverviews.size(); ++i) {
            BudgetDocumentVersion budgetDocumentOverview = (BudgetDocumentVersion)budgetDocumentOverviews.get(i);
            BudgetVersionOverview budgetOverview = budgetDocumentOverview.getBudgetVersionOverview();
            if (!this.budgetStatusCompleteCode.equalsIgnoreCase(budgetOverview.getBudgetStatus())) continue;
            BudgetDocument budgetDocument = this.getBudgetDocument(budgetOverview.getDocumentNumber());
            this.updateDocumentBudget(budgetDocument, budgetOverview);
            passed &= this.checkTotalDirectCost(budgetDocument, i, reportErrors, warningMessages);
        }
        return passed;
    }

    private void updateDocumentBudget(BudgetDocument budgetDocument, BudgetVersionOverview version) {
        Budget budget = budgetDocument.getBudget();
        BudgetParentDocument proposal = budgetDocument.getParentDocument();
        budget.setFinalVersionFlag(version.isFinalVersionFlag());
        budget.setBudgetStatus(version.getBudgetStatus());
        budget.setModularBudgetFlag(version.getModularBudgetFlag());
    }

    private boolean checkTotalDirectCost(BudgetDocument budgetDocument, int currentIndex, boolean reportErrors, Set<String> warningMessages) {
        assert (budgetDocument != null) : "the budget overview was null";
        assert (currentIndex >= 0) : "the current index was not valid, index: " + currentIndex;
        assert (warningMessages != null) : "the warningMessages is null";
        if (Boolean.FALSE.equals(budgetDocument.getBudget().getModularBudgetFlag())) {
            return true;
        }
        List<BudgetPeriod> budgetPeriods = budgetDocument.getBudget().getBudgetPeriods();
        if (budgetPeriods != null) {
            int positiveCount = -1;
            for (BudgetPeriod budgetPeriod : budgetPeriods) {
                if (budgetPeriod == null) continue;
                BudgetModular budgetModular = budgetPeriod.getBudgetModular();
                int n = positiveCount = positiveCount != -1 ? positiveCount : 0;
                if (budgetModular != null) {
                    BudgetDecimal tdc = budgetModular.getTotalDirectCost();
                    if (tdc.isPositive()) {
                        ++positiveCount;
                        continue;
                    }
                    warningMessages.add(this.tdcWarning);
                    continue;
                }
                warningMessages.add(this.tdcWarning);
            }
            if (positiveCount == 0 && reportErrors) {
                GlobalVariables.getMessageMap().putError("budgetVersionOverview[" + currentIndex + "].budgetStatus", "error.budgetVersion.budgetStatusCompleteWhenNotModuler", new String[0]);
                return false;
            }
        }
        return true;
    }

    private BudgetDocument getBudgetDocument(String docNumber) {
        assert (docNumber != null) : "docNumber is null";
        assert (docNumber.trim().length() > 0) : "docNumber whitespace or empty";
        try {
            return (BudgetDocument)this.documentService.getByDocumentHeaderId(docNumber);
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Error getting document by header id, document number [" + docNumber + "]", e);
        }
    }
}

