/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.logging.TraceLogProxyFactory;
import org.kuali.kra.logging.Traceable;
import org.kuali.kra.proposaldevelopment.bo.CreditSplit;
import org.kuali.kra.proposaldevelopment.bo.CreditSplitNameInfo;
import org.kuali.kra.proposaldevelopment.bo.CreditSplitable;
import org.kuali.kra.proposaldevelopment.bo.InvestigatorCreditType;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;

public class CreditSplitValidator
implements Traceable<CreditSplitValidator> {
    private static final Log LOG = LogFactory.getLog(CreditSplitValidator.class);
    private static final KualiDecimal CREDIT_UPBOUND = new KualiDecimal(100.0);
    private static final KualiDecimal CREDIT_LOWBOUND = KualiDecimal.ZERO;
    private static final String VALIDATING_MESSAGE = "Validating ";
    private static final String VALIDATING_CT_MESSAGE = "Validating credit type ";
    private static final String UNIT_VALIDATION_MESSAGE = "Unit validation passed ";
    private static final String INV_VALIDATION_MESSAGE = "Investigator validation passed ";
    private static final String AUDIT_ADDITION_MESSAGE_1 = "Adding ";
    private static final String AUDIT_ADDITION_MESSAGE_2 = " audit error.";

    public boolean validate(ProposalDevelopmentDocument document) {
        Collection<InvestigatorCreditType> creditTypes = this.getKeyPersonnelService().getInvestigatorCreditTypes();
        boolean retval = true;
        for (InvestigatorCreditType creditType : creditTypes) {
            BufferedLogger.info(VALIDATING_CT_MESSAGE, creditType.getDescription());
            if (!creditType.addsToHundred().booleanValue()) continue;
            retval &= this.validate(document.getDevelopmentProposal().getInvestigators(), creditType);
        }
        return retval;
    }

    public boolean validate(Collection<ProposalPerson> investigators, InvestigatorCreditType creditType) {
        boolean retval = true;
        DecimalHolder investigatorCreditTotal = new DecimalHolder(KualiDecimal.ZERO);
        if (!this.validateCreditSplitable(investigators.iterator(), creditType, investigatorCreditTotal)) {
            this.addAuditError("error.totalCreditSplit.upbound", creditType.getDescription());
            retval = false;
        }
        BufferedLogger.info(INV_VALIDATION_MESSAGE, retval);
        for (ProposalPerson investigator : investigators) {
            DecimalHolder unitCreditTotal = new DecimalHolder(KualiDecimal.ZERO);
            if (!this.validateCreditSplitable(investigator.getUnits().iterator(), creditType, unitCreditTotal)) {
                this.addAuditError("error.creditSplit.upbound", creditType.getDescription(), this.getCreditSplitableName(investigator));
                retval = false;
            }
            BufferedLogger.info(UNIT_VALIDATION_MESSAGE, retval);
        }
        return retval;
    }

    public boolean validateCreditSplitable(Iterator<? extends CreditSplitable> splitable_it, InvestigatorCreditType creditType, DecimalHolder greaterCummulative) {
        if (!splitable_it.hasNext()) {
            return this.isCreditSplitTotalValid(greaterCummulative.getValue());
        }
        boolean retval = true;
        CreditSplitable splitable = splitable_it.next();
        BufferedLogger.info(VALIDATING_MESSAGE, this.getCreditSplitableName(splitable));
        DecimalHolder lesserCummulative = new DecimalHolder(KualiDecimal.ZERO);
        greaterCummulative.add(lesserCummulative);
        return (retval &= this.validateCreditSplit(splitable.getCreditSplits().iterator(), creditType, lesserCummulative)) & this.validateCreditSplitable(splitable_it, creditType, greaterCummulative);
    }

    private boolean isCreditSplitTotalValid(KualiDecimal total) {
        return CREDIT_UPBOUND.compareTo((AbstractKualiDecimal)total) == 0 || CREDIT_LOWBOUND.compareTo((AbstractKualiDecimal)total) > 0;
    }

    public boolean validateCreditSplit(Iterator<? extends CreditSplit> creditSplit_it, InvestigatorCreditType creditType, DecimalHolder lesserCummulative) {
        if (!creditSplit_it.hasNext()) {
            return false;
        }
        CreditSplit creditSplit = creditSplit_it.next();
        if (creditType.getInvCreditTypeCode().equals(creditSplit.getInvCreditTypeCode())) {
            lesserCummulative.add(creditSplit.getCredit());
            BufferedLogger.info("Credit split is %s", creditSplit.getCredit());
            return this.isCreditSplitValid(creditSplit.getCredit());
        }
        return this.validateCreditSplit(creditSplit_it, creditType, lesserCummulative);
    }

    protected boolean isCreditSplitValid(KualiDecimal value) {
        boolean retval = true;
        if (CREDIT_UPBOUND.compareTo((AbstractKualiDecimal)value) < 0) {
            retval = false;
        } else if (CREDIT_LOWBOUND.compareTo((AbstractKualiDecimal)value) > 0) {
            retval = false;
        }
        return retval;
    }

    private List<AuditError> getAuditErrors() {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!KNSGlobalVariables.getAuditErrorMap().containsKey("keyPersonnelAuditErrors")) {
            KNSGlobalVariables.getAuditErrorMap().put("keyPersonnelAuditErrors", new AuditCluster("Key Personnel Information", auditErrors, "Validation Errors"));
        } else {
            auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get("keyPersonnelAuditErrors")).getAuditErrorList();
        }
        return auditErrors;
    }

    private void addAuditError(String messageKey) {
        this.addAuditError(messageKey, null);
    }

    private void addAuditError(String messageKey, String ... params) {
        CreditSplitAuditError error = new CreditSplitAuditError(messageKey, params);
        if (!this.getAuditErrors().contains((Object)error)) {
            this.getAuditErrors().add(error);
            BufferedLogger.info(AUDIT_ADDITION_MESSAGE_1, messageKey, AUDIT_ADDITION_MESSAGE_2);
        }
    }

    private KeyPersonnelService getKeyPersonnelService() {
        return KraServiceLocator.getService(KeyPersonnelService.class);
    }

    private String getCreditSplitableName(CreditSplitable splitable) {
        for (Method method : splitable.getClass().getMethods()) {
            if (!method.isAnnotationPresent(CreditSplitNameInfo.class)) continue;
            LOG.info((Object)("Found method name " + method.getName()));
            try {
                return (String)method.invoke((Object)splitable, null);
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not find the name property for the credit splitable object of class " + splitable.getClass().getName() + ". Make sure the " + CreditSplitNameInfo.class.getSimpleName() + " annotation is declared on the name property of " + splitable.getClass().getSimpleName()));
            }
        }
        return null;
    }

    public static CreditSplitValidator getInstance() {
        return TraceLogProxyFactory.getProxyFor(CreditSplitValidator.class);
    }

    @Override
    public CreditSplitValidator getProxy(CreditSplitValidator archetype) {
        return TraceLogProxyFactory.getProxyFor(archetype);
    }

    final class CreditSplitAuditError
    extends AuditError {
        public CreditSplitAuditError(String messageKey) {
            this(messageKey, null);
        }

        public CreditSplitAuditError(String messageKey, String ... params) {
            super("document.developmentProposalList[0].creditSplit", messageKey, "keyPersonnel.KeyPersonnel", params);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            AuditError error = (AuditError)obj;
            boolean retval = true;
            retval &= this.getErrorKey().equals(error.getErrorKey());
            retval &= this.getMessageKey().equals(error.getMessageKey());
            retval &= this.getLink().equals(error.getLink());
            return retval &= Arrays.equals(this.getParams(), error.getParams());
        }
    }

    final class DecimalHolder
    implements Comparable<DecimalHolder> {
        private KualiDecimal value;

        public DecimalHolder(KualiDecimal val) {
            this.value = val;
        }

        public KualiDecimal getValue() {
            return this.value;
        }

        public void setValue(KualiDecimal value) {
            this.value = value;
        }

        public void add(KualiDecimal val) {
            this.value = (KualiDecimal)this.value.add((AbstractKualiDecimal)val);
        }

        public void add(DecimalHolder val) {
            this.value = (KualiDecimal)this.value.add((AbstractKualiDecimal)val.getValue());
        }

        @Override
        public int compareTo(DecimalHolder obj) {
            return this.value.compareTo((AbstractKualiDecimal)obj.getValue());
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

