/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonUnit;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalPersonModuleQuestionnaireBean;
import org.kuali.kra.proposaldevelopment.rules.CreditSplitValidator;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentKeyPersonsRule;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.SponsorService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class KeyPersonnelAuditRule
extends ResearchDocumentRuleBase
implements DocumentAuditRule {
    private static final Log LOG = LogFactory.getLog(KeyPersonnelAuditRule.class);

    @Override
    public boolean processRunAuditBusinessRules(Document document) {
        ProposalDevelopmentDocument pd = (ProposalDevelopmentDocument)document;
        boolean retval = true;
        if (!this.hasPrincipalInvestigator(pd)) {
            retval = false;
            this.getAuditErrors().add(new AuditError("newProposalPerson", "error.principalInvestigators.lowbound", "keyPersonnel.KeyPersonnel"));
        }
        retval &= new ProposalDevelopmentKeyPersonsRule().processCustomSaveDocumentBusinessRules((Document)pd);
        boolean hasInvestigator = false;
        int personCount = 0;
        for (ProposalPerson person : pd.getDevelopmentProposal().getProposalPersons()) {
            retval &= this.validateInvestigator(person);
            if (KraServiceLocator.getService(SponsorService.class).isSponsorNihMultiplePi(pd.getDevelopmentProposal()) && (person.isMultiplePi() || person.getRole().getProposalPersonRoleId().equalsIgnoreCase("PI"))) {
                retval &= this.validateEraCommonUserName(person, personCount);
            }
            if (hasInvestigator || !this.isInvestigator(person)) continue;
            hasInvestigator = true;
        }
        retval &= this.validateYesNoQuestions((ProposalDevelopmentDocument)document);
        if (hasInvestigator) {
            retval &= this.validateCreditSplit((ProposalDevelopmentDocument)document);
        }
        return retval;
    }

    private boolean validateEraCommonUserName(ProposalPerson person, int personCount) {
        boolean retval = true;
        if (person.getEraCommonsUserName() == null) {
            this.getAuditErrors().add(new AuditError("document.developmentProposalList[0].proposalPersons[" + personCount + "].eraCommonUserName", "error.investigators.eraCommonUserName", "keyPersonnel.KeyPersonnel", new String[]{person.getFullName()}));
            retval = false;
        }
        return retval;
    }

    private boolean validateYesNoQuestions(ProposalDevelopmentDocument document) {
        boolean retval = true;
        int count = 0;
        AuditError error = null;
        String errorStarter = "proposalPersonQuestionnaireHelpers[";
        String errorFinish = "].answerHeaders[0].answers[0].answer";
        String errorLink = "keyPersonnel.KeyPersonnel";
        for (ProposalPerson person : document.getDevelopmentProposal().getProposalPersons()) {
            if (this.shouldValidateYesNoQuestions(person) && !this.validateYesNoQuestions(person)) {
                retval = false;
                String errorKey = "proposalPersonQuestionnaireHelpers[" + count + "].answerHeaders[0].answers[0].answer";
                error = new AuditError(errorKey, "error.proposalperson.certfication.incomplete", "keyPersonnel.KeyPersonnel", new String[]{person.getFullName()});
                this.getAuditErrors().add(error);
                this.reportError(errorKey, "error.proposalperson.certfication.incomplete", person.getFullName());
            }
            ++count;
        }
        return retval;
    }

    private boolean shouldValidateYesNoQuestions(ProposalPerson person) {
        boolean retval = false;
        if (person.getProposalPersonRoleId().equals("COI") || person.getProposalPersonRoleId().equals("PI")) {
            retval = true;
        } else if (person.getProposalPersonRoleId().equals("KP") && StringUtils.isNotBlank((String)person.getOptInCertificationStatus()) && person.getOptInCertificationStatus().equals("Y")) {
            retval = true;
        }
        return retval;
    }

    private boolean validateYesNoQuestions(ProposalPerson investigator) {
        boolean retval = true;
        ProposalPersonModuleQuestionnaireBean bean = new ProposalPersonModuleQuestionnaireBean(investigator.getDevelopmentProposal(), investigator);
        List<AnswerHeader> headers = KraServiceLocator.getService(QuestionnaireAnswerService.class).getQuestionnaireAnswer(bean);
        for (AnswerHeader head : headers) {
            retval &= head.getCompleted();
        }
        return retval;
    }

    protected boolean validateInvestigator(ProposalPerson person) {
        boolean retval = true;
        if (!this.isInvestigator(person)) {
            return retval;
        }
        return retval &= this.validateInvestigatorUnits(person);
    }

    protected boolean validateInvestigatorUnits(ProposalPerson person) {
        boolean retval = true;
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        LOG.info((Object)("validating units for " + person.getPersonId() + " " + person.getFullName()));
        if (person.getUnits().size() < 1) {
            LOG.info((Object)"error.investigatorUnits.limit");
            auditErrors.add(new AuditError("document.developmentProposalList[0].proposalPerson", "error.investigatorUnits.upbound", "keyPersonnel.KeyPersonnel"));
        }
        for (ProposalPersonUnit unit : person.getUnits()) {
            if (StringUtils.isBlank((String)unit.getUnitNumber())) {
                LOG.trace((Object)"error.investigatorUnits.limit");
                auditErrors.add(new AuditError("document.developmentProposalList[0].proposalPerson", "error.investigatorUnits.upbound", "keyPersonnel.KeyPersonnel"));
            }
            retval &= this.validateUnit(unit);
        }
        if (auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put("keyPersonnelAuditErrors", new AuditCluster("Key Personnel Information", auditErrors, "Validation Errors"));
        }
        return retval;
    }

    private boolean validateUnit(ProposalPersonUnit source) {
        boolean retval = true;
        if (source == null) {
            LOG.info((Object)"validated null unit");
            return false;
        }
        if (source.getUnit() == null && StringUtils.isBlank((String)source.getUnitNumber())) {
            retval = false;
        }
        if (StringUtils.isNotBlank((String)source.getUnitNumber()) && this.isInvalid(Unit.class, this.keyValue("unitNumber", source.getUnitNumber()))) {
            retval = false;
        }
        LOG.debug((Object)("Validating " + source));
        LOG.debug((Object)("validateUnit = " + retval));
        return retval;
    }

    private Map.Entry<String, String> keyValue(String key, String value) {
        return new DefaultMapEntry((Object)key, (Object)value);
    }

    private boolean isInvestigator(ProposalPerson person) {
        return this.getKeyPersonnelService().isInvestigator(person);
    }

    private boolean hasPrincipalInvestigator(ProposalDevelopmentDocument document) {
        return this.getKeyPersonnelService().hasPrincipalInvestigator(document);
    }

    private KeyPersonnelService getKeyPersonnelService() {
        return KraServiceLocator.getService(KeyPersonnelService.class);
    }

    private List<AuditError> getAuditErrors() {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!KNSGlobalVariables.getAuditErrorMap().containsKey("keyPersonnelAuditErrors")) {
            KNSGlobalVariables.getAuditErrorMap().put("keyPersonnelAuditErrors", new AuditCluster("Key Personnel Information", auditErrors, "Validation Errors"));
        } else {
            auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get("keyPersonnelAuditErrors")).getAuditErrorList();
        }
        return auditErrors;
    }

    protected boolean validateCreditSplit(ProposalDevelopmentDocument document) {
        boolean retval = true;
        if (this.getKeyPersonnelService().isCreditSplitEnabled()) {
            CreditSplitValidator validator = CreditSplitValidator.getInstance();
            retval &= validator.validate(document);
        }
        return retval;
    }
}

