/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.AbstractType;
import org.kuali.kra.proposaldevelopment.bo.ProposalAbstract;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.AbstractsRule;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentAbstractsRule
extends ResearchDocumentRuleBase
implements AbstractsRule {
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentAbstractsRule.class);

    @Override
    public boolean processAddAbstractBusinessRules(ProposalDevelopmentDocument document, ProposalAbstract proposalAbstract) {
        boolean isValid = true;
        String abstractTypeCode = proposalAbstract.getAbstractTypeCode();
        if (StringUtils.isBlank((String)abstractTypeCode)) {
            isValid = false;
            GlobalVariables.getMessageMap().putError("newProposalAbstract.abstractTypeCode", "error.abstractType.notselected", new String[0]);
        } else if (this.isInvalid(abstractTypeCode)) {
            isValid = false;
            this.reportError("newProposalAbstract", "error.abstractType.invalid", new String[0]);
        } else if (this.isDuplicate(document, abstractTypeCode)) {
            isValid = false;
            this.reportError("newProposalAbstract", "error.abstractType.duplicate", new String[0]);
        }
        return isValid;
    }

    private boolean isInvalid(String abstractTypeCode) {
        if (abstractTypeCode != null) {
            BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("abstractTypeCode", abstractTypeCode);
            if (businessObjectService.countMatching(AbstractType.class, fieldValues) == 1) {
                return false;
            }
        }
        return true;
    }

    private boolean isDuplicate(ProposalDevelopmentDocument document, String abstractTypeCode) {
        List<ProposalAbstract> proposalAbstracts = document.getDevelopmentProposal().getProposalAbstracts();
        for (ProposalAbstract proposalAbstract : proposalAbstracts) {
            if (!proposalAbstract.getAbstractTypeCode().equals(abstractTypeCode)) continue;
            return true;
        }
        return false;
    }
}

