/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.infrastructure.TimeFormatter;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.NarrativeUserRights;
import org.kuali.kra.proposaldevelopment.bo.PropScienceKeyword;
import org.kuali.kra.proposaldevelopment.bo.ProposalAbstract;
import org.kuali.kra.proposaldevelopment.bo.ProposalCopyCriteria;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalUser;
import org.kuali.kra.proposaldevelopment.bo.ProposalUserEditRoles;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.bo.YnqGroupName;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarchyException;
import org.kuali.kra.proposaldevelopment.rule.AbstractsRule;
import org.kuali.kra.proposaldevelopment.rule.AddCongressionalDistrictRule;
import org.kuali.kra.proposaldevelopment.rule.AddInstituteAttachmentRule;
import org.kuali.kra.proposaldevelopment.rule.AddKeyPersonRule;
import org.kuali.kra.proposaldevelopment.rule.AddNarrativeRule;
import org.kuali.kra.proposaldevelopment.rule.AddPersonnelAttachmentRule;
import org.kuali.kra.proposaldevelopment.rule.AddProposalSiteRule;
import org.kuali.kra.proposaldevelopment.rule.BudgetDataOverrideRule;
import org.kuali.kra.proposaldevelopment.rule.CalculateCreditSplitRule;
import org.kuali.kra.proposaldevelopment.rule.ChangeKeyPersonRule;
import org.kuali.kra.proposaldevelopment.rule.CopyProposalRule;
import org.kuali.kra.proposaldevelopment.rule.DeleteCongressionalDistrictRule;
import org.kuali.kra.proposaldevelopment.rule.DeleteProposalSiteRule;
import org.kuali.kra.proposaldevelopment.rule.NewNarrativeUserRightsRule;
import org.kuali.kra.proposaldevelopment.rule.PermissionsRule;
import org.kuali.kra.proposaldevelopment.rule.ProposalDataOverrideRule;
import org.kuali.kra.proposaldevelopment.rule.ResubmissionPromptRule;
import org.kuali.kra.proposaldevelopment.rule.SaveKeyPersonRule;
import org.kuali.kra.proposaldevelopment.rule.SaveNarrativesRule;
import org.kuali.kra.proposaldevelopment.rule.event.AddInstituteAttachmentEvent;
import org.kuali.kra.proposaldevelopment.rule.event.AddNarrativeEvent;
import org.kuali.kra.proposaldevelopment.rule.event.AddPersonnelAttachmentEvent;
import org.kuali.kra.proposaldevelopment.rule.event.AddProposalCongressionalDistrictEvent;
import org.kuali.kra.proposaldevelopment.rule.event.AddProposalSiteEvent;
import org.kuali.kra.proposaldevelopment.rule.event.BasicProposalSiteEvent;
import org.kuali.kra.proposaldevelopment.rule.event.BudgetDataOverrideEvent;
import org.kuali.kra.proposaldevelopment.rule.event.ClearProposalSiteAddressRule;
import org.kuali.kra.proposaldevelopment.rule.event.DeleteProposalCongressionalDistrictEvent;
import org.kuali.kra.proposaldevelopment.rule.event.ProposalDataOverrideEvent;
import org.kuali.kra.proposaldevelopment.rule.event.ResubmissionRuleEvent;
import org.kuali.kra.proposaldevelopment.rule.event.SaveNarrativesEvent;
import org.kuali.kra.proposaldevelopment.rule.event.SavePersonnelAttachmentEvent;
import org.kuali.kra.proposaldevelopment.rule.event.SaveProposalSitesEvent;
import org.kuali.kra.proposaldevelopment.rules.KeyPersonnelAuditRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalBudgetDataOverrideRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentAbstractsRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentCongressionalDistrictRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentCopyRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentDataOverrideRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentGrantsGovAuditRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentInstituteAttachmentRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentKeyPersonsRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentNarrativeRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentPermissionsRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentPersonnelAttachmentRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentProposalAttachmentsAuditRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentProposalLocationRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentProposalRequiredFieldsAuditRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentQuestionnaireAuditRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentResubmissionPromptRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentS2sQuestionnaireAuditRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentSponsorProgramInformationAuditRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentYnqAuditRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalSiteRule;
import org.kuali.kra.proposaldevelopment.rules.SaveProposalSitesRule;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.proposaldevelopment.web.bean.ProposalUserRoles;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rule.event.KraDocumentEventBaseExtension;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.SponsorService;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ProposalDevelopmentDocumentRule
extends ResearchDocumentRuleBase
implements AddCongressionalDistrictRule,
AddKeyPersonRule,
AddNarrativeRule,
SaveNarrativesRule,
AddInstituteAttachmentRule,
AddPersonnelAttachmentRule,
AddProposalSiteRule,
BusinessRuleInterface,
SaveProposalSitesRule,
DeleteProposalSiteRule,
ClearProposalSiteAddressRule,
AbstractsRule,
CopyProposalRule,
ChangeKeyPersonRule,
DeleteCongressionalDistrictRule,
PermissionsRule,
NewNarrativeUserRightsRule,
SaveKeyPersonRule,
CalculateCreditSplitRule,
ProposalDataOverrideRule,
ResubmissionPromptRule,
BudgetDataOverrideRule {
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentDocumentRule.class);
    private static final String PROPOSAL_QUESTIONS_KEY = "proposalYnq[%d].%s";
    private static final String PROPOSAL_QUESTIONS_KEY_PROPERTY_ANSWER = "answer";
    private static final String PROPOSAL_QUESTIONS_KEY_PROPERTY_REVIEW_DATE = "reviewDate";
    private static final String PROPOSAL_QUESTIONS_KEY_PROPERTY_EXPLANATION = "explanation";

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        boolean retval = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        retval &= super.processCustomRouteDocumentBusinessRules(document);
        return retval &= new KeyPersonnelAuditRule().processRunAuditBusinessRules(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        if (!(document instanceof ProposalDevelopmentDocument)) {
            return false;
        }
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        this.getDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively(document, this.getMaxDictionaryValidationDepth(), true, false);
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        GlobalVariables.getMessageMap().addToErrorPath("document.developmentProposalList[0]");
        valid &= this.processProposalRequiredFieldsBusinessRule(proposalDevelopmentDocument);
        valid &= this.processProposalYNQBusinessRule(proposalDevelopmentDocument, false);
        valid &= this.processBudgetVersionsBusinessRule(proposalDevelopmentDocument, false);
        valid &= this.processProposalGrantsGovBusinessRule(proposalDevelopmentDocument);
        valid &= this.processSponsorProgramBusinessRule(proposalDevelopmentDocument);
        valid &= this.processKeywordBusinessRule(proposalDevelopmentDocument);
        GlobalVariables.getMessageMap().removeFromErrorPath("document.developmentProposalList[0]");
        return valid &= this.proccessValidateSponsor(proposalDevelopmentDocument);
    }

    private boolean proccessValidateSponsor(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        System.err.println("proccessValidateSponsor");
        boolean valid = true;
        DataDictionaryService dataDictionaryService = KraServiceLocator.getService(DataDictionaryService.class);
        if (!this.getSponsorService().validateSponsor(proposalDevelopmentDocument.getDevelopmentProposal().getSponsor())) {
            System.err.println("  Invalid sponsor");
            valid = false;
            GlobalVariables.getMessageMap().putError("sponsorCode", "error.missing", new String[]{dataDictionaryService.getAttributeErrorLabel(DevelopmentProposal.class, "sponsorCode")});
        }
        if (!StringUtils.isEmpty((String)proposalDevelopmentDocument.getDevelopmentProposal().getPrimeSponsorCode()) && !this.getSponsorService().validateSponsor(proposalDevelopmentDocument.getDevelopmentProposal().getPrimeSponsor())) {
            System.err.println("  Invalid  prime sponsor");
            valid = false;
            GlobalVariables.getMessageMap().putError("primeSponsorCode", "error.missing", new String[]{dataDictionaryService.getAttributeErrorLabel(DevelopmentProposal.class, "primeSponsorCode")});
        }
        System.err.println("  returning: " + valid);
        return valid;
    }

    @Override
    public boolean processDeleteProposalSiteRules(BasicProposalSiteEvent proposalSiteEvent) {
        return new ProposalSiteRule().processBasicProposalSiteRules(proposalSiteEvent);
    }

    @Override
    public boolean processClearProposalSiteAddressRules(BasicProposalSiteEvent ProposalSiteEvent) {
        return new ProposalSiteRule().processBasicProposalSiteRules(ProposalSiteEvent);
    }

    @Override
    public boolean processAddCongressionalDistrictRules(AddProposalCongressionalDistrictEvent addCongressionalDistrictEvent) {
        return new ProposalDevelopmentCongressionalDistrictRule().processAddCongressionalDistrictRules(addCongressionalDistrictEvent);
    }

    @Override
    public boolean processDeleteCongressionalDistrictRules(DeleteProposalCongressionalDistrictEvent deleteCongressionalDistrictEvent) {
        return new ProposalDevelopmentCongressionalDistrictRule().processDeleteCongressionalDistrictRules(deleteCongressionalDistrictEvent);
    }

    public boolean processProposalYNQBusinessRule(ProposalDevelopmentDocument proposalDevelopmentDocument, boolean docRouting) {
        boolean valid = true;
        for (int j = 0; j < proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs().size(); ++j) {
            String explanationRequiredFor;
            String dateRequiredFor;
            ProposalYnq proposalYnq = proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs().get(j);
            String groupName = proposalYnq.getYnq().getGroupName();
            HashMap<String, Integer> questionSerial = ProposalDevelopmentDocumentRule.getQuestionSerialNumberBasedOnGroup(proposalDevelopmentDocument);
            String[] errorParameter = new String[]{groupName};
            String ynqAnswer = proposalYnq.getAnswer();
            if (docRouting && StringUtils.isBlank((String)proposalYnq.getAnswer())) {
                BufferedLogger.info("no answer");
                valid = false;
                this.reportError(String.format(PROPOSAL_QUESTIONS_KEY, j, PROPOSAL_QUESTIONS_KEY_PROPERTY_ANSWER), "error.required.answer", questionSerial.get(proposalYnq.getQuestionId()).toString(), groupName);
            }
            if ((dateRequiredFor = proposalYnq.getYnq().getDateRequiredFor()) != null && StringUtils.isNotBlank((String)ynqAnswer) && dateRequiredFor.contains(ynqAnswer) && proposalYnq.getReviewDate() == null) {
                BufferedLogger.info("No review date");
                valid = false;
                this.reportError(String.format(PROPOSAL_QUESTIONS_KEY, j, PROPOSAL_QUESTIONS_KEY_PROPERTY_REVIEW_DATE), "error.required.for.reviewDate", questionSerial.get(proposalYnq.getQuestionId()).toString(), groupName);
            }
            if ((explanationRequiredFor = proposalYnq.getYnq().getExplanationRequiredFor()) == null || !StringUtils.isNotBlank((String)ynqAnswer) || !explanationRequiredFor.contains(ynqAnswer) || !StringUtils.isBlank((String)proposalYnq.getExplanation())) continue;
            BufferedLogger.info("No explanation date");
            valid = false;
            this.reportError(String.format(PROPOSAL_QUESTIONS_KEY, j, PROPOSAL_QUESTIONS_KEY_PROPERTY_EXPLANATION), "error.required.for.explanation", questionSerial.get(proposalYnq.getQuestionId()).toString(), groupName);
        }
        return valid;
    }

    public static HashMap<String, Integer> getQuestionSerialNumberBasedOnGroup(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        HashMap<String, Integer> ynqGroupSerial = new HashMap<String, Integer>();
        for (YnqGroupName ynqGroupName : proposalDevelopmentDocument.getDevelopmentProposal().getYnqGroupNames()) {
            Integer serialNumber = 1;
            for (ProposalYnq proposalYnq : proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs()) {
                if (!ynqGroupName.getGroupName().equalsIgnoreCase(proposalYnq.getYnq().getGroupName())) continue;
                ynqGroupSerial.put(proposalYnq.getQuestionId(), serialNumber);
                Integer n = serialNumber;
                Integer n2 = serialNumber = Integer.valueOf(serialNumber + 1);
            }
        }
        return ynqGroupSerial;
    }

    private boolean processProposalRequiredFieldsBusinessRule(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        DataDictionaryService dataDictionaryService = KraServiceLocator.getService(DataDictionaryService.class);
        if (proposalDevelopmentDocument.getDevelopmentProposal().getRequestedStartDateInitial() != null && proposalDevelopmentDocument.getDevelopmentProposal().getRequestedEndDateInitial() != null && proposalDevelopmentDocument.getDevelopmentProposal().getRequestedStartDateInitial().after(proposalDevelopmentDocument.getDevelopmentProposal().getRequestedEndDateInitial())) {
            valid = false;
            errorMap.putError("requestedStartDateInitial", "error.start.date.after.end.date", new String[]{dataDictionaryService.getAttributeErrorLabel(DevelopmentProposal.class, "requestedStartDateInitial"), dataDictionaryService.getAttributeErrorLabel(DevelopmentProposal.class, "requestedEndDateInitial")});
        }
        ProposalDevelopmentService proposalDevelopmentService = KraServiceLocator.getService(ProposalDevelopmentService.class);
        if (StringUtils.isNotBlank((String)proposalDevelopmentDocument.getDevelopmentProposal().getCurrentAwardNumber()) && proposalDevelopmentService.getProposalCurrentAwardVersion(proposalDevelopmentDocument) == null) {
            valid = false;
            errorMap.putError("currentAwardNumber", "error.missing", new String[]{dataDictionaryService.getAttributeErrorLabel(DevelopmentProposal.class, "currentAwardNumber")});
        }
        if (StringUtils.isNotBlank((String)proposalDevelopmentDocument.getDevelopmentProposal().getContinuedFrom()) && proposalDevelopmentService.getProposalContinuedFromVersion(proposalDevelopmentDocument) == null) {
            valid = false;
            errorMap.putError("continuedFrom", "error.missing", new String[]{dataDictionaryService.getAttributeErrorLabel(DevelopmentProposal.class, "continuedFrom")});
        }
        return valid;
    }

    private boolean processProposalGrantsGovBusinessRule(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        boolean valid = true;
        if (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity() != null && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getOpportunityId() != null && StringUtils.equalsIgnoreCase((String)proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionCode(), (String)this.getS2sRevisionTypeOther()) && (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionOtherDescription() == null || StringUtils.equals((String)proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionOtherDescription().trim(), (String)""))) {
            this.reportError("s2sOpportunity.revisionOtherDescription", "error.s2sopportunity.revisionTypeOther", new String[0]);
            valid &= false;
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity() != null && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getOpportunityId() != null && !StringUtils.equalsIgnoreCase((String)proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionCode(), (String)this.getS2sRevisionTypeOther()) && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionOtherDescription() != null && !StringUtils.equals((String)proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionOtherDescription().trim(), (String)"")) {
            this.reportError("s2sOpportunity.revisionOtherDescription", "error.s2sopportunity.revisionTypeNotOtherSpecifyNotBlank", new String[0]);
            valid &= false;
        }
        return valid;
    }

    private String getS2sRevisionTypeOther() {
        return this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2s.revisiontype.other");
    }

    @Override
    public boolean processAddKeyPersonBusinessRules(ProposalDevelopmentDocument document, ProposalPerson person) {
        return new ProposalDevelopmentKeyPersonsRule().processAddKeyPersonBusinessRules(document, person);
    }

    private boolean processSponsorProgramBusinessRule(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        String sponsorName;
        boolean valid = true;
        String regExpr = "(\\d{2})(\\.)(\\d{3})[a-zA-z]?";
        MessageMap errorMap = GlobalVariables.getMessageMap();
        DataDictionaryService dataDictionaryService = KraServiceLocator.getService(DataDictionaryService.class);
        if (StringUtils.isNotBlank((String)proposalDevelopmentDocument.getDevelopmentProposal().getCfdaNumber()) && !proposalDevelopmentDocument.getDevelopmentProposal().getCfdaNumber().matches(regExpr) && GlobalVariables.getMessageMap().getMessages("document.developmentProposalList[0].cfdaNumber") == null) {
            errorMap.putError("developmentProposalList[0].cfdaNumber", "error.invalidFormat", new String[]{dataDictionaryService.getAttributeErrorLabel(DevelopmentProposal.class, "cfdaNumber"), proposalDevelopmentDocument.getDevelopmentProposal().getCfdaNumber()});
            valid = false;
        }
        SponsorService sponsorService = KraServiceLocator.getService(SponsorService.class);
        String sponsorCode = proposalDevelopmentDocument.getDevelopmentProposal().getPrimeSponsorCode();
        if (sponsorCode != null && (sponsorName = sponsorService.getSponsorName(sponsorCode)) == null) {
            errorMap.putError("developmentProposalList[0].primeSponsorCode", "error.existence", new String[]{dataDictionaryService.getAttributeLabel(DevelopmentProposal.class, "primeSponsorCode")});
            valid = false;
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().getDeadlineTime() != null) {
            TimeFormatter formatter = new TimeFormatter();
            String deadLineTime = (String)formatter.convertToObject(proposalDevelopmentDocument.getDevelopmentProposal().getDeadlineTime());
            if (!deadLineTime.equalsIgnoreCase("Invalid Time")) {
                proposalDevelopmentDocument.getDevelopmentProposal().setDeadlineTime(deadLineTime);
            } else {
                errorMap.putError("deadlineTime", "error.invalid.deadLineTime", new String[]{dataDictionaryService.getAttributeErrorLabel(DevelopmentProposal.class, "deadlineTime")});
                valid = false;
            }
        }
        return valid;
    }

    private boolean processKeywordBusinessRule(ProposalDevelopmentDocument document) {
        List<PropScienceKeyword> keywords = document.getDevelopmentProposal().getPropScienceKeywords();
        for (PropScienceKeyword keyword : keywords) {
            for (PropScienceKeyword keyword2 : keywords) {
                if (keyword == keyword2 || !StringUtils.equalsIgnoreCase((String)keyword.getScienceKeywordCode(), (String)keyword2.getScienceKeywordCode())) continue;
                GlobalVariables.getMessageMap().putError("propScienceKeyword", "error.proposalKeywords.duplicate", new String[0]);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean processAddNarrativeBusinessRules(AddNarrativeEvent addNarrativeEvent) {
        return new ProposalDevelopmentNarrativeRule().processAddNarrativeBusinessRules(addNarrativeEvent);
    }

    @Override
    public boolean processRunAuditBusinessRules(Document document) {
        if (((ProposalDevelopmentDocument)document).getDevelopmentProposal().isChild()) {
            throw new RuntimeException(new ProposalHierarchyException("Cannot run validation on a Proposal Hierarchy Child."));
        }
        boolean retval = true;
        retval &= super.processRunAuditBusinessRules(document);
        retval &= new ProposalDevelopmentProposalRequiredFieldsAuditRule().processRunAuditBusinessRules(document);
        retval &= new ProposalDevelopmentSponsorProgramInformationAuditRule().processRunAuditBusinessRules(document);
        retval &= new KeyPersonnelAuditRule().processRunAuditBusinessRules(document);
        retval &= new ProposalDevelopmentProposalAttachmentsAuditRule().processRunAuditBusinessRules(document);
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        proposalDevelopmentDocument.getDevelopmentProposal().getYnqService().populateProposalQuestions(proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs(), proposalDevelopmentDocument.getDevelopmentProposal().getYnqGroupNames(), proposalDevelopmentDocument);
        retval &= new ProposalDevelopmentYnqAuditRule().processRunAuditBusinessRules(document);
        retval &= new ProposalDevelopmentGrantsGovAuditRule().processRunAuditBusinessRules(document);
        retval &= new ProposalDevelopmentS2sQuestionnaireAuditRule().processRunAuditBusinessRules((Document)proposalDevelopmentDocument);
        retval &= new ProposalDevelopmentQuestionnaireAuditRule().processRunAuditBusinessRules((Document)proposalDevelopmentDocument);
        try {
        }
        catch (Exception ex) {
            throw new RuntimeException("Validate Budget Audit rules encountered exception", ex);
        }
        return retval &= KraServiceLocator.getService(BudgetService.class).validateBudgetAuditRule((ProposalDevelopmentDocument)document);
    }

    @Override
    public boolean processAddAbstractBusinessRules(ProposalDevelopmentDocument document, ProposalAbstract proposalAbstract) {
        return new ProposalDevelopmentAbstractsRule().processAddAbstractBusinessRules(document, proposalAbstract);
    }

    @Override
    public boolean processSaveNarrativesBusinessRules(SaveNarrativesEvent saveNarrativesEvent) {
        return new ProposalDevelopmentNarrativeRule().processSaveNarrativesBusinessRules(saveNarrativesEvent);
    }

    @Override
    public boolean processCopyProposalBusinessRules(ProposalDevelopmentDocument document, ProposalCopyCriteria criteria) {
        return new ProposalDevelopmentCopyRule().processCopyProposalBusinessRules(document, criteria);
    }

    @Override
    public boolean processAddInstituteAttachmentBusinessRules(AddInstituteAttachmentEvent addInstituteAttachmentEvent) {
        return new ProposalDevelopmentInstituteAttachmentRule().processAddInstituteAttachmentBusinessRules(addInstituteAttachmentEvent);
    }

    @Override
    public boolean processAddPersonnelAttachmentBusinessRules(AddPersonnelAttachmentEvent addPersonnelAttachmentEvent) {
        return new ProposalDevelopmentPersonnelAttachmentRule().processAddPersonnelAttachmentBusinessRules(addPersonnelAttachmentEvent);
    }

    public boolean processSavePersonnelAttachmentBusinessRules(SavePersonnelAttachmentEvent savePersonnelAttachmentEvent) {
        return new ProposalDevelopmentPersonnelAttachmentRule().processSavePersonnelAttachmentBusinessRules(savePersonnelAttachmentEvent);
    }

    @Override
    public boolean processChangeKeyPersonBusinessRules(ProposalPerson proposalPerson, BusinessObject source, int index) {
        return new ProposalDevelopmentKeyPersonsRule().processChangeKeyPersonBusinessRules(proposalPerson, source, index);
    }

    @Override
    public boolean processAddProposalSiteBusinessRules(AddProposalSiteEvent addProposalLocationEvent) {
        return new ProposalDevelopmentProposalLocationRule().processAddProposalSiteBusinessRules(addProposalLocationEvent);
    }

    @Override
    public boolean processSaveProposalSiteBusinessRules(SaveProposalSitesEvent saveProposalSitesEvent) {
        return new ProposalDevelopmentProposalLocationRule().processSaveProposalSiteBusinessRules(saveProposalSitesEvent);
    }

    @Override
    public boolean processAddProposalUserBusinessRules(ProposalDevelopmentDocument document, List<ProposalUserRoles> list, ProposalUser proposalUser) {
        return new ProposalDevelopmentPermissionsRule().processAddProposalUserBusinessRules(document, list, proposalUser);
    }

    @Override
    public boolean processDeleteProposalUserBusinessRules(ProposalDevelopmentDocument document, List<ProposalUserRoles> list, int index) {
        return new ProposalDevelopmentPermissionsRule().processDeleteProposalUserBusinessRules(document, list, index);
    }

    @Override
    public boolean processEditProposalUserRolesBusinessRules(ProposalDevelopmentDocument document, List<ProposalUserRoles> list, ProposalUserEditRoles editRoles) {
        return new ProposalDevelopmentPermissionsRule().processEditProposalUserRolesBusinessRules(document, list, editRoles);
    }

    @Override
    public boolean processSaveKeyPersonBusinessRules(ProposalDevelopmentDocument document) {
        BufferedLogger.info("In processSaveKeyPersonBusinessRules()");
        return new ProposalDevelopmentKeyPersonsRule().processCustomSaveDocumentBusinessRules((Document)document);
    }

    @Override
    public boolean processNewNarrativeUserRightsBusinessRules(ProposalDevelopmentDocument document, List<NarrativeUserRights> newNarrativeUserRights, int narrativeIndex) {
        return new ProposalDevelopmentNarrativeRule().processNewNarrativeUserRightsBusinessRules(document, newNarrativeUserRights, narrativeIndex);
    }

    @Override
    public boolean processCalculateCreditSplitBusinessRules(ProposalDevelopmentDocument document) {
        return new ProposalDevelopmentKeyPersonsRule().processCalculateCreditSplitBusinessRules(document);
    }

    @Override
    public boolean processProposalDataOverrideRules(ProposalDataOverrideEvent proposalDataOverrideEvent) {
        return new ProposalDevelopmentDataOverrideRule().processProposalDataOverrideRules(proposalDataOverrideEvent);
    }

    @Override
    public boolean processBudgetDataOverrideRules(BudgetDataOverrideEvent budgetDataOverrideEvent) {
        return new ProposalBudgetDataOverrideRule().processBudgetDataOverrideRules(budgetDataOverrideEvent);
    }

    @Override
    public boolean processResubmissionPromptBusinessRules(ResubmissionRuleEvent resubmissionRuleEvent) {
        return new ProposalDevelopmentResubmissionPromptRule().processResubmissionPromptBusinessRules(resubmissionRuleEvent);
    }

    public boolean processRules(KraDocumentEventBaseExtension event) {
        boolean retVal = false;
        retVal = event.getRule().processRules(event);
        return retVal;
    }

    private SponsorService getSponsorService() {
        return KraServiceLocator.getService(SponsorService.class);
    }
}

