/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.service.S2SService;
import org.kuali.kra.service.SponsorService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class ProposalDevelopmentGrantsGovAuditRule
implements DocumentAuditRule {
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentGrantsGovAuditRule.class);
    private ParameterService parameterService;

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        if (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity() != null && (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionTypeCode() == null || StringUtils.equalsIgnoreCase((String)proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionTypeCode().toString(), (String)""))) {
            valid = false;
            auditErrors.add(new AuditError("document.developmentProposalList[0].s2sOpportunity.s2sSubmissionTypeCode", "error.submissionType.notSelected", "grantsGov.Opportunity"));
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().getProposalTypeCode() != null && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity() != null && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getOpportunityId() != null && proposalDevelopmentDocument.getDevelopmentProposal().getProposalTypeCode().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.revision")) && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionCode() == null) {
            valid &= false;
            auditErrors.add(new AuditError("document.developmentProposalList[0].s2sOpportunity.revisionCode", "error.s2sopportunity.revisiontype", "grantsGov.Opportunity"));
        }
        if ((this.getSponsorService().isSponsorNihOsc(proposalDevelopmentDocument.getDevelopmentProposal()) || this.getSponsorService().isSponsorNihMultiplePi(proposalDevelopmentDocument.getDevelopmentProposal())) && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity() != null && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getCompetetionId() != null && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getCompetetionId().equals("ADOBE-FORMS-A")) {
            auditErrors.add(new AuditError("document.developmentProposalList[0].s2sOpportunity.competetionId", "error.s2sopportunity.competitionIdInvalid", "grantsGov.Opportunity"));
            valid = false;
        }
        if (auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put("grantsGovAuditWarnings", new AuditCluster("GrantsGov", auditErrors, "Validation Errors"));
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity() != null) {
            try {
                valid &= this.getS2sValidatorService().validateApplication(proposalDevelopmentDocument, auditErrors);
            }
            catch (S2SException e) {
                valid = false;
                LOG.error((Object)"Unknown error while validating grants.gov data", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return valid;
    }

    private SponsorService getSponsorService() {
        return KraServiceLocator.getService(SponsorService.class);
    }

    private S2SService getS2sValidatorService() {
        return KraServiceLocator.getService(S2SService.class);
    }
}

