/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.DegreeType;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.logging.FormattedLogger;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonComparator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonCreditSplit;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonDegree;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonUnit;
import org.kuali.kra.proposaldevelopment.bo.ProposalUnitCreditSplit;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.AddKeyPersonRule;
import org.kuali.kra.proposaldevelopment.rule.CalculateCreditSplitRule;
import org.kuali.kra.proposaldevelopment.rule.ChangeKeyPersonRule;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentKeyPersonsRule
extends ResearchDocumentRuleBase
implements AddKeyPersonRule,
ChangeKeyPersonRule,
CalculateCreditSplitRule {
    private static final String PERSON_HAS_UNIT_MSG = "Person %s has unit %s";
    private static final int FIELD_ERA_COMMONS_USERNAME_MIN_LENGTH = 6;
    private KcPersonService kcPersonService;

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        return this.processSaveKeyPersonBusinessRules((ProposalDevelopmentDocument)document);
    }

    public boolean processSaveKeyPersonBusinessRules(ProposalDevelopmentDocument document) {
        FormattedLogger.info("Processing Key Personnel Save Document Rule", new Object[0]);
        boolean retval = true;
        int pi_cnt = 0;
        int personIndex = 0;
        List<ProposalPerson> investigators = document.getDevelopmentProposal().getInvestigators();
        for (ProposalPerson person : document.getDevelopmentProposal().getProposalPersons()) {
            if (this.isPrincipalInvestigator(person)) {
                ++pi_cnt;
            }
            if (person.getProposalPersonExtendedAttributes() != null && person.getProposalPersonExtendedAttributes().getCitizenshipTypeCode() == null) {
                FormattedLogger.debug("error.noCitizenshipType", new Object[0]);
                this.reportError("document.developmentProposalList[0].proposalPersons[" + personIndex + "].proposalPersonExtendedAttributes.citizenshipTypeCode", "error.missingcitizenship", new String[0]);
                retval = false;
            }
            if (StringUtils.isBlank((String)person.getProposalPersonRoleId()) && person.getRole() == null) {
                FormattedLogger.debug("error.missingPersonRole", new Object[0]);
                this.reportError("document.developmentProposalList[0].proposalPersons[" + personIndex + "]", "error.missingPersonRole", new String[0]);
            }
            ++personIndex;
        }
        if (pi_cnt > 1) {
            retval = false;
            this.reportError("newProposalPerson", "error.principalInvestigators.upbound", this.getKeyPersonnelService().getPrincipalInvestigatorRoleDescription(document));
        }
        personIndex = 0;
        for (ProposalPerson person : document.getDevelopmentProposal().getProposalPersons()) {
            if (this.isCoInvestigator(person) && person.getUnits() != null && person.getUnits().size() == 0) {
                this.reportError("newProposalPersonUnit[" + personIndex + "].unitNumber", "error.one.unit", person.getFullName());
            }
            if (this.isKeyPerson(person) && person.getOptInUnitStatus().equals("Y") && person.getUnits() != null && person.getUnits().size() == 0) {
                this.reportError("newProposalPersonUnit[" + personIndex + "].unitNumber", "error.one.unit", person.getFullName());
            }
            if (this.isKeyPerson(person) && StringUtils.isBlank((String)person.getProjectRole())) {
                this.reportError("document.developmentProposalList[0].proposalPersons[" + personIndex + "].projectRole", "error.required", "Key Person Role");
            }
            if (person.getPercentageEffort() != null && (person.getPercentageEffort().isLessThan((AbstractKualiDecimal)new KualiDecimal(0)) || person.getPercentageEffort().isGreaterThan((AbstractKualiDecimal)new KualiDecimal(100)))) {
                GlobalVariables.getMessageMap().putError("document.developmentProposalList[0].proposalPersons[" + personIndex + "].percentageEffort", "error.percentage", new String[]{"Percentage Effort"});
            }
            if (StringUtils.isNotBlank((String)person.getEraCommonsUserName()) && person.getEraCommonsUserName().length() < 6) {
                GlobalVariables.getMessageMap().putError("document.developmentProposalList[0].proposalPersons[" + personIndex + "].eraCommonsUserName", "error.minLength", new String[]{"eRA Commons User Name", "6"});
            }
            ++personIndex;
        }
        if (retval &= this.processCalculateCreditSplitBusinessRules(document)) {
            boolean leadunit = false;
            ProposalPersonUnit unit = null;
            for (ProposalPerson person : document.getDevelopmentProposal().getProposalPersons()) {
                if (person.getProposalPersonRoleId().equals("PI")) {
                    for (ProposalPersonUnit personunit : person.getUnits()) {
                        if (!personunit.isLeadUnit()) continue;
                        leadunit = true;
                    }
                    if (!leadunit) {
                        this.getKeyPersonnelService().assignLeadUnit(person, document.getDevelopmentProposal().getOwnedByUnitNumber());
                    }
                    leadunit = false;
                    continue;
                }
                if (!person.getProposalPersonRoleId().equals("COI")) continue;
                for (ProposalPersonUnit personunit : person.getUnits()) {
                    if (!personunit.isLeadUnit() || !StringUtils.isNotBlank((String)person.getHomeUnit()) || person.getHomeUnit().equals(document.getDevelopmentProposal().getOwnedByUnitNumber())) continue;
                    leadunit = true;
                    personunit.setLeadUnit(false);
                    unit = person.getUnit(personunit.getUnitNumber());
                }
                if (!leadunit || unit == null) continue;
                person.getUnits().remove(unit);
            }
            Collections.sort(document.getDevelopmentProposal().getProposalPersons(), new ProposalPersonComparator());
        }
        return retval;
    }

    @Override
    public boolean processAddKeyPersonBusinessRules(ProposalDevelopmentDocument document, ProposalPerson person) {
        boolean retval = true;
        FormattedLogger.debug("validating " + person, new Object[0]);
        FormattedLogger.info("Person role is " + person.getRole(), new Object[0]);
        if (this.isPrincipalInvestigator(person) && this.hasPrincipalInvestigator(document)) {
            FormattedLogger.debug("error.principalInvestigator.limit", new Object[0]);
            this.reportError("newProposalPerson", "error.principalInvestigators.upbound", this.getKeyPersonnelService().getPrincipalInvestigatorRoleDescription(document));
            retval = false;
        }
        FormattedLogger.info("roleid is %s", person.getProposalPersonRoleId());
        FormattedLogger.info("role is %s", person.getRole());
        if (StringUtils.isBlank((String)person.getProposalPersonRoleId()) && person.getRole() == null) {
            FormattedLogger.debug("Tried to add person without role", new Object[0]);
            this.reportError("newProposalPerson", "error.missingPersonRole", new String[0]);
            retval = false;
        }
        FormattedLogger.debug("Does document contain a proposal person with PERSON_ID " + person.getPersonId() + "?", new Object[0]);
        FormattedLogger.debug(document.getDevelopmentProposal().getProposalPersons().contains(person) + "", new Object[0]);
        int firstIndex = document.getDevelopmentProposal().getProposalPersons().indexOf(person);
        int lastIndex = document.getDevelopmentProposal().getProposalPersons().lastIndexOf(person);
        if (firstIndex != -1) {
            if (firstIndex == lastIndex) {
                if (this.isKeyPerson(person) && this.isKeyPerson(document.getDevelopmentProposal().getProposalPersons().get(firstIndex))) {
                    this.reportError("newProposalPerson", "error.proposalPersonExistsWithRole", person.getFullName(), "Key Person");
                    retval = false;
                } else if (this.isInvestigator(person) && this.isInvestigator(document.getDevelopmentProposal().getProposalPersons().get(firstIndex))) {
                    this.reportError("newProposalPerson", "error.proposalPersonExistsWithRole", person.getFullName(), "Investigator");
                    retval = false;
                }
            } else {
                this.reportError("newProposalPerson", "error.proposalPersonExistsWithRole", person.getFullName(), "both Investigator and Key Person");
                retval = false;
            }
        }
        if (StringUtils.isNotBlank((String)person.getProposalPersonRoleId()) && (StringUtils.isNotBlank((String)person.getPersonId()) && this.getKcPersonService().getKcPersonByPersonId(person.getPersonId()) == null || person.getRolodexId() != null && this.isInvalid(Rolodex.class, this.keyValue("rolodexId", person.getRolodexId())) || StringUtils.isBlank((String)person.getPersonId()) && person.getRolodexId() == null)) {
            this.reportError("newProposalPerson", "error.missingPersonRole", person.getFullName());
            retval = false;
        }
        if (this.isKeyPerson(person) && StringUtils.isBlank((String)person.getProjectRole())) {
            this.reportError("newProposalPerson", "error.required", "Key Person Role");
            retval = false;
        }
        if (document.getDevelopmentProposal().isParent()) {
            this.reportError("newProposalPerson", "error.hierarchy.unexpected", "Cannot add Personnel to the Parent of a Hierarchy");
            retval = false;
        }
        return retval;
    }

    protected void reportErrorWithPrefix(String errorPathPrefix, String propertyName, String errorKey, String ... errorParams) {
        GlobalVariables.getMessageMap().addToErrorPath(errorPathPrefix);
        super.reportError(propertyName, errorKey, errorParams);
        GlobalVariables.getMessageMap().removeFromErrorPath(errorPathPrefix);
    }

    private boolean isPrincipalInvestigator(ProposalPerson person) {
        return this.getKeyPersonnelService().isPrincipalInvestigator(person);
    }

    private boolean hasPrincipalInvestigator(ProposalDevelopmentDocument document) {
        return this.getKeyPersonnelService().hasPrincipalInvestigator(document);
    }

    private boolean isCoInvestigator(ProposalPerson person) {
        return this.getKeyPersonnelService().isCoInvestigator(person);
    }

    private boolean isInvestigator(ProposalPerson person) {
        return this.isCoInvestigator(person) || this.isPrincipalInvestigator(person);
    }

    private boolean isKeyPerson(ProposalPerson person) {
        return this.getKeyPersonnelService().isKeyPerson(person);
    }

    private KeyPersonnelService getKeyPersonnelService() {
        return KraServiceLocator.getService(KeyPersonnelService.class);
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    @Override
    public boolean processChangeKeyPersonBusinessRules(ProposalPerson proposalPerson, BusinessObject source, int index) {
        boolean retval = true;
        if (source instanceof ProposalPersonDegree) {
            retval &= this.validateDegree((ProposalPersonDegree)source, index);
        } else if (source instanceof ProposalPersonUnit) {
            retval &= this.validateUnit((ProposalPersonUnit)source, proposalPerson, index);
        }
        return retval;
    }

    private boolean validateUnit(ProposalPersonUnit source, ProposalPerson person, int index) {
        boolean retval = true;
        if (source == null) {
            FormattedLogger.debug("validated null unit", new Object[0]);
            return false;
        }
        FormattedLogger.debug("Validating unit %s", source);
        if (source.getUnit() == null && StringUtils.isBlank((String)source.getUnitNumber()) && GlobalVariables.getMessageMap().getMessages("newProposalPersonUnit*") == null) {
            GlobalVariables.getMessageMap().putError("newProposalPersonUnit[" + index + "].unitNumber", "error.select.unit", new String[0]);
            retval = false;
        }
        if (StringUtils.isNotBlank((String)source.getUnitNumber()) && this.isInvalid(Unit.class, this.keyValue("unitNumber", source.getUnitNumber())) && GlobalVariables.getMessageMap().getMessages("newProposalPersonUnit*") == null) {
            GlobalVariables.getMessageMap().putError("newProposalPersonUnit[" + index + "].unitNumber", "error.invalid.unit", new String[]{source.getUnitNumber(), person.getFullName()});
            retval = false;
        }
        FormattedLogger.debug("isLeadUnit %s", source.isLeadUnit());
        if (source.isDelete()) {
            if (person.getProposalPersonRoleId().equals("PI") && this.isDeletingUnitFromPrincipalInvestigator(source, person) && GlobalVariables.getMessageMap().getMessages("newProposalPersonUnit*") == null) {
                GlobalVariables.getMessageMap().putError("newProposalPersonUnit[" + index + "].unitNumber", "error.deleteLeadUnit", new String[]{source.getUnitNumber(), person.getFullName()});
                retval = false;
            }
        } else if (this.unitExists(source, person) && GlobalVariables.getMessageMap().getMessages("newProposalPersonUnit*") == null) {
            GlobalVariables.getMessageMap().putError("newProposalPersonUnit[" + index + "].unitNumber", "error.addExistingUnit", new String[]{source.getUnitNumber(), person.getFullName()});
            retval = false;
        }
        FormattedLogger.debug("validateUnit = %s", retval);
        return retval;
    }

    private boolean unitExists(ProposalPersonUnit source, ProposalPerson person) {
        for (ProposalPersonUnit unit : person.getUnits()) {
            if (!unit.getUnitNumber().equals(source.getUnitNumber())) continue;
            return true;
        }
        return false;
    }

    private boolean isDeletingUnitFromPrincipalInvestigator(ProposalPersonUnit unit, ProposalPerson person) {
        boolean retval = false;
        FormattedLogger.info(PERSON_HAS_UNIT_MSG, person.getProposalPersonNumber(), unit.getUnitNumber());
        return retval && unit.isDelete() && unit.isLeadUnit() && this.getKeyPersonnelService().isPrincipalInvestigator(person);
    }

    private boolean validateDegree(ProposalPersonDegree source, int index) {
        boolean retval = true;
        String regExpr = "^(16|17|18|19|20)[0-9]{2}$";
        if (source.getGraduationYear() != null && !source.getGraduationYear().matches(regExpr) && GlobalVariables.getMessageMap().getMessages("document.newProposalPersonDegree") == null) {
            GlobalVariables.getMessageMap().putError("newProposalPersonDegree[" + index + "].graduationYear", "error.invalid.year", new String[]{source.getGraduationYear(), "Graduation Year"});
            retval = false;
        }
        if (source == null) {
            return false;
        }
        if (StringUtils.isNotBlank((String)source.getDegreeCode()) && this.isInvalid(DegreeType.class, this.keyValue("degreeCode", source.getDegreeCode()))) {
            retval = false;
        }
        if (StringUtils.isBlank((String)source.getDegreeCode())) {
            GlobalVariables.getMessageMap().putError("newProposalPersonDegree[" + index + "].degreeCode", "error.required", new String[]{"Degree Type"});
            retval = false;
        }
        if (StringUtils.isBlank((String)source.getDegree())) {
            GlobalVariables.getMessageMap().putError("newProposalPersonDegree[" + index + "].degree", "error.required", new String[]{"Degree Description"});
            retval = false;
        }
        if (StringUtils.isBlank((String)source.getGraduationYear())) {
            GlobalVariables.getMessageMap().putError("newProposalPersonDegree[" + index + "].graduationYear", "error.required", new String[]{"Graduation year"});
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean processCalculateCreditSplitBusinessRules(ProposalDevelopmentDocument document) {
        List<ProposalPerson> person = document.getDevelopmentProposal().getInvestigators();
        boolean retval = true;
        for (int i = 0; i < person.size(); ++i) {
            int j;
            ProposalPerson propPerson = person.get(i);
            List<ProposalPersonCreditSplit> personCreditSplit = propPerson.getCreditSplits();
            List<ProposalPersonUnit> propUnitCreditSplit = propPerson.getUnits();
            for (j = 0; j < personCreditSplit.size(); ++j) {
                ProposalPersonCreditSplit creditSplit = personCreditSplit.get(j);
                if (creditSplit.getCredit() == null || !(creditSplit.getCredit().doubleValue() > 100.0) && !(creditSplit.getCredit().doubleValue() < 0.0)) continue;
                GlobalVariables.getMessageMap().putError("document.developmentProposalList[0].investigator[" + i + "].creditSplits[" + j + "].credit", "error.percentage", new String[]{"Credit Split"});
                retval = false;
            }
            for (j = 0; j < propUnitCreditSplit.size(); ++j) {
                List<ProposalUnitCreditSplit> unitCreditSplit = propUnitCreditSplit.get(j).getCreditSplits();
                for (int k = 0; k < unitCreditSplit.size(); ++k) {
                    ProposalUnitCreditSplit unitSplit = unitCreditSplit.get(k);
                    if (unitSplit.getCredit() == null || !(unitSplit.getCredit().doubleValue() > 100.0) && !(unitSplit.getCredit().doubleValue() < 0.0)) continue;
                    GlobalVariables.getMessageMap().putError("document.developmentProposalList[0].investigator[" + i + "].units[" + j + "].creditSplits[" + k + "].credit", "error.percentage", new String[]{"Credit Split"});
                    retval = false;
                }
            }
            ++i;
        }
        return retval;
    }
}

