/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.infrastructure.NarrativeRight;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeUserRights;
import org.kuali.kra.proposaldevelopment.bo.ProposalRoleState;
import org.kuali.kra.proposaldevelopment.bo.ProposalUser;
import org.kuali.kra.proposaldevelopment.bo.ProposalUserEditRoles;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.PermissionsRule;
import org.kuali.kra.proposaldevelopment.web.bean.ProposalUserRoles;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.kra.service.SystemAuthorizationService;
import org.kuali.rice.krad.document.Document;

public class ProposalDevelopmentPermissionsRule
extends ResearchDocumentRuleBase
implements PermissionsRule {
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentPermissionsRule.class);
    private transient KcPersonService kcPersonService;

    @Override
    public boolean processAddProposalUserBusinessRules(ProposalDevelopmentDocument document, List<ProposalUserRoles> proposalUserRolesList, ProposalUser proposalUser) {
        boolean isValid = true;
        KraWorkflowService kraWorkflowService = KraServiceLocator.getService(KraWorkflowService.class);
        if (StringUtils.isEmpty((String)proposalUser.getUsername())) {
            isValid = false;
            this.reportError("newProposalUser.username", "error.empty.username", new String[0]);
        } else if (!this.isValidUser(proposalUser.getUsername())) {
            isValid = false;
            this.reportError("newProposalUser.username", "error.unknown.username", new String[0]);
        } else if (this.isDuplicate(proposalUser.getUsername(), proposalUserRolesList)) {
            isValid = false;
            this.reportError("newProposalUser.username", "error.duplicate.proposalUser", new String[0]);
        } else if (kraWorkflowService.isInWorkflow((Document)document) && !this.isAddingViewerOnly(proposalUser)) {
            isValid = false;
            this.reportError("newProposalUser.roleName", "error.viewer.only", new String[0]);
        }
        return isValid;
    }

    @Override
    public boolean processDeleteProposalUserBusinessRules(ProposalDevelopmentDocument document, List<ProposalUserRoles> proposalUserRolesList, int index) {
        boolean isValid = true;
        KraWorkflowService kraWorkflowService = KraServiceLocator.getService(KraWorkflowService.class);
        ProposalUserRoles proposalUserRole = proposalUserRolesList.get(index);
        String username = proposalUserRole.getUsername();
        if (this.hasModifyNarrativePermission(username, proposalUserRolesList)) {
            isValid &= !this.testForLastModifier(username, document.getDevelopmentProposal().getNarratives(), "newProposalUser", "Proposal Attachment");
            isValid &= !this.testForLastModifier(username, document.getDevelopmentProposal().getInstituteAttachments(), "newProposalUser", "Internal Attachment");
        }
        if (this.isLastAggregator(username, proposalUserRolesList)) {
            isValid = false;
            this.reportError("newProposalUser", "error.last.aggregator", new String[0]);
        } else if (this.isAggregatorInitiator(document, proposalUserRole)) {
            isValid = false;
            this.reportError("newProposalUser", "error.propdev.perm.initiator", new String[0]);
        } else if (kraWorkflowService.isInWorkflow((Document)document)) {
            isValid = false;
            this.reportError("proposalUserEditRole", "error.viewer.only", new String[0]);
        }
        return isValid;
    }

    @Override
    public boolean processEditProposalUserRolesBusinessRules(ProposalDevelopmentDocument document, List<ProposalUserRoles> proposalUserRolesList, ProposalUserEditRoles editRoles) {
        boolean isValid = true;
        KraWorkflowService kraWorkflowService = KraServiceLocator.getService(KraWorkflowService.class);
        String username = editRoles.getUsername();
        if (this.isRemovingModifyNarrativePermission(proposalUserRolesList, editRoles)) {
            isValid &= !this.testForLastModifier(username, document.getDevelopmentProposal().getNarratives(), "proposalUserEditRole", "Proposal Attachment");
            isValid &= !this.testForLastModifier(username, document.getDevelopmentProposal().getInstituteAttachments(), "proposalUserEditRole", "Internal Attachment");
        }
        if (this.hasAggregator(editRoles) && this.hasNonAggregator(editRoles)) {
            isValid = false;
            this.reportError("proposalUserEditRole", "error.aggregator.inclusive", new String[0]);
        } else if (!this.hasAggregator(editRoles) && this.isLastAggregator(username, proposalUserRolesList)) {
            isValid = false;
            this.reportError("proposalUserEditRole", "error.last.aggregator", new String[0]);
        } else if (kraWorkflowService.isInWorkflow((Document)document)) {
            isValid = false;
            this.reportError("proposalUserEditRole", "error.viewer.only", new String[0]);
        }
        return isValid;
    }

    private boolean isOnlyModifier(String username, Narrative narrative) {
        boolean retval = true;
        KcPerson person = null;
        for (NarrativeUserRights narrativeUserRights : narrative.getNarrativeUserRights()) {
            person = this.getKcPersonService().getKcPersonByPersonId(narrativeUserRights.getUserId());
            if (StringUtils.equals((String)username, (String)person.getUserName()) || !StringUtils.equals((String)narrativeUserRights.getAccessType(), (String)NarrativeRight.MODIFY_NARRATIVE_RIGHT.getAccessType())) continue;
            retval = false;
            break;
        }
        return retval;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    private boolean isRemovingModifyNarrativePermission(List<ProposalUserRoles> proposalUserRolesList, ProposalUserEditRoles editRoles) {
        boolean newListContainsModifyNarrative = false;
        SystemAuthorizationService systemAuthorizationService = KraServiceLocator.getService(SystemAuthorizationService.class);
        List<String> matchingRoleNames = systemAuthorizationService.getRoleNamesForPermission("Modify Narrative", "KC-PD");
        for (ProposalRoleState roleState : editRoles.getRoleStates()) {
            if (!roleState.getState().booleanValue() || !matchingRoleNames.contains(roleState.getName())) continue;
            newListContainsModifyNarrative = true;
            break;
        }
        return this.hasModifyNarrativePermission(editRoles.getUsername(), proposalUserRolesList) && !newListContainsModifyNarrative;
    }

    private boolean hasModifyNarrativePermission(String username, List<ProposalUserRoles> proposalUserRolesList) {
        SystemAuthorizationService systemAuthorizationService = KraServiceLocator.getService(SystemAuthorizationService.class);
        List<String> matchingRoleNames = systemAuthorizationService.getRoleNamesForPermission("Modify Narrative", "KC-PD");
        for (ProposalUserRoles proposalUserRoles : proposalUserRolesList) {
            if (!proposalUserRoles.getUsername().equals(username)) continue;
            for (String roleName : proposalUserRoles.getRoleNames()) {
                if (!matchingRoleNames.contains(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean testForLastModifier(String username, List<Narrative> attachments, String errorLocationKey, String errorLabel) {
        int index = 1;
        boolean reportedError = false;
        for (Narrative attachment : attachments) {
            if (this.isOnlyModifier(username, attachment)) {
                reportedError = true;
                this.reportError(errorLocationKey, "error.narrative.one.modify.with.arg", errorLabel + " " + index);
            }
            ++index;
        }
        return reportedError;
    }

    private boolean hasAggregator(ProposalUserEditRoles editRoles) {
        List<ProposalRoleState> roleStates = editRoles.getRoleStates();
        for (ProposalRoleState roleState : roleStates) {
            String roleName;
            if (!roleState.getState().booleanValue() || !StringUtils.equals((String)(roleName = roleState.getName()), (String)"Aggregator")) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonAggregator(ProposalUserEditRoles editRoles) {
        List<ProposalRoleState> roleStates = editRoles.getRoleStates();
        for (ProposalRoleState roleState : roleStates) {
            String roleName;
            if (!roleState.getState().booleanValue() || StringUtils.equals((String)(roleName = roleState.getName()), (String)"Aggregator")) continue;
            return true;
        }
        return false;
    }

    private boolean isValidUser(String username) {
        return this.getKcPersonService().getKcPersonByUserName(username) != null;
    }

    private boolean isDuplicate(String username, List<ProposalUserRoles> proposalUserRolesList) {
        for (ProposalUserRoles userRoles : proposalUserRolesList) {
            if (!StringUtils.equals((String)username, (String)userRoles.getUsername())) continue;
            return true;
        }
        return false;
    }

    private boolean isLastAggregator(String username, List<ProposalUserRoles> proposalUserRolesList) {
        for (ProposalUserRoles userRoles : proposalUserRolesList) {
            if (StringUtils.equals((String)username, (String)userRoles.getUsername())) continue;
            List<String> roleNames = userRoles.getRoleNames();
            for (String roleName : roleNames) {
                if (!StringUtils.equals((String)roleName, (String)"Aggregator")) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAggregatorInitiator(ProposalDevelopmentDocument document, ProposalUserRoles proposalUserRole) {
        KcPerson initiator = this.getKcPersonService().getKcPersonByPersonId(document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        if (StringUtils.equals((String)initiator.getUserName(), (String)proposalUserRole.getUsername())) {
            for (String roleName : proposalUserRole.getRoleNames()) {
                if (!StringUtils.equals((String)roleName, (String)"Aggregator")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAddingViewerOnly(ProposalUser proposalUser) {
        return StringUtils.equals((String)proposalUser.getRoleName(), (String)"Viewer");
    }
}

