/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.AddProposalSiteRule;
import org.kuali.kra.proposaldevelopment.rule.event.AddProposalSiteEvent;
import org.kuali.kra.proposaldevelopment.rule.event.SaveProposalSitesEvent;
import org.kuali.kra.proposaldevelopment.rules.SaveProposalSitesRule;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public class ProposalDevelopmentProposalLocationRule
extends ResearchDocumentRuleBase
implements AddProposalSiteRule,
SaveProposalSitesRule {
    private static final String LOCATION_NAME_PROPERTY = "locationName";
    private static final String ADDRESS_NAME_PROPERTY = "address";

    @Override
    public boolean processAddProposalSiteBusinessRules(AddProposalSiteEvent addProposalSiteEvent) {
        boolean isPerformanceSite;
        ProposalSite proposalSite = addProposalSiteEvent.getProposalSite();
        boolean rulePassed = this.checkLocationName(proposalSite, LOCATION_NAME_PROPERTY);
        boolean bl = isPerformanceSite = proposalSite.getLocationTypeCode() == 4;
        if (proposalSite.getOrganization() == null && proposalSite.getRolodex() == null && !isPerformanceSite) {
            rulePassed = false;
            this.reportError(ADDRESS_NAME_PROPERTY, "error.required.address", new String[0]);
        }
        return rulePassed;
    }

    @Override
    public boolean processSaveProposalSiteBusinessRules(SaveProposalSitesEvent saveProposalSiteEvent) {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)saveProposalSiteEvent.getDocument();
        DevelopmentProposal developmentProposal = document.getDevelopmentProposal();
        boolean isValid = true;
        List<ProposalSite> performanceSites = developmentProposal.getPerformanceSites();
        for (int i = 0; i < performanceSites.size(); ++i) {
            isValid &= this.checkLocationName(performanceSites.get(i), "performanceSites[" + i + "].locationName");
        }
        List<ProposalSite> otherOrganizations = developmentProposal.getOtherOrganizations();
        for (int i = 0; i < otherOrganizations.size(); ++i) {
            isValid &= this.checkLocationName(otherOrganizations.get(i), "otherOrganizations[" + i + "].locationName");
        }
        return isValid;
    }

    private boolean checkLocationName(ProposalSite proposalSite, String propertyName) {
        boolean isValid = true;
        if (StringUtils.isBlank((String)proposalSite.getLocationName())) {
            isValid = false;
            this.reportError(propertyName, "error.required.locationName", new String[0]);
        }
        return isValid;
    }
}

