/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalDevelopmentModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.QuestionnaireUsage;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class ProposalDevelopmentQuestionnaireAuditRule
extends ResearchDocumentRuleBase
implements DocumentAuditRule {
    private static final String PROPOSAL_QUESTIONNAIRE_KEY = "questionnaireHelper.answerHeaders[%s].answers[0].answer";
    private static final String PROPOSAL_QUESTIONNAIRE_PANEL_KEY = "%s%s%s";
    private transient QuestionnaireAnswerService questionnaireAnswerService;

    @Override
    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        List<AnswerHeader> headers = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(new ProposalDevelopmentModuleQuestionnaireBean(proposalDevelopmentDocument.getDevelopmentProposal()));
        List<QuestionnaireUsage> usages = this.getQuestionnaireAnswerService().getPublishedQuestionnaire(new ProposalDevelopmentModuleQuestionnaireBean(proposalDevelopmentDocument.getDevelopmentProposal()));
        int i = 0;
        for (AnswerHeader answerHeader : headers) {
            if (!answerHeader.getCompleted()) {
                for (QuestionnaireUsage questionnaireUsage : usages) {
                    String questionnaireId = questionnaireUsage.getQuestionnaire().getQuestionnaireId();
                    if (!questionnaireId.equalsIgnoreCase(answerHeader.getQuestionnaire().getQuestionnaireId())) continue;
                    valid = false;
                    this.getProposalS2sAuditErrorsByGroup("questionnaireHelper", questionnaireUsage.getQuestionnaireLabel(), i).add(new AuditError(String.format(PROPOSAL_QUESTIONNAIRE_KEY, i, "complete"), "error.proposaldev.questionnaire.notcomplete", "questions." + questionnaireUsage.getQuestionnaireLabel(), new String[]{questionnaireUsage.getQuestionnaireLabel()}));
                    break;
                }
            }
            ++i;
        }
        return valid;
    }

    private synchronized QuestionnaireAnswerService getQuestionnaireAnswerService() {
        if (this.questionnaireAnswerService == null) {
            this.questionnaireAnswerService = KraServiceLocator.getService(QuestionnaireAnswerService.class);
        }
        return this.questionnaireAnswerService;
    }

    private List<AuditError> getProposalS2sAuditErrorsByGroup(String formProperty, String usageLabel, Integer answerHeaderIndex) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String key = String.format(PROPOSAL_QUESTIONNAIRE_PANEL_KEY, formProperty, usageLabel, answerHeaderIndex);
        if (!KNSGlobalVariables.getAuditErrorMap().containsKey(key)) {
            KNSGlobalVariables.getAuditErrorMap().put(key, new AuditCluster(usageLabel, auditErrors, "Validation Errors"));
        } else {
            auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(key)).getAuditErrorList();
        }
        return auditErrors;
    }
}

