/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProposalDevelopmentSponsorProgramInformationAuditRule
implements DocumentAuditRule {
    private ParameterService parameterService;
    private ProposalDevelopmentService proposalDevelopmentService;
    private BusinessObjectService businessObjectService;

    public ProposalDevelopmentSponsorProgramInformationAuditRule() {
        this.getParameterService();
        this.getProposalDevelopmentService();
    }

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal proposal = proposalDevelopmentDocument.getDevelopmentProposal();
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        if (proposal.getDeadlineDate() == null) {
            auditErrors.add(new AuditError("document.developmentProposalList[0].deadlineDate", "warning.empty.deadline.date", "proposal.SponsorProgramInformation"));
        } else if (proposal.getDeadlineDate().before(new Date(System.currentTimeMillis()))) {
            auditErrors.add(new AuditError("document.developmentProposalList[0].deadlineDate", "warning.past.deadline.date", "proposal.SponsorProgramInformation"));
        }
        if (auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put("sponsorProgramInformationAuditWarnings", new AuditCluster("Sponsor & Program Information", auditErrors, "Warnings"));
            valid &= false;
        }
        auditErrors = new ArrayList();
        if (proposal.getS2sOpportunity() != null) {
            if (proposal.getS2sOpportunity().getOpportunityId() != null && proposal.getProgramAnnouncementNumber() != null && !StringUtils.equalsIgnoreCase((String)proposal.getS2sOpportunity().getOpportunityId(), (String)proposal.getProgramAnnouncementNumber())) {
                valid &= false;
                auditErrors.add(new AuditError("document.developmentProposalList[0].programAnnouncementNumber", "error.opportunityId.differ", "proposal.SponsorProgramInformation"));
            }
            if (proposal.getS2sOpportunity().getCfdaNumber() != null && proposal.getCfdaNumber() != null && !StringUtils.equalsIgnoreCase((String)proposal.getS2sOpportunity().getCfdaNumber(), (String)proposal.getCfdaNumber())) {
                valid &= false;
                auditErrors.add(new AuditError("document.cfdaNumber", "error.cfdaNumber.differ", "proposal.SponsorProgramInformation"));
            }
            if (proposal.getProgramAnnouncementTitle() == null || StringUtils.equalsIgnoreCase((String)proposal.getProgramAnnouncementTitle().trim(), (String)"")) {
                valid &= false;
                auditErrors.add(new AuditError("document.developmentProposalList[0].programAnnouncementTitle", "error.opportunityTitle.deleted", "proposal.SponsorProgramInformation"));
            }
            String federalIdComesFromAwardStr = null;
            try {
                federalIdComesFromAwardStr = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "FEDERAL_ID_COMES_FROM_CURRENT_AWARD");
            }
            catch (Exception e) {
                // empty catch block
            }
            Boolean federalIdComesFromAward = federalIdComesFromAwardStr != null && federalIdComesFromAwardStr.equalsIgnoreCase("Y");
            Award currentAward = null;
            if (StringUtils.isNotBlank((String)proposal.getCurrentAwardNumber())) {
                currentAward = this.proposalDevelopmentService.getProposalCurrentAwardVersion(proposalDevelopmentDocument);
            }
            if (!(!this.isProposalTypeRenewalRevisionContinuation(proposal.getProposalTypeCode()) || StringUtils.isNotBlank((String)proposal.getSponsorProposalNumber()) || currentAward != null && StringUtils.isNotBlank((String)currentAward.getSponsorAwardNumber()) && federalIdComesFromAward.booleanValue())) {
                valid = false;
                auditErrors.add(new AuditError("document.developmentProposalList[0].sponsorProposalNumber", "error.proposal.require.priorAward", "proposal.SponsorProgramInformation"));
            }
            InstitutionalProposal iProposal = null;
            if (StringUtils.isNotBlank((String)proposal.getContinuedFrom())) {
                iProposal = this.proposalDevelopmentService.getProposalContinuedFromVersion(proposalDevelopmentDocument);
            }
            if (this.isProposalTypeResubmission(proposal.getProposalTypeCode()) && StringUtils.isBlank((String)proposal.getSponsorProposalNumber()) && (iProposal == null || StringUtils.isBlank((String)iProposal.getSponsorProposalNumber()))) {
                valid = false;
                auditErrors.add(new AuditError("document.developmentProposalList[0].sponsorProposalNumber", "error.proposal.require.priorAwardResubmit", "proposal.SponsorProgramInformation"));
            }
        }
        if (auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put("sponsorProgramInformationAuditErrors", new AuditCluster("Sponsor & Program Information", auditErrors, "Grants.Gov Errors"));
        }
        auditErrors = new ArrayList();
        if (!StringUtils.isEmpty((String)proposal.getPrimeSponsorCode())) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("sponsorCode", proposal.getPrimeSponsorCode());
            Sponsor sp = (Sponsor)this.getBusinessObjectService().findByPrimaryKey(Sponsor.class, primaryKeys);
            if (sp == null) {
                auditErrors.add(new AuditError("document.developmentProposalList[0].primeSponsorCode", "error.empty.primesponsorid", "proposal.SponsorProgramInformation"));
                valid &= false;
            }
        }
        if (auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put("sponsorProgramInformationAuditErrors", new AuditCluster("Sponsor & Program Information", auditErrors, "Validation Errors"));
            valid &= false;
        }
        return valid;
    }

    private boolean isProposalTypeRenewalRevisionContinuation(String proposalTypeCode) {
        String proposalTypeCodeRenewal = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.renewal");
        String proposalTypeCodeRevision = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.revision");
        String proposalTypeCodeContinuation = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.continuation");
        return !StringUtils.isEmpty((String)proposalTypeCode) && (proposalTypeCode.equals(proposalTypeCodeRenewal) || proposalTypeCode.equals(proposalTypeCodeRevision) || proposalTypeCode.equals(proposalTypeCodeContinuation));
    }

    private boolean isProposalTypeResubmission(String proposalTypeCode) {
        String proposalTypeCodeResubmission = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.resubmission");
        return !StringUtils.isEmpty((String)proposalTypeCode) && proposalTypeCode.equals(proposalTypeCodeResubmission);
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected ProposalDevelopmentService getProposalDevelopmentService() {
        if (this.proposalDevelopmentService == null) {
            this.proposalDevelopmentService = KraServiceLocator.getService(ProposalDevelopmentService.class);
        }
        return this.proposalDevelopmentService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setProposalDevelopmentService(ProposalDevelopmentService proposalDevelopmentService) {
        this.proposalDevelopmentService = proposalDevelopmentService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

