/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentDocumentRule;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class ProposalDevelopmentYnqAuditRule
extends ResearchDocumentRuleBase
implements DocumentAuditRule {
    private static final String PROPOSAL_QUESTIONS_KEY = "document.developmentProposalList[0].proposalYnq[%d].%s";
    private static final String PROPOSAL_QUESTIONS_PANEL_KEY = "ynqAuditErrors%s";

    @Override
    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        for (int j = 0; j < proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs().size(); ++j) {
            String explanationRequiredFor;
            String dateRequiredFor;
            ProposalYnq proposalYnq = proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs().get(j);
            String groupName = proposalYnq.getYnq().getGroupName();
            String ynqAnswer = proposalYnq.getAnswer();
            HashMap<String, Integer> questionSerials = ProposalDevelopmentDocumentRule.getQuestionSerialNumberBasedOnGroup(proposalDevelopmentDocument);
            if (StringUtils.isBlank((String)proposalYnq.getAnswer())) {
                valid = false;
                this.getProposalYnqAuditErrorsByGroup(groupName).add(new AuditError(String.format(PROPOSAL_QUESTIONS_KEY, j, "answer"), "error.required.answer", "questions." + groupName, new String[]{questionSerials.get(proposalYnq.getQuestionId()).toString(), groupName}));
            }
            if ((dateRequiredFor = proposalYnq.getYnq().getDateRequiredFor()) != null && StringUtils.isNotBlank((String)ynqAnswer) && dateRequiredFor.contains(ynqAnswer) && proposalYnq.getReviewDate() == null) {
                valid = false;
                this.getProposalYnqAuditErrorsByGroup(groupName).add(new AuditError(String.format(PROPOSAL_QUESTIONS_KEY, j, "reviewDate"), "error.required.for.reviewDate", "questions." + groupName, new String[]{questionSerials.get(proposalYnq.getQuestionId()).toString(), groupName}));
            }
            if ((explanationRequiredFor = proposalYnq.getYnq().getExplanationRequiredFor()) == null || !StringUtils.isNotBlank((String)ynqAnswer) || !explanationRequiredFor.contains(ynqAnswer) || !StringUtils.isBlank((String)proposalYnq.getExplanation())) continue;
            valid = false;
            this.getProposalYnqAuditErrorsByGroup(groupName).add(new AuditError(String.format(PROPOSAL_QUESTIONS_KEY, j, "explanation"), "error.required.for.explanation", "questions." + groupName, new String[]{questionSerials.get(proposalYnq.getQuestionId()).toString(), groupName}));
        }
        return valid;
    }

    private List<AuditError> getProposalYnqAuditErrorsByGroup(String groupName) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String key = String.format(PROPOSAL_QUESTIONS_PANEL_KEY, groupName);
        if (!KNSGlobalVariables.getAuditErrorMap().containsKey(key)) {
            KNSGlobalVariables.getAuditErrorMap().put(key, new AuditCluster(groupName, auditErrors, "Validation Errors"));
        } else {
            auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(key)).getAuditErrorList();
        }
        return auditErrors;
    }
}

