/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.PersonBiosketch;
import org.kuali.kra.bo.PersonDegree;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.Ynq;
import org.kuali.kra.budget.personnel.PersonRolodex;
import org.kuali.kra.infrastructure.Constants;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.logging.FormattedLogger;
import org.kuali.kra.proposaldevelopment.bo.CreditSplit;
import org.kuali.kra.proposaldevelopment.bo.InvestigatorCreditType;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiographyAttachment;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonCreditSplit;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonDegree;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonRole;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonUnit;
import org.kuali.kra.proposaldevelopment.bo.ProposalUnitCreditSplit;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.proposaldevelopment.service.NarrativeService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.YnqService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.service.BusinessObjectService;

public class KeyPersonnelServiceImpl
implements KeyPersonnelService,
Constants {
    private static final String READ_ONLY_ROLES_PARAM_NAME = "personrole.readonly.roles";
    private static final String NIH_PARM_KEY = "nih.";
    private KcPersonService kcPersonService;
    private BusinessObjectService businessObjectService;
    private NarrativeService narrativeService;
    private YnqService ynqService;
    private ParameterService parameterService;
    private SponsorService sponsorService;

    @Override
    public void populateDocument(ProposalDevelopmentDocument document) {
        if (this.hasBeenRoutedOrCanceled(document)) {
            Collection<InvestigatorCreditType> availableCreditTypes = this.getAllInvestigatorCreditTypes();
            HashSet<InvestigatorCreditType> usedCreditTypes = new HashSet<InvestigatorCreditType>();
            for (ProposalPerson person : document.getDevelopmentProposal().getInvestigators()) {
                for (ProposalPersonCreditSplit creditSplit : person.getCreditSplits()) {
                    for (InvestigatorCreditType currentCreditType : availableCreditTypes) {
                        if (!currentCreditType.getInvCreditTypeCode().equals(creditSplit.getInvCreditTypeCode())) continue;
                        usedCreditTypes.add(currentCreditType);
                    }
                }
            }
            document.getDevelopmentProposal().setInvestigatorCreditTypes(usedCreditTypes);
        } else {
            document.getDevelopmentProposal().setInvestigatorCreditTypes(this.getInvestigatorCreditTypes());
        }
        if (document.getDevelopmentProposal().getInvestigators().isEmpty() && !document.getDevelopmentProposal().getProposalPersons().isEmpty()) {
            FormattedLogger.info("Need to repopulate investigator list", new Object[0]);
            this.populateInvestigators(document);
            if (!document.getDocumentHeader().getWorkflowDocument().getStatus().getCode().equals("R")) {
                this.populateActiveCredittypesPerson(document);
            }
        }
        for (ProposalPerson person : document.getDevelopmentProposal().getProposalPersons()) {
            this.getYnqService().getPersonYNQ(person, document);
        }
    }

    public void populateActiveCredittypesPerson(ProposalDevelopmentDocument document) {
        Collection<InvestigatorCreditType> invcrdttype = this.getInvestigatorCreditTypes();
        for (ProposalPerson person : document.getDevelopmentProposal().getInvestigators()) {
            for (InvestigatorCreditType invcredtype : invcrdttype) {
                boolean creditTypeFound = false;
                for (ProposalPersonCreditSplit proposalpersoncrdt : person.getCreditSplits()) {
                    if (!invcredtype.getInvCreditTypeCode().equals(proposalpersoncrdt.getInvCreditTypeCode())) continue;
                    creditTypeFound = true;
                    break;
                }
                if (creditTypeFound) continue;
                ProposalPersonCreditSplit creditSplit = new ProposalPersonCreditSplit();
                creditSplit.setProposalNumber(person.getProposalNumber());
                creditSplit.setProposalPersonNumber(person.getProposalPersonNumber());
                creditSplit.setInvCreditTypeCode(invcredtype.getInvCreditTypeCode());
                creditSplit.setCredit(new KualiDecimal(0));
                person.getCreditSplits().add(creditSplit);
            }
            for (ProposalPersonUnit unitsplit : person.getUnits()) {
                for (InvestigatorCreditType invcrdtype : invcrdttype) {
                    boolean creditTypeFound = false;
                    for (ProposalUnitCreditSplit unitcreditsplit : unitsplit.getCreditSplits()) {
                        if (!invcrdtype.getInvCreditTypeCode().equals(unitcreditsplit.getInvCreditTypeCode())) continue;
                        creditTypeFound = true;
                        break;
                    }
                    if (creditTypeFound) continue;
                    ProposalUnitCreditSplit creditSplit = new ProposalUnitCreditSplit();
                    creditSplit.setProposalNumber(person.getProposalNumber());
                    creditSplit.setProposalPersonNumber(person.getProposalPersonNumber());
                    creditSplit.setInvCreditTypeCode(invcrdtype.getInvCreditTypeCode());
                    creditSplit.setCredit(new KualiDecimal(0));
                    unitsplit.getCreditSplits().add(creditSplit);
                }
            }
        }
    }

    public void populateInvestigators(ProposalDevelopmentDocument document) {
        FormattedLogger.debug("Populating Investigators", new Object[0]);
        FormattedLogger.debug("Clearing investigator list", new Object[0]);
        document.getDevelopmentProposal().getInvestigators().clear();
        for (ProposalPerson person : document.getDevelopmentProposal().getProposalPersons()) {
            FormattedLogger.debug(person.getFullName() + " is " + this.isInvestigator(person), new Object[0]);
            person.setInvestigatorFlag(this.isInvestigator(person));
            if (!person.isInvestigator()) continue;
            FormattedLogger.info("Adding investigator " + person.getFullName(), new Object[0]);
            document.getDevelopmentProposal().getInvestigators().add(person);
        }
    }

    @Override
    public void populateProposalPerson(ProposalPerson person, ProposalDevelopmentDocument document) {
        person = this.getYnqService().getPersonYNQ(person, document);
        person.setInvestigatorFlag(this.isInvestigator(person));
        if (person.isInvestigator()) {
            if (!document.getDevelopmentProposal().getInvestigators().contains(person)) {
                document.getDevelopmentProposal().getInvestigators().add(person);
            }
            this.populateCreditTypes(person);
            if (!this.isCoInvestigator(person)) {
                person.setMultiplePi(false);
            }
        }
        person.refreshReferenceObject("role");
        if (person.getRole() != null) {
            person.getRole().setReadOnly(this.isRoleReadOnly(person.getRole()));
        }
        person.setRoleChanged(false);
        try {
            if (person.getPersonId() != null && person.getPerson().getExtendedAttributes() != null) {
                KcPerson origPerson = person.getPerson();
                for (PersonDegree degree : origPerson.getExtendedAttributes().getPersonDegrees()) {
                    ProposalPersonDegree newDegree = new ProposalPersonDegree();
                    newDegree.setDegree(degree.getDegree());
                    newDegree.setDegreeCode(degree.getDegreeCode());
                    newDegree.setFieldOfStudy(degree.getFieldOfStudy());
                    newDegree.setGraduationYear(degree.getGraduationYear());
                    newDegree.setSchool(degree.getSchool());
                    newDegree.setSchoolId(degree.getSchoolId());
                    newDegree.setSchoolIdCode(degree.getSchoolIdCode());
                    newDegree.setDegreeSequenceNumber(document.getDocumentNextValue("proposalDevelopment.proposalPerson.degree.degreeSequenceNumber"));
                    person.addDegree(newDegree);
                }
                if (origPerson.getExtendedAttributes().getAttachments() != null) {
                    for (PersonBiosketch attachment : origPerson.getExtendedAttributes().getAttachments()) {
                        ProposalPersonBiography bio = new ProposalPersonBiography();
                        bio.setProposalPersonNumber(person.getProposalPersonNumber());
                        bio.setDocumentTypeCode(this.getDefaultPersonAttachmentDocType());
                        bio.setDescription(attachment.getDescription());
                        bio.setFileName(attachment.getFileName());
                        bio.setContentType(attachment.getContentType());
                        ProposalPersonBiographyAttachment personnelAttachment = new ProposalPersonBiographyAttachment();
                        personnelAttachment.setFileName(attachment.getFileName());
                        personnelAttachment.setProposalNumber(document.getDevelopmentProposal().getProposalNumber());
                        personnelAttachment.setProposalPersonNumber(person.getProposalPersonNumber());
                        personnelAttachment.setBiographyData(attachment.getAttachmentContent());
                        personnelAttachment.setContentType(attachment.getContentType());
                        if (bio.getPersonnelAttachmentList().isEmpty()) {
                            bio.getPersonnelAttachmentList().add(personnelAttachment);
                        } else {
                            bio.getPersonnelAttachmentList().set(0, personnelAttachment);
                        }
                        document.getDevelopmentProposal().addProposalPersonBiography(bio);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void populateCreditTypes(ProposalPerson person) {
        if (!person.getCreditSplits().isEmpty()) {
            return;
        }
        for (InvestigatorCreditType creditType : this.getInvestigatorCreditTypes()) {
            ProposalPersonCreditSplit creditSplit = new ProposalPersonCreditSplit();
            creditSplit.setProposalNumber(person.getProposalNumber());
            creditSplit.setProposalPersonNumber(person.getProposalPersonNumber());
            creditSplit.setInvCreditTypeCode(creditType.getInvCreditTypeCode());
            creditSplit.setCredit(new KualiDecimal(0));
            person.getCreditSplits().add(creditSplit);
        }
    }

    @Override
    public Collection<InvestigatorCreditType> getInvestigatorCreditTypes() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        BusinessObjectService bos = KraServiceLocator.getService(BusinessObjectService.class);
        valueMap.put("active", "true");
        return bos.findMatching(InvestigatorCreditType.class, valueMap);
    }

    public Collection<InvestigatorCreditType> getAllInvestigatorCreditTypes() {
        return this.getBusinessObjectService().findAll(InvestigatorCreditType.class);
    }

    public Collection<Ynq> getYesNoQuestions() {
        return this.getBusinessObjectService().findAll(Ynq.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map calculateCreditSplitTotals(ProposalDevelopmentDocument document) {
        HashMap retval = new HashMap();
        if (document.getDevelopmentProposal().getInvestigatorCreditTypes() == null || document.getDevelopmentProposal().getInvestigatorCreditTypes().size() == 0) {
            document.getDevelopmentProposal().setInvestigatorCreditTypes(this.getInvestigatorCreditTypes());
        }
        Collection<InvestigatorCreditType> creditTypes = document.getDevelopmentProposal().getInvestigatorCreditTypes();
        for (ProposalPerson investigator : document.getDevelopmentProposal().getInvestigators()) {
            HashMap<String, Object> creditTypeTotals = (HashMap<String, Object>)retval.get(investigator.getProposalPersonNumber().toString());
            HashMap<String, Object> investigatorCreditTypeTotals = (HashMap<String, Object>)retval.get("investigator");
            if (creditTypeTotals == null) {
                creditTypeTotals = new HashMap<String, Object>();
                retval.put(investigator.getProposalPersonNumber().toString(), creditTypeTotals);
            }
            if (investigatorCreditTypeTotals == null) {
                investigatorCreditTypeTotals = new HashMap<String, Object>();
                retval.put("investigator", investigatorCreditTypeTotals);
            }
            for (InvestigatorCreditType creditType : creditTypes) {
                KualiDecimal kualiDecimal;
                KualiDecimal totalCredit = (KualiDecimal)creditTypeTotals.get(creditType.getInvCreditTypeCode());
                if (totalCredit == null) {
                    totalCredit = new KualiDecimal(0);
                    creditTypeTotals.put(creditType.getInvCreditTypeCode(), totalCredit);
                }
                if ((kualiDecimal = (KualiDecimal)investigatorCreditTypeTotals.get(creditType.getInvCreditTypeCode())) == null) {
                    KualiDecimal kualiDecimal2 = new KualiDecimal(0);
                    investigatorCreditTypeTotals.put(creditType.getInvCreditTypeCode(), kualiDecimal2);
                }
                for (CreditSplit creditSplit : investigator.getCreditSplits()) {
                    void var11_14;
                    if (!creditSplit.getInvCreditTypeCode().equals(creditType.getInvCreditTypeCode())) continue;
                    investigatorCreditTypeTotals.put(creditType.getInvCreditTypeCode(), var11_14.add((AbstractKualiDecimal)creditSplit.getCredit()));
                }
            }
            for (ProposalPersonUnit unit : investigator.getUnits()) {
                for (CreditSplit creditSplit : unit.getCreditSplits()) {
                    KualiDecimal totalCredit = (KualiDecimal)creditTypeTotals.get(creditSplit.getInvCreditTypeCode());
                    if (totalCredit == null) {
                        totalCredit = new KualiDecimal(0);
                        creditTypeTotals.put(creditSplit.getInvCreditTypeCode(), totalCredit);
                    }
                    creditTypeTotals.put(creditSplit.getInvCreditTypeCode(), totalCredit.add((AbstractKualiDecimal)creditSplit.getCredit()));
                }
            }
        }
        return retval;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService boservice) {
        this.businessObjectService = boservice;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    @Override
    public boolean isPrincipalInvestigator(ProposalPerson person) {
        return "PI".equals(person.getProposalPersonRoleId());
    }

    @Override
    public boolean isCoInvestigator(ProposalPerson person) {
        return "COI".equals(person.getProposalPersonRoleId());
    }

    @Override
    public boolean isKeyPerson(ProposalPerson person) {
        return "KP".equals(person.getProposalPersonRoleId());
    }

    @Override
    public boolean isInvestigator(ProposalPerson person) {
        if (StringUtils.isNotBlank((String)person.getOptInUnitStatus()) && person.getOptInUnitStatus().equals("Y")) {
            return this.isPrincipalInvestigator(person) || this.isCoInvestigator(person) || this.isKeyPerson(person);
        }
        return this.isPrincipalInvestigator(person) || this.isCoInvestigator(person);
    }

    @Override
    public boolean hasPrincipalInvestigator(ProposalDevelopmentDocument document) {
        boolean retval;
        ProposalPerson person;
        Iterator<ProposalPerson> person_it = document.getDevelopmentProposal().getProposalPersons().iterator();
        for (retval = false; person_it.hasNext() && !retval; retval |= this.isPrincipalInvestigator(person)) {
            person = person_it.next();
        }
        return retval;
    }

    @Override
    public void addUnitToPerson(ProposalPerson person, ProposalPersonUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Cannot add null units to a ProposalPerson instance");
        }
        if (!person.containsUnit(unit.getUnitNumber())) {
            unit.setProposalNumber(person.getProposalNumber());
            unit.setProposalPersonNumber(person.getProposalPersonNumber());
            person.addUnit(unit);
            unit.refreshReferenceObject("unit");
        }
    }

    @Override
    public void assignLeadUnit(ProposalPerson person, String unitNumber) {
        if (person.containsUnit(unitNumber)) {
            person.getUnit(unitNumber).setLeadUnit(true);
            return;
        }
        ProposalPersonUnit unit = this.createProposalPersonUnit(unitNumber, person);
        unit.setLeadUnit(true);
        this.addUnitToPerson(person, unit);
    }

    @Override
    public ProposalPersonUnit createProposalPersonUnit(String unitId, ProposalPerson person) {
        ProposalPersonUnit retval = new ProposalPersonUnit();
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("unitNumber", unitId);
        Collection units = this.getBusinessObjectService().findMatching(Unit.class, valueMap);
        for (Unit found : units) {
            retval.setUnitNumber(found.getUnitNumber());
            retval.setUnit(found);
        }
        for (InvestigatorCreditType creditType : this.getInvestigatorCreditTypes()) {
            ProposalUnitCreditSplit creditSplit = new ProposalUnitCreditSplit();
            creditSplit.setProposalNumber(person.getProposalNumber());
            creditSplit.setProposalPersonNumber(person.getProposalPersonNumber());
            creditSplit.setUnitNumber(unitId);
            creditSplit.setInvCreditTypeCode(creditType.getInvCreditTypeCode());
            creditSplit.setCredit(new KualiDecimal(0));
            retval.getCreditSplits().add(creditSplit);
        }
        return retval;
    }

    public void setYnqService(YnqService ynqService) {
        this.ynqService = ynqService;
    }

    public NarrativeService getNarrativeService() {
        return this.narrativeService;
    }

    public void setNarrativeService(NarrativeService narrativeService) {
        this.narrativeService = narrativeService;
    }

    public YnqService getYnqService() {
        return this.ynqService;
    }

    @Override
    public boolean isRoleReadOnly(String roleId) {
        if (roleId == null) {
            return false;
        }
        String parmValue = this.parameterService.getParameterValueAsString("KC-GEN", "All", READ_ONLY_ROLES_PARAM_NAME);
        return parmValue.toLowerCase().contains(roleId.toLowerCase());
    }

    @Override
    public boolean isCreditSplitEnabled() {
        return this.parameterService.getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "proposaldevelopment.creditsplit.enabled");
    }

    public String getDefaultPersonAttachmentDocType() {
        return this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "DEFAULT_BIOGRAPHY_DOCUMENT_TYPE_CODE");
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public boolean isRoleReadOnly(ProposalPersonRole role) {
        if (role == null) {
            return false;
        }
        return this.isRoleReadOnly(role.getProposalPersonRoleId());
    }

    @Override
    public String getPrincipalInvestigatorRoleDescription(ProposalDevelopmentDocument document) {
        String parameterName = "personrole.pi";
        Sponsor sponsor = document.getDevelopmentProposal().getSponsor();
        if (sponsor != null && sponsor.getAcronym() != null && this.isSponsorNihMultiplePi(document)) {
            parameterName = "personrole.nih.pi";
        }
        return this.getRoleDescriptionParameterValue(parameterName);
    }

    public boolean isSponsorNihMultiplePi(ProposalDevelopmentDocument document) {
        return this.getSponsorService().isSponsorNihMultiplePi(document.getDevelopmentProposal());
    }

    @Override
    public Map<String, String> loadKeyPersonnelRoleDescriptions(boolean sponsorIsNih) {
        Collection roles = this.businessObjectService.findAll(ProposalPersonRole.class);
        HashMap<String, String> roleDescriptions = new HashMap<String, String>();
        for (ProposalPersonRole role : roles) {
            roleDescriptions.put(role.getProposalPersonRoleId(), this.findRoleDescription(role, sponsorIsNih));
        }
        return roleDescriptions;
    }

    protected SponsorService getSponsorService() {
        return this.sponsorService;
    }

    protected String findRoleDescription(ContactRole role, boolean sponsorIsNih) {
        String parmName = this.createRoleDescriptionParameterName(role, sponsorIsNih ? NIH_PARM_KEY : "");
        return this.getRoleDescriptionParameterValue(parmName);
    }

    protected String getRoleDescriptionParameterValue(String parmName) {
        return this.parameterService.getParameterValueAsString("KC-GEN", "All", parmName);
    }

    protected String createRoleDescriptionParameterName(ContactRole role, String nihToken) {
        return String.format("%s%s%s", "personrole.", nihToken, role.getRoleCode().toLowerCase());
    }

    protected boolean hasBeenRoutedOrCanceled(ProposalDevelopmentDocument document) {
        WorkflowDocument workflowDoc = document.getDocumentHeader().getWorkflowDocument();
        return !workflowDoc.isInitiated() && !workflowDoc.isSaved();
    }

    @Override
    public String getPersonnelRoleDesc(PersonRolodex person) {
        if (this.getSponsorService().isSponsorNihMultiplePi(person.getParent())) {
            String parmName = this.createRoleDescriptionParameterName(person.getContactRole(), NIH_PARM_KEY);
            if (StringUtils.equals((String)person.getContactRole().getRoleCode(), (String)"COI") && person.isMultiplePi()) {
                parmName = parmName + ".mpi";
            }
            return this.getRoleDescriptionParameterValue(parmName);
        }
        return person.getContactRole().getRoleDescription();
    }

    public void setSponsorService(SponsorService sponsorService) {
        this.sponsorService = sponsorService;
    }
}

