/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.infrastructure.NarrativeRight;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeUserRights;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.NarrativeAuthZService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.SystemAuthorizationService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NarrativeAuthZServiceImpl
implements NarrativeAuthZService {
    private BusinessObjectService businessObjectService;
    private SystemAuthorizationService systemAuthorizationService;
    private KraAuthorizationService kraAuthorizationService;

    @Override
    public NarrativeRight authorize(Narrative narrative, String loggedInUserId) {
        HashMap<String, Object> narrativeRightQuery = new HashMap<String, Object>();
        narrativeRightQuery.put("proposalNumber", narrative.getProposalNumber());
        narrativeRightQuery.put("moduleNumber", narrative.getModuleNumber());
        narrativeRightQuery.put("userId", loggedInUserId);
        Collection narrativeUserRights = this.getBusinessObjectService().findMatching(NarrativeUserRights.class, narrativeRightQuery);
        for (NarrativeUserRights narrativeUserRight : narrativeUserRights) {
            if (narrativeUserRight.getAccessType().equals(NarrativeRight.MODIFY_NARRATIVE_RIGHT.getAccessType())) {
                return NarrativeRight.MODIFY_NARRATIVE_RIGHT;
            }
            if (narrativeUserRight.getAccessType().equals(NarrativeRight.VIEW_NARRATIVE_RIGHT.getAccessType())) {
                return NarrativeRight.VIEW_NARRATIVE_RIGHT;
            }
            if (!narrativeUserRight.getAccessType().equals(NarrativeRight.NO_NARRATIVE_RIGHT.getAccessType())) continue;
            return NarrativeRight.NO_NARRATIVE_RIGHT;
        }
        return NarrativeRight.NO_NARRATIVE_RIGHT;
    }

    public void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    @Override
    public NarrativeRight getDefaultNarrativeRight(String userId, ProposalDevelopmentDocument doc) {
        NarrativeRight right = this.kraAuthorizationService.hasPermission(userId, doc, "Modify Narrative") ? NarrativeRight.MODIFY_NARRATIVE_RIGHT : (this.kraAuthorizationService.hasPermission(userId, doc, "View Narratives") ? NarrativeRight.VIEW_NARRATIVE_RIGHT : NarrativeRight.NO_NARRATIVE_RIGHT);
        return right;
    }

    @Override
    public NarrativeRight getDefaultNarrativeRight(String roleName) {
        return this.getDefaultNarrativeRight(Collections.singletonList(roleName));
    }

    @Override
    public NarrativeRight getDefaultNarrativeRight(List<String> roleNames) {
        List<String> matchingRoleNames = this.systemAuthorizationService.getRoleNamesForPermission("Modify Narrative", "KC-PD");
        for (String role : roleNames) {
            if (!matchingRoleNames.contains(role)) continue;
            return NarrativeRight.MODIFY_NARRATIVE_RIGHT;
        }
        matchingRoleNames.clear();
        matchingRoleNames = this.systemAuthorizationService.getRoleNamesForPermission("View Narratives", "KC-PD");
        for (String role : roleNames) {
            if (!matchingRoleNames.contains(role)) continue;
            return NarrativeRight.VIEW_NARRATIVE_RIGHT;
        }
        return NarrativeRight.NO_NARRATIVE_RIGHT;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }
}

