/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.CustomAttributeDocValue;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.summary.BudgetSummaryService;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.CongressionalDistrict;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeAttachment;
import org.kuali.kra.proposaldevelopment.bo.NarrativeUserRights;
import org.kuali.kra.proposaldevelopment.bo.ProposalAbstract;
import org.kuali.kra.proposaldevelopment.bo.ProposalCopyCriteria;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiographyAttachment;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonExtendedAttributes;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonRole;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonUnit;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonYnq;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.bo.ProposalUnitCreditSplit;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardAttachment;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardFiles;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwards;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModular;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.hierarchy.HierarchyStatusConstants;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalDevelopmentModuleQuestionnaireBean;
import org.kuali.kra.proposaldevelopment.rule.event.CopyProposalEvent;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.proposaldevelopment.service.NarrativeService;
import org.kuali.kra.proposaldevelopment.service.ProposalCopyService;
import org.kuali.kra.proposaldevelopment.service.ProposalPersonBiographyService;
import org.kuali.kra.questionnaire.QuestionnaireService;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class ProposalCopyServiceImpl
implements ProposalCopyService {
    private static final String MODULE_NUMBER = "moduleNumber";
    private static final String PROPOSAL_NUMBER = "proposalNumber";
    private static final Log LOG = LogFactory.getLog(ProposalCopyServiceImpl.class);
    private BudgetService<DevelopmentProposal> budgetService;
    private BudgetSummaryService budgetSummaryService;
    private QuestionnaireService questionnaireService;
    private QuestionnaireAnswerService questionnaireAnswerService;
    private static String[] filteredProperties = new String[]{"ProposalNumber", "OwnedByUnitNumber", "OwnedByUnit", "Narratives", "InstituteAttachments", "PropPersonBios", "BudgetVersionOverviews", "SubmitFlag", "ProposalStateTypeCode", "ProposalState", "ProposalDocument", "YnqGroupNames"};
    private BusinessObjectService businessObjectService;
    private KeyPersonnelService keyPersonnelService;
    private DocumentService documentService;
    private ParameterService parameterService;
    private DateTimeService dateTimeService;

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public String copyProposal(ProposalDevelopmentDocument doc, ProposalCopyCriteria criteria) throws Exception {
        String newDocNbr = null;
        LOG.info((Object)"STARTING PROPOSAL COPY");
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new CopyProposalEvent(doc, criteria));
        if (rulePassed) {
            ProposalDevelopmentDocument newDoc = this.createNewProposal(doc, criteria);
            this.copyProposal(doc, newDoc, criteria);
            this.fixProposal(doc, newDoc, criteria);
            DocumentService docService = KRADServiceLocatorWeb.getDocumentService();
            docService.saveDocument((Document)newDoc);
            this.initializeAuthorization(newDoc);
            if (criteria.getIncludeAttachments()) {
                this.copyAttachments(doc, newDoc);
            }
            if (criteria.getIncludeBudget()) {
                this.copyBudget(doc, newDoc, criteria.getBudgetVersions());
            }
            if (criteria.getIncludeQuestionnaire()) {
                ProposalDevelopmentModuleQuestionnaireBean moduleQuestionnaireBean = new ProposalDevelopmentModuleQuestionnaireBean(doc.getDevelopmentProposal(), true);
                List<AnswerHeader> answerHeaders = this.questionnaireAnswerService.getQuestionnaireAnswer(moduleQuestionnaireBean);
                ProposalDevelopmentModuleQuestionnaireBean destModuleQuestionnaireBean = new ProposalDevelopmentModuleQuestionnaireBean(newDoc.getDevelopmentProposal(), false);
                this.questionnaireAnswerService.copyAnswerHeaders(moduleQuestionnaireBean, destModuleQuestionnaireBean);
            }
            List<ProposalPerson> proposalPersons = newDoc.getDevelopmentProposal().getProposalPersons();
            for (ProposalPerson person : proposalPersons) {
                if (person.getProposalPersonExtendedAttributes() == null) continue;
                this.businessObjectService.save((PersistableBusinessObject)person.getProposalPersonExtendedAttributes());
            }
            this.copyCustomData(doc, newDoc);
            newDocNbr = newDoc.getDocumentNumber();
        }
        return newDocNbr;
    }

    protected ProposalDevelopmentDocument createNewProposal(ProposalDevelopmentDocument srcDoc, ProposalCopyCriteria criteria) throws Exception {
        DocumentService docService = KRADServiceLocatorWeb.getDocumentService();
        ProposalDevelopmentDocument newDoc = (ProposalDevelopmentDocument)docService.getNewDocument(srcDoc.getClass());
        LOG.info((Object)"EXECUTING IN createNewProposal");
        this.copyOverviewProperties(srcDoc, newDoc);
        this.copyRequiredProperties(srcDoc, newDoc);
        this.setLeadUnit(newDoc, criteria.getLeadUnitNumber());
        newDoc.getDocumentHeader().setDocumentTemplateNumber(srcDoc.getDocumentNumber());
        docService.saveDocument((Document)newDoc);
        return newDoc;
    }

    protected void copyRequiredProperties(ProposalDevelopmentDocument srcDoc, ProposalDevelopmentDocument destDoc) {
        DevelopmentProposal srcDevelopmentProposal = srcDoc.getDevelopmentProposal();
        DevelopmentProposal destDevelopmentProposal = destDoc.getDevelopmentProposal();
        destDoc.getDocumentHeader().setDocumentDescription(srcDoc.getDocumentHeader().getDocumentDescription());
        destDevelopmentProposal.setProposalTypeCode(srcDevelopmentProposal.getProposalTypeCode());
        destDevelopmentProposal.setActivityTypeCode(srcDevelopmentProposal.getActivityTypeCode());
        destDevelopmentProposal.setTitle(srcDevelopmentProposal.getTitle());
        destDevelopmentProposal.setSponsorCode(srcDevelopmentProposal.getSponsorCode());
        destDevelopmentProposal.setRequestedStartDateInitial(srcDevelopmentProposal.getRequestedStartDateInitial());
        destDevelopmentProposal.setRequestedEndDateInitial(srcDevelopmentProposal.getRequestedEndDateInitial());
        destDevelopmentProposal.getApplicantOrganization().setLocationName(srcDevelopmentProposal.getApplicantOrganization().getLocationName());
        destDevelopmentProposal.getApplicantOrganization().setSiteNumber(srcDevelopmentProposal.getApplicantOrganization().getSiteNumber());
        destDevelopmentProposal.getPerformingOrganization().setLocationName(srcDevelopmentProposal.getPerformingOrganization().getLocationName());
        destDevelopmentProposal.getPerformingOrganization().setSiteNumber(srcDevelopmentProposal.getPerformingOrganization().getSiteNumber());
        if (this.isProposalTypeRenewalRevisionContinuation(srcDevelopmentProposal.getProposalTypeCode())) {
            destDevelopmentProposal.setSponsorProposalNumber(srcDevelopmentProposal.getSponsorProposalNumber());
        }
    }

    protected void copyProposal(ProposalDevelopmentDocument src, ProposalDevelopmentDocument dest, ProposalCopyCriteria criteria) throws Exception {
        this.copyProposalProperties(src, dest);
    }

    protected void copyProposalProperties(ProposalDevelopmentDocument src, ProposalDevelopmentDocument dest) throws Exception {
        List<DocProperty> properties = this.getCopyableProperties();
        this.fixNextValues(src, dest);
        this.copyProperties(src.getDevelopmentProposal(), dest.getDevelopmentProposal(), properties);
    }

    protected void fixNextValues(ProposalDevelopmentDocument oldDoc, ProposalDevelopmentDocument newDoc) {
        ArrayList<DocumentNextvalue> newNextValues = new ArrayList<DocumentNextvalue>();
        List<DocumentNextvalue> oldNextValues = oldDoc.getDocumentNextvalues();
        for (DocumentNextvalue oldNextValue : oldNextValues) {
            DocumentNextvalue newNextValue = new DocumentNextvalue();
            newNextValue.setPropertyName(oldNextValue.getPropertyName());
            newNextValue.setNextValue(oldNextValue.getNextValue());
            newNextValue.setDocumentKey(newDoc.getDocumentNumber());
            newNextValues.add(newNextValue);
        }
        newDoc.setDocumentNextvalues(newNextValues);
    }

    protected void copyProperties(DevelopmentProposal src, DevelopmentProposal dest, List<DocProperty> properties) throws Exception {
        for (DocProperty property : properties) {
            Object value = property.getter.invoke((Object)src, new Object[0]);
            if (value instanceof Serializable && (value = ObjectUtils.deepCopy((Serializable)((Serializable)value))) instanceof PersistableBusinessObjectBase) {
                PersistableBusinessObjectBase obj = (PersistableBusinessObjectBase)value;
                obj.setVersionNumber(null);
            }
            property.setter.invoke((Object)dest, value);
        }
    }

    protected void copyOverviewProperties(ProposalDevelopmentDocument src, ProposalDevelopmentDocument dest) {
        DocumentHeader srcHdr = src.getDocumentHeader();
        DocumentHeader destHdr = dest.getDocumentHeader();
        destHdr.setDocumentDescription(srcHdr.getDocumentDescription());
        destHdr.setExplanation(srcHdr.getExplanation());
        destHdr.setOrganizationDocumentNumber(srcHdr.getOrganizationDocumentNumber());
    }

    protected List<DocProperty> getCopyableProperties() {
        Method[] methods;
        ArrayList<DocProperty> list = new ArrayList<DocProperty>();
        for (Method method : methods = DevelopmentProposal.class.getDeclaredMethods()) {
            Method getter;
            String name;
            if (!method.getName().startsWith("set") || this.isFilteredProperty(name = this.getPropertyName(method)) || (getter = this.getGetter(name, methods)) == null || getter.getParameterTypes().length != 0 || method.getParameterTypes().length != 1) continue;
            list.add(new DocProperty(getter, method));
        }
        return list;
    }

    protected String getPropertyName(Method method) {
        String name = method.getName();
        return name.substring(3);
    }

    protected boolean isFilteredProperty(String name) {
        for (String filteredProperty : filteredProperties) {
            if (!name.equals(filteredProperty)) continue;
            return true;
        }
        return name.endsWith("Service");
    }

    protected Method getGetter(String name, Method[] methods) {
        String getter = "get" + name;
        for (Method method : methods) {
            if (!getter.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    protected void setLeadUnit(ProposalDevelopmentDocument doc, String newLeadUnitNumber) {
        UnitService unitService = KraServiceLocator.getService(UnitService.class);
        Unit newLeadUnit = unitService.getUnit(newLeadUnitNumber);
        doc.getDevelopmentProposal().setOwnedByUnitNumber(newLeadUnitNumber);
        doc.getDevelopmentProposal().setOwnedByUnit(newLeadUnit);
    }

    protected void fixProposal(ProposalDevelopmentDocument srcDoc, ProposalDevelopmentDocument newDoc, ProposalCopyCriteria criteria) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ProposalPerson proposalperson : newDoc.getDevelopmentProposal().getProposalPersons()) {
            proposalperson.setDevelopmentProposal(newDoc.getDevelopmentProposal());
            proposalperson.setProposalNumber(newDoc.getDevelopmentProposal().getProposalNumber());
            for (ProposalPersonUnit proposalPersonUnit : proposalperson.getUnits()) {
                ObjectUtils.materializeObjects(proposalPersonUnit.getCreditSplits());
            }
            for (ProposalPerson srcProposalperson : srcDoc.getDevelopmentProposal().getProposalPersons()) {
                if (!StringUtils.equals((String)proposalperson.getFullName(), (String)srcProposalperson.getFullName()) || !StringUtils.equals((String)proposalperson.getProposalPersonRoleId(), (String)srcProposalperson.getProposalPersonRoleId()) || srcProposalperson.getProposalPersonExtendedAttributes() == null) continue;
                ProposalPersonExtendedAttributes ppea = (ProposalPersonExtendedAttributes)((Object)ObjectUtils.deepCopy((Serializable)((Object)srcProposalperson.getProposalPersonExtendedAttributes())));
                ppea.setProposalPerson(proposalperson);
                ppea.setProposalNumber(proposalperson.getProposalNumber());
                ppea.setProposalPersonNumber(proposalperson.getProposalPersonNumber());
                ppea.setProposalPersonRoleId(proposalperson.getProposalPersonRoleId());
                proposalperson.setProposalPersonExtendedAttributes(ppea);
            }
        }
        this.fixProposalNumbers(newDoc, newDoc.getDevelopmentProposal().getProposalNumber(), list);
        this.fixKeyPersonnel(newDoc, srcDoc.getDevelopmentProposal().getOwnedByUnitNumber(), criteria.getLeadUnitNumber());
        this.fixCongressionalDistricts(newDoc);
        if (!StringUtils.equals((String)srcDoc.getDevelopmentProposal().getUnitNumber(), (String)newDoc.getDevelopmentProposal().getUnitNumber())) {
            this.fixOrganizationAndLocations(newDoc);
        }
        list.clear();
        this.fixBudgetVersions(newDoc);
        newDoc.getDevelopmentProposal().setHierarchyStatus(HierarchyStatusConstants.None.code());
        newDoc.getDevelopmentProposal().setHierarchyParentProposalNumber(null);
        newDoc.getDevelopmentProposal().setHierarchyLastSyncHashCode(null);
        newDoc.getDevelopmentProposal().cleanupSpecialReviews(srcDoc.getDevelopmentProposal());
        for (ProposalAbstract curAbstract : newDoc.getDevelopmentProposal().getProposalAbstracts()) {
            curAbstract.setTimestampDisplay(this.dateTimeService.getCurrentTimestamp());
        }
    }

    protected void fixOrganizationAndLocations(ProposalDevelopmentDocument doc) {
        DevelopmentProposal developmentProposal = doc.getDevelopmentProposal();
        Unit ownedByUnit = developmentProposal.getOwnedByUnit();
        if (ownedByUnit != null) {
            String unitOrganizationId = ownedByUnit.getOrganizationId();
            for (ProposalSite proposalSite : developmentProposal.getProposalSites()) {
                proposalSite.setOrganizationId(unitOrganizationId);
                proposalSite.refreshReferenceObject("organization");
                proposalSite.setLocationName(proposalSite.getOrganization().getOrganizationName());
                proposalSite.setRolodexId(proposalSite.getOrganization().getContactAddressId());
                proposalSite.refreshReferenceObject("rolodex");
            }
        }
    }

    protected void fixProposalNumbers(Object object, String proposalNumber, List<Object> list) throws Exception {
        if (object instanceof BusinessObject) {
            Method[] methods;
            if (list.contains(object)) {
                return;
            }
            list.add(object);
            for (Method method : methods = object.getClass().getMethods()) {
                if (method.getName().equals("setProposalNumber")) {
                    method.invoke(object, proposalNumber);
                    continue;
                }
                if (!this.isPropertyGetterMethod(method, methods)) continue;
                Object value = method.invoke(object, new Object[0]);
                if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    for (Object entry : c) {
                        this.fixProposalNumbers(entry, proposalNumber, list);
                    }
                    continue;
                }
                this.fixProposalNumbers(value, proposalNumber, list);
            }
        }
    }

    protected boolean isPropertyGetterMethod(Method method, Method[] methods) {
        if (method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
            String setterName = method.getName().replaceFirst("get", "set");
            for (Method m : methods) {
                if (!m.getName().equals(setterName)) continue;
                return true;
            }
        }
        return false;
    }

    protected void fixKeyPersonnel(ProposalDevelopmentDocument doc, String oldLeadUnitNumber, String newLeadUnitNumber) throws Exception {
        this.clearCertifyQuestions(doc);
        this.fixKeyPersonnelUnits(doc, oldLeadUnitNumber, newLeadUnitNumber);
    }

    protected void fixCongressionalDistricts(ProposalDevelopmentDocument doc) {
        for (ProposalSite proposalSite : doc.getDevelopmentProposal().getProposalSites()) {
            for (CongressionalDistrict district : proposalSite.getCongressionalDistricts()) {
                district.setCongressionalDistrictId(null);
            }
        }
    }

    protected void fixBudgetVersions(ProposalDevelopmentDocument doc) {
        if (doc.getBudgetDocumentVersions().size() > 0) {
            String budgetStatusIncompleteCode = this.parameterService.getParameterValueAsString(BudgetDocument.class, "budgetStatusIncompleteCode");
            doc.getDevelopmentProposal().setBudgetStatus(budgetStatusIncompleteCode);
        }
    }

    protected void clearCertifyQuestions(ProposalDevelopmentDocument doc) {
        List<ProposalPerson> persons = doc.getDevelopmentProposal().getProposalPersons();
        for (ProposalPerson person : persons) {
            ProposalPersonRole role = person.getRole();
            String roleId = role.getProposalPersonRoleId();
            if (!StringUtils.equals((String)roleId, (String)"PI") && !StringUtils.equals((String)roleId, (String)"COI")) continue;
            List<ProposalPersonYnq> questions = person.getProposalPersonYnqs();
            for (ProposalPersonYnq question : questions) {
                question.setAnswer(null);
                question.setDummyAnswer(null);
            }
        }
    }

    protected void fixKeyPersonnelUnits(ProposalDevelopmentDocument doc, String oldLeadUnitNumber, String newLeadUnitNumber) throws Exception {
        List<ProposalPerson> persons = doc.getDevelopmentProposal().getProposalPersons();
        for (ProposalPerson person : persons) {
            person.setProposalNumber(null);
            ProposalPersonRole role = person.getRole();
            String roleId = role.getProposalPersonRoleId();
            if (StringUtils.equals((String)roleId, (String)"PI")) {
                List<ProposalPersonUnit> proposalPersonUnits = person.getUnits();
                ArrayList<ProposalPersonUnit> newProposalPersonUnits = new ArrayList<ProposalPersonUnit>();
                ProposalPersonUnit unit = this.createProposalPersonUnit(person, newLeadUnitNumber, true, false, proposalPersonUnits);
                newProposalPersonUnits.add(unit);
                String homeUnitNumber = person.getHomeUnit();
                if (!StringUtils.equals((String)newLeadUnitNumber, (String)homeUnitNumber) && (unit = this.createProposalPersonUnit(person, homeUnitNumber, false, true, proposalPersonUnits)) != null) {
                    newProposalPersonUnits.add(unit);
                }
                for (ProposalPersonUnit oldUnit : proposalPersonUnits) {
                    String oldUnitNumber = oldUnit.getUnitNumber();
                    if (StringUtils.equals((String)newLeadUnitNumber, (String)oldUnitNumber) || StringUtils.equals((String)homeUnitNumber, (String)oldUnitNumber) || StringUtils.equals((String)oldLeadUnitNumber, (String)oldUnitNumber)) continue;
                    unit = this.createProposalPersonUnit(person, oldUnitNumber, false, true, proposalPersonUnits);
                    newProposalPersonUnits.add(unit);
                }
                person.setUnits(newProposalPersonUnits);
            }
            for (ProposalPersonYnq ynq : person.getProposalPersonYnqs()) {
                ynq.setAnswer(null);
            }
        }
        doc.getDevelopmentProposal().setInvestigators(new ArrayList<ProposalPerson>());
        this.keyPersonnelService.populateDocument(doc);
    }

    protected ProposalPersonUnit createProposalPersonUnit(ProposalPerson person, String unitNumber, boolean isLeadUnit, boolean isDeletable, List<ProposalPersonUnit> oldProposalPersonUnits) {
        ProposalPersonUnit proposalPersonUnit = this.keyPersonnelService.createProposalPersonUnit(unitNumber, person);
        if (proposalPersonUnit.getUnitNumber() == null) {
            return null;
        }
        proposalPersonUnit.setLeadUnit(isLeadUnit);
        proposalPersonUnit.setDelete(isDeletable);
        proposalPersonUnit.setVersionNumber(null);
        ProposalPersonUnit oldProposalPersonUnit = this.findProposalPersonUnit(unitNumber, oldProposalPersonUnits);
        if (oldProposalPersonUnit != null) {
            ArrayList<ProposalUnitCreditSplit> newUnitCreditSplits = new ArrayList<ProposalUnitCreditSplit>();
            List<ProposalUnitCreditSplit> oldUnitCreditSplits = oldProposalPersonUnit.getCreditSplits();
            for (ProposalUnitCreditSplit oldUnitCreditSplit : oldUnitCreditSplits) {
                ProposalUnitCreditSplit newUnitCreditSplit = (ProposalUnitCreditSplit)((Object)ObjectUtils.deepCopy((Serializable)((Object)oldUnitCreditSplit)));
                newUnitCreditSplit.setVersionNumber(null);
                newUnitCreditSplits.add(newUnitCreditSplit);
            }
            proposalPersonUnit.setCreditSplits(newUnitCreditSplits);
        }
        return proposalPersonUnit;
    }

    protected ProposalPersonUnit findProposalPersonUnit(String unitNumber, List<ProposalPersonUnit> proposalPersonUnits) {
        for (ProposalPersonUnit proposalPersonUnit : proposalPersonUnits) {
            if (!StringUtils.equals((String)unitNumber, (String)proposalPersonUnit.getUnitNumber())) continue;
            return proposalPersonUnit;
        }
        return null;
    }

    protected void initializeAuthorization(ProposalDevelopmentDocument doc) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        KraAuthorizationService kraAuthService = KraServiceLocator.getService(KraAuthorizationService.class);
        kraAuthService.addRole(userId, "Aggregator", doc);
    }

    protected void copyAttachments(ProposalDevelopmentDocument src, ProposalDevelopmentDocument dest) throws Exception {
        NarrativeService narrativeService = dest.getDevelopmentProposal().getNarrativeService();
        ProposalPersonBiographyService propPersonBioService = dest.getDevelopmentProposal().getProposalPersonBiographyService();
        this.loadAttachmentContents(src);
        List<ProposalPersonBiography> propPersonBios = src.getDevelopmentProposal().getPropPersonBios();
        for (ProposalPersonBiography srcPropPersonBio : propPersonBios) {
            ProposalPersonBiography destPropPersonBio = (ProposalPersonBiography)((Object)ObjectUtils.deepCopy((Serializable)((Object)srcPropPersonBio)));
            propPersonBioService.addProposalPersonBiography(dest, destPropPersonBio);
        }
        List<Narrative> narratives = src.getDevelopmentProposal().getNarratives();
        for (Narrative srcNarrative : narratives) {
            Narrative destNarrative = (Narrative)((Object)ObjectUtils.deepCopy((Serializable)((Object)srcNarrative)));
            if (StringUtils.equals((String)destNarrative.getNarrativeType().getNarrativeTypeGroup(), (String)"P")) {
                destNarrative.setModuleStatusCode("I");
            } else {
                destNarrative.setModuleStatusCode("C");
            }
            this.removePersonNarrativePermission(GlobalVariables.getUserSession().getPrincipalId(), destNarrative);
            narrativeService.addNarrative(dest, destNarrative);
        }
    }

    protected void removePersonNarrativePermission(String personId, Narrative narrative) {
        Iterator<NarrativeUserRights> iter = narrative.getNarrativeUserRights().iterator();
        while (iter.hasNext()) {
            NarrativeUserRights right = iter.next();
            if (!StringUtils.equals((String)right.getUserId(), (String)personId)) continue;
            iter.remove();
        }
    }

    protected void loadAttachmentContents(ProposalDevelopmentDocument doc) {
        List<Narrative> narratives = doc.getDevelopmentProposal().getNarratives();
        for (Narrative narrative : narratives) {
            this.loadAttachmentContent(narrative);
        }
        narratives = doc.getDevelopmentProposal().getInstituteAttachments();
        for (Narrative narrative : narratives) {
            this.loadAttachmentContent(narrative);
            if (doc.getDevelopmentProposal().getNarratives().contains(narrative)) continue;
            doc.getDevelopmentProposal().getNarratives().add(narrative);
        }
        List<ProposalPersonBiography> bios = doc.getDevelopmentProposal().getPropPersonBios();
        for (ProposalPersonBiography bio : bios) {
            this.loadBioContent(bio);
        }
    }

    protected void loadAttachmentContent(Narrative narrative) {
        HashMap<String, String> primaryKey = new HashMap<String, String>();
        primaryKey.put(PROPOSAL_NUMBER, narrative.getProposalNumber());
        primaryKey.put(MODULE_NUMBER, narrative.getModuleNumber() + "");
        NarrativeAttachment attachment = (NarrativeAttachment)this.businessObjectService.findByPrimaryKey(NarrativeAttachment.class, primaryKey);
        narrative.getNarrativeAttachmentList().clear();
        narrative.getNarrativeAttachmentList().add(attachment);
    }

    protected void loadBioContent(ProposalPersonBiography bio) {
        HashMap<String, String> primaryKey = new HashMap<String, String>();
        primaryKey.put(PROPOSAL_NUMBER, bio.getProposalNumber());
        primaryKey.put("biographyNumber", bio.getBiographyNumber() + "");
        primaryKey.put("proposalPersonNumber", bio.getProposalPersonNumber() + "");
        ProposalPersonBiographyAttachment attachment = (ProposalPersonBiographyAttachment)this.businessObjectService.findByPrimaryKey(ProposalPersonBiographyAttachment.class, primaryKey);
        bio.getPersonnelAttachmentList().clear();
        bio.getPersonnelAttachmentList().add(attachment);
    }

    protected void copyBudget(ProposalDevelopmentDocument src, ProposalDevelopmentDocument dest, String budgetVersions) throws Exception {
        if (budgetVersions.equals("final version")) {
            BudgetDocumentVersion finalBudgetVersion = src.getFinalBudgetVersion();
            if (finalBudgetVersion != null) {
                this.copyAndFinalizeBudgetVersion(finalBudgetVersion.getDocumentNumber(), dest, 1, StringUtils.equals((String)src.getDevelopmentProposal().getHierarchyStatus(), (String)HierarchyStatusConstants.Parent.code()));
            }
        } else if (budgetVersions.equals("all versions")) {
            int i = 1;
            for (BudgetDocumentVersion budgetDocumentVersion : src.getBudgetDocumentVersions()) {
                this.copyAndFinalizeBudgetVersion(budgetDocumentVersion.getDocumentNumber(), dest, i++, StringUtils.equals((String)src.getDevelopmentProposal().getHierarchyStatus(), (String)HierarchyStatusConstants.Parent.code()));
            }
        }
    }

    protected void copyAndFinalizeBudgetVersion(String documentNumber, ProposalDevelopmentDocument dest, int budgetVersionNumber, boolean resetRates) throws Exception {
        BudgetDocument budgetDocument = (BudgetDocument)this.documentService.getByDocumentHeaderId(documentNumber);
        List<BudgetSubAwards> budgetSubAwards = budgetDocument.getBudget().getBudgetSubAwards();
        for (BudgetSubAwards budgetSubAward : budgetSubAwards) {
            List<BudgetSubAwardFiles> budgetSubAwardFiles = budgetSubAward.getBudgetSubAwardFiles();
            if (budgetSubAwardFiles != null && !budgetSubAwardFiles.isEmpty()) continue;
            HashMap<String, Number> param = new HashMap<String, Number>();
            param.put("budgetId", budgetSubAward.getBudgetId());
            param.put("subAwardNumber", budgetSubAward.getSubAwardNumber());
            budgetSubAward.setBudgetSubAwardFiles((List)this.businessObjectService.findMatching(BudgetSubAwardFiles.class, param));
            budgetSubAward.setBudgetSubAwardAttachments((List)this.businessObjectService.findMatching(BudgetSubAwardAttachment.class, param));
        }
        budgetDocument.toCopy();
        budgetDocument.setVersionNumber(null);
        if (budgetDocument.getBudgets().isEmpty()) {
            return;
        }
        budgetDocument.getBudget().setBudgetVersionNumber(budgetVersionNumber);
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        this.fixNumericProperty(budgetDocument, "setBudgetId", Long.class, null, objectMap);
        objectMap.clear();
        this.fixNumericProperty(budgetDocument, "setBudgetPeriodId", Long.class, null, objectMap);
        objectMap.clear();
        this.fixNumericProperty(budgetDocument, "setBudgetLineItemId", Long.class, null, objectMap);
        objectMap.clear();
        this.fixNumericProperty(budgetDocument, "setBudgetLineItemCalculatedAmountId", Long.class, null, objectMap);
        objectMap.clear();
        this.fixNumericProperty(budgetDocument, "setBudgetPersonnelLineItemId", Long.class, null, objectMap);
        objectMap.clear();
        this.fixNumericProperty(budgetDocument, "setBudgetPersonnelCalculatedAmountId", Long.class, null, objectMap);
        objectMap.clear();
        this.fixNumericProperty(budgetDocument, "setBudgetPersonnelRateAndBaseId", Long.class, null, objectMap);
        objectMap.clear();
        this.fixNumericProperty(budgetDocument, "setBudgetRateAndBaseId", Long.class, null, objectMap);
        objectMap.clear();
        this.fixNumericProperty(budgetDocument, "setBudgetSubawardAttachmentId", Long.class, null, objectMap);
        objectMap.clear();
        this.fixNumericProperty(budgetDocument, "setBudgetSubAwardDetailId", Long.class, null, objectMap);
        objectMap.clear();
        this.fixNumericProperty(budgetDocument, "setVersionNumber", Integer.class, null, objectMap);
        objectMap.clear();
        this.fixNumericProperty(budgetDocument, "setNoteIdentifier", Long.class, null, objectMap);
        objectMap.clear();
        for (Note note : budgetDocument.getNotes()) {
            note.setObjectId(null);
        }
        ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)budgetDocument.getBudget());
        Budget budget = budgetDocument.getBudget();
        budget.setFinalVersionFlag(false);
        budgetDocument.setParentDocumentKey(dest.getDocumentNumber());
        HashMap<BudgetPeriod, BudgetModular> tmpBudgetModulars = new HashMap<BudgetPeriod, BudgetModular>();
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            BudgetModular tmpObject = null;
            if (budgetPeriod.getBudgetModular() != null) {
                tmpObject = (BudgetModular)((Object)ObjectUtils.deepCopy((Serializable)((Object)budgetPeriod.getBudgetModular())));
            }
            tmpBudgetModulars.put(budgetPeriod, tmpObject);
            budgetPeriod.setBudgetModular(null);
        }
        List<BudgetProjectIncome> srcProjectIncomeList = budget.getBudgetProjectIncomes();
        budget.setBudgetProjectIncomes(new ArrayList<BudgetProjectIncome>());
        budget.setBudgetDocument(budgetDocument);
        budget.setDocumentNumber(budgetDocument.getDocumentNumber());
        this.documentService.saveDocument((Document)budgetDocument);
        for (BudgetPeriod tmpBudgetPeriod : budget.getBudgetPeriods()) {
            BudgetModular tmpBudgetModular = (BudgetModular)tmpBudgetModulars.get(tmpBudgetPeriod);
            if (tmpBudgetModular != null) {
                tmpBudgetModular.setBudgetPeriodId(tmpBudgetPeriod.getBudgetPeriodId());
                tmpBudgetPeriod.setBudgetModular(tmpBudgetModular);
            }
            for (BudgetProjectIncome budgetProjectIncome : srcProjectIncomeList) {
                if (budgetProjectIncome.getBudgetPeriodNumber().intValue() != tmpBudgetPeriod.getBudgetPeriod().intValue()) continue;
                budgetProjectIncome.setBudgetPeriodId(tmpBudgetPeriod.getBudgetPeriodId());
                budgetProjectIncome.setBudgetId(tmpBudgetPeriod.getBudget().getBudgetId());
                budgetProjectIncome.setVersionNumber(new Long(0L));
            }
        }
        budget.setBudgetProjectIncomes(srcProjectIncomeList);
        this.budgetSummaryService.calculateBudget(budgetDocument.getBudget());
        if (resetRates) {
            budgetDocument.getBudget().getBudgetRates().clear();
            budgetDocument.getBudget().getBudgetLaRates().clear();
        }
        this.documentService.saveDocument((Document)budgetDocument);
        this.documentService.routeDocument((Document)budgetDocument, "Route to Final", new ArrayList());
        budgetDocument.getParentDocument().refreshBudgetDocumentVersions();
    }

    protected void fixNumericProperty(Object object, String methodName, Class clazz, Object propertyValue, Map<String, Object> objectMap) throws Exception {
        if (ObjectUtils.isNotNull((Object)object) && object instanceof PersistableBusinessObject) {
            Method[] methods;
            PersistableBusinessObject objectWId = (PersistableBusinessObject)object;
            if (objectMap.get(objectWId.getObjectId()) != null) {
                return;
            }
            objectMap.put(((PersistableBusinessObject)object).getObjectId(), object);
            for (Method method : methods = object.getClass().getMethods()) {
                if (method.getName().equals(methodName)) {
                    try {
                        if (clazz.equals(Long.class)) {
                            method.invoke(object, (Long)propertyValue);
                            continue;
                        }
                        method.invoke(object, (Integer)propertyValue);
                    }
                    catch (Throwable e) {}
                    continue;
                }
                if (!this.isPropertyGetterMethod(method, methods)) continue;
                Object value = null;
                try {
                    value = method.invoke(object, new Object[0]);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (value == null) continue;
                if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    for (Object entry : c) {
                        this.fixNumericProperty(entry, methodName, clazz, propertyValue, objectMap);
                    }
                    continue;
                }
                this.fixNumericProperty(value, methodName, clazz, propertyValue, objectMap);
            }
        }
    }

    protected void copyCustomData(ProposalDevelopmentDocument src, ProposalDevelopmentDocument dest) {
        for (Map.Entry<String, CustomAttributeDocument> entry : src.getCustomAttributeDocuments().entrySet()) {
            CustomAttributeDocValue newDocValue;
            CustomAttributeDocument customAttributeDocument = entry.getValue();
            if (!customAttributeDocument.isActive()) continue;
            HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
            primaryKeys.put("documentNumber", src.getDocumentNumber());
            primaryKeys.put("customAttributeId", customAttributeDocument.getCustomAttributeId());
            CustomAttributeDocValue customAttributeDocValue = (CustomAttributeDocValue)this.businessObjectService.findByPrimaryKey(CustomAttributeDocValue.class, primaryKeys);
            if (customAttributeDocValue != null) {
                newDocValue = new CustomAttributeDocValue();
                newDocValue.setDocumentNumber(dest.getDocumentNumber());
                newDocValue.setCustomAttributeId(customAttributeDocument.getCustomAttributeId().longValue());
                newDocValue.setValue(customAttributeDocValue.getValue());
                dest.getCustomDataList().add(newDocValue);
                continue;
            }
            newDocValue = new CustomAttributeDocValue();
            newDocValue.setDocumentNumber(dest.getDocumentNumber());
            newDocValue.setCustomAttributeId(customAttributeDocument.getCustomAttributeId().longValue());
            newDocValue.setValue(customAttributeDocument.getCustomAttribute().getDefaultValue());
            dest.getCustomDataList().add(newDocValue);
        }
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setKeyPersonnelService(KeyPersonnelService keyPersonnelService) {
        this.keyPersonnelService = keyPersonnelService;
    }

    protected KualiRuleService getKualiRuleService() {
        return KraServiceLocator.getService(KualiRuleService.class);
    }

    public QuestionnaireService getQuestionnaireService() {
        return this.questionnaireService;
    }

    public void setQuestionnaireService(QuestionnaireService questionnaireService) {
        this.questionnaireService = questionnaireService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    protected boolean isProposalTypeRenewalRevisionContinuation(String proposalTypeCode) {
        String proposalTypeCodeRenewal = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.renewal");
        String proposalTypeCodeRevision = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.revision");
        String proposalTypeCodeContinuation = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.continuation");
        return !StringUtils.isEmpty((String)proposalTypeCode) && (proposalTypeCode.equals(proposalTypeCodeRenewal) || proposalTypeCode.equals(proposalTypeCodeRevision) || proposalTypeCode.equals(proposalTypeCodeContinuation));
    }

    protected DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public BudgetService<DevelopmentProposal> getBudgetService() {
        return this.budgetService;
    }

    public void setBudgetService(BudgetService<DevelopmentProposal> budgetService) {
        this.budgetService = budgetService;
    }

    public BudgetSummaryService getBudgetSummaryService() {
        return this.budgetSummaryService;
    }

    public void setBudgetSummaryService(BudgetSummaryService budgetSummaryService) {
        this.budgetSummaryService = budgetSummaryService;
    }

    protected class DocProperty {
        Method getter;
        Method setter;

        DocProperty(Method getter, Method setter) {
            this.getter = getter;
            this.setter = setter;
        }
    }
}

