/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.krms.service.impl.KcKrmsFactBuilderServiceHelper;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krms.api.engine.Facts;
import org.w3c.dom.Document;

public class ProposalDevelopmentFactBuilderServiceImpl
extends KcKrmsFactBuilderServiceHelper {
    private DocumentService documentService;

    @Override
    public void addFacts(Facts.Builder factsBuilder, String docContent) {
        String documentNumber = this.getElementValue(docContent, "//document/documentNumber");
        try {
            ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
            this.addFacts(factsBuilder, proposalDevelopmentDocument);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder, ResearchDocumentBase document) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        this.addBudgetFacts(factsBuilder, proposalDevelopmentDocument);
        this.addProposalFacts(factsBuilder, developmentProposal);
        factsBuilder.addFact("moduleCode", (Object)"3");
        factsBuilder.addFact("moduleItemKey", (Object)developmentProposal.getProposalNumber());
    }

    private void addBudgetFacts(Facts.Builder factsBuilder, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        Budget budget = proposalDevelopmentDocument.getFinalBudgetForThisProposal();
        this.addObjectMembersAsFacts(factsBuilder, budget, "KC-PD-CONTEXT", "KC-B");
    }

    private void addProposalFacts(Facts.Builder factsBuilder, DevelopmentProposal developmentProposal) {
        this.addObjectMembersAsFacts(factsBuilder, developmentProposal, "KC-PD-CONTEXT", "KC-PD");
        factsBuilder.addFact("DevelopmentProposal", (Object)developmentProposal);
        factsBuilder.addFact("proposalNarrativesComplete", (Object)this.isProposalNarrativesComplete(developmentProposal));
    }

    protected boolean isProposalNarrativesComplete(DevelopmentProposal developmentProposal) {
        for (Narrative narrative : developmentProposal.getNarratives()) {
            if ("C".equals((Object)narrative.getNarrativeStatus())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getElementValue(String docContent, String xpathExpression) {
        try {
            Document document = XmlHelper.trimXml((InputStream)new ByteArrayInputStream(docContent.getBytes()));
            XPath xpath = XPathHelper.newXPath();
            String value = (String)xpath.evaluate(xpathExpression, document, XPathConstants.STRING);
            return value;
        }
        catch (Exception e) {
            throw new RiceRuntimeException();
        }
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

