/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.S2sOppFormQuestionnaire;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalDevelopmentModuleQuestionnaireBean;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalDevelopmentS2sModuleQuestionnaireBean;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentS2sQuestionnaireService;
import org.kuali.kra.questionnaire.QuestionnaireService;
import org.kuali.kra.questionnaire.QuestionnaireUsage;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.s2s.bo.S2sOppForms;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProposalDevelopmentS2sQuestionnaireServiceImpl
implements ProposalDevelopmentS2sQuestionnaireService {
    private BusinessObjectService businessObjectService;
    private QuestionnaireAnswerService questionnaireAnswerService;
    private QuestionnaireService questionnaireService;
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentS2sQuestionnaireServiceImpl.class);

    @Override
    public List<AnswerHeader> getProposalAnswerHeaderForForm(DevelopmentProposal proposal, String oppNameSpace, String formName) {
        return this.getProposalS2sAnswerHeaders(proposal, oppNameSpace, formName);
    }

    @Override
    public List<AnswerHeader> getProposalS2sAnswerHeaders(DevelopmentProposal developmentProposal) {
        return this.getProposalS2sAnswerHeaders(developmentProposal, null, null);
    }

    protected List<AnswerHeader> getProposalS2sAnswerHeaders(DevelopmentProposal developmentProposal, String oppNameSpace, String formName) {
        HashSet result = new HashSet();
        S2sOpportunity opp = developmentProposal.getS2sOpportunity();
        HashSet<AnswerHeader> results = new HashSet<AnswerHeader>();
        List<AnswerHeader> rawAnswerHeaders = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(this.getModuleQnBean(developmentProposal));
        if (opp != null) {
            for (AnswerHeader header : rawAnswerHeaders) {
                for (S2sOppForms oppForms : opp.getS2sOppForms()) {
                    if (oppNameSpace != null && !StringUtils.equals((String)oppForms.getOppNameSpace(), (String)oppNameSpace) || formName != null && !StringUtils.equals((String)oppForms.getFormName(), (String)formName)) continue;
                    List<QuestionnaireUsage> usages = this.getQuestionnaireUsages(oppForms.getOppNameSpace(), oppForms.getFormName(), developmentProposal);
                    for (QuestionnaireUsage usage : usages) {
                        if (!header.getQuestionnaire().getQuestionnaireId().equals(usage.getQuestionnaire().getQuestionnaireId())) continue;
                        results.add(header);
                    }
                }
            }
        }
        return new ArrayList<AnswerHeader>(results);
    }

    @Override
    public List<QuestionnaireUsage> getQuestionnaireUsages(String oppNameSpace, String formName, DevelopmentProposal proposal) {
        HashSet<QuestionnaireUsage> result = new HashSet<QuestionnaireUsage>();
        ProposalDevelopmentModuleQuestionnaireBean questionnaireBean = new ProposalDevelopmentModuleQuestionnaireBean(proposal);
        questionnaireBean.setModuleSubItemCode("2");
        List<QuestionnaireUsage> usages = this.getQuestionnaireAnswerService().getPublishedQuestionnaire(questionnaireBean);
        List<S2sOppFormQuestionnaire> s2sOppFormQuestionnaires = this.findOppFormToQuestionnaires(oppNameSpace, formName);
        for (QuestionnaireUsage usage : usages) {
            for (S2sOppFormQuestionnaire oppFormQuestionnaire : s2sOppFormQuestionnaires) {
                if (!oppFormQuestionnaire.getQuestionnaireId().toString().equals(usage.getQuestionnaire().getQuestionnaireId())) continue;
                result.add(usage);
            }
        }
        return new ArrayList<QuestionnaireUsage>(result);
    }

    protected List<S2sOppFormQuestionnaire> findOppFormToQuestionnaires(String oppNameSpace, String formName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Looking up S2sOppFormQuestionnaire for (%s,%s)", oppNameSpace, formName));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("oppNameSpace", oppNameSpace);
        params.put("formName", formName);
        List oppFormToQuestionnaires = (List)this.getBusinessObjectService().findMatching(S2sOppFormQuestionnaire.class, params);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Found S2sOppFormQuestionnaire records for (%s,%s)", oppNameSpace, formName));
            for (S2sOppFormQuestionnaire oppFormQuest : oppFormToQuestionnaires) {
                LOG.debug((Object)oppFormQuest);
            }
        }
        return oppFormToQuestionnaires;
    }

    public ModuleQuestionnaireBean getModuleQnBean(DevelopmentProposal proposal) {
        ProposalDevelopmentS2sModuleQuestionnaireBean moduleQuestionnaireBean = new ProposalDevelopmentS2sModuleQuestionnaireBean(proposal);
        return moduleQuestionnaireBean;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public QuestionnaireService getQuestionnaireService() {
        return this.questionnaireService;
    }

    public void setQuestionnaireService(QuestionnaireService questionnaireService) {
        this.questionnaireService = questionnaireService;
    }
}

