/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalLockService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.impl.PessimisticLockServiceImpl;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class ProposalLockServiceImpl
extends PessimisticLockServiceImpl
implements ProposalLockService {
    private static final String FALSE = "FALSE";
    private static final String ADD_BUDGET = "addBudget";

    protected boolean isLockRequiredByUser(Document document, Map editMode, Person user) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        for (Map.Entry entry : editMode.entrySet()) {
            if (!this.isEntryEditMode(entry) || !StringUtils.isNotEmpty((String)activeLockRegion)) continue;
            return true;
        }
        return false;
    }

    protected boolean isEntryEditMode(Map.Entry entry) {
        if ("fullEntry".equals(entry.getKey()) || "addNarratives".equals(entry.getKey()) || "modifyPermissions".equals(entry.getKey()) || "modifyProposal".equals(entry.getKey()) || "modifyBudgets".equals(entry.getKey()) || ADD_BUDGET.equals(entry.getKey())) {
            String fullEntryEditModeValue = (String)entry.getValue();
            return ObjectUtils.isNotNull((Object)fullEntryEditModeValue) && StringUtils.equalsIgnoreCase((String)"true", (String)fullEntryEditModeValue);
        }
        return false;
    }

    protected Map getEditModeWithEditableModesRemoved(Map currentEditMode) {
        HashMap editModeMap = new HashMap();
        for (Map.Entry entry : editModeMap.entrySet()) {
            if (!StringUtils.equals((String)((String)entry.getKey()), (String)ADD_BUDGET)) continue;
            entry.setValue(FALSE);
        }
        return editModeMap;
    }

    protected PessimisticLock createNewPessimisticLock(Document document, Map editMode, Person user) {
        if (document.useCustomLockDescriptors()) {
            String lockDescriptor = document.getCustomLockDescriptor(user);
            ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
            if (StringUtils.isNotEmpty((String)lockDescriptor) && lockDescriptor.contains("BUDGET")) {
                for (BudgetDocumentVersion budgetOverview : pdDocument.getBudgetDocumentVersions()) {
                    this.generateNewLock(budgetOverview.getDocumentNumber(), lockDescriptor, user);
                }
            }
            return this.generateNewLock(document.getDocumentNumber(), lockDescriptor, user);
        }
        return this.generateNewLock(document.getDocumentNumber(), user);
    }
}

