/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.PropPerDocType;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiographyAttachment;
import org.kuali.kra.proposaldevelopment.dao.AttachmentDao;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalPersonBiographyService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class ProposalPersonBiographyServiceImpl
implements ProposalPersonBiographyService {
    private BusinessObjectService businessObjectService;
    private AttachmentDao attachmentDao;
    private PersonService personService;

    @Override
    public void addProposalPersonBiography(ProposalDevelopmentDocument proposaldevelopmentDocument, ProposalPersonBiography proposalPersonBiography) {
        proposalPersonBiography.setProposalNumber(proposaldevelopmentDocument.getDevelopmentProposal().getProposalNumber());
        proposalPersonBiography.setBiographyNumber(proposaldevelopmentDocument.getDocumentNextValue("proposalDevelopment.proposalPersonBiography.biographyNumber"));
        proposalPersonBiography.setPropPerDocType(new PropPerDocType());
        ProposalPerson proposalPerson = this.getPerson(proposaldevelopmentDocument, proposalPersonBiography.getProposalPersonNumber());
        if (proposalPerson != null) {
            proposalPersonBiography.setPersonId(proposalPerson.getPersonId());
            proposalPersonBiography.setRolodexId(proposalPerson.getRolodexId());
        }
        proposalPersonBiography.getPropPerDocType().setDocumentTypeCode(proposalPersonBiography.getDocumentTypeCode());
        proposalPersonBiography.refreshReferenceObject("propPerDocType");
        FormFile personnelAttachmentFile = proposalPersonBiography.getPersonnelAttachmentFile();
        if (personnelAttachmentFile != null) {
            try {
                byte[] fileData = personnelAttachmentFile.getFileData();
                if (fileData.length > 0) {
                    ProposalPersonBiographyAttachment personnelAttachment = new ProposalPersonBiographyAttachment();
                    personnelAttachment.setFileName(personnelAttachmentFile.getFileName());
                    personnelAttachment.setProposalNumber(proposalPersonBiography.getProposalNumber());
                    personnelAttachment.setProposalPersonNumber(proposalPersonBiography.getProposalPersonNumber());
                    personnelAttachment.setBiographyData(personnelAttachmentFile.getFileData());
                    personnelAttachment.setContentType(personnelAttachmentFile.getContentType());
                    proposalPersonBiography.setFileName(personnelAttachmentFile.getFileName());
                    proposalPersonBiography.setContentType(personnelAttachmentFile.getContentType());
                    if (proposalPersonBiography.getPersonnelAttachmentList().isEmpty()) {
                        proposalPersonBiography.getPersonnelAttachmentList().add(personnelAttachment);
                    } else {
                        proposalPersonBiography.getPersonnelAttachmentList().set(0, personnelAttachment);
                    }
                }
            }
            catch (Exception e) {
                proposalPersonBiography.getPersonnelAttachmentList().clear();
            }
        }
        DocumentNextvalue documentNextvalue = proposaldevelopmentDocument.getDocumentNextvalueBo("proposalDevelopment.proposalPersonBiography.biographyNumber");
        ArrayList<KraPersistableBusinessObjectBase> businessObjects = new ArrayList<KraPersistableBusinessObjectBase>();
        businessObjects.add(documentNextvalue);
        businessObjects.add(proposalPersonBiography);
        this.getBusinessObjectService().save(businessObjects);
        proposalPersonBiography.getPersonnelAttachmentList().clear();
        proposaldevelopmentDocument.getDevelopmentProposal().getPropPersonBios().add(proposalPersonBiography);
    }

    @Override
    public void removePersonnelAttachmentForDeletedPerson(ProposalDevelopmentDocument proposaldevelopmentDocument, ProposalPerson person) {
        ArrayList<ProposalPersonBiography> personAttachments = new ArrayList<ProposalPersonBiography>();
        for (ProposalPersonBiography proposalPersonBiography : proposaldevelopmentDocument.getDevelopmentProposal().getPropPersonBios()) {
            if (!proposalPersonBiography.getProposalPersonNumber().equals(person.getProposalPersonNumber())) continue;
            personAttachments.add(proposalPersonBiography);
        }
        if (!personAttachments.isEmpty()) {
            proposaldevelopmentDocument.getDevelopmentProposal().getPropPersonBios().removeAll(personAttachments);
        }
    }

    @Override
    public void deleteProposalPersonBiography(ProposalDevelopmentDocument proposaldevelopmentDocument, int lineToDelete) {
        ProposalPersonBiography proposalPersonBiography = proposaldevelopmentDocument.getDevelopmentProposal().getPropPersonBios().get(lineToDelete);
        proposaldevelopmentDocument.getDevelopmentProposal().getPropPersonBios().remove(proposalPersonBiography);
        this.getBusinessObjectService().delete((PersistableBusinessObject)proposalPersonBiography);
    }

    protected ProposalPerson getPerson(ProposalDevelopmentDocument proposaldevelopmentDocument, Integer proposalPersonNumber) {
        for (ProposalPerson person : proposaldevelopmentDocument.getDevelopmentProposal().getProposalPersons()) {
            if (!proposalPersonNumber.equals(person.getProposalPersonNumber())) continue;
            return person;
        }
        return null;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public void setPersonnelBioTimeStampUser(List<ProposalPersonBiography> proposalPersonBios) {
        for (ProposalPersonBiography proposalPersonBiography : proposalPersonBios) {
            Iterator personBioAtt = this.attachmentDao.getPersonnelTimeStampAndUploadUser(proposalPersonBiography.getProposalPersonNumber(), proposalPersonBiography.getProposalNumber(), proposalPersonBiography.getBiographyNumber());
            if (!personBioAtt.hasNext()) continue;
            Object[] item = (Object[])personBioAtt.next();
            proposalPersonBiography.setTimestampDisplay((Timestamp)item[0]);
            proposalPersonBiography.setUploadUserDisplay((String)item[1]);
            Person person = this.personService.getPersonByPrincipalName(proposalPersonBiography.getUploadUserDisplay());
            proposalPersonBiography.setUploadUserFullName(ObjectUtils.isNull((Object)person) ? proposalPersonBiography.getUploadUserDisplay() + "(not found)" : person.getName());
        }
    }

    public AttachmentDao getAttachmentDao() {
        return this.attachmentDao;
    }

    public void setAttachmentDao(AttachmentDao attachmentDao) {
        this.attachmentDao = attachmentDao;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

