/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.lookup.keyvalue.KCStateValuesFinder;
import org.kuali.kra.proposaldevelopment.service.ProposalPersonService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.UnitService;
import org.kuali.kra.util.ValuesFinderUtility;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProposalPersonServiceImpl
implements ProposalPersonService {
    private static final Integer UNIT_HEIRARCHY_NODE = 3;
    private BusinessObjectService businessObjectService;
    private KcPersonService kcPersonService;

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    @Override
    public String getPersonName(ProposalDevelopmentDocument doc, String userId) {
        String propPersonName = null;
        List proposalPersons = doc.getDevelopmentProposal().getProposalPersons();
        if (proposalPersons.isEmpty()) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("proposalNumber", doc.getDevelopmentProposal().getProposalNumber());
            proposalPersons = (List)this.getBusinessObjectService().findMatching(ProposalPerson.class, queryMap);
        }
        for (ProposalPerson proposalPerson : proposalPersons) {
            if (!StringUtils.equals((String)proposalPerson.getPersonId(), (String)userId)) continue;
            propPersonName = proposalPerson.getFullName();
            break;
        }
        if (StringUtils.isBlank(propPersonName)) {
            KcPerson person = this.kcPersonService.getKcPersonByPersonId(userId);
            propPersonName = person.getFullName();
        }
        return propPersonName;
    }

    @Override
    public KcPerson getPerson(String loggedInUser) {
        return this.kcPersonService.getKcPersonByUserName(loggedInUser);
    }

    @Override
    public ProposalPerson getProposalPersonById(String proposalNumber, Integer proposalPersonNumber) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("proposalNumber", proposalNumber.toString());
        keys.put("proposalPersonNumber", proposalPersonNumber.toString());
        return (ProposalPerson)this.getBusinessObjectService().findByPrimaryKey(ProposalPerson.class, keys);
    }

    @Override
    public List<ProposalPerson> getProposalKeyPersonnel(String proposalNumber) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("proposalNumber", proposalNumber.toString());
        return (List)this.getBusinessObjectService().findMatching(ProposalPerson.class, keys);
    }

    @Override
    public List<ProposalPerson> getProposalKeyPersonnel(String proposalNumber, String roleCode) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("proposalNumber", proposalNumber.toString());
        keys.put("proposalPersonRoleId", roleCode);
        return (List)this.getBusinessObjectService().findMatching(ProposalPerson.class, keys);
    }

    @Override
    public String getProposalPersonDivisionName(ProposalPerson proposalPerson) {
        UnitService unitService;
        List<Unit> units;
        String personDivisionName = null;
        if (proposalPerson != null && (units = (unitService = KraServiceLocator.getService(UnitService.class)).getUnitHierarchyForUnit(proposalPerson.getHomeUnit())).size() > UNIT_HEIRARCHY_NODE) {
            Unit unit = units.get(UNIT_HEIRARCHY_NODE);
            personDivisionName = unit.getUnitName();
        }
        return personDivisionName;
    }

    @Override
    public String getNewStateList(String countryCode) {
        List<KeyValue> values = KCStateValuesFinder.getKeyValues(countryCode.trim());
        return ValuesFinderUtility.processKeyValueList(values);
    }
}

