/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.hierarchy.service.ProposalHierarchyService;
import org.kuali.kra.proposaldevelopment.service.ProposalStateService;
import org.kuali.rice.kew.api.WorkflowDocument;

public class ProposalStateServiceImpl
implements ProposalStateService {
    private ProposalHierarchyService proposalHierarchyService;

    @Override
    public String getProposalStateTypeCode(ProposalDevelopmentDocument proposalDevelopmentDocument, boolean isRouteStatusChanged, boolean isRejectAction) {
        String proposalStateTypeCode = null;
        WorkflowDocument wd = proposalDevelopmentDocument.getDocumentHeader().getWorkflowDocument();
        proposalStateTypeCode = wd.isInitiated() ? this.computeProposalStateForInitiated(proposalDevelopmentDocument) : (wd.isSaved() ? this.computeProposalStateForSaved(proposalDevelopmentDocument) : (isRejectAction && wd.isEnroute() ? this.computeProposalStateForRejected(proposalDevelopmentDocument) : (wd.isEnroute() ? this.computeProposalStateForEnRoute(proposalDevelopmentDocument) : (wd.isApproved() ? this.computeProposalStateForApproved(proposalDevelopmentDocument, isRouteStatusChanged) : (wd.isDisapproved() ? this.computeProposalStateForDisapproved(proposalDevelopmentDocument, isRouteStatusChanged) : (wd.isCanceled() ? this.computeProposalStateForCanceled(proposalDevelopmentDocument) : this.computeProposalStateForException(proposalDevelopmentDocument)))))));
        return proposalStateTypeCode;
    }

    protected String computeProposalStateForInitiated(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        return "1";
    }

    protected String computeProposalStateForSaved(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        if (this.isSubmitted(proposalDevelopmentDocument)) {
            return "4";
        }
        return "1";
    }

    protected String computeProposalStateForEnRoute(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        if (this.isSubmitted(proposalDevelopmentDocument)) {
            return "5";
        }
        return "2";
    }

    protected String computeProposalStateForApproved(ProposalDevelopmentDocument proposalDevelopmentDocument, boolean isRouteStatusChanged) {
        if (this.isSubmitted(proposalDevelopmentDocument)) {
            if (isRouteStatusChanged) {
                return "8";
            }
            return "6";
        }
        return "3";
    }

    protected String computeProposalStateForDisapproved(ProposalDevelopmentDocument proposalDevelopmentDocument, boolean isRouteStatusChanged) {
        if (this.isSubmitted(proposalDevelopmentDocument) && isRouteStatusChanged) {
            return "9";
        }
        return "7";
    }

    protected String computeProposalStateForRejected(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        return "12";
    }

    protected String computeProposalStateForCanceled(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        return "10";
    }

    protected String computeProposalStateForException(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        return "11";
    }

    protected boolean isSubmitted(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        return proposalDevelopmentDocument.getDevelopmentProposal().getSubmitFlag();
    }

    public ProposalHierarchyService getProposalHierarchyService() {
        return this.proposalHierarchyService;
    }

    public void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }
}

