/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import java.util.HashMap;
import java.util.List;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalBudgetStatus;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalStatusService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class ProposalStatusServiceImpl
implements ProposalStatusService {
    private BusinessObjectService businessObjectService;

    @Override
    public void saveBudgetFinalVersionStatus(ProposalDevelopmentDocument pdDocument) {
        ProposalBudgetStatus proposalStatus = this.getProposalStatus(pdDocument.getDevelopmentProposal().getProposalNumber());
        if (proposalStatus == null) {
            if (pdDocument.getDevelopmentProposal().getProposalNumber() != null) {
                proposalStatus = new ProposalBudgetStatus();
                proposalStatus.setProposalNumber(pdDocument.getDevelopmentProposal().getProposalNumber());
                proposalStatus.setBudgetStatusCode(pdDocument.getDevelopmentProposal().getBudgetStatus());
                this.businessObjectService.save((PersistableBusinessObject)proposalStatus);
            }
        } else if (proposalStatus.getBudgetStatusCode() == null || !proposalStatus.getBudgetStatusCode().equals(pdDocument.getDevelopmentProposal().getBudgetStatus())) {
            proposalStatus.setBudgetStatusCode(pdDocument.getDevelopmentProposal().getBudgetStatus());
            this.businessObjectService.save((PersistableBusinessObject)proposalStatus);
        }
    }

    @Override
    public void saveBudgetFinalVersionStatus(BudgetDocument budgetDocument) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)budgetDocument.getParentDocument();
        ProposalBudgetStatus proposalStatus = this.getProposalStatus(proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber());
        if (proposalStatus == null) {
            if (proposalDevelopmentDocument != null && proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber() != null) {
                proposalStatus = new ProposalBudgetStatus();
                proposalStatus.setProposalNumber(proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber());
                proposalStatus.setBudgetStatusCode(proposalDevelopmentDocument.getDevelopmentProposal().getBudgetStatus());
                this.businessObjectService.save((PersistableBusinessObject)proposalStatus);
            }
        } else if (!ObjectUtils.isNull(budgetDocument.getParentDocument())) {
            if (proposalStatus.getBudgetStatusCode() == null && proposalDevelopmentDocument.getDevelopmentProposal().getBudgetStatus() != null) {
                proposalStatus.setBudgetStatusCode(proposalDevelopmentDocument.getDevelopmentProposal().getBudgetStatus());
                this.businessObjectService.save((PersistableBusinessObject)proposalStatus);
            } else if (proposalStatus.getBudgetStatusCode() != null && !proposalStatus.getBudgetStatusCode().equals(proposalDevelopmentDocument.getDevelopmentProposal().getBudgetStatus())) {
                proposalStatus.setBudgetStatusCode(proposalDevelopmentDocument.getDevelopmentProposal().getBudgetStatus());
                this.businessObjectService.save((PersistableBusinessObject)proposalStatus);
            }
        }
        if (!ObjectUtils.isNull(budgetDocument.getParentDocument())) {
            List budgetDocumentVersions = budgetDocument.getParentDocument().getBudgetDocumentVersions();
            for (BudgetDocumentVersion documentVersion : budgetDocumentVersions) {
                BudgetVersionOverview dbVersion;
                BudgetVersionOverview version = documentVersion.getBudgetVersionOverview();
                if (version.getBudgetVersionNumber().equals(budgetDocument.getBudget().getBudgetVersionNumber()) || (dbVersion = this.getBudgetVersion(version)) != null && dbVersion.isFinalVersionFlag() == version.isFinalVersionFlag()) continue;
                this.businessObjectService.save((PersistableBusinessObject)version);
            }
        }
    }

    @Override
    public void loadBudgetStatus(DevelopmentProposal proposal) {
        ProposalBudgetStatus proposalStatus;
        if (proposal != null && (proposalStatus = this.getProposalStatus(proposal.getProposalNumber())) != null) {
            proposal.setBudgetStatus(proposalStatus.getBudgetStatusCode());
            if (proposalStatus.getBudgetStatus() != null) {
                proposal.setBudgetStatusDescription(proposalStatus.getBudgetStatus().getDescription());
            } else {
                proposal.setBudgetStatusDescription("Unset");
            }
        }
    }

    protected ProposalBudgetStatus getProposalStatus(String proposalNumber) {
        BusinessObjectService boService = KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("proposalNumber", proposalNumber);
        ProposalBudgetStatus proposalStatus = (ProposalBudgetStatus)boService.findByPrimaryKey(ProposalBudgetStatus.class, keyMap);
        return proposalStatus;
    }

    protected BudgetVersionOverview getBudgetVersion(BudgetVersionOverview version) {
        BusinessObjectService boService = KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, Long> keyMap = new HashMap<String, Long>();
        keyMap.put("budgetId", version.getBudgetId());
        BudgetVersionOverview dbVersion = (BudgetVersionOverview)boService.findByPrimaryKey(BudgetVersionOverview.class, keyMap);
        return dbVersion;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public void loadBudgetStatus(String proposalNumber) {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("proposalNumber", proposalNumber);
        DevelopmentProposal proposal = (DevelopmentProposal)this.businessObjectService.findByPrimaryKey(DevelopmentProposal.class, keyMap);
        this.loadBudgetStatus(proposal);
    }

    @Override
    public void loadBudgetStatusByProposalDocumentNumber(String documentNumber) {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("documentNumber", documentNumber);
        DevelopmentProposal proposal = (DevelopmentProposal)this.businessObjectService.findByPrimaryKey(DevelopmentProposal.class, keyMap);
        this.loadBudgetStatus(proposal);
    }
}

