/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.specialreview;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.specialreview.web.struts.form.SpecialReviewHelperBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.authorization.ProposalTask;
import org.kuali.kra.proposaldevelopment.specialreview.ProposalSpecialReview;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.krad.util.GlobalVariables;

public class SpecialReviewHelper
extends SpecialReviewHelperBase<ProposalSpecialReview> {
    private static final long serialVersionUID = 8832539481443727887L;
    private static final String PROTOCOL_DEVELOPMENT_PROPOSAL_LINKING_ENABLED_PARAMETER = "irb.protocol.development.proposal.linking.enabled";
    private static final String IACUC_PROTOCOL_PROPOSAL_DEVELOPMENT_LINKING_ENABLED_PARAMETER = "iacuc.protocol.proposal.development.linking.enabled";
    private ProposalDevelopmentForm form;

    public SpecialReviewHelper(ProposalDevelopmentForm form) {
        this.form = form;
        this.setNewSpecialReview(new ProposalSpecialReview());
        this.setLinkedProtocolNumbers(new ArrayList<String>());
    }

    @Override
    protected boolean hasModifySpecialReviewPermission(String principalId) {
        return BooleanUtils.toBoolean((String)((String)this.form.getEditingMode().get("modifyProposal")));
    }

    @Override
    protected boolean isIrbProtocolLinkingEnabledForModule() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PROTOCOL", "Document", PROTOCOL_DEVELOPMENT_PROPOSAL_LINKING_ENABLED_PARAMETER);
    }

    @Override
    protected boolean isIacucProtocolLinkingEnabledForModule() {
        return this.getParameterService().getParameterValueAsBoolean("KC-IACUC", "Document", IACUC_PROTOCOL_PROPOSAL_DEVELOPMENT_LINKING_ENABLED_PARAMETER);
    }

    @Override
    protected List<ProposalSpecialReview> getSpecialReviews() {
        return this.form.getProposalDevelopmentDocument().getDevelopmentProposal().getPropSpecialReviews();
    }

    @Override
    public boolean isCanCreateIrbProtocol() {
        boolean canCreateIrbProtocol = false;
        ProposalTask irbTask = new ProposalTask("createIrbProtocolFromProposal", this.form.getProposalDevelopmentDocument());
        canCreateIrbProtocol = this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), irbTask);
        return canCreateIrbProtocol;
    }

    @Override
    public boolean isCanCreateIacucProtocol() {
        boolean canCreateIacucProtocol = false;
        ProposalTask iacucTask = new ProposalTask("createIacucProtocolFromProposal", this.form.getProposalDevelopmentDocument());
        canCreateIacucProtocol = this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), iacucTask);
        return canCreateIacucProtocol;
    }

    private TaskAuthorizationService getTaskAuthorizationService() {
        return KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    private String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public void populatePropSpecialReviewApproverView(String summarySpecialReview) {
        if (!StringUtils.isEmpty((String)summarySpecialReview)) {
            String[] splitString = StringUtils.split((String)summarySpecialReview, (String)",");
            ArrayList<ProposalSpecialReview> propSpecialReviewFilteredList = new ArrayList<ProposalSpecialReview>();
            for (ProposalSpecialReview proposalSpecialReview : this.form.getProposalDevelopmentDocument().getDevelopmentProposal().getPropSpecialReviews()) {
                for (int i = 0; i < splitString.length; ++i) {
                    if (!proposalSpecialReview.getSpecialReviewTypeCode().equals(splitString[i])) continue;
                    propSpecialReviewFilteredList.add(proposalSpecialReview);
                }
            }
            this.form.getProposalDevelopmentDocument().getDevelopmentProposal().setPropSpecialReviews(propSpecialReviewFilteredList);
        }
    }
}

