/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web.struts.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeAttachment;
import org.kuali.kra.proposaldevelopment.bo.NarrativeUserRights;
import org.kuali.kra.proposaldevelopment.bo.ProposalAbstract;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiographyAttachment;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.notification.ProposalDevelopmentNotificationContext;
import org.kuali.kra.proposaldevelopment.notification.ProposalDevelopmentNotificationRenderer;
import org.kuali.kra.proposaldevelopment.rule.event.AddAbstractEvent;
import org.kuali.kra.proposaldevelopment.rule.event.AddInstituteAttachmentEvent;
import org.kuali.kra.proposaldevelopment.rule.event.AddNarrativeEvent;
import org.kuali.kra.proposaldevelopment.rule.event.AddPersonnelAttachmentEvent;
import org.kuali.kra.proposaldevelopment.rule.event.NewNarrativeUserRightsEvent;
import org.kuali.kra.proposaldevelopment.rule.event.SaveInstituteAttachmentsEvent;
import org.kuali.kra.proposaldevelopment.rule.event.SaveNarrativesEvent;
import org.kuali.kra.proposaldevelopment.rule.event.SavePersonnelAttachmentEvent;
import org.kuali.kra.proposaldevelopment.service.NarrativeService;
import org.kuali.kra.proposaldevelopment.service.ProposalAbstractsService;
import org.kuali.kra.proposaldevelopment.service.ProposalPersonBiographyService;
import org.kuali.kra.proposaldevelopment.web.struts.action.ProposalDevelopmentAction;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.ObjectUtils;

public class ProposalDevelopmentAbstractsAttachmentsAction
extends ProposalDevelopmentAction {
    private static final String PROPOSAL_NARRATIVE_TYPE_GROUP2 = "proposalNarrativeTypeGroup";
    private static final String EMPTY_STRING = "";
    private static final String MODULE_NUMBER = "moduleNumber";
    private static final String PROPOSAL_NUMBER = "proposalNumber";
    private static final String PROPOSAL_PERSON_NUMBER = "proposalPersonNumber";
    private static final String BIOGRAPHY_NUMBER = "biographyNumber";
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentAbstractsAttachmentsAction.class);
    private static final String LINE_NUMBER = "line";
    private static final String CONFIRM_DELETE_ABSTRACT_KEY = "confirmDeleteAbstract";
    private static final String CONFIRM_DELETE_INSTITUTIONAL_ATTACHMENT_KEY = "confirmDeleteInstitutionalAttachment";
    private static final String CONFIRM_DELETE_PERSONNEL_ATTACHMENT_KEY = "confirmDeletePersonnelAttachment";
    private static final String CONFIRM_DELETE_PROPOSAL_ATTACHMENT_KEY = "confirmDeleteProposalAttachment";

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        Narrative newNarrative = proposalDevelopmentForm.getNewNarrative();
        boolean rulePassed = true;
        rulePassed &= this.getKualiRuleService().applyRules((KualiDocumentEvent)new SaveNarrativesEvent(EMPTY_STRING, proposalDevelopmentDocument, newNarrative, proposalDevelopmentForm.getNarratives()));
        rulePassed &= this.getKualiRuleService().applyRules((KualiDocumentEvent)new SavePersonnelAttachmentEvent(EMPTY_STRING, proposalDevelopmentDocument, proposalDevelopmentForm.getNewPropPersonBio()));
        if (!(rulePassed &= this.getKualiRuleService().applyRules((KualiDocumentEvent)new SaveInstituteAttachmentsEvent(EMPTY_STRING, proposalDevelopmentDocument)))) {
            mapping.findForward("basic");
        }
        List<Narrative> narativeListToBeSaved = proposalDevelopmentDocument.getDevelopmentProposal().getNarratives();
        for (Narrative narrativeToBeSaved : narativeListToBeSaved) {
            narrativeToBeSaved.refreshNonUpdateableReferences();
        }
        return super.save(mapping, form, request, response);
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((ProposalDevelopmentForm)form).getProposalDevelopmentParameters().put(PROPOSAL_NARRATIVE_TYPE_GROUP2, this.getParameterService().getParameter("KC-PD", "Document", PROPOSAL_NARRATIVE_TYPE_GROUP2));
        ActionForward actionForward = super.execute(mapping, form, request, response);
        ProposalDevelopmentDocument doc = (ProposalDevelopmentDocument)((ProposalDevelopmentForm)form).getDocument();
        KraServiceLocator.getService(ProposalPersonBiographyService.class).setPersonnelBioTimeStampUser(doc.getDevelopmentProposal().getPropPersonBios());
        ArrayList<Narrative> narratives = new ArrayList<Narrative>();
        narratives.addAll(doc.getDevelopmentProposal().getNarratives());
        narratives.addAll(doc.getDevelopmentProposal().getInstituteAttachments());
        KraServiceLocator.getService(NarrativeService.class).setNarrativeTimeStampUser(narratives);
        KraServiceLocator.getService(ProposalAbstractsService.class).loadAbstractsUploadUserFullName(doc.getDevelopmentProposal().getProposalAbstracts());
        return actionForward;
    }

    public ActionForward addProposalAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        Narrative narrative = proposalDevelopmentForm.getNewNarrative();
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new AddNarrativeEvent(EMPTY_STRING, proposalDevelopmentDocument, narrative))) {
            proposalDevelopmentDocument.getDevelopmentProposal().addNarrative(narrative);
            proposalDevelopmentForm.setNewNarrative(new Narrative());
            this.populateTabState((KualiForm)proposalDevelopmentForm, "Proposal Attachments " + proposalDevelopmentDocument.getDevelopmentProposal().getNarratives().size());
        }
        return mapping.findForward("basic");
    }

    public ActionForward downloadInstituteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        String line = request.getParameter(LINE_NUMBER);
        int lineNumber = line == null ? 0 : Integer.parseInt(line);
        ProposalDevelopmentDocument pd = proposalDevelopmentForm.getProposalDevelopmentDocument();
        Narrative narrative = pd.getDevelopmentProposal().getInstituteAttachments().get(lineNumber);
        NarrativeAttachment narrativeAttachment = this.findNarrativeAttachment(narrative);
        if (narrativeAttachment == null && !narrative.getNarrativeAttachmentList().isEmpty()) {
            narrativeAttachment = narrative.getNarrativeAttachmentList().get(0);
        }
        this.streamToResponse(narrativeAttachment, response);
        return null;
    }

    public ActionForward downloadProposalAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        String line = request.getParameter(LINE_NUMBER);
        int lineNumber = line == null ? 0 : Integer.parseInt(line);
        ProposalDevelopmentDocument pd = proposalDevelopmentForm.getProposalDevelopmentDocument();
        Narrative narrative = pd.getDevelopmentProposal().getNarratives().get(lineNumber);
        NarrativeAttachment narrativeAttachment = this.findNarrativeAttachment(narrative);
        if (narrativeAttachment == null && !narrative.getNarrativeAttachmentList().isEmpty()) {
            narrativeAttachment = narrative.getNarrativeAttachmentList().get(0);
        }
        this.streamToResponse(narrativeAttachment, response);
        return null;
    }

    private NarrativeAttachment findNarrativeAttachment(Narrative narrative) {
        HashMap<String, String> narrativeAttachemntMap = new HashMap<String, String>();
        narrativeAttachemntMap.put(PROPOSAL_NUMBER, narrative.getProposalNumber());
        narrativeAttachemntMap.put(MODULE_NUMBER, narrative.getModuleNumber() + EMPTY_STRING);
        return (NarrativeAttachment)this.getBusinessObjectService().findByPrimaryKey(NarrativeAttachment.class, narrativeAttachemntMap);
    }

    public ActionForward deleteProposalAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildDeleteAttachmentConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_PROPOSAL_ATTACHMENT_KEY), CONFIRM_DELETE_PROPOSAL_ATTACHMENT_KEY, EMPTY_STRING);
    }

    public ActionForward confirmDeleteProposalAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDoc = pdForm.getProposalDevelopmentDocument();
        this.populateTabState((KualiForm)((ProposalDevelopmentForm)form), "Proposal Attachments " + pdDoc.getDevelopmentProposal().getNarratives().size());
        return this.deleteAttachment(mapping, form, request, response, CONFIRM_DELETE_PROPOSAL_ATTACHMENT_KEY, "deleteProposalAttachment");
    }

    public ActionForward deleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String key, String deleteMethodName) throws Exception {
        String question = request.getParameter("questionIndex");
        if (key.equals(question)) {
            ProposalDevelopmentDocument document = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument();
            LOG.info((Object)("Running delete '" + deleteMethodName + "' on " + document + " for " + this.getLineToDelete(request)));
            document.getDevelopmentProposal().getClass().getMethod(deleteMethodName, Integer.TYPE).invoke((Object)document.getDevelopmentProposal(), this.getLineToDelete(request));
        }
        return mapping.findForward("basic");
    }

    public ActionForward getInstituteAttachmentRights(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        proposalDevelopmentForm.setShowMaintenanceLinks(false);
        String line = request.getParameter(LINE_NUMBER);
        int lineNumber = line == null ? this.getLineToDelete(request) : Integer.parseInt(line);
        ProposalDevelopmentDocument pd = proposalDevelopmentForm.getProposalDevelopmentDocument();
        pd.getDevelopmentProposal().populatePersonNameForInstituteAttachmentUserRights(lineNumber);
        Narrative narrative = pd.getDevelopmentProposal().getInstituteAttachment(lineNumber);
        List<NarrativeUserRights> userRights = narrative.getNarrativeUserRights();
        List editUserRights = (List)((Object)ObjectUtils.deepCopy((Serializable)((Serializable)((Object)userRights))));
        proposalDevelopmentForm.setNewNarrativeUserRights(editUserRights);
        request.setAttribute(LINE_NUMBER, (Object)(EMPTY_STRING + lineNumber));
        return mapping.findForward("instituteAttachmentRights");
    }

    public ActionForward getProposalAttachmentRights(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        proposalDevelopmentForm.setShowMaintenanceLinks(false);
        String line = request.getParameter(LINE_NUMBER);
        int lineNumber = line == null ? this.getLineToDelete(request) : Integer.parseInt(line);
        ProposalDevelopmentDocument pd = proposalDevelopmentForm.getProposalDevelopmentDocument();
        pd.getDevelopmentProposal().populatePersonNameForNarrativeUserRights(lineNumber);
        Narrative narrative = pd.getDevelopmentProposal().getNarratives().get(lineNumber);
        List<NarrativeUserRights> userRights = narrative.getNarrativeUserRights();
        List editUserRights = (List)((Object)ObjectUtils.deepCopy((Serializable)((Serializable)((Object)userRights))));
        proposalDevelopmentForm.setNewNarrativeUserRights(editUserRights);
        request.setAttribute(LINE_NUMBER, (Object)(EMPTY_STRING + lineNumber));
        return mapping.findForward("attachmentRights");
    }

    public ActionForward addProposalAttachmentRights(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        List<NarrativeUserRights> newNarrativeUserRights = proposalDevelopmentForm.getNewNarrativeUserRights();
        int lineNumber = this.getLineNumber(request);
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new NewNarrativeUserRightsEvent(proposalDevelopmentDocument, newNarrativeUserRights, lineNumber));
        if (!rulePassed) {
            request.setAttribute(LINE_NUMBER, (Object)Integer.toString(lineNumber));
            forward = mapping.findForward("attachmentRights");
        } else {
            proposalDevelopmentDocument.getDevelopmentProposal().getNarrative(lineNumber).setNarrativeUserRights(newNarrativeUserRights);
            forward = mapping.findForward("closePage");
        }
        return forward;
    }

    public ActionForward addInstituteAttachmentRights(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        List<NarrativeUserRights> newNarrativeUserRights = proposalDevelopmentForm.getNewNarrativeUserRights();
        int lineNumber = this.getLineNumber(request);
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new NewNarrativeUserRightsEvent(proposalDevelopmentDocument, newNarrativeUserRights, lineNumber));
        if (!rulePassed) {
            request.setAttribute(LINE_NUMBER, (Object)Integer.toString(lineNumber));
            forward = mapping.findForward("instituteAttachmentRights");
        } else {
            proposalDevelopmentDocument.getDevelopmentProposal().getInstituteAttachment(lineNumber).setNarrativeUserRights(newNarrativeUserRights);
            forward = mapping.findForward("closePage");
        }
        return forward;
    }

    public ActionForward replaceProposalAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pd = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ActionForward forward = mapping.findForward("basic");
        Narrative modifiedNarrative = pd.getDevelopmentProposal().getNarrative(this.getSelectedLine(request));
        pd.getDevelopmentProposal().replaceAttachment(this.getSelectedLine(request));
        ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext(pd.getDevelopmentProposal(), "102", "Proposal Data Override");
        ((ProposalDevelopmentNotificationRenderer)context.getRenderer()).setModifiedNarrative(modifiedNarrative);
        if (proposalDevelopmentForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            proposalDevelopmentForm.getNotificationHelper().initializeDefaultValues(context);
            forward = mapping.findForward("notificationEditor");
        } else {
            this.getNotificationService().sendNotification(context);
        }
        return forward;
    }

    public ActionForward replacePersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pd = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ActionForward forward = mapping.findForward("basic");
        ProposalPersonBiography ppb = pd.getDevelopmentProposal().getPropPersonBio(this.getSelectedLine(request));
        ppb.populateAttachment();
        this.getBusinessObjectService().save((PersistableBusinessObject)ppb);
        return forward;
    }

    public ActionForward replaceInstituteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pd = proposalDevelopmentForm.getProposalDevelopmentDocument();
        pd.getDevelopmentProposal().replaceInstituteAttachment(this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    private void setUpdateFields(KraPersistableBusinessObjectBase bo) {
        String updateUser = GlobalVariables.getUserSession().getPrincipalName();
        bo.setUpdateUser(updateUser);
        bo.setUpdateTimestamp(KraServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
        if (bo instanceof ProposalAbstract) {
            ProposalAbstract abstractBo = (ProposalAbstract)bo;
            abstractBo.setTimestampDisplay(KraServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
            abstractBo.setUploadUserDisplay(updateUser);
        }
    }

    public ActionForward addAbstract(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalAbstract proposalAbstract = proposalDevelopmentForm.getNewProposalAbstract();
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new AddAbstractEvent(proposalDevelopmentForm.getProposalDevelopmentDocument(), proposalAbstract));
        if (rulePassed) {
            this.setUpdateFields(proposalAbstract);
            proposalAbstract.setTimestampDisplay(KraServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
            proposalAbstract.setUploadUserDisplay(GlobalVariables.getUserSession().getPrincipalName());
            proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalAbstracts().add(proposalAbstract);
            proposalDevelopmentForm.setNewProposalAbstract(new ProposalAbstract());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteAbstract(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildDeleteAbstractConfirmationQuestion(mapping, form, request, response), CONFIRM_DELETE_ABSTRACT_KEY, EMPTY_STRING);
    }

    public ActionForward confirmDeleteAbstract(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        int lineNum = this.getLineToDelete(request);
        if (CONFIRM_DELETE_ABSTRACT_KEY.equals(question)) {
            ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument().getDevelopmentProposal().getProposalAbstracts().remove(lineNum);
        }
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildDeleteAbstractConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentDocument doc = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument();
        String description = doc.getDevelopmentProposal().getProposalAbstracts().get(this.getLineToDelete(request)).getAbstractType().getDescription();
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_ABSTRACT_KEY, "document.question.deleteAbstract.text", description);
    }

    private StrutsConfirmation buildDeleteAttachmentConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionId) throws Exception {
        ProposalDevelopmentDocument doc = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument();
        String description = null;
        String fileName = null;
        if (CONFIRM_DELETE_INSTITUTIONAL_ATTACHMENT_KEY.equals(questionId)) {
            description = "Institutional Attachment";
            fileName = doc.getDevelopmentProposal().getInstituteAttachment(this.getLineToDelete(request)).getFileName();
        } else if (CONFIRM_DELETE_PERSONNEL_ATTACHMENT_KEY.equals(questionId)) {
            description = "Personnel Attachment";
            fileName = doc.getDevelopmentProposal().getPropPersonBio(this.getLineToDelete(request)).getFileName();
        } else if (CONFIRM_DELETE_PROPOSAL_ATTACHMENT_KEY.equals(questionId)) {
            description = "Proposal Attachment";
            fileName = doc.getDevelopmentProposal().getNarrative(this.getLineToDelete(request)).getFileName();
        }
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, questionId, "document.question.deleteAttachment.text", description, fileName);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    protected KualiRuleService getKualiRuleService() {
        return KraServiceLocator.getService(KualiRuleService.class);
    }

    public ActionForward addPersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new AddPersonnelAttachmentEvent(EMPTY_STRING, proposalDevelopmentDocument, proposalDevelopmentForm.getNewPropPersonBio()))) {
            proposalDevelopmentDocument.getDevelopmentProposal().addProposalPersonBiography(proposalDevelopmentForm.getNewPropPersonBio());
            proposalDevelopmentForm.setNewPropPersonBio(new ProposalPersonBiography());
            this.populateTabState((KualiForm)proposalDevelopmentForm, "Personnel Attachments " + proposalDevelopmentDocument.getDevelopmentProposal().getPropPersonBios().size());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deletePersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String questionId = CONFIRM_DELETE_PERSONNEL_ATTACHMENT_KEY;
        return this.confirm(this.buildDeleteAttachmentConfirmationQuestion(mapping, form, request, response, questionId), questionId, EMPTY_STRING);
    }

    public ActionForward confirmDeletePersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDoc = pdForm.getProposalDevelopmentDocument();
        this.populateTabState((KualiForm)((ProposalDevelopmentForm)form), "Personnel Attachments " + pdDoc.getDevelopmentProposal().getPropPersonBios().size());
        return this.deleteAttachment(mapping, form, request, response, CONFIRM_DELETE_PERSONNEL_ATTACHMENT_KEY, "deleteProposalPersonBiography");
    }

    public ActionForward viewPersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pd = proposalDevelopmentForm.getProposalDevelopmentDocument();
        String line = request.getParameter(LINE_NUMBER);
        int lineNumber = line == null ? 0 : Integer.parseInt(line);
        ProposalPersonBiography propPersonBio = pd.getDevelopmentProposal().getPropPersonBios().get(lineNumber);
        HashMap<String, String> propPersonBioAttVal = new HashMap<String, String>();
        propPersonBioAttVal.put(PROPOSAL_NUMBER, propPersonBio.getProposalNumber());
        propPersonBioAttVal.put(BIOGRAPHY_NUMBER, propPersonBio.getBiographyNumber() + EMPTY_STRING);
        propPersonBioAttVal.put(PROPOSAL_PERSON_NUMBER, propPersonBio.getProposalPersonNumber() + EMPTY_STRING);
        ProposalPersonBiographyAttachment propPersonBioAttachment = (ProposalPersonBiographyAttachment)this.getBusinessObjectService().findByPrimaryKey(ProposalPersonBiographyAttachment.class, propPersonBioAttVal);
        if (propPersonBioAttachment == null && !propPersonBio.getPersonnelAttachmentList().isEmpty()) {
            propPersonBioAttachment = propPersonBio.getPersonnelAttachmentList().get(0);
        }
        this.streamToResponse(propPersonBioAttachment, response);
        return null;
    }

    public ActionForward addInstitutionalAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        Narrative narrative = proposalDevelopmentForm.getNewInstituteAttachment();
        narrative.setModuleStatusCode("C");
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new AddInstituteAttachmentEvent(EMPTY_STRING, proposalDevelopmentDocument, narrative))) {
            proposalDevelopmentDocument.getDevelopmentProposal().addInstituteAttachment(narrative);
            proposalDevelopmentForm.setNewInstituteAttachment(new Narrative());
            this.populateTabState((KualiForm)proposalDevelopmentForm, "Internal Attachments " + proposalDevelopmentDocument.getDevelopmentProposal().getInstituteAttachments().size());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteInstitutionalAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String questionId = CONFIRM_DELETE_INSTITUTIONAL_ATTACHMENT_KEY;
        return this.confirm(this.buildDeleteAttachmentConfirmationQuestion(mapping, form, request, response, questionId), questionId, EMPTY_STRING);
    }

    public ActionForward confirmDeleteInstitutionalAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDoc = pdForm.getProposalDevelopmentDocument();
        this.populateTabState((KualiForm)((ProposalDevelopmentForm)form), "Internal Attachments " + pdDoc.getDevelopmentProposal().getInstituteAttachments().size());
        return this.deleteAttachment(mapping, form, request, response, CONFIRM_DELETE_INSTITUTIONAL_ATTACHMENT_KEY, "deleteInstitutionalAttachment");
    }

    public ActionForward viewInstitutionalAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pd = proposalDevelopmentForm.getProposalDevelopmentDocument();
        String line = request.getParameter(LINE_NUMBER);
        int lineNumber = line == null ? 0 : Integer.parseInt(line);
        Narrative narrative = pd.getDevelopmentProposal().getInstituteAttachments().get(lineNumber);
        NarrativeAttachment narrativeAttachment = this.findNarrativeAttachment(narrative);
        if (narrativeAttachment == null && !narrative.getNarrativeAttachmentList().isEmpty()) {
            narrativeAttachment = narrative.getNarrativeAttachmentList().get(0);
        }
        this.streamToResponse(narrativeAttachment, response);
        return null;
    }

    @Override
    public ActionForward processAuthorizationViolation(String taskName, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        if (!StringUtils.equals((String)taskName, (String)"addProposalAttachmentRights")) {
            forward = super.processAuthorizationViolation(taskName, mapping, form, request, response);
        } else {
            MessageMap errorMap = GlobalVariables.getMessageMap();
            errorMap.putError("newNarrativeUserRight", "error.authorization.violation", new String[0]);
            ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
            int lineNumber = this.getLineNumber(request);
            request.setAttribute(LINE_NUMBER, (Object)Integer.toString(lineNumber));
            forward = mapping.findForward("attachmentRights");
        }
        return forward;
    }

    private int getLineNumber(HttpServletRequest request) {
        int lineNumber = 0;
        String lineStr = request.getParameter(LINE_NUMBER);
        if (lineStr == null) {
            lineNumber = this.getLineToDelete(request);
        } else {
            try {
                lineNumber = Integer.parseInt(lineStr);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return lineNumber;
    }

    public ActionForward insertBONote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        Note newNote = kualiDocumentFormBase.getNewNote();
        newNote.setNotePostedTimestamp(CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp());
        return super.insertBONote(mapping, form, request, response);
    }
}

