/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web.struts.action;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.RateClassType;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.web.struts.action.BudgetParentActionBase;
import org.kuali.kra.budget.web.struts.action.BudgetTDCValidator;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.kew.KraDocumentRejectionService;
import org.kuali.kra.krms.service.KrmsRulesExecutionService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalAbstract;
import org.kuali.kra.proposaldevelopment.bo.ProposalColumnsToAlter;
import org.kuali.kra.proposaldevelopment.bo.ProposalCopyCriteria;
import org.kuali.kra.proposaldevelopment.bo.ProposalDevelopmentApproverViewDO;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.budget.bo.ProposalDevelopmentBudgetExt;
import org.kuali.kra.proposaldevelopment.budget.service.BudgetPrintService;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarcyActionHelper;
import org.kuali.kra.proposaldevelopment.printing.service.ProposalDevelopmentPrintingService;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalPersonQuestionnaireHelper;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.proposaldevelopment.service.NarrativeService;
import org.kuali.kra.proposaldevelopment.service.ProposalAbstractsService;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.proposaldevelopment.service.ProposalPersonBiographyService;
import org.kuali.kra.proposaldevelopment.service.ProposalRoleTemplateService;
import org.kuali.kra.proposaldevelopment.web.struts.action.ProposalDevelopmentKeyPersonnelAction;
import org.kuali.kra.proposaldevelopment.web.struts.action.S2sOppFormsComparator1;
import org.kuali.kra.proposaldevelopment.web.struts.action.S2sOppFormsComparator2;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.bo.S2sOppForms;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.s2s.service.S2SBudgetCalculatorService;
import org.kuali.kra.s2s.service.S2SService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.kra.service.PersonEditableService;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.util.CollectionUtils;

public class ProposalDevelopmentAction
extends BudgetParentActionBase {
    private static final String PROPOSAL_NARRATIVE_TYPE_GROUP = "proposalNarrativeTypeGroup";
    private static final String DELIVERY_INFO_DISPLAY_INDICATOR = "deliveryInfoDisplayIndicator";
    private static final String PROPOSAL_SUMMARY_INDICATOR = "enableProposalSummaryPanel";
    private static final String BUDGET_SUMMARY_INDICATOR = "enableBudgetSummaryPanel";
    private static final String KEY_PERSONNEL_INDICATOR = "enableKeyPersonnelPanel";
    private static final String SPECIAL_REVIEW_INDICATOR = "enableSpecialReviewPanel";
    private static final String SUMMARY_PRINT_FORMS_INDICATOR = "enableSummaryPrintPanel";
    private static final String CUSTOM_DATA_INFO_INDICATOR = "enableCustomDataInfoPanel";
    private static final String SUMMARY_QUESTIONS_INDICATOR = "enableSummaryQuestionsPanel";
    private static final String SUMMARY_ATTACHMENTS_INDICATOR = "enableSummaryAttachmentsPanel";
    private static final String SUMMARY_KEYWORDS_INDICATOR = "enableSummaryKeywordsPanel";
    private static final String PROPOSAL_SUMMARY_DISCLAIMER_INDICATOR = "propSummaryDisclaimerText";
    private static final String SUMMARY_DATA_VALIDATION_INDICATOR = "enableSummaryDataValidationPanel";
    private static final String ERROR_NO_GRANTS_GOV_FORM_SELECTED = "error.proposalDevelopment.no.grants.gov.form.selected";
    private static final String ALL_SPONSOR_HIERARCHY_NIH_MULTI_PI = "ALL_SPONSOR_HIERARCHY_NIH_MULTI_PI";
    private static final String PERSON_INDEX = "personIndex";
    private static final String COMMENTS = "comments";
    private static final String SUMMARY_SPECIAL_REVIEW_LIST = "proposal.summary.validSpecialReviewCodes";
    private static final String PROPOSAL_ATTACHMENT_TYPE_GROUP_CODE = "P";
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentAction.class);
    private ProposalHierarcyActionHelper hierarchyHelper;
    private KcNotificationService notificationService;
    private BudgetService budgetService;
    private S2SBudgetCalculatorService s2SBudgetCalculatorService;
    List<AnswerHeader> answerHeaders;

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        String command = proposalDevelopmentForm.getCommand();
        String createProposalFromGrantsGov = request.getParameter("createProposalFromGrantsGov");
        S2sOpportunity s2sOpportunity = new S2sOpportunity();
        if (createProposalFromGrantsGov != null && createProposalFromGrantsGov.equals("true")) {
            s2sOpportunity = proposalDevelopmentForm.getNewS2sOpportunity();
            proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().setS2sOpportunity(s2sOpportunity);
            proposalDevelopmentForm.setNewS2sOpportunity(new S2sOpportunity());
        }
        if (proposalDevelopmentForm.getProposalDevelopmentDocument().getDocumentHeader().getDocumentNumber() == null && request.getParameter("docId") != null) {
            this.loadDocumentInForm(request, proposalDevelopmentForm);
        }
        if ("displayActionListInlineView".equals(command)) {
            KraWorkflowService workflowService = KraServiceLocator.getService(KraWorkflowService.class);
            ProposalDevelopmentApproverViewDO approverViewDO = workflowService.populateApproverViewDO(proposalDevelopmentForm);
            proposalDevelopmentForm.setApproverViewDO(approverViewDO);
            forward = mapping.findForward("proposalDevelopmentSummary");
            forward = new ActionForward(forward.getPath() + "?" + "docId" + "=" + request.getParameter("docId"));
        } else {
            KraWorkflowService workflowService;
            if (proposalDevelopmentForm.getDocTypeName() == null || proposalDevelopmentForm.getDocTypeName().equals("")) {
                proposalDevelopmentForm.setDocTypeName("ProposalDevelopmentDocument");
            }
            boolean rejectedDocument = false;
            KraDocumentRejectionService documentRejectionService = KraServiceLocator.getService(KraDocumentRejectionService.class);
            if (proposalDevelopmentForm.getDocument().getDocumentNumber() != null) {
                rejectedDocument = documentRejectionService.isDocumentOnInitialNode(proposalDevelopmentForm.getDocument().getDocumentNumber());
            }
            if ((workflowService = KraServiceLocator.getService(KraWorkflowService.class)).canPerformWorkflowAction(proposalDevelopmentForm.getProposalDevelopmentDocument()) && !rejectedDocument) {
                ProposalDevelopmentApproverViewDO approverViewDO = workflowService.populateApproverViewDO(proposalDevelopmentForm);
                proposalDevelopmentForm.setApproverViewDO(approverViewDO);
                super.docHandler(mapping, form, request, response);
                return this.approverView(mapping, form, request, response);
            }
            if ("actions".equals(command)) {
                this.loadDocument((KualiDocumentFormBase)proposalDevelopmentForm);
                forward = this.actions(mapping, (ActionForm)proposalDevelopmentForm, request, response);
            } else {
                forward = super.docHandler(mapping, form, request, response);
            }
        }
        if (proposalDevelopmentForm.getProposalDevelopmentDocument().isProposalDeleted()) {
            return mapping.findForward("deleted");
        }
        if ("initiate".equals(proposalDevelopmentForm.getCommand())) {
            proposalDevelopmentForm.getProposalDevelopmentDocument().initialize();
        } else {
            proposalDevelopmentForm.initialize();
        }
        if ("actions".equals(command)) {
            forward = this.actions(mapping, (ActionForm)proposalDevelopmentForm, request, response);
        }
        if (createProposalFromGrantsGov != null && createProposalFromGrantsGov.equals("true") && s2sOpportunity != null) {
            this.createS2sOpportunityDetails(proposalDevelopmentForm, s2sOpportunity);
        }
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        Role roleInfo = this.getRoleService().getRoleByNamespaceCodeAndName("KC-ADM", "OSP Administrator");
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleInfo.getId());
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put("unitNumber", "*");
        HashMap qualifications = new HashMap(qualifiedRoleAttributes);
        if (this.getRoleService().principalHasRole(principalId, roleIds, qualifications)) {
            proposalDevelopmentForm.setSaveXmlPermission(true);
        }
        KraAuthorizationService proposalAuthService = KraServiceLocator.getService(KraAuthorizationService.class);
        List<KcPerson> persons = proposalAuthService.getPersonsInRole(proposalDevelopmentForm.getProposalDevelopmentDocument(), "Aggregator");
        for (KcPerson person : persons) {
            if (!GlobalVariables.getUserSession().getPrincipalName().equals(person.getUserName())) continue;
            proposalDevelopmentForm.setSaveXmlPermission(true);
        }
        if (proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().getS2sOpportunity() != null) {
            proposalDevelopmentForm.setGrantsGovSelectFlag(true);
        }
        return forward;
    }

    private void createS2sOpportunityDetails(ProposalDevelopmentForm proposalDevelopmentForm, S2sOpportunity s2sOpportunity) throws S2SException {
        Boolean mandatoryFormNotAvailable = false;
        if (s2sOpportunity.getCfdaNumber() != null) {
            proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().setCfdaNumber(s2sOpportunity.getCfdaNumber());
        }
        if (s2sOpportunity.getOpportunityId() != null) {
            proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().setProgramAnnouncementNumber(s2sOpportunity.getOpportunityId());
        }
        if (s2sOpportunity.getOpportunityTitle() != null) {
            proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().setProgramAnnouncementTitle(s2sOpportunity.getOpportunityTitle());
        }
        List<Object> s2sOppForms = new ArrayList();
        if (s2sOpportunity.getSchemaUrl() != null) {
            s2sOppForms = KraServiceLocator.getService(S2SService.class).parseOpportunityForms(s2sOpportunity);
            if (s2sOppForms != null) {
                for (S2sOppForms s2sOppForm : s2sOppForms) {
                    if (!s2sOppForm.getMandatory().booleanValue() || s2sOppForm.getAvailable().booleanValue()) continue;
                    mandatoryFormNotAvailable = true;
                    break;
                }
            }
            if (!mandatoryFormNotAvailable.booleanValue()) {
                s2sOpportunity.setS2sOppForms(s2sOppForms);
                s2sOpportunity.setVersionNumber(proposalDevelopmentForm.getVersionNumberForS2sOpportunity());
                proposalDevelopmentForm.setVersionNumberForS2sOpportunity(null);
                proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().setS2sOpportunity(s2sOpportunity);
            } else {
                GlobalVariables.getMessageMap().putError("noField", "error.s2sopportunity.opportunityIdInvalid", new String[]{proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().getS2sOpportunity().getOpportunityId()});
                proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().setS2sOpportunity(new S2sOpportunity());
            }
        }
    }

    protected ProposalHierarcyActionHelper getHierarchyHelper() {
        if (this.hierarchyHelper == null) {
            this.hierarchyHelper = new ProposalHierarcyActionHelper();
        }
        return this.hierarchyHelper;
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = proposalDevelopmentForm.getProposalDevelopmentDocument();
        String keywordPanelDisplay = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.displayKeywordPanel");
        request.getSession().setAttribute("proposaldevelopment.displayKeywordPanel", (Object)keywordPanelDisplay);
        if (proposalDevelopmentForm.isAuditActivated()) {
            proposalDevelopmentForm.setUnitRulesMessages(this.getUnitRulesMessages(proposalDevelopmentForm.getProposalDevelopmentDocument()));
        }
        if (KNSGlobalVariables.getAuditErrorMap().isEmpty()) {
            new AuditActionHelper().auditConditionally(proposalDevelopmentForm);
        }
        proposalDevelopmentForm.setProposalDataOverrideMethodToCalls(this.constructColumnsToAlterLookupMTCs(proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalNumber()));
        ((ProposalDevelopmentForm)form).getProposalDevelopmentParameters().put(DELIVERY_INFO_DISPLAY_INDICATOR, this.getParameterService().getParameter("KC-PD", "Document", DELIVERY_INFO_DISPLAY_INDICATOR));
        ((ProposalDevelopmentForm)form).getProposalDevelopmentParameters().put(PROPOSAL_NARRATIVE_TYPE_GROUP, this.getParameterService().getParameter("KC-PD", "Document", PROPOSAL_NARRATIVE_TYPE_GROUP));
        if (document.getDevelopmentProposal().getS2sOpportunity() != null && document.getDevelopmentProposal().getS2sOpportunity().getS2sOppForms() != null) {
            Collections.sort(document.getDevelopmentProposal().getS2sOpportunity().getS2sOppForms(), new S2sOppFormsComparator2());
            Collections.sort(document.getDevelopmentProposal().getS2sOpportunity().getS2sOppForms(), new S2sOppFormsComparator1());
        }
        return actionForward;
    }

    protected List<String> getUnitRulesMessages(ProposalDevelopmentDocument pdDoc) {
        KrmsRulesExecutionService rulesService = KraServiceLocator.getService(KrmsRulesExecutionService.class);
        return rulesService.processUnitValidations(pdDoc.getLeadUnitNumber(), pdDoc);
    }

    public ActionForward nullOp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    @Override
    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.loadDocument(kualiDocumentFormBase);
        ProposalDevelopmentDocument document = ((ProposalDevelopmentForm)kualiDocumentFormBase).getProposalDevelopmentDocument();
        this.loadDocument(document);
    }

    protected void loadDocument(ProposalDevelopmentDocument document) {
        this.getKeyPersonnelService().populateDocument(document);
        this.updateNIHDescriptions(document);
        this.setBudgetStatuses(document);
    }

    protected SponsorService getSponsorService() {
        return KraServiceLocator.getService(SponsorService.class);
    }

    protected void updateNIHDescriptions(ProposalDevelopmentDocument document) {
        boolean multiPIFlag;
        DevelopmentProposal proposal;
        SponsorService sponsorService = this.getSponsorService();
        if (sponsorService.isSponsorNihMultiplePi(proposal = document.getDevelopmentProposal())) {
            proposal.setNihDescription(this.getKeyPersonnelService().loadKeyPersonnelRoleDescriptions(true));
        }
        if (multiPIFlag = this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, ALL_SPONSOR_HIERARCHY_NIH_MULTI_PI).booleanValue()) {
            proposal.setSponsorNihMultiplePi(true);
            proposal.setSponsorNihOsc(true);
        } else {
            proposal.setSponsorNihMultiplePi(sponsorService.isSponsorNihMultiplePi(proposal));
            proposal.setSponsorNihOsc(sponsorService.isSponsorNihOsc(proposal));
        }
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument doc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        S2sOpportunity s2sOpportunity = proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().getS2sOpportunity();
        if (s2sOpportunity != null && s2sOpportunity.getProposalNumber() == null) {
            proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().setS2sOpportunity(null);
            proposalDevelopmentForm.setS2sOpportunity(s2sOpportunity);
        }
        this.updateProposalDocument(proposalDevelopmentForm);
        this.preSave(mapping, (ActionForm)proposalDevelopmentForm, request, response);
        ActionForward forward = super.save(mapping, form, request, response);
        if (proposalDevelopmentForm.isAuditActivated()) {
            forward = mapping.findForward("actions");
        }
        if ((s2sOpportunity = proposalDevelopmentForm.getS2sOpportunity()) != null) {
            doc.getDevelopmentProposal().setS2sOpportunity(s2sOpportunity);
            s2sOpportunity.setProposalNumber(doc.getDevelopmentProposal().getProposalNumber());
            this.getBusinessObjectService().save((PersistableBusinessObject)s2sOpportunity);
            proposalDevelopmentForm.setS2sOpportunity(null);
        }
        doc.getDevelopmentProposal().updateProposalNumbers();
        proposalDevelopmentForm.setFinalBudgetVersion(this.getFinalBudgetVersion(doc.getBudgetDocumentVersions()));
        this.setBudgetStatuses(doc);
        if ("ProposalDevelopmentBudgetVersionsAction".equals(proposalDevelopmentForm.getActionName())) {
            GlobalVariables.getMessageMap().addToErrorPath("document.proposal");
            BudgetTDCValidator tdcValidator = new BudgetTDCValidator(request);
            tdcValidator.validateGeneratingErrorsAndWarnings(doc);
        }
        if (doc.getBudgetDocumentVersions() != null && !doc.getBudgetDocumentVersions().isEmpty()) {
            for (BudgetDocumentVersion bdv : doc.getBudgetDocumentVersions()) {
                ProposalDevelopmentBudgetExt budget = (ProposalDevelopmentBudgetExt)this.getBusinessObjectService().findBySinglePrimaryKey(ProposalDevelopmentBudgetExt.class, (Object)bdv.getBudgetVersionOverview().getBudgetId());
                if (budget.getFinalVersionFlag().booleanValue()) continue;
                budget.setStartDate(proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().getRequestedStartDateInitial());
                budget.setEndDate(proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().getRequestedEndDateInitial());
                this.getBusinessObjectService().save((PersistableBusinessObject)budget);
            }
        }
        return forward;
    }

    @Override
    protected ActionForward saveOnClose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.saveOnClose(mapping, form, request, response);
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument doc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        this.updateProposalDocument(proposalDevelopmentForm);
        doc.getDevelopmentProposal().updateProposalNumbers();
        return forward;
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        if (proposalDevelopmentForm.getViewFundingSource()) {
            return mapping.findForward("closePage");
        }
        return super.close(mapping, form, request, response);
    }

    protected void updateProposalDocument(ProposalDevelopmentForm pdForm) throws Exception {
        ProposalDevelopmentDocument pdDocument = pdForm.getProposalDevelopmentDocument();
        ProposalDevelopmentDocument updatedDocCopy = this.getProposalDoc(pdDocument.getDocumentNumber());
        if (updatedDocCopy != null) {
            if (StringUtils.isNotEmpty((String)pdForm.getActionName()) && updatedDocCopy != null) {
                if (!pdForm.getActionName().equalsIgnoreCase("ProposalDevelopmentBudgetVersionsAction")) {
                    pdDocument.setBudgetDocumentVersions(updatedDocCopy.getBudgetDocumentVersions());
                    pdDocument.getDevelopmentProposal().setBudgetStatus(updatedDocCopy.getDevelopmentProposal().getBudgetStatus());
                } else {
                    List<BudgetDocumentVersion> newVersions = pdDocument.getBudgetDocumentVersions();
                    String budgetStatus = pdDocument.getDevelopmentProposal().getBudgetStatus();
                    pdForm.setDocument((Document)updatedDocCopy);
                    pdDocument = updatedDocCopy;
                    this.loadDocument(pdDocument);
                    pdDocument.setBudgetDocumentVersions(newVersions);
                    pdDocument.getDevelopmentProposal().setBudgetStatus(budgetStatus);
                }
                if (!pdForm.getActionName().equalsIgnoreCase("ProposalDevelopmentAbstractsAttachmentsAction")) {
                    pdDocument.getDevelopmentProposal().setNarratives(updatedDocCopy.getDevelopmentProposal().getNarratives());
                    pdDocument.getDevelopmentProposal().setInstituteAttachments(updatedDocCopy.getDevelopmentProposal().getInstituteAttachments());
                    pdDocument.getDevelopmentProposal().setProposalAbstracts(updatedDocCopy.getDevelopmentProposal().getProposalAbstracts());
                    pdDocument.getDevelopmentProposal().setPropPersonBios(updatedDocCopy.getDevelopmentProposal().getPropPersonBios());
                    this.removePersonnelAttachmentForDeletedPerson(pdDocument);
                } else {
                    List<Narrative> newNarratives = pdDocument.getDevelopmentProposal().getNarratives();
                    List<Narrative> instituteAttachments = pdDocument.getDevelopmentProposal().getInstituteAttachments();
                    List<ProposalAbstract> newAbstracts = pdDocument.getDevelopmentProposal().getProposalAbstracts();
                    List<ProposalPersonBiography> newBiographies = pdDocument.getDevelopmentProposal().getPropPersonBios();
                    pdForm.setDocument((Document)updatedDocCopy);
                    pdDocument = updatedDocCopy;
                    this.loadDocument(pdDocument);
                    ArrayList<Narrative> newNarrativesCopy = new ArrayList<Narrative>();
                    if (newNarratives != null) {
                        for (Narrative refreshNarrativesList : newNarratives) {
                            if (!refreshNarrativesList.getNarrativeType().getNarrativeTypeGroup().equalsIgnoreCase(PROPOSAL_ATTACHMENT_TYPE_GROUP_CODE)) continue;
                            newNarrativesCopy.add(refreshNarrativesList);
                        }
                    }
                    pdDocument.getDevelopmentProposal().setNarratives(newNarrativesCopy);
                    pdDocument.getDevelopmentProposal().setInstituteAttachments(instituteAttachments);
                    pdDocument.getDevelopmentProposal().setProposalAbstracts(newAbstracts);
                    pdDocument.getDevelopmentProposal().setPropPersonBios(newBiographies);
                }
            }
            pdDocument.getDocumentHeader().setVersionNumber(updatedDocCopy.getDocumentHeader().getVersionNumber());
            int noteIndex = 0;
            for (Object note : pdDocument.getNotes()) {
                Note updatedNote = updatedDocCopy.getNote(noteIndex);
                ((Note)note).setVersionNumber(updatedNote.getVersionNumber());
                ++noteIndex;
            }
            for (DocumentNextvalue documentNextValue : pdDocument.getDocumentNextvalues()) {
                DocumentNextvalue updatedDocumentNextvalue = updatedDocCopy.getDocumentNextvalueBo(documentNextValue.getPropertyName());
                if (updatedDocumentNextvalue == null) continue;
                documentNextValue.setVersionNumber(updatedDocumentNextvalue.getVersionNumber());
            }
            for (int i = 0; i < pdDocument.getBudgetDocumentVersions().size(); ++i) {
                BudgetDocumentVersion curVersion = pdDocument.getBudgetDocumentVersion(i);
                BudgetDocumentVersion otherVersion = updatedDocCopy.getBudgetDocumentVersion(i);
                otherVersion.refreshReferenceObject("documentHeader");
                if (curVersion == null || otherVersion == null) continue;
                curVersion.getDocumentHeader().setVersionNumber(otherVersion.getDocumentHeader().getVersionNumber());
            }
            pdForm.setDocument((Document)pdDocument);
        }
    }

    private void removePersonnelAttachmentForDeletedPerson(ProposalDevelopmentDocument proposaldevelopmentDocument) {
        ArrayList<ProposalPersonBiography> personAttachments = new ArrayList<ProposalPersonBiography>();
        for (ProposalPersonBiography proposalPersonBiography : proposaldevelopmentDocument.getDevelopmentProposal().getPropPersonBios()) {
            boolean personFound = false;
            for (ProposalPerson person : proposaldevelopmentDocument.getDevelopmentProposal().getProposalPersons()) {
                if (!proposalPersonBiography.getProposalPersonNumber().equals(person.getProposalPersonNumber())) continue;
                personFound = true;
                break;
            }
            if (personFound) continue;
            personAttachments.add(proposalPersonBiography);
        }
        if (!personAttachments.isEmpty()) {
            proposaldevelopmentDocument.getDevelopmentProposal().getPropPersonBios().removeAll(personAttachments);
        }
    }

    private boolean isPropertyGetterMethod(Method method, Method[] methods) {
        if (method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
            String setterName = method.getName().replaceFirst("get", "set");
            for (Method m : methods) {
                if (!m.getName().equals(setterName)) continue;
                return true;
            }
        }
        return false;
    }

    private void fixVersionNumbers(Object srcObject, Object object, List<Object> list) throws Exception {
        Class[] setterParamTypes = new Class[]{Long.class};
        if (object != null && object instanceof PersistableBusinessObject) {
            Method[] methods;
            if (list.contains(object)) {
                return;
            }
            list.add(object);
            Method getterMethod = object.getClass().getMethod("getVersionNumber", new Class[0]);
            if (getterMethod != null) {
                Long currentVersionNumber = null;
                currentVersionNumber = srcObject != null ? (Long)getterMethod.invoke(srcObject, new Object[0]) : (Long)getterMethod.invoke(object, new Object[0]);
                Method setterMethod = object.getClass().getMethod("setVersionNumber", setterParamTypes);
                if (currentVersionNumber != null) {
                    setterMethod.invoke(object, currentVersionNumber);
                }
            }
            for (Method method : methods = object.getClass().getDeclaredMethods()) {
                Object value;
                if (!this.isPropertyGetterMethod(method, methods)) continue;
                Object srcValue = null;
                if (srcObject != null) {
                    srcValue = method.invoke(srcObject, new Object[0]);
                }
                if ((value = method.invoke(object, new Object[0])) != null && value instanceof Collection) {
                    Collection c = (Collection)value;
                    Object[] srcC = c.toArray();
                    if (srcValue != null) {
                        srcC = ((Collection)srcValue).toArray();
                    }
                    Iterator iter = c.iterator();
                    int count = 0;
                    while (iter.hasNext()) {
                        Object srcEntry = null;
                        if (srcC.length > count) {
                            srcEntry = srcC[count];
                        }
                        Object entry = iter.next();
                        this.fixVersionNumbers(srcEntry, entry, list);
                        ++count;
                    }
                    continue;
                }
                this.fixVersionNumbers(srcValue, value, list);
            }
        }
    }

    protected ProposalDevelopmentDocument getProposalDoc(String pdDocumentNumber) throws Exception {
        DocumentService docService = KraServiceLocator.getService(DocumentService.class);
        ProposalDevelopmentDocument newCopy = (ProposalDevelopmentDocument)docService.getByDocumentHeaderId(pdDocumentNumber);
        return newCopy;
    }

    public ActionForward proposal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("proposal");
    }

    public ActionForward keyPersonnel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        this.getKeyPersonnelService().populateDocument(pdform.getProposalDevelopmentDocument());
        if (this instanceof ProposalDevelopmentKeyPersonnelAction) {
            LOG.info((Object)"forwarding to keyPersonnel action");
            return mapping.findForward("keyPersonnel");
        }
        new ProposalDevelopmentKeyPersonnelAction().prepare(form, request);
        return mapping.findForward("keyPersonnel");
    }

    public ActionForward specialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().refreshReferenceObject("propSpecialReviews");
        ((ProposalDevelopmentForm)form).getSpecialReviewHelper().prepareView();
        return mapping.findForward("specialReview");
    }

    public ActionForward permissions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("permissions");
    }

    public ActionForward getProposalPersonCertification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        String personIndex = request.getParameter(PERSON_INDEX);
        request.setAttribute(PERSON_INDEX, (Object)personIndex);
        return mapping.findForward("proposalPersonCertificate");
    }

    public ActionForward getProposalComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = proposalDevelopmentForm.getProposalDevelopmentDocument();
        String personIndex = request.getParameter(PERSON_INDEX);
        String comments = request.getParameter(COMMENTS);
        request.setAttribute(COMMENTS, (Object)comments);
        request.setAttribute(PERSON_INDEX, (Object)personIndex);
        return mapping.findForward("personComment");
    }

    public ActionForward hierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        pdForm.setHierarchyProposalSummaries(this.getHierarchyHelper().getHierarchyProposalSummaries(pdForm.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalNumber()));
        return mapping.findForward("hierarchy");
    }

    public ActionForward grantsGov(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (!((ProposalDevelopmentForm)form).isGrantsGovEnabled()) {
            GlobalVariables.getMessageMap().putWarning("noField", "error.grantsgov.disabled", new String[0]);
        }
        return mapping.findForward("grantsGov");
    }

    public ActionForward budgetVersions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        String headerTabCall = this.getHeaderTabDispatch(request);
        if (StringUtils.isEmpty((String)headerTabCall)) {
            pdForm.getDocument().refreshPessimisticLocks();
        }
        pdForm.setFinalBudgetVersion(this.getFinalBudgetVersion(pdForm.getProposalDevelopmentDocument().getBudgetDocumentVersions()));
        this.setBudgetStatuses(pdForm.getProposalDevelopmentDocument());
        BudgetTDCValidator tdcValidator = new BudgetTDCValidator(request);
        tdcValidator.validateGeneratingWarnings(pdForm.getProposalDevelopmentDocument());
        return mapping.findForward("budgetVersions");
    }

    public ActionForward abstractsAttachments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument doc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        doc.getDevelopmentProposal().populateNarrativeRightsForLoggedinUser();
        List narratives = (List)((Object)ObjectUtils.deepCopy((Serializable)((Serializable)((Object)doc.getDevelopmentProposal().getNarratives()))));
        proposalDevelopmentForm.setNarratives(narratives);
        KraServiceLocator.getService(ProposalPersonBiographyService.class).setPersonnelBioTimeStampUser(doc.getDevelopmentProposal().getPropPersonBios());
        ArrayList<Narrative> narrativeList = new ArrayList<Narrative>();
        narrativeList.addAll(doc.getDevelopmentProposal().getNarratives());
        narrativeList.addAll(doc.getDevelopmentProposal().getInstituteAttachments());
        KraServiceLocator.getService(NarrativeService.class).setNarrativeTimeStampUser(narrativeList);
        KraServiceLocator.getService(ProposalAbstractsService.class).loadAbstractsUploadUserFullName(doc.getDevelopmentProposal().getProposalAbstracts());
        return mapping.findForward("abstractsAttachments");
    }

    public ActionForward customData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        TreeMap customAttributeGroups = new TreeMap();
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument doc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        proposalDevelopmentForm.getCustomDataHelper().prepareCustomData();
        return mapping.findForward("customData");
    }

    public ActionForward actions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        if (proposalDevelopmentForm.getProposalDevelopmentDocument().getDocumentNumber() == null) {
            this.loadDocumentInForm(request, proposalDevelopmentForm);
        }
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ProposalDevelopmentPrintingService printService = KraServiceLocator.getService(ProposalDevelopmentPrintingService.class);
        printService.populateSponsorForms(proposalDevelopmentForm.getSponsorFormTemplates(), proposalDevelopmentDocument.getDevelopmentProposal().getSponsorCode());
        return mapping.findForward("actions");
    }

    public ActionForward medusa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        if (proposalDevelopmentForm.getProposalDevelopmentDocument().getDocumentNumber() == null) {
            this.loadDocumentInForm(request, proposalDevelopmentForm);
        }
        ProposalDevelopmentDocument document = proposalDevelopmentForm.getProposalDevelopmentDocument();
        String proposalNumber = document.getDevelopmentProposal().getProposalNumber();
        proposalDevelopmentForm.getMedusaBean().setMedusaViewRadio("0");
        proposalDevelopmentForm.getMedusaBean().setModuleName("DP");
        proposalDevelopmentForm.getMedusaBean().setModuleIdentifier(Long.valueOf(proposalNumber));
        proposalDevelopmentForm.getMedusaBean().generateParentNodes();
        return mapping.findForward("proposalMedusa");
    }

    public ActionForward auditMode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        new AuditActionHelper().auditConditionally((ProposalDevelopmentForm)form);
        return mapping.findForward("auditMode");
    }

    protected KeyPersonnelService getKeyPersonnelService() {
        return KraServiceLocator.getService(KeyPersonnelService.class);
    }

    protected PersonEditableService getPersonEditableService() {
        return KraServiceLocator.getService(PersonEditableService.class);
    }

    @Override
    protected void initialDocumentSave(KualiDocumentFormBase form) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument doc = pdForm.getProposalDevelopmentDocument();
        this.initializeProposalUsers(doc);
        if (pdForm.getCopyCriteria() != null) {
            pdForm.getCopyCriteria().setOriginalLeadUnitNumber(doc.getDevelopmentProposal().getOwnedByUnitNumber());
        }
    }

    protected void initializeProposalUsers(ProposalDevelopmentDocument doc) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        KraAuthorizationService kraAuthService = KraServiceLocator.getService(KraAuthorizationService.class);
        if (!kraAuthService.hasRole(userId, doc, "Aggregator")) {
            kraAuthService.addRole(userId, "Aggregator", doc);
        }
        ProposalRoleTemplateService proposalRoleTemplateService = KraServiceLocator.getService(ProposalRoleTemplateService.class);
        proposalRoleTemplateService.addUsers(doc);
    }

    protected String getActionName() {
        String name = ((Object)((Object)this)).getClass().getSimpleName();
        int endIndex = name.lastIndexOf("Action");
        return name.substring(19, endIndex);
    }

    protected void loadDocumentInForm(HttpServletRequest request, ProposalDevelopmentForm proposalDevelopmentForm) throws WorkflowException {
        String docIdRequestParameter = request.getParameter("docId");
        ProposalDevelopmentDocument retrievedDocument = (ProposalDevelopmentDocument)KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
        proposalDevelopmentForm.setDocument((Document)retrievedDocument);
        proposalDevelopmentForm.setDocTypeName(retrievedDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        request.setAttribute("docId", (Object)docIdRequestParameter);
        ProposalCopyCriteria cCriteria = proposalDevelopmentForm.getCopyCriteria();
        if (cCriteria != null) {
            cCriteria.setOriginalLeadUnitNumber(retrievedDocument.getDevelopmentProposal().getOwnedByUnitNumber());
        }
    }

    @Override
    public ActionForward headerTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((KualiForm)form).setTabStates(new HashMap());
        return super.headerTab(mapping, form, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward printForms(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        super.save(mapping, form, request, response);
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        boolean grantsGovErrorExists = false;
        if (proposalDevelopmentDocument.getDevelopmentProposal().getSelectedS2sOppForms().isEmpty()) {
            GlobalVariables.getMessageMap().putError("noKey", ERROR_NO_GRANTS_GOV_FORM_SELECTED, new String[0]);
            return mapping.findForward("actions");
        }
        AttachmentDataSource attachmentDataSource = KraServiceLocator.getService(S2SService.class).printForm(proposalDevelopmentDocument);
        if (attachmentDataSource == null || attachmentDataSource.getContent() == null || attachmentDataSource.getContent().length == 0) {
            for (String errorKey : KNSGlobalVariables.getAuditErrorMap().keySet()) {
                AuditCluster auditCluster = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(errorKey);
                if (!StringUtils.equalsIgnoreCase((String)auditCluster.getCategory(), (String)"Grants.Gov Errors")) continue;
                grantsGovErrorExists = true;
                for (Object error : auditCluster.getAuditErrorList()) {
                    AuditError auditError = (AuditError)error;
                    GlobalVariables.getMessageMap().putError("grantsGovFormValidationErrors", auditError.getMessageKey(), auditError.getParams());
                }
            }
        }
        if (grantsGovErrorExists) {
            GlobalVariables.getMessageMap().putError("grantsGovFormValidationErrors", "validation.errors.before.grantsGov.submission", new String[0]);
            return mapping.findForward("grantsGov");
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().getGrantsGovSelectFlag().booleanValue()) {
            String loggingDirectory = KraServiceLocator.getService(ConfigurationService.class).getPropertyValueAsString("print.xml.directory");
            String saveXmlFolderName = proposalDevelopmentDocument.getSaveXmlFolderName();
            if (StringUtils.isNotBlank((String)loggingDirectory)) {
                File directory = new File(loggingDirectory);
                if (!directory.exists()) {
                    directory.createNewFile();
                }
                if (!loggingDirectory.endsWith("/")) {
                    loggingDirectory = loggingDirectory + "/";
                }
                File grantsGovXmlDirectoryFile = new File(loggingDirectory + saveXmlFolderName + ".zip");
                byte[] bytes = new byte[(int)grantsGovXmlDirectoryFile.length()];
                FileInputStream fileInputStream = new FileInputStream(grantsGovXmlDirectoryFile);
                fileInputStream.read(bytes);
                ByteArrayOutputStream baos = null;
                try {
                    baos = new ByteArrayOutputStream(bytes.length);
                    baos.write(bytes);
                    WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"binary/octet-stream", (ByteArrayOutputStream)baos, (String)(saveXmlFolderName + ".zip"));
                }
                finally {
                    try {
                        if (baos != null) {
                            baos.close();
                            baos = null;
                        }
                    }
                    catch (IOException ioEx) {
                        LOG.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
                    }
                }
            }
            proposalDevelopmentDocument.getDevelopmentProposal().setGrantsGovSelectFlag(false);
            return mapping.findForward("basic");
        }
        if (attachmentDataSource == null || attachmentDataSource.getContent() == null) {
            return mapping.findForward("actions");
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream(attachmentDataSource.getContent().length);
            baos.write(attachmentDataSource.getContent());
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)attachmentDataSource.getContentType(), (ByteArrayOutputStream)baos, (String)attachmentDataSource.getFileName());
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                    baos = null;
                }
            }
            catch (IOException ioEx) {
                LOG.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            }
        }
        return mapping.findForward("basic");
    }

    public List<String> constructColumnsToAlterLookupMTCs(String proposalNumber) {
        HashMap filterMap = new HashMap();
        ProposalDevelopmentService proposalDevelopmentService = KraServiceLocator.getService(ProposalDevelopmentService.class);
        Collection proposalColumnsToAlterCollection = KraServiceLocator.getService(BusinessObjectService.class).findMatching(ProposalColumnsToAlter.class, filterMap);
        ArrayList<String> mtcReturn = new ArrayList<String>();
        for (ProposalColumnsToAlter pcta : proposalColumnsToAlterCollection) {
            if (!pcta.getHasLookup()) continue;
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("columnName", pcta.getColumnName());
            Object fieldValue = proposalDevelopmentService.getProposalFieldValueFromDBColumnName(proposalNumber, pcta.getColumnName());
            String displayAttributeName = pcta.getLookupReturn();
            String displayLookupReturnValue = proposalDevelopmentService.getDataOverrideLookupDisplayReturnValue(pcta.getLookupClass());
            mtcReturn.add("methodToCall.performLookup.(!!" + pcta.getLookupClass() + "!!).(((" + displayLookupReturnValue + ":newProposalChangedData.changedValue," + displayAttributeName + ":newProposalChangedData.displayValue))).((``)).((<>)).(([])).((**)).((^^)).((&&)).((//)).((~~)).anchorProposalDataOverride");
        }
        return mtcReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void streamToResponse(AttachmentDataSource attachmentDataSource, HttpServletResponse response) throws Exception {
        byte[] xbts = attachmentDataSource.getContent();
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream(xbts.length);
            baos.write(xbts);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)attachmentDataSource.getContentType(), (ByteArrayOutputStream)baos, (String)attachmentDataSource.getFileName());
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                    baos = null;
                }
            }
            catch (IOException ioEx) {
                LOG.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            }
        }
    }

    public ActionForward questions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        proposalDevelopmentForm.getQuestionnaireHelper().prepareView();
        proposalDevelopmentForm.getS2sQuestionnaireHelper().prepareView();
        proposalDevelopmentForm.getQuestionnaireHelper().populateAnswers();
        proposalDevelopmentForm.getS2sQuestionnaireHelper().populateAnswers();
        return mapping.findForward("questions");
    }

    public ActionForward approverView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        this.getKeyPersonnelService().populateDocument(pdform.getProposalDevelopmentDocument());
        BudgetDocument budgetDocument = this.getS2SBudgetCalculatorService().getFinalBudgetVersion(document);
        if (budgetDocument != null) {
            Budget budget = budgetDocument.getBudget();
            if (budget.getFinalVersionFlag().booleanValue()) {
                HashMap<String, Long> fieldValues = new HashMap<String, Long>();
                fieldValues.put("budgetId", budget.getBudgetId());
                BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
                List budgetPeriods = (List)businessObjectService.findMatching(BudgetPeriod.class, fieldValues);
                budget.setBudgetPeriods(budgetPeriods);
                Collection rates = businessObjectService.findMatching(BudgetRate.class, fieldValues);
                if (!CollectionUtils.isEmpty((Collection)rates)) {
                    List rateClassTypes = (List)businessObjectService.findAll(RateClassType.class);
                    budget.setRateClassTypes(rateClassTypes);
                    pdform.setBudgetToSummarize(budget);
                }
                pdform.setBudgetToSummarize(budget);
            }
            if (budget.getBudgetPrintForms().isEmpty()) {
                BudgetPrintService budgetPrintService = KraServiceLocator.getService(BudgetPrintService.class);
                budgetPrintService.populateBudgetPrintForms(budget);
            }
        }
        ProposalDevelopmentPrintingService printService = KraServiceLocator.getService(ProposalDevelopmentPrintingService.class);
        printService.populateSponsorForms(pdform.getSponsorFormTemplates(), document.getDevelopmentProposal().getSponsorCode());
        pdform.getQuestionnaireHelper().prepareView();
        pdform.getS2sQuestionnaireHelper().prepareView();
        if (CollectionUtils.isEmpty(pdform.getQuestionnaireHelper().getAnswerHeaders())) {
            pdform.getQuestionnaireHelper().populateAnswers();
        }
        ArrayList<ProposalPersonQuestionnaireHelper> proposalPersonQuestionnaireHelpers = new ArrayList<ProposalPersonQuestionnaireHelper>();
        for (ProposalPerson person : document.getDevelopmentProposal().getProposalPersons()) {
            ProposalPersonQuestionnaireHelper helper = new ProposalPersonQuestionnaireHelper(pdform, person);
            proposalPersonQuestionnaireHelpers.add(helper);
        }
        pdform.setProposalPersonQuestionnaireHelpers(proposalPersonQuestionnaireHelpers);
        pdform.getProposalDevelopmentParameters().put(PROPOSAL_SUMMARY_INDICATOR, this.getParameterService().getParameter("KC-PD", "Document", PROPOSAL_SUMMARY_INDICATOR));
        pdform.getProposalDevelopmentParameters().put(BUDGET_SUMMARY_INDICATOR, this.getParameterService().getParameter("KC-PD", "Document", BUDGET_SUMMARY_INDICATOR));
        pdform.getProposalDevelopmentParameters().put(KEY_PERSONNEL_INDICATOR, this.getParameterService().getParameter("KC-PD", "Document", KEY_PERSONNEL_INDICATOR));
        pdform.getProposalDevelopmentParameters().put(SPECIAL_REVIEW_INDICATOR, this.getParameterService().getParameter("KC-PD", "Document", SPECIAL_REVIEW_INDICATOR));
        pdform.getProposalDevelopmentParameters().put(SUMMARY_PRINT_FORMS_INDICATOR, this.getParameterService().getParameter("KC-PD", "Document", SUMMARY_PRINT_FORMS_INDICATOR));
        pdform.getProposalDevelopmentParameters().put(CUSTOM_DATA_INFO_INDICATOR, this.getParameterService().getParameter("KC-PD", "Document", CUSTOM_DATA_INFO_INDICATOR));
        pdform.getProposalDevelopmentParameters().put(SUMMARY_QUESTIONS_INDICATOR, this.getParameterService().getParameter("KC-PD", "Document", SUMMARY_QUESTIONS_INDICATOR));
        pdform.getProposalDevelopmentParameters().put(SUMMARY_ATTACHMENTS_INDICATOR, this.getParameterService().getParameter("KC-PD", "Document", SUMMARY_ATTACHMENTS_INDICATOR));
        pdform.getProposalDevelopmentParameters().put(SUMMARY_KEYWORDS_INDICATOR, this.getParameterService().getParameter("KC-PD", "Document", SUMMARY_KEYWORDS_INDICATOR));
        pdform.getProposalDevelopmentParameters().put(SUMMARY_DATA_VALIDATION_INDICATOR, this.getParameterService().getParameter("KC-PD", "Document", SUMMARY_DATA_VALIDATION_INDICATOR));
        pdform.getProposalDevelopmentParameters().put(PROPOSAL_SUMMARY_DISCLAIMER_INDICATOR, this.getParameterService().getParameter("KC-PD", "Document", PROPOSAL_SUMMARY_DISCLAIMER_INDICATOR));
        pdform.getProposalDevelopmentParameters().put(SUMMARY_SPECIAL_REVIEW_LIST, this.getParameterService().getParameter("KC-PD", "Document", SUMMARY_SPECIAL_REVIEW_LIST));
        pdform.getSpecialReviewHelper().populatePropSpecialReviewApproverView(pdform.getProposalDevelopmentParameters().get(SUMMARY_SPECIAL_REVIEW_LIST).getValue());
        return mapping.findForward("approverView");
    }

    @Override
    public ActionForward recall(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        ReasonPrompt prompt = new ReasonPrompt("DocRecall", "nonCancelling.recall.question.text", "nonCancellingRecallQuestion", "error.document.recall.reasonRequired", "recall", "1", "message.recall.noteTextIntro");
        ReasonPrompt.Response resp = prompt.ask(mapping, form, request, response);
        if (resp.forward != null) {
            forward = resp.forward;
        } else if ("DocRecall".equals(resp.question) && "0".equals(resp.button)) {
            KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
            this.doProcessingAfterPost((KualiForm)kualiDocumentFormBase, request);
            this.getDocumentService().recallDocument(kualiDocumentFormBase.getDocument(), resp.reason, false);
            forward = mapping.findForward("portal");
        } else {
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    public void preSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        if (pdForm.isHidePropDevDocDescriptionPanel()) {
            pdForm.getProposalDevelopmentDocument().defaultDocumentDescription();
        }
    }

    protected final boolean applyRules(KualiDocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    protected String getFormProperty(HttpServletRequest request, String methodToCall) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String formProperty = "";
        if (StringUtils.isNotBlank((String)parameterName)) {
            formProperty = StringUtils.substringBetween((String)parameterName, (String)("." + methodToCall), (String)".line");
        }
        return formProperty;
    }

    protected KcNotificationService getNotificationService() {
        if (this.notificationService == null) {
            this.notificationService = KraServiceLocator.getService(KcNotificationService.class);
        }
        return this.notificationService;
    }

    public void setNotificationService(KcNotificationService notificationService) {
        this.notificationService = notificationService;
    }

    private BudgetService getBudgetService() {
        return KraServiceLocator.getService(BudgetService.class);
    }

    private void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public S2SBudgetCalculatorService getS2SBudgetCalculatorService() {
        return KraServiceLocator.getService(S2SBudgetCalculatorService.class);
    }

    public void setS2SBudgetCalculatorService(S2SBudgetCalculatorService s2sBudgetCalculatorService) {
        this.s2SBudgetCalculatorService = s2sBudgetCalculatorService;
    }

    private RoleService getRoleService() {
        return KraServiceLocator.getService(RoleService.class);
    }

    private class ReasonPrompt {
        final String questionId;
        final String questionTextKey;
        final String questionType;
        final String missingReasonKey;
        final String questionCallerMapping;
        final String abortButton;
        final String noteIntroKey;

        private ReasonPrompt(String questionId, String questionTextKey, String questionType, String missingReasonKey, String questionCallerMapping, String abortButton, String noteIntroKey) {
            this.questionId = questionId;
            this.questionTextKey = questionTextKey;
            this.questionType = questionType;
            this.questionCallerMapping = questionCallerMapping;
            this.abortButton = abortButton;
            this.noteIntroKey = noteIntroKey;
            this.missingReasonKey = missingReasonKey;
        }

        public Response ask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
            String context;
            String question = request.getParameter("questionIndex");
            String reason = request.getParameter("reason");
            if (StringUtils.isBlank((String)reason) && (context = request.getParameter("context")) != null && StringUtils.contains((String)context, (String)"reason=")) {
                reason = StringUtils.substringAfter((String)context, (String)"reason=");
            }
            String disapprovalNoteText = "";
            if (question == null) {
                return new Response(question, ProposalDevelopmentAction.this.performQuestionWithInput(mapping, form, request, response, this.questionId, ProposalDevelopmentAction.this.getKualiConfigurationService().getPropertyValueAsString(this.questionTextKey), this.questionType, this.questionCallerMapping, ""));
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if (this.questionId.equals(question) && this.abortButton != null && this.abortButton.equals(buttonClicked)) {
                return new Response(question, mapping.findForward("basic"));
            }
            String introNoteMessage = "";
            if (this.noteIntroKey != null) {
                introNoteMessage = ProposalDevelopmentAction.this.getKualiConfigurationService().getPropertyValueAsString(this.noteIntroKey) + " ";
            }
            disapprovalNoteText = introNoteMessage + reason;
            boolean warnForSensitiveData = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-NS", "All", "SENSITIVE_DATA_PATTERNS_WARNING_IND");
            if (warnForSensitiveData) {
                String context2 = "reason=" + reason;
                ActionForward forward = ProposalDevelopmentAction.this.checkAndWarnAboutSensitiveData(mapping, form, request, response, "reason", disapprovalNoteText, this.questionCallerMapping, context2);
                if (forward != null) {
                    return new Response(question, forward);
                }
            } else if (KRADUtils.containsSensitiveDataPatternMatch((String)disapprovalNoteText)) {
                return new Response(question, ProposalDevelopmentAction.this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, this.questionId, ProposalDevelopmentAction.this.getKualiConfigurationService().getPropertyValueAsString(this.questionTextKey), this.questionType, this.questionCallerMapping, "", reason, "error.document.fieldContainsPossibleSensitiveData", "reason", "reason"));
            }
            int disapprovalNoteTextLength = disapprovalNoteText.length();
            int noteTextMaxLength = ProposalDevelopmentAction.this.getDataDictionaryService().getAttributeMaxLength(Note.class, "noteText");
            if (StringUtils.isBlank((String)reason) || disapprovalNoteTextLength > noteTextMaxLength) {
                if (reason == null) {
                    reason = "";
                }
                return new Response(question, ProposalDevelopmentAction.this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, this.questionId, ProposalDevelopmentAction.this.getKualiConfigurationService().getPropertyValueAsString(this.questionTextKey), this.questionType, this.questionCallerMapping, "", reason, this.missingReasonKey, "reason", Integer.toString(noteTextMaxLength)));
            }
            return new Response(question, disapprovalNoteText, buttonClicked);
        }

        private class Response {
            final String question;
            final ActionForward forward;
            final String reason;
            final String button;

            Response(String question, ActionForward forward) {
                this(question, forward, null, null);
            }

            Response(String question, String reason, String button) {
                this(question, null, reason, button);
            }

            private Response(String question, ActionForward forward, String reason, String button) {
                this.question = question;
                this.forward = forward;
                this.reason = reason;
                this.button = button;
            }
        }
    }

    public class LabelComparator
    implements Comparator {
        public int compare(Object cad1, Object cad2) {
            try {
                String label1 = ((CustomAttributeDocument)((Object)cad1)).getCustomAttribute().getLabel();
                String label2 = ((CustomAttributeDocument)((Object)cad2)).getCustomAttribute().getLabel();
                if (label1 == null) {
                    label1 = "";
                }
                if (label2 == null) {
                    label2 = "";
                }
                return label1.compareTo(label2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

