/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web.struts.action;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarchyException;
import org.kuali.kra.proposaldevelopment.web.struts.action.ProposalDevelopmentAction;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.bo.S2sOppForms;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.s2s.service.S2SService;
import org.kuali.kra.s2s.service.impl.PrintServiceImpl;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentGrantsGovAction
extends ProposalDevelopmentAction {
    private static final String CONFIRM_REMOVE_OPPRTUNITY_KEY = "confirmRemoveOpportunity";
    private static final String EMPTY_STRING = "";
    private static final Log LOG = LogFactory.getLog(PrintServiceImpl.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)proposalDevelopmentForm.getDocument();
        if (proposalDevelopmentDocument.getDevelopmentProposal().isChild()) {
            throw new ProposalHierarchyException("Cannot perform Grants.gov tasks on a Proposal Hierarchy child");
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity() != null) {
            proposalDevelopmentForm.setGrantsGovSelectFlag(true);
            if (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getProposalNumber() == null) {
                proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().setProposalNumber(proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber());
            }
            if (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getOpportunityId() != null) {
                proposalDevelopmentDocument.getDevelopmentProposal().setProgramAnnouncementNumber(proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getOpportunityId());
            }
            if (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle() != null) {
                proposalDevelopmentDocument.getDevelopmentProposal().setProgramAnnouncementTitle(proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle());
            }
            if (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getCfdaNumber() != null) {
                proposalDevelopmentDocument.getDevelopmentProposal().setCfdaNumber(proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getCfdaNumber());
            }
        }
        ActionForward actionForward = super.execute(mapping, form, request, response);
        return actionForward;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        Boolean mandatoryFormNotAvailable = false;
        List<Object> s2sOppForms = new ArrayList();
        if (proposalDevelopmentForm.getNewS2sOpportunity() != null && StringUtils.isNotEmpty((String)proposalDevelopmentForm.getNewS2sOpportunity().getOpportunityId())) {
            proposalDevelopmentDocument.getDevelopmentProposal().setS2sOpportunity(proposalDevelopmentForm.getNewS2sOpportunity());
            proposalDevelopmentForm.setNewS2sOpportunity(new S2sOpportunity());
        }
        S2sOpportunity s2sOpportunity = proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity();
        try {
            if (s2sOpportunity != null && s2sOpportunity.getSchemaUrl() != null) {
                s2sOppForms = KraServiceLocator.getService(S2SService.class).parseOpportunityForms(s2sOpportunity);
                if (s2sOppForms != null) {
                    for (S2sOppForms s2sOppForm : s2sOppForms) {
                        if (!s2sOppForm.getMandatory().booleanValue() || s2sOppForm.getAvailable().booleanValue()) continue;
                        mandatoryFormNotAvailable = true;
                        break;
                    }
                }
                if (!mandatoryFormNotAvailable.booleanValue()) {
                    s2sOpportunity.setS2sOppForms(s2sOppForms);
                    s2sOpportunity.setVersionNumber(proposalDevelopmentForm.getVersionNumberForS2sOpportunity());
                    proposalDevelopmentForm.setVersionNumberForS2sOpportunity(null);
                } else {
                    GlobalVariables.getMessageMap().putError("noField", "error.s2sopportunity.opportunityIdInvalid", new String[]{proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getOpportunityId()});
                    proposalDevelopmentDocument.getDevelopmentProposal().setS2sOpportunity(new S2sOpportunity());
                }
            }
        }
        catch (S2SException ex) {
            if (ex.getErrorKey().equals("error.grantsgov.no.form.element")) {
                ex.setMessage(s2sOpportunity.getOpportunityId());
            }
            GlobalVariables.getMessageMap().putError("noField", ex.getErrorKey(), ex.getMessageWithParams());
            proposalDevelopmentDocument.getDevelopmentProposal().setS2sOpportunity(new S2sOpportunity());
            return mapping.findForward("basic");
        }
        return mapping.findForward("basic");
    }

    public ActionForward confirmRemoveOpportunity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_REMOVE_OPPRTUNITY_KEY.equals(question)) {
            ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
            ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)proposalDevelopmentForm.getDocument();
            proposalDevelopmentForm.setVersionNumberForS2sOpportunity(proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getVersionNumber());
            proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().setS2sOppForms(null);
            proposalDevelopmentDocument.getDevelopmentProposal().setS2sOpportunity(null);
            proposalDevelopmentDocument.getDevelopmentProposal().setProgramAnnouncementNumber(null);
            proposalDevelopmentDocument.getDevelopmentProposal().setProgramAnnouncementTitle(null);
            proposalDevelopmentDocument.getDevelopmentProposal().setCfdaNumber(null);
        }
        return mapping.findForward("basic");
    }

    public ActionForward removeOpportunity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildDeleteOpportunityConfirmationQuestion(mapping, form, request, response), CONFIRM_REMOVE_OPPRTUNITY_KEY, EMPTY_STRING);
    }

    private StrutsConfirmation buildDeleteOpportunityConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)proposalDevelopmentForm.getDocument();
        String description = proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getOpportunityId();
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_REMOVE_OPPRTUNITY_KEY, "document.question.deleteOpportunity.text", description);
    }

    @Override
    public ActionForward printForms(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.printForms(mapping, form, request, response);
    }

    public ActionForward refreshSubmissionDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)proposalDevelopmentForm.getDocument();
        try {
            if (KraServiceLocator.getService(S2SService.class).refreshGrantsGov(proposalDevelopmentDocument)) {
                proposalDevelopmentDocument.getDevelopmentProposal().refreshReferenceObject("s2sAppSubmission");
                return mapping.findForward("basic");
            }
            throw new RuntimeException("Refresh Failed");
        }
        catch (S2SException ex) {
            GlobalVariables.getMessageMap().putError("noField", ex.getErrorKey(), new String[]{ex.getMessage()});
            return mapping.findForward("basic");
        }
    }

    public ActionForward performLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)proposalDevelopmentForm.getDocument();
        if (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity() != null && proposalDevelopmentForm.getVersionNumberForS2sOpportunity() == null) {
            proposalDevelopmentForm.setVersionNumberForS2sOpportunity(proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getVersionNumber());
        }
        return super.performLookup(mapping, form, request, response);
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        if (!((ProposalDevelopmentForm)form).isGrantsGovEnabled()) {
            GlobalVariables.getMessageMap().putWarning("noField", "error.grantsgov.disabled", new String[0]);
            return mapping.findForward("basic");
        }
        String proposalTypeCodeRevision = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.revision");
        if (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity() != null && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getOpportunityId() != null && StringUtils.equalsIgnoreCase((String)proposalDevelopmentDocument.getDevelopmentProposal().getProposalTypeCode(), (String)proposalTypeCodeRevision) && StringUtils.isBlank((String)proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionCode())) {
            GlobalVariables.getMessageMap().putError("document.developmentProposalList[0].s2sOpportunity.revisionCode", "error.required.s2sopportunity.revisionType", new String[0]);
            return mapping.findForward("basic");
        }
        return super.save(mapping, form, request, response);
    }

    public ActionForward saveXml(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)proposalDevelopmentForm.getDocument();
        proposalDevelopmentDocument.getDevelopmentProposal().setGrantsGovSelectFlag(true);
        proposalDevelopmentForm.setDocument((Document)proposalDevelopmentDocument);
        return super.printForms(mapping, (ActionForm)proposalDevelopmentForm, request, response);
    }
}

