/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web.struts.action;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.ScienceKeyword;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.CongressionalDistrict;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.PropScienceKeyword;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonComparator;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.event.AddProposalCongressionalDistrictEvent;
import org.kuali.kra.proposaldevelopment.rule.event.AddProposalSiteEvent;
import org.kuali.kra.proposaldevelopment.rule.event.BasicProposalSiteEvent;
import org.kuali.kra.proposaldevelopment.rule.event.DeleteProposalCongressionalDistrictEvent;
import org.kuali.kra.proposaldevelopment.rule.event.SaveProposalSitesEvent;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.proposaldevelopment.web.struts.action.ProposalDevelopmentAction;
import org.kuali.kra.proposaldevelopment.web.struts.form.CongressionalDistrictHelper;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentProposalAction
extends ProposalDevelopmentAction {
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentProposalAction.class);
    private static final String CONFIRM_DELETE_PROPOSAL_SITE_KEY = "confirmDeleteProposalSite";
    private static final String CONFIRM_DELETE_CONG_DISTRICT_KEY = "confirmDeleteCongDistrict";
    private static final String CONFIRM_CLEAR_DELIVERY_INFO_ADDRESS_KEY = "confirmClearDeliveryInfoAddress";

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setKeywordsPanelFlag(request);
        ProposalDevelopmentDocument proposalDevelopmentDocument = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument();
        KraServiceLocator.getService(ProposalDevelopmentService.class).initializeUnitOrganizationLocation(proposalDevelopmentDocument);
        KraServiceLocator.getService(ProposalDevelopmentService.class).initializeProposalSiteNumbers(proposalDevelopmentDocument);
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        if (!proposalDevelopmentForm.isGrantsGovEnabled() && proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().getS2sOpportunity() != null) {
            proposalDevelopmentForm.setVersionNumberForS2sOpportunity(proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getVersionNumber());
            proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().setS2sOppForms(null);
            proposalDevelopmentDocument.getDevelopmentProposal().setS2sOpportunity(null);
            proposalDevelopmentDocument.getDevelopmentProposal().setProgramAnnouncementNumber(null);
            proposalDevelopmentDocument.getDevelopmentProposal().setProgramAnnouncementTitle(null);
        }
        SaveProposalSitesEvent ruleEvent = new SaveProposalSitesEvent("document.developmentProposal", proposalDevelopmentDocument);
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)ruleEvent)) {
            return super.save(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward saveOnClose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.saveOnClose(mapping, form, request, response);
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument doc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        KraServiceLocator.getService(ProposalDevelopmentService.class).initializeUnitOrganizationLocation(doc);
        KraServiceLocator.getService(ProposalDevelopmentService.class).initializeProposalSiteNumbers(doc);
        return forward;
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String primeSponsorCode;
        ActionForward actionForward = super.execute(mapping, form, request, response);
        this.setKeywordsPanelFlag(request);
        ProposalDevelopmentDocument proposalDevelopmentDocument = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument();
        if (proposalDevelopmentDocument.getDevelopmentProposal().getApplicantOrganization() != null && proposalDevelopmentDocument.getDevelopmentProposal().getProposalSites().size() == 0 && StringUtils.isNotBlank((String)request.getParameter("methodToCall")) && request.getParameter("methodToCall").toString().equals("refresh") && StringUtils.isNotBlank((String)request.getParameter("refreshCaller")) && request.getParameter("refreshCaller").toString().equals("kualiLookupable") && StringUtils.isNotBlank((String)request.getParameter("document.organizationId"))) {
            ProposalSite propSite = new ProposalSite();
            propSite.setLocationName(proposalDevelopmentDocument.getDevelopmentProposal().getApplicantOrganization().getLocationName());
            propSite.setSiteNumber(proposalDevelopmentDocument.getDocumentNextValue("proposalDevelopment.proposalLocation.locationSequenceNumber"));
            proposalDevelopmentDocument.getDevelopmentProposal().addPerformanceSite(propSite);
        }
        if (StringUtils.isNotEmpty((String)(primeSponsorCode = proposalDevelopmentDocument.getDevelopmentProposal().getPrimeSponsorCode()))) {
            String primeSponsorName = this.getSponsorService().getSponsorName(primeSponsorCode);
            if (StringUtils.isEmpty((String)primeSponsorName)) {
                primeSponsorName = "not found";
            }
            ((ProposalDevelopmentForm)form).setPrimeSponsorName(primeSponsorName);
        } else {
            ((ProposalDevelopmentForm)form).setPrimeSponsorName(null);
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().getProposalPersons().size() > 0) {
            Collections.sort(proposalDevelopmentDocument.getDevelopmentProposal().getProposalPersons(), new ProposalPersonComparator());
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().getInvestigators().size() > 0) {
            Collections.sort(proposalDevelopmentDocument.getDevelopmentProposal().getInvestigators(), new ProposalPersonComparator());
        }
        this.updateNIHDescriptions(proposalDevelopmentDocument);
        return actionForward;
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.route(mapping, form, request, response);
    }

    @Override
    protected SponsorService getSponsorService() {
        return KraServiceLocator.getService(SponsorService.class);
    }

    private void setKeywordsPanelFlag(HttpServletRequest request) {
        String keywordPanelDisplay = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.displayKeywordPanel");
        request.getSession().setAttribute("proposaldevelopment.displayKeywordPanel", (Object)keywordPanelDisplay);
    }

    public ActionForward addOtherOrganization(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ProposalSite newOtherOrganization = proposalDevelopmentForm.getNewOtherOrganization();
        newOtherOrganization.setLocationTypeCode(3);
        if (this.checkAndInitNewLocation("newOtherOrganization", proposalDevelopmentDocument, newOtherOrganization)) {
            proposalDevelopmentDocument.getDevelopmentProposal().addOtherOrganization(newOtherOrganization);
            proposalDevelopmentForm.setNewOtherOrganization(new ProposalSite());
        }
        return mapping.findForward("basic");
    }

    public ActionForward addPerformanceSite(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ProposalSite newPerformanceSite = proposalDevelopmentForm.getNewPerformanceSite();
        newPerformanceSite.setLocationTypeCode(4);
        if (this.checkAndInitNewLocation("newPerformanceSite", proposalDevelopmentDocument, newPerformanceSite)) {
            proposalDevelopmentDocument.getDevelopmentProposal().addPerformanceSite(newPerformanceSite);
            proposalDevelopmentForm.setNewPerformanceSite(new ProposalSite());
        }
        return mapping.findForward("basic");
    }

    private boolean checkAndInitNewLocation(String errorPathPrefix, ProposalDevelopmentDocument proposalDevelopmentDocument, ProposalSite newProposalSite) {
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new AddProposalSiteEvent(errorPathPrefix, proposalDevelopmentDocument, newProposalSite))) {
            newProposalSite.initializeDefaultCongressionalDistrict();
            newProposalSite.setSiteNumber(proposalDevelopmentDocument.getDocumentNextValue("proposalDevelopment.proposalLocation.locationSequenceNumber"));
            return true;
        }
        return false;
    }

    public ActionForward clearPerformanceSiteAddress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int siteIndex;
        ProposalDevelopmentDocument proposalDevelopmentDocument = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument();
        BasicProposalSiteEvent clearEvent = new BasicProposalSiteEvent("", proposalDevelopmentDocument);
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)clearEvent) && (siteIndex = this.getSiteIndexForConfirmation(form, request)) >= 0) {
            proposalDevelopmentDocument.getDevelopmentProposal().clearPerformanceSiteAddress(siteIndex);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deletePerformanceSite(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.deleteProposalSite(mapping, form, request, response, "confirmDeletePerformanceSite", "Performance Site");
    }

    public ActionForward deleteOtherOrganization(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.deleteProposalSite(mapping, form, request, response, "confirmDeleteOtherOrganization", "Organization");
    }

    public ActionForward deleteProposalSite(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String yesMethodName, String locationTypeName) throws Exception {
        ProposalDevelopmentDocument proposalDevelopmentDocument = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument();
        BasicProposalSiteEvent deleteEvent = new BasicProposalSiteEvent("", proposalDevelopmentDocument);
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)deleteEvent)) {
            StrutsConfirmation deleteConfirmation = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_PROPOSAL_SITE_KEY, "document.question.delete.text", "this " + locationTypeName);
            return this.confirm(deleteConfirmation, yesMethodName, "");
        }
        return mapping.findForward("basic");
    }

    public ActionForward confirmDeletePerformanceSite(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int siteIndex = this.getSiteIndexForConfirmation(form, request, CONFIRM_DELETE_PROPOSAL_SITE_KEY);
        if (siteIndex >= 0) {
            ProposalDevelopmentDocument proposalDevelopmentDocument = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument();
            proposalDevelopmentDocument.getDevelopmentProposal().removePerformanceSite(siteIndex);
        }
        return mapping.findForward("basic");
    }

    public ActionForward confirmDeleteOtherOrganization(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int siteIndex = this.getSiteIndexForConfirmation(form, request, CONFIRM_DELETE_PROPOSAL_SITE_KEY);
        if (siteIndex >= 0) {
            ProposalDevelopmentDocument proposalDevelopmentDocument = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument();
            proposalDevelopmentDocument.getDevelopmentProposal().removeOtherOrganization(siteIndex);
        }
        return mapping.findForward("basic");
    }

    private int getSiteIndexForConfirmation(ActionForm form, HttpServletRequest request, String confirmationKey) {
        int siteIndex = -1;
        String question = request.getParameter("questionIndex");
        if (confirmationKey.equals(question)) {
            return this.getSiteIndexForConfirmation(form, request);
        }
        return siteIndex;
    }

    private int getSiteIndexForConfirmation(ActionForm form, HttpServletRequest request) {
        int siteIndex = -1;
        ProposalDevelopmentDocument proposalDevelopmentDocument = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument();
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new BasicProposalSiteEvent("", proposalDevelopmentDocument))) {
            String siteIndexStr = this.getSiteIndex(request);
            siteIndex = new Integer(siteIndexStr);
        }
        return siteIndex;
    }

    public ActionForward confirmDeleteProposalSite(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_PROPOSAL_SITE_KEY.equals(question)) {
            ProposalDevelopmentDocument proposalDevelopmentDocument = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument();
            if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new BasicProposalSiteEvent("", proposalDevelopmentDocument))) {
                String siteIndexStr = this.getSiteIndex(request);
                int siteIndex = new Integer(siteIndexStr);
                proposalDevelopmentDocument.getDevelopmentProposal().removePerformanceSite(siteIndex);
            }
        }
        return mapping.findForward("basic");
    }

    private boolean isDuplicateKeyword(String newScienceKeywordCode, List<PropScienceKeyword> keywords) {
        for (PropScienceKeyword propScienceKeyword : keywords) {
            String scienceKeywordCode = propScienceKeyword.getScienceKeywordCode();
            if (!scienceKeywordCode.equalsIgnoreCase(newScienceKeywordCode)) continue;
            return true;
        }
        return false;
    }

    public ActionForward selectAllScienceKeyword(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        List<PropScienceKeyword> keywords = proposalDevelopmentDocument.getDevelopmentProposal().getPropScienceKeywords();
        for (PropScienceKeyword propScienceKeyword : keywords) {
            propScienceKeyword.setSelectKeyword(true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteSelectedScienceKeyword(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        List<PropScienceKeyword> keywords = proposalDevelopmentDocument.getDevelopmentProposal().getPropScienceKeywords();
        ListIterator<PropScienceKeyword> iter = keywords.listIterator();
        while (iter.hasNext()) {
            PropScienceKeyword propScienceKeyword = iter.next();
            if (!propScienceKeyword.getSelectKeyword().booleanValue()) continue;
            iter.remove();
        }
        return mapping.findForward("basic");
    }

    public ActionForward addApplicantOrgCongDistrict(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ProposalSite applicantOrganization = proposalDevelopmentDocument.getDevelopmentProposal().getApplicantOrganization();
        CongressionalDistrictHelper applicantOrganizationHelper = proposalDevelopmentForm.getApplicantOrganizationHelper();
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new AddProposalCongressionalDistrictEvent("applicantOrganizationHelper", proposalDevelopmentDocument, applicantOrganization, applicantOrganizationHelper))) {
            return this.addCongressionalDistrict(mapping, applicantOrganization, applicantOrganizationHelper);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addPerformingOrgCongDistrict(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ProposalSite performingOrganization = proposalDevelopmentDocument.getDevelopmentProposal().getPerformingOrganization();
        CongressionalDistrictHelper performingOrganizationHelper = proposalDevelopmentForm.getPerformingOrganizationHelper();
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new AddProposalCongressionalDistrictEvent("performingOrganizationHelper", proposalDevelopmentDocument, performingOrganization, performingOrganizationHelper))) {
            return this.addCongressionalDistrict(mapping, performingOrganization, performingOrganizationHelper);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addPerformanceSiteCongDistrict(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        List<ProposalSite> performanceSites = proposalDevelopmentDocument.getDevelopmentProposal().getPerformanceSites();
        List<CongressionalDistrictHelper> proposalSiteHelpers = proposalDevelopmentForm.getPerformanceSiteHelpers();
        String siteIndexStr = this.getSiteIndex(request);
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new AddProposalCongressionalDistrictEvent("performanceSiteHelpers[" + siteIndexStr + "]", proposalDevelopmentDocument, performanceSites, proposalSiteHelpers, siteIndexStr))) {
            return this.addCongressionalDistrict(mapping, performanceSites, proposalSiteHelpers, siteIndexStr);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addOtherOrgCongDistrict(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        List<ProposalSite> otherOrganizations = proposalDevelopmentDocument.getDevelopmentProposal().getOtherOrganizations();
        List<CongressionalDistrictHelper> otherOrganizationHelpers = proposalDevelopmentForm.getOtherOrganizationHelpers();
        String siteIndexStr = this.getSiteIndex(request);
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new AddProposalCongressionalDistrictEvent("otherOrganizationHelpers[" + siteIndexStr + "]", proposalDevelopmentDocument, otherOrganizations, otherOrganizationHelpers, siteIndexStr))) {
            return this.addCongressionalDistrict(mapping, otherOrganizations, otherOrganizationHelpers, siteIndexStr);
        }
        return mapping.findForward("basic");
    }

    private ActionForward addCongressionalDistrict(ActionMapping mapping, ProposalSite proposalSite, CongressionalDistrictHelper proposalSiteHelper) {
        String stateCode = proposalSiteHelper.getNewState();
        String districtNumber = proposalSiteHelper.getNewDistrictNumber();
        CongressionalDistrict newDistrict = new CongressionalDistrict();
        newDistrict.setCongressionalDistrict(stateCode, districtNumber);
        proposalSite.addCongressionalDistrict(newDistrict);
        proposalSiteHelper.setNewDistrictNumber("");
        proposalSiteHelper.setNewState("");
        return mapping.findForward("basic");
    }

    private ActionForward addCongressionalDistrict(ActionMapping mapping, List<ProposalSite> proposalSites, List<CongressionalDistrictHelper> proposalSiteHelpers, String siteIndexStr) {
        int siteIndex = new Integer(siteIndexStr);
        return this.addCongressionalDistrict(mapping, proposalSites.get(siteIndex), proposalSiteHelpers.get(siteIndex));
    }

    private String getDistrictIndex(HttpServletRequest request) {
        return this.getMethodToCallParameter(request, "district");
    }

    private String getSiteIndex(HttpServletRequest request) {
        return this.getMethodToCallParameter(request, "site");
    }

    private String getMethodToCallParameter(HttpServletRequest request, String parameterName) {
        String methodToCallAttribute = (String)request.getAttribute("methodToCallAttribute");
        return StringUtils.substringBetween((String)methodToCallAttribute, (String)("." + parameterName), (String)".");
    }

    public ActionForward deleteApplicantOrgCongDistrict(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.deleteCongressionalDistrict(mapping, form, request, response, "confirmDeleteApplicantOrgCongDistrict");
    }

    public ActionForward confirmDeleteApplicantOrgCongDistrict(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ProposalSite applicantOrganization = proposalDevelopmentDocument.getDevelopmentProposal().getApplicantOrganization();
        String districtIndexStr = this.getDistrictIndex(request);
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new DeleteProposalCongressionalDistrictEvent("", proposalDevelopmentDocument, applicantOrganization, districtIndexStr))) {
            return this.deleteCongressionalDistrict(mapping, applicantOrganization, request, proposalDevelopmentForm);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deletePerformingOrgCongDistrict(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.deleteCongressionalDistrict(mapping, form, request, response, "confirmDeletePerformingOrgCongDistrict");
    }

    public ActionForward confirmDeletePerformingOrgCongDistrict(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ProposalSite performingOrganization = proposalDevelopmentDocument.getDevelopmentProposal().getPerformingOrganization();
        String districtIndexStr = this.getDistrictIndex(request);
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new DeleteProposalCongressionalDistrictEvent("", proposalDevelopmentDocument, performingOrganization, districtIndexStr))) {
            return this.deleteCongressionalDistrict(mapping, performingOrganization, request, proposalDevelopmentForm);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deletePerformanceSiteCongDistrict(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.deleteCongressionalDistrict(mapping, form, request, response, "confirmDeletePerformanceSiteCongDistrict");
    }

    public ActionForward confirmDeletePerformanceSiteCongDistrict(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        List<ProposalSite> performanceSites = proposalDevelopmentDocument.getDevelopmentProposal().getPerformanceSites();
        String siteIndexStr = this.getSiteIndex(request);
        String districtIndexStr = this.getDistrictIndex(request);
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new DeleteProposalCongressionalDistrictEvent("", proposalDevelopmentDocument, performanceSites, siteIndexStr, districtIndexStr))) {
            return this.deleteCongressionalDistrict(mapping, performanceSites, proposalDevelopmentForm, siteIndexStr, districtIndexStr);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteOtherOrgCongDistrict(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.deleteCongressionalDistrict(mapping, form, request, response, "confirmDeleteOtherOrgCongDistrict");
    }

    public ActionForward confirmDeleteOtherOrgCongDistrict(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        List<ProposalSite> otherOrganizations = proposalDevelopmentDocument.getDevelopmentProposal().getOtherOrganizations();
        String siteIndexStr = this.getSiteIndex(request);
        String districtIndexStr = this.getDistrictIndex(request);
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new DeleteProposalCongressionalDistrictEvent("", proposalDevelopmentDocument, otherOrganizations, siteIndexStr, districtIndexStr))) {
            return this.deleteCongressionalDistrict(mapping, otherOrganizations, proposalDevelopmentForm, siteIndexStr, districtIndexStr);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteCongressionalDistrict(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String yesMethodName) throws Exception {
        ProposalDevelopmentDocument proposalDevelopmentDocument = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument();
        BasicProposalSiteEvent deleteEvent = new BasicProposalSiteEvent("", proposalDevelopmentDocument);
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)deleteEvent)) {
            StrutsConfirmation deleteConfirmation = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_CONG_DISTRICT_KEY, "document.question.delete.text", "this Congressional District");
            return this.confirm(deleteConfirmation, yesMethodName, "");
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteCongressionalDistrict(ActionMapping mapping, List<ProposalSite> proposalSites, ProposalDevelopmentForm proposalDevelopmentForm, String siteIndexStr, String districtIndexStr) {
        int siteIndex = new Integer(siteIndexStr);
        int districtIndex = new Integer(districtIndexStr);
        ProposalSite proposalSite = proposalSites.get(siteIndex);
        proposalSite.deleteCongressionalDistrict(districtIndex);
        return mapping.findForward("basic");
    }

    private ActionForward deleteCongressionalDistrict(ActionMapping mapping, ProposalSite proposalSite, HttpServletRequest request, ProposalDevelopmentForm proposalDevelopmentForm) {
        String districtIndexStr = this.getDistrictIndex(request);
        int districtIndex = new Integer(districtIndexStr);
        proposalSite.deleteCongressionalDistrict(districtIndex);
        return mapping.findForward("basic");
    }

    public ActionForward clearApplicantOrganization(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        proposalDevelopmentDocument.getDevelopmentProposal().setApplicantOrganization(new ProposalSite());
        return mapping.findForward("basic");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String lookupResultsSequenceNumber;
        super.refresh(mapping, form, request, response);
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        DevelopmentProposal developmentProposal = proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal();
        String performingOrganizationId = developmentProposal.getPerformingOrganization().getOrganizationId();
        if (StringUtils.isEmpty((String)performingOrganizationId)) {
            String applicationOrganizationId = developmentProposal.getApplicantOrganization().getOrganizationId();
            ProposalSite performingOrganization = developmentProposal.getPerformingOrganization();
            performingOrganization.setOrganizationId(applicationOrganizationId);
        }
        for (ProposalSite proposalSite : developmentProposal.getProposalSites()) {
            proposalSite.refreshReferenceObject("rolodex");
            proposalSite.refreshReferenceObject("organization");
        }
        proposalDevelopmentForm.getNewPerformanceSite().refreshReferenceObject("rolodex");
        proposalDevelopmentForm.getNewOtherOrganization().refreshReferenceObject("organization");
        if ("multipleValues".equals(proposalDevelopmentForm.getRefreshCaller()) && StringUtils.isNotBlank((String)(lookupResultsSequenceNumber = proposalDevelopmentForm.getLookupResultsSequenceNumber()))) {
            Class<ScienceKeyword> lookupResultsBOClass = Class.forName(proposalDevelopmentForm.getLookupResultsBOClassName());
            Collection rawValues = KNSServiceLocator.getLookupResultsService().retrieveSelectedResultBOs(lookupResultsSequenceNumber, lookupResultsBOClass, GlobalVariables.getUserSession().getPrincipalId());
            if (lookupResultsBOClass.isAssignableFrom(ScienceKeyword.class)) {
                for (ScienceKeyword scienceKeyword : rawValues) {
                    PropScienceKeyword propScienceKeyword = new PropScienceKeyword(developmentProposal.getProposalNumber(), scienceKeyword);
                    if (this.isDuplicateKeyword(propScienceKeyword.getScienceKeywordCode(), developmentProposal.getPropScienceKeywords())) continue;
                    developmentProposal.addPropScienceKeyword(propScienceKeyword);
                }
            }
        }
        return mapping.findForward("basic");
    }

    protected KualiRuleService getKualiRuleService() {
        return KraServiceLocator.getService(KualiRuleService.class);
    }

    @Override
    public ActionForward headerTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        String command = request.getParameter("command");
        String docId = request.getParameter("docId");
        if (StringUtils.isNotEmpty((String)command) && command.equals("displayDocSearchView") && StringUtils.isNotEmpty((String)docId)) {
            Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docId);
            pdform.setDocument(retrievedDocument);
        }
        return super.headerTab(mapping, form, request, response);
    }

    public ActionForward clearMailingNameAddress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentDocument proposalDevelopmentDocument = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument();
        BasicProposalSiteEvent deleteEvent = new BasicProposalSiteEvent("", proposalDevelopmentDocument);
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)deleteEvent)) {
            StrutsConfirmation deleteConfirmation = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_CLEAR_DELIVERY_INFO_ADDRESS_KEY, "document.question.clearDeliveryAddress.text", "");
            return this.confirm(deleteConfirmation, "confirmClearMailingNameAddress", "");
        }
        return mapping.findForward("basic");
    }

    public ActionForward confirmClearMailingNameAddress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        DevelopmentProposal developmentProposal = proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal();
        if (developmentProposal.getRolodex() != null) {
            developmentProposal.setRolodex(null);
            developmentProposal.setMailingAddressId(null);
        }
        return mapping.findForward("basic");
    }
}

