/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web.struts.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.bo.CitizenshipType;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.SponsorFormTemplateList;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.common.notification.web.struts.form.NotificationHelper;
import org.kuali.kra.common.permissions.web.bean.Role;
import org.kuali.kra.common.web.struts.form.ReportHelperBean;
import org.kuali.kra.common.web.struts.form.ReportHelperBeanContainer;
import org.kuali.kra.infrastructure.Constants;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.kim.service.ProposalRoleService;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.medusa.MedusaBean;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeType;
import org.kuali.kra.proposaldevelopment.bo.NarrativeUserRights;
import org.kuali.kra.proposaldevelopment.bo.PropScienceKeyword;
import org.kuali.kra.proposaldevelopment.bo.ProposalAbstract;
import org.kuali.kra.proposaldevelopment.bo.ProposalAssignedRole;
import org.kuali.kra.proposaldevelopment.bo.ProposalChangedData;
import org.kuali.kra.proposaldevelopment.bo.ProposalCopyCriteria;
import org.kuali.kra.proposaldevelopment.bo.ProposalDevelopmentApproverViewDO;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonDegree;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.bo.ProposalState;
import org.kuali.kra.proposaldevelopment.bo.ProposalUser;
import org.kuali.kra.proposaldevelopment.bo.ProposalUserEditRoles;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetChangedData;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.document.authorization.ProposalTask;
import org.kuali.kra.proposaldevelopment.hierarchy.bo.HierarchyProposalSummary;
import org.kuali.kra.proposaldevelopment.notification.ProposalDevelopmentNotificationContext;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalDevelopmentQuestionnaireHelper;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalDevelopmentS2sQuestionnaireHelper;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalPersonQuestionnaireHelper;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.proposaldevelopment.specialreview.SpecialReviewHelper;
import org.kuali.kra.proposaldevelopment.web.bean.ProposalDevelopmentRejectionBean;
import org.kuali.kra.proposaldevelopment.web.bean.ProposalUserRoles;
import org.kuali.kra.proposaldevelopment.web.struts.form.CongressionalDistrictHelper;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentCustomDataHelper;
import org.kuali.kra.questionnaire.MultiQuestionableFormInterface;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.s2s.bo.S2sAppSubmission;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.service.UnitService;
import org.kuali.kra.web.struts.form.BudgetVersionFormBase;
import org.kuali.kra.web.struts.form.CustomDataDocumentForm;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.permission.PermissionQueryResults;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kns.datadictionary.HeaderNavigation;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.util.ActionFormUtilMap;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class ProposalDevelopmentForm
extends BudgetVersionFormBase
implements ReportHelperBeanContainer,
MultiQuestionableFormInterface,
CustomDataDocumentForm {
    private static final long serialVersionUID = 7928293162992415894L;
    private static final String MISSING_PARAM_MSG = "Couldn't find parameter ";
    private boolean creditSplitEnabled;
    private String primeSponsorName;
    private ProposalPerson newProposalPerson;
    private List<ProposalPersonDegree> newProposalPersonDegree;
    private List<Unit> newProposalPersonUnit;
    private String newRolodexId;
    private String newPersonId;
    private Narrative newNarrative;
    private FormFile narrativeFile;
    private boolean showMaintenanceLinks;
    private ProposalAbstract newProposalAbstract;
    private ProposalPersonBiography newPropPersonBio;
    private Narrative newInstituteAttachment;
    private boolean grantsGovAuditActivated;
    private ProposalCopyCriteria copyCriteria;
    private Map<String, Parameter> proposalDevelopmentParameters;
    private ProposalUser newProposalUser;
    private String newBudgetVersionName;
    private List<ProposalUserRoles> proposalUserRolesList = null;
    private ProposalUserEditRoles proposalUserEditRoles;
    private boolean newProposalPersonRoleRendered;
    private List<NarrativeUserRights> newNarrativeUserRights;
    private S2sOpportunity newS2sOpportunity;
    private List<S2sAppSubmission> newS2sAppSubmission;
    private SortedMap<String, List<CustomAttributeDocument>> customAttributeGroups;
    private Map<String, String[]> customAttributeValues;
    private List<Narrative> narratives;
    private boolean saveAfterCopy;
    private String optInUnitDetails;
    private String optInCertificationStatus;
    private ProposalChangedData newProposalChangedData;
    private Long versionNumberForS2sOpportunity;
    private ProposalSite newPerformanceSite;
    private ProposalSite newOtherOrganization;
    private ProposalDevelopmentApproverViewDO approverViewDO;
    private CongressionalDistrictHelper applicantOrganizationHelper;
    private CongressionalDistrictHelper performingOrganizationHelper;
    private List<CongressionalDistrictHelper> performanceSiteHelpers;
    private List<CongressionalDistrictHelper> otherOrganizationHelpers;
    private SpecialReviewHelper specialReviewHelper;
    private String newHierarchyProposalNumber;
    private String newHierarchyChildProposalNumber;
    private String newHierarchyBudgetTypeCode;
    private List<HierarchyProposalSummary> hierarchyProposalSummaries;
    private DevelopmentProposal proposalToSummarize;
    private HierarchyProposalSummary proposalSummary;
    private Budget budgetToSummarize;
    private String proposalNumberToSummarize;
    private String budgetNumberToSummarize;
    private transient boolean showSubmissionDetails;
    private transient boolean grantsGovSubmitFlag;
    private transient boolean saveXmlPermission;
    private transient boolean grantsGovSelectFlag;
    private String proposalFormTabTitle = "Print Sponsor Form Packages ";
    private transient ParameterService parameterService;
    private List<SponsorFormTemplateList> sponsorFormTemplates;
    private transient KcPersonService kcPersonService;
    private String resubmissionOption;
    private String institutionalProposalToVersion;
    private MedusaBean medusaBean;
    private ReportHelperBean reportHelperBean;
    private List<String> proposalDataOverrideMethodToCalls;
    private List<String> BudgetDataOverrideMethodToCalls;
    private boolean canCreateProposal;
    private boolean viewFundingSource;
    private ProposalDevelopmentRejectionBean proposalDevelopmentRejectionBean;
    private boolean showRejectionConfirmation;
    private NotificationHelper<ProposalDevelopmentNotificationContext> notificationHelper;
    private ProposalDevelopmentQuestionnaireHelper proposalDevelopmentQuestionnaireHelper;
    private ProposalDevelopmentS2sQuestionnaireHelper proposalDevelopmentS2sQuestionnaireHelper;
    private List<ProposalPersonQuestionnaireHelper> proposalPersonQuestionnaireHelpers;
    private List<AnswerHeader> answerHeadersToDelete;
    private List<ProposalPerson> proposalPersonsToDelete;
    private transient S2sOpportunity s2sOpportunity;
    private BudgetChangedData newBudgetChangedData;
    private String[] selectedBudgetPrint;
    private static final String PROPOSAL_SUMMARY_TAB_INDICATOR = "enableProposalSummaryTab";
    private transient String currentPersonCountryCode = "";
    private ProposalDevelopmentCustomDataHelper customDataHelper;

    public ProposalDevelopmentForm() {
        this.initialize();
        this.sponsorFormTemplates = new ArrayList<SponsorFormTemplateList>();
    }

    @Override
    protected String getDefaultDocumentTypeName() {
        return "ProposalDevelopmentDocument";
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void initialize() {
        this.setNewNarrative(this.createNarrative());
        this.setNewProposalPerson(new ProposalPerson());
        this.setNewProposalPersonDegree(new ArrayList<ProposalPersonDegree>());
        this.setNewProposalPersonUnit(new ArrayList<Unit>());
        this.setNewProposalAbstract(new ProposalAbstract());
        this.setNewProposalUser(new ProposalUser());
        this.setNewS2sOpportunity(new S2sOpportunity());
        this.setNewPerformanceSite(new ProposalSite());
        this.setNewOtherOrganization(new ProposalSite());
        this.setApplicantOrganizationHelper(new CongressionalDistrictHelper());
        this.setPerformingOrganizationHelper(new CongressionalDistrictHelper());
        this.setPerformanceSiteHelpers((List<CongressionalDistrictHelper>)new AutoPopulatingList(CongressionalDistrictHelper.class));
        this.setOtherOrganizationHelpers((List<CongressionalDistrictHelper>)new AutoPopulatingList(CongressionalDistrictHelper.class));
        this.setSpecialReviewHelper(new SpecialReviewHelper(this));
        this.customAttributeValues = new HashMap<String, String[]>();
        this.setCopyCriteria(new ProposalCopyCriteria(this.getProposalDevelopmentDocument()));
        this.proposalDevelopmentParameters = new HashMap<String, Parameter>();
        this.newProposalPersonRoleRendered = false;
        this.setNewProposalChangedData(new ProposalChangedData());
        this.setNewBudgetChangedData(new BudgetChangedData());
        this.versionNumberForS2sOpportunity = null;
        this.setHierarchyProposalSummaries(new ArrayList<HierarchyProposalSummary>());
        this.medusaBean = new MedusaBean();
        this.reportHelperBean = new ReportHelperBean((KualiDocumentFormBase)this);
        this.canCreateProposal = this.isAuthorizedToCreateProposal();
        this.setProposalDevelopmentRejectionBean(new ProposalDevelopmentRejectionBean());
        this.setNotificationHelper(new NotificationHelper<ProposalDevelopmentNotificationContext>());
        this.setQuestionnaireHelper(new ProposalDevelopmentQuestionnaireHelper(this));
        this.setS2sQuestionnaireHelper(new ProposalDevelopmentS2sQuestionnaireHelper(this));
        this.proposalPersonQuestionnaireHelpers = new ArrayList<ProposalPersonQuestionnaireHelper>();
        for (ProposalPerson person : this.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons()) {
            ProposalPersonQuestionnaireHelper helper = new ProposalPersonQuestionnaireHelper(this, person);
            this.proposalPersonQuestionnaireHelpers.add(helper);
        }
        this.answerHeadersToDelete = new ArrayList<AnswerHeader>();
        this.proposalPersonsToDelete = new ArrayList<ProposalPerson>();
        this.setNewInstituteAttachment(this.createNarrative());
        this.setNewPropPersonBio(new ProposalPersonBiography());
        this.setApproverViewTabTitle();
        this.customDataHelper = new ProposalDevelopmentCustomDataHelper(this);
    }

    protected Narrative createNarrative() {
        return new Narrative();
    }

    private void clearMultipleValueLookupResults() {
        this.setLookupResultsSequenceNumber(null);
        this.setLookupResultsBOClassName(null);
    }

    @Override
    public void populate(HttpServletRequest request) {
        this.clearMultipleValueLookupResults();
        super.populate(request);
        ProposalDevelopmentDocument proposalDevelopmentDocument = this.getProposalDevelopmentDocument();
        proposalDevelopmentDocument.getDevelopmentProposal().refreshReferenceObject("sponsor");
        if (this.getActionFormUtilMap() instanceof ActionFormUtilMap) {
            ((ActionFormUtilMap)this.getActionFormUtilMap()).clear();
        }
        List<ProposalPerson> keyPersonnel = this.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons();
        int personCount = 0;
        String fieldStarter = "document.developmentProposalList[0].proposalPersons[";
        String fieldEnder = "].proposalPersonExtendedAttributes.citizenshipTypeCode";
        for (ProposalPerson proposalPerson : keyPersonnel) {
            String citizenshipTypeCode;
            String field = "document.developmentProposalList[0].proposalPersons[" + personCount + "].proposalPersonExtendedAttributes.citizenshipTypeCode";
            if (request.getParameterMap().containsKey(field) && (citizenshipTypeCode = request.getParameter(field)) != null && StringUtils.isNotBlank((String)citizenshipTypeCode)) {
                Integer citizenshipTypeCodeInt = new Integer(citizenshipTypeCode);
                proposalPerson.getProposalPersonExtendedAttributes().setCitizenshipTypeCode(citizenshipTypeCodeInt);
                HashMap<String, Integer> params = new HashMap<String, Integer>();
                params.put("citizenshipTypeCode", citizenshipTypeCodeInt);
                CitizenshipType newCitizenshipType = (CitizenshipType)this.getBusinessObjectService().findByPrimaryKey(CitizenshipType.class, params);
                proposalPerson.getProposalPersonExtendedAttributes().setCitizenshipType(newCitizenshipType);
            }
            ++personCount;
        }
    }

    public static void printRequest(HttpServletRequest request) {
        System.err.println("*****************");
        for (Object param : request.getParameterMap().keySet()) {
            String value = request.getParameter(param.toString());
            System.err.println("Key: " + param.toString() + "  value: " + value.toString());
        }
        System.err.println("*****************");
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
        ProposalDevelopmentDocument pd = this.getProposalDevelopmentDocument();
        if (!pd.isProposalDeleted()) {
            ProposalState proposalState = pd == null ? null : pd.getDevelopmentProposal().getProposalState();
            HeaderField docStatus = new HeaderField("DataDictionary.AttributeReferenceDummy.attributes.workflowDocumentStatus", proposalState == null ? "" : proposalState.getDescription());
            this.getDocInfo().set(1, docStatus);
            if (pd.getDevelopmentProposal().getSponsor() == null) {
                this.getDocInfo().add(new HeaderField("DataDictionary.Sponsor.attributes.sponsorName", ""));
            } else {
                this.getDocInfo().add(new HeaderField("DataDictionary.Sponsor.attributes.sponsorName", pd.getDevelopmentProposal().getSponsor().getSponsorName()));
            }
            if (this.getKeyPersonnelService().hasPrincipalInvestigator(pd)) {
                boolean found = false;
                Iterator<ProposalPerson> person_it = pd.getDevelopmentProposal().getInvestigators().iterator();
                while (person_it.hasNext() && !found) {
                    ProposalPerson investigator = person_it.next();
                    if (!this.getKeyPersonnelService().isPrincipalInvestigator(investigator)) continue;
                    found = true;
                    this.getDocInfo().add(new HeaderField("DataDictionary.KraAttributeReferenceDummy.attributes.principalInvestigator", investigator.getFullName()));
                }
            } else {
                this.getDocInfo().add(new HeaderField("DataDictionary.KraAttributeReferenceDummy.attributes.principalInvestigator", ""));
            }
        }
    }

    public ProposalAbstract getNewProposalAbstract() {
        return this.newProposalAbstract;
    }

    public void setNewProposalAbstract(ProposalAbstract newProposalAbstract) {
        this.newProposalAbstract = newProposalAbstract;
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        ProposalCopyCriteria cCriteria = this.getCopyCriteria();
        if (cCriteria != null) {
            cCriteria.setIncludeAttachments(false);
            cCriteria.setIncludeBudget(false);
        }
        this.setCurrentTabIndex(0);
        ProposalDevelopmentDocument proposalDevelopmentDocument = this.getProposalDevelopmentDocument();
        List<PropScienceKeyword> keywords = proposalDevelopmentDocument.getDevelopmentProposal().getPropScienceKeywords();
        for (int i = 0; i < keywords.size(); ++i) {
            PropScienceKeyword propScienceKeyword = keywords.get(i);
            propScienceKeyword.setSelectKeyword(false);
        }
        ProposalUserEditRoles editRoles = this.getProposalUserEditRoles();
        if (editRoles != null) {
            editRoles.clear();
        }
        this.setResubmissionOption(null);
    }

    public void setPrimeSponsorName(String primeSponsorName) {
        this.primeSponsorName = primeSponsorName;
    }

    public String getPrimeSponsorName() {
        return this.primeSponsorName;
    }

    public String getNewPersonId() {
        return this.newPersonId;
    }

    public void setNewPersonId(String argNewPersonId) {
        this.newPersonId = argNewPersonId;
    }

    public ProposalPerson getNewProposalPerson() {
        return this.newProposalPerson;
    }

    public void setNewProposalPerson(ProposalPerson argNewProposalPerson) {
        this.newProposalPerson = argNewProposalPerson;
    }

    public List<Unit> getNewProposalPersonUnit() {
        if (this.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons().size() > this.newProposalPersonUnit.size()) {
            this.newProposalPersonUnit.add(this.newProposalPersonUnit.size(), new Unit());
        }
        return this.newProposalPersonUnit;
    }

    public void setNewProposalPersonUnit(List<Unit> argUnit) {
        this.newProposalPersonUnit = argUnit;
    }

    public List<ProposalPersonDegree> getNewProposalPersonDegree() {
        if (this.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons().size() > this.newProposalPersonDegree.size()) {
            this.newProposalPersonDegree.add(this.newProposalPersonDegree.size(), new ProposalPersonDegree());
        }
        return this.newProposalPersonDegree;
    }

    public void setNewProposalPersonDegree(List<ProposalPersonDegree> argDegree) {
        this.newProposalPersonDegree = argDegree;
    }

    public String getNewRolodexId() {
        return this.newRolodexId;
    }

    public void setNewRolodexId(String argNewRolodexId) {
        this.newRolodexId = argNewRolodexId;
    }

    public Narrative getNewNarrative() {
        return this.newNarrative;
    }

    public void setNewNarrative(Narrative newNarrative) {
        this.newNarrative = newNarrative;
    }

    public FormFile getNarrativeFile() {
        return this.narrativeFile;
    }

    public void setNarrativeFile(FormFile narrativeFile) {
        this.narrativeFile = narrativeFile;
    }

    public boolean isShowMaintenanceLinks() {
        return this.showMaintenanceLinks;
    }

    public void setShowMaintenanceLinks(boolean showMaintenanceLinks) {
        this.showMaintenanceLinks = showMaintenanceLinks;
    }

    private BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    public Map<String, KualiDecimal> getCreditSplitTotals() {
        return this.getKeyPersonnelService().calculateCreditSplitTotals(this.getProposalDevelopmentDocument());
    }

    public ProposalPersonBiography getNewPropPersonBio() {
        return this.newPropPersonBio;
    }

    public void setNewPropPersonBio(ProposalPersonBiography newPropPersonBio) {
        this.newPropPersonBio = newPropPersonBio;
    }

    public Narrative getNewInstituteAttachment() {
        return this.newInstituteAttachment;
    }

    public void setNewInstituteAttachment(Narrative newInstituteAttachment) {
        this.newInstituteAttachment = newInstituteAttachment;
    }

    public void setCustomAttributeGroups(SortedMap<String, List<CustomAttributeDocument>> customAttributeGroups) {
        this.customAttributeGroups = customAttributeGroups;
    }

    private KeyPersonnelService getKeyPersonnelService() {
        return KraServiceLocator.getService(KeyPersonnelService.class);
    }

    public ProposalCopyCriteria getCopyCriteria() {
        return this.copyCriteria;
    }

    public void setCopyCriteria(ProposalCopyCriteria copyCriteria) {
        this.copyCriteria = copyCriteria;
    }

    public boolean getIsCopyAttachmentsDisabled() {
        ProposalDevelopmentDocument doc = this.getProposalDevelopmentDocument();
        return doc.getDevelopmentProposal().getNarratives().size() <= 0 && doc.getDevelopmentProposal().getInstituteAttachments().size() <= 0 && doc.getDevelopmentProposal().getPropPersonBios().size() <= 0;
    }

    public Map<String, List<CustomAttributeDocument>> getCustomAttributeGroups() {
        return this.customAttributeGroups;
    }

    public void setCustomAttributeValues(Map<String, String[]> customAttributeValues) {
        this.customAttributeValues = customAttributeValues;
    }

    public Map<String, String[]> getCustomAttributeValues() {
        return this.customAttributeValues;
    }

    public boolean getIsCopyBudgetDisabled() {
        return this.getProposalDevelopmentDocument().getBudgetDocumentVersions().size() <= 0;
    }

    public void setProposalDevelopmentParameters(Map<String, Parameter> proposalDevelopmentParameters) {
        this.proposalDevelopmentParameters = proposalDevelopmentParameters;
    }

    public Map<String, Parameter> getProposalDevelopmentParameters() {
        return this.proposalDevelopmentParameters;
    }

    public Integer getAnswerYesNo() {
        return Constants.ANSWER_YES_NO;
    }

    public Integer getAnswerYesNoNA() {
        return Constants.ANSWER_YES_NO_NA;
    }

    public List<ProposalAssignedRole> getProposalAssignedRoles() {
        PerformanceLogger perfLog = new PerformanceLogger();
        ArrayList<ProposalAssignedRole> assignedRoles = new ArrayList<ProposalAssignedRole>();
        Collection<org.kuali.rice.kim.api.role.Role> roles = this.getKimProposalRoles();
        for (org.kuali.rice.kim.api.role.Role role : roles) {
            if (StringUtils.equals((String)role.getName(), (String)"unassigned")) continue;
            ProposalAssignedRole assignedRole = new ProposalAssignedRole(role.getName(), this.getUsersInRole(role.getName()));
            assignedRoles.add(assignedRole);
        }
        perfLog.log("Time to execute getProposalAssignedRoles method.", true);
        return assignedRoles;
    }

    private List<String> getUsersInRole(String roleName) {
        ArrayList<String> names = new ArrayList<String>();
        List<ProposalUserRoles> proposalUsers = this.getProposalUserRoles();
        for (ProposalUserRoles proposalUser : proposalUsers) {
            if (!proposalUser.getRoleNames().contains(roleName)) continue;
            names.add(proposalUser.getFullname());
        }
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String name1, String name2) {
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return -1;
                }
                return name1.compareTo(name2);
            }
        });
        return names;
    }

    public ProposalUser getNewProposalUser() {
        return this.newProposalUser;
    }

    public void setNewProposalUser(ProposalUser newProposalUser) {
        this.newProposalUser = newProposalUser;
    }

    public List<Role> getProposalRoles() {
        ArrayList<Role> returnRoleBeans = new ArrayList<Role>();
        Collection<org.kuali.rice.kim.api.role.Role> roles = this.getKimProposalRoles();
        QueryByCriteria.Builder queryBuilder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        PermissionQueryResults permissionResults = null;
        for (org.kuali.rice.kim.api.role.Role role : roles) {
            if (StringUtils.equals((String)role.getName(), (String)"unassigned")) continue;
            predicates.add(PredicateFactory.equal((String)"rolePermissions.roleId", (Object)role.getId()));
            queryBuilder.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])predicates.toArray(new Predicate[0]))});
            permissionResults = this.getKimPermissionService().findPermissions(queryBuilder.build());
            if (permissionResults != null && permissionResults.getResults().size() > 0) {
                returnRoleBeans.add(new Role(role.getName(), role.getDescription(), permissionResults.getResults()));
            }
            predicates.clear();
            queryBuilder = QueryByCriteria.Builder.create();
            permissionResults = null;
        }
        return returnRoleBeans;
    }

    public synchronized List<ProposalUserRoles> getProposalUserRoles() {
        if (this.proposalUserRolesList == null) {
            this.proposalUserRolesList = new ArrayList<ProposalUserRoles>();
            Collection<org.kuali.rice.kim.api.role.Role> roles = this.getKimProposalRoles();
            for (org.kuali.rice.kim.api.role.Role role : roles) {
                this.addPersons(this.proposalUserRolesList, role.getName());
            }
            this.sortProposalUsers();
        }
        return this.proposalUserRolesList;
    }

    public List<ProposalUserRoles> getCurrentProposalUserRoles() {
        ArrayList<ProposalUserRoles> current = new ArrayList<ProposalUserRoles>();
        Collection<org.kuali.rice.kim.api.role.Role> roles = this.getKimProposalRoles();
        for (org.kuali.rice.kim.api.role.Role role : roles) {
            this.addPersons(current, role.getName());
        }
        return current;
    }

    public Collection<org.kuali.rice.kim.api.role.Role> getKimProposalRoles() {
        ProposalRoleService proposalRoleService = KraServiceLocator.getService(ProposalRoleService.class);
        List<org.kuali.rice.kim.api.role.Role> proposalRoles = proposalRoleService.getRolesForDisplay();
        return proposalRoles;
    }

    private void sortProposalUsers() {
        Collections.sort(this.proposalUserRolesList, new Comparator<ProposalUserRoles>(){

            @Override
            public int compare(ProposalUserRoles o1, ProposalUserRoles o2) {
                return o1.getFullname().compareTo(o2.getFullname());
            }
        });
    }

    public void addProposalUser(ProposalUser proposalUser) {
        KcPerson person = this.getKcPersonService().getKcPersonByUserName(proposalUser.getUsername());
        ProposalUserRoles userRoles = this.buildProposalUserRoles(person, proposalUser.getRoleName());
        this.proposalUserRolesList.add(userRoles);
        this.sortProposalUsers();
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    private void addPersons(List<ProposalUserRoles> propUserRolesList, String roleName) {
        KraAuthorizationService proposalAuthService = KraServiceLocator.getService(KraAuthorizationService.class);
        ProposalDevelopmentDocument doc = this.getProposalDevelopmentDocument();
        List<KcPerson> persons = proposalAuthService.getPersonsInRole(doc, roleName);
        for (KcPerson person : persons) {
            ProposalUserRoles proposalUserRoles = this.findProposalUserRoles(propUserRolesList, person.getUserName());
            if (proposalUserRoles != null) {
                proposalUserRoles.addRoleName(roleName);
                continue;
            }
            propUserRolesList.add(this.buildProposalUserRoles(person, roleName));
        }
    }

    private ProposalUserRoles findProposalUserRoles(List<ProposalUserRoles> propUserRolesList, String username) {
        for (ProposalUserRoles proposalUserRoles : propUserRolesList) {
            if (!StringUtils.equals((String)username, (String)proposalUserRoles.getUsername())) continue;
            return proposalUserRoles;
        }
        return null;
    }

    private ProposalUserRoles buildProposalUserRoles(KcPerson person, String roleName) {
        ProposalUserRoles proposalUserRoles = new ProposalUserRoles();
        proposalUserRoles.setUsername(person.getUserName());
        proposalUserRoles.addRoleName(roleName);
        proposalUserRoles.setFullname(person.getFullName());
        proposalUserRoles.setUnitNumber(person.getOrganizationIdentifier());
        UnitService unitService = KraServiceLocator.getService(UnitService.class);
        Unit unit = unitService.getUnit(person.getOrganizationIdentifier());
        if (unit != null) {
            proposalUserRoles.setUnitName(unit.getUnitName());
        }
        return proposalUserRoles;
    }

    public void clearDocumentRelatedState() {
        this.initialize();
        this.proposalUserRolesList = null;
    }

    public ProposalUserEditRoles getProposalUserEditRoles() {
        return this.proposalUserEditRoles;
    }

    public void setProposalUserEditRoles(ProposalUserEditRoles proposalUserEditRoles) {
        this.proposalUserEditRoles = proposalUserEditRoles;
    }

    @Override
    public String getNewBudgetVersionName() {
        return this.newBudgetVersionName;
    }

    @Override
    public void setNewBudgetVersionName(String newBudgetVersionName) {
        this.newBudgetVersionName = newBudgetVersionName;
    }

    public boolean isNewProposalPersonRoleRendered() {
        return this.newProposalPersonRoleRendered;
    }

    public void setNewProposalPersonRoleRendered(boolean newProposalPersonRoleRendered) {
        this.newProposalPersonRoleRendered = newProposalPersonRoleRendered;
    }

    @Override
    public String getHeaderDispatch() {
        return this.getDocumentActions().containsKey("canSave") ? "save" : "reload";
    }

    public void setNewNarrativeUserRights(List<NarrativeUserRights> newNarrativeUserRights) {
        this.newNarrativeUserRights = newNarrativeUserRights;
    }

    public List<NarrativeUserRights> getNewNarrativeUserRights() {
        return this.newNarrativeUserRights;
    }

    public NarrativeUserRights getNewNarrativeUserRight(int index) {
        return this.newNarrativeUserRights.get(index);
    }

    public S2sOpportunity getNewS2sOpportunity() {
        return this.newS2sOpportunity;
    }

    public void setNewS2sOpportunity(S2sOpportunity newS2sOpportunity) {
        this.newS2sOpportunity = newS2sOpportunity;
    }

    public List<S2sAppSubmission> getNewS2sAppSubmission() {
        return this.newS2sAppSubmission;
    }

    public void setNewS2sAppSubmission(List<S2sAppSubmission> newS2sAppSubmission) {
        this.newS2sAppSubmission = newS2sAppSubmission;
    }

    public void setNarratives(List<Narrative> narratives) {
        this.narratives = narratives;
    }

    public List<Narrative> getNarratives() {
        return this.narratives;
    }

    public List<ExtraButton> getExtraActionsButtons() {
        this.extraButtons.clear();
        ProposalDevelopmentDocument doc = this.getProposalDevelopmentDocument();
        String externalImageURL = "kra.externalizable.images.url";
        TaskAuthorizationService tas = KraServiceLocator.getService(TaskAuthorizationService.class);
        ConfigurationService configurationService = KRADServiceLocator.getKualiConfigurationService();
        if (tas.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), new ProposalTask("submitToSponsor", doc))) {
            if (this.isCanSubmitToSponsor()) {
                String submitToGrantsGovImage = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_submittosponsor.gif";
                this.addExtraButton("methodToCall.submitToSponsor", submitToGrantsGovImage, "Submit To Sponsor");
            }
            if (this.isCanSubmitToGrantsGov() && doc.getDevelopmentProposal().getS2sOpportunity() != null && doc.getDevelopmentProposal().getS2sAppSubmission().size() == 0) {
                String grantsGovSubmitImage = configurationService.getPropertyValueAsString(externalImageURL) + "buttonsmall_submittos2s.gif";
                this.addExtraButton("methodToCall.submitToGrantsGov", grantsGovSubmitImage, "Submit To S2S");
            }
        }
        if (tas.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), new ProposalTask("rejectProposal", doc))) {
            String resubmissionImage = configurationService.getPropertyValueAsString(externalImageURL) + "buttonsmall_reject.gif";
            this.addExtraButton("methodToCall.reject", resubmissionImage, "Reject");
        }
        if (tas.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), new ProposalTask("deleteProposal", doc))) {
            String deleteProposalImage = configurationService.getPropertyValueAsString(externalImageURL) + "buttonsmall_deleteproposal.gif";
            this.addExtraButton("methodToCall.deleteProposal", deleteProposalImage, "Delete Proposal");
        }
        String sendNotificationImage = configurationService.getPropertyValueAsString(externalImageURL) + "buttonsmall_send_notification.gif";
        this.addExtraButton("methodToCall.sendNotification", sendNotificationImage, "Send Notification");
        return this.extraButtons;
    }

    public void processValidationFail() {
        try {
            boolean cSplitEnabled = this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "proposaldevelopment.creditsplit.enabled") != false && this.getProposalDevelopmentDocument().getDevelopmentProposal().getInvestigators().size() > 0;
            this.setCreditSplitEnabled(cSplitEnabled);
        }
        catch (Exception e) {
            BufferedLogger.warn(MISSING_PARAM_MSG, "proposaldevelopment.creditsplit.enabled");
            BufferedLogger.warn(e.getMessage());
        }
    }

    public boolean isCreditSplitEnabled() {
        return this.creditSplitEnabled;
    }

    public void setCreditSplitEnabled(boolean creditSplitEnabled) {
        this.creditSplitEnabled = creditSplitEnabled;
    }

    public String getOptInUnitDetails() {
        return this.optInUnitDetails;
    }

    public void setOptInUnitDetails(String optInUnitDetails) {
        this.optInUnitDetails = optInUnitDetails;
    }

    public String getOptInCertificationStatus() {
        return this.optInCertificationStatus;
    }

    public void setOptInCertificationStatus(String optInCertificationStatus) {
        this.optInCertificationStatus = optInCertificationStatus;
    }

    public ProposalChangedData getNewProposalChangedData() {
        return this.newProposalChangedData;
    }

    public void setNewProposalChangedData(ProposalChangedData newProposalChangedData) {
        this.newProposalChangedData = newProposalChangedData;
    }

    public boolean isSubmissionStatusVisible() {
        String routeStatus = this.getProposalDevelopmentDocument().getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return "P".equals(routeStatus) || "F".equals(routeStatus) || this.getProposalDevelopmentDocument().getDevelopmentProposal().getSubmitFlag() != false && "R".equals(routeStatus);
    }

    public boolean isSubmissionStatusReadOnly() {
        KraAuthorizationService kraAuthorizationService;
        boolean result = true;
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        KraAuthorizationService proposalAuthService = KraServiceLocator.getService(KraAuthorizationService.class);
        boolean canModify = proposalAuthService.hasPermission(userId, this.getProposalDevelopmentDocument(), "Modify ProposalDevelopmentDocument");
        if (canModify) {
            result = false;
        }
        if ((kraAuthorizationService = KraServiceLocator.getService(KraAuthorizationService.class)).hasRole(userId, "KC-ADM", "OSP Administrator")) {
            result = false;
        }
        return result;
    }

    public boolean isCanSubmitToSponsor() {
        String routeStatus = this.getProposalDevelopmentDocument().getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return ("P".equals(routeStatus) || "F".equals(routeStatus) || "R".equals(routeStatus)) && this.getProposalDevelopmentDocument().getDevelopmentProposal().getSubmitFlag() == false && !this.isSubmissionStatusReadOnly();
    }

    public boolean isCanSubmitToGrantsGov() {
        String routeStatus = this.getProposalDevelopmentDocument().getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return ("P".equals(routeStatus) || "F".equals(routeStatus) || "R".equals(routeStatus)) && !this.isSubmissionStatusReadOnly();
    }

    public Long getVersionNumberForS2sOpportunity() {
        return this.versionNumberForS2sOpportunity;
    }

    public void setVersionNumberForS2sOpportunity(Long versionNumberForS2sOpportunity) {
        this.versionNumberForS2sOpportunity = versionNumberForS2sOpportunity;
    }

    public void setNewPerformanceSite(ProposalSite newPerformanceSite) {
        this.newPerformanceSite = newPerformanceSite;
    }

    public ProposalSite getNewPerformanceSite() {
        return this.newPerformanceSite;
    }

    public void setNewOtherOrganization(ProposalSite newOtherOrganization) {
        this.newOtherOrganization = newOtherOrganization;
    }

    public ProposalSite getNewOtherOrganization() {
        return this.newOtherOrganization;
    }

    public void setApplicantOrganizationHelper(CongressionalDistrictHelper applicantOrganizationHelper) {
        this.applicantOrganizationHelper = applicantOrganizationHelper;
    }

    public CongressionalDistrictHelper getApplicantOrganizationHelper() {
        return this.applicantOrganizationHelper;
    }

    public void setPerformingOrganizationHelper(CongressionalDistrictHelper performingOrganizationHelper) {
        this.performingOrganizationHelper = performingOrganizationHelper;
    }

    public CongressionalDistrictHelper getPerformingOrganizationHelper() {
        return this.performingOrganizationHelper;
    }

    public void setPerformanceSiteHelpers(List<CongressionalDistrictHelper> performanceSiteHelpers) {
        this.performanceSiteHelpers = performanceSiteHelpers;
    }

    public List<CongressionalDistrictHelper> getPerformanceSiteHelpers() {
        return this.performanceSiteHelpers;
    }

    public ProposalDevelopmentApproverViewDO getApproverViewDO() {
        return this.approverViewDO;
    }

    public void setApproverViewDO(ProposalDevelopmentApproverViewDO approverViewDO) {
        this.approverViewDO = approverViewDO;
    }

    public void setOtherOrganizationHelpers(List<CongressionalDistrictHelper> otherOrganizationHelpers) {
        this.otherOrganizationHelpers = otherOrganizationHelpers;
    }

    public List<CongressionalDistrictHelper> getOtherOrganizationHelpers() {
        return this.otherOrganizationHelpers;
    }

    public SpecialReviewHelper getSpecialReviewHelper() {
        return this.specialReviewHelper;
    }

    public void setSpecialReviewHelper(SpecialReviewHelper specialReviewHelper) {
        this.specialReviewHelper = specialReviewHelper;
    }

    public final String getProposalFormTabTitle() {
        String totalForms = this.getSponsorFormTemplates().size() + "";
        return this.proposalFormTabTitle.concat("(" + totalForms + ")");
    }

    public final void setProposalFormTabTitle(String proposalFormTabTitle) {
        this.proposalFormTabTitle = proposalFormTabTitle;
    }

    public List<SponsorFormTemplateList> getSponsorFormTemplates() {
        return this.sponsorFormTemplates;
    }

    public void setSponsorFormTemplates(List<SponsorFormTemplateList> sponsorFormTemplates) {
        this.sponsorFormTemplates = sponsorFormTemplates;
    }

    public SponsorFormTemplateList getSponsorFormTemplate(int index) {
        while (this.getSponsorFormTemplates().size() <= index) {
            this.getSponsorFormTemplates().add(new SponsorFormTemplateList());
        }
        return this.getSponsorFormTemplates().get(index);
    }

    @Override
    public boolean isSaveAfterCopy() {
        return this.saveAfterCopy;
    }

    @Override
    public void setSaveAfterCopy(boolean val) {
        this.saveAfterCopy = val;
    }

    @Override
    protected void setSaveDocumentControl(Map editMode) {
        this.getDocumentActions().remove("canSave");
        if (this.isProposalAction() && this.hasModifyProposalPermission(editMode)) {
            this.getDocumentActions().put("canSave", "true");
        } else if (this.isNarrativeAction() && this.hasModifyNarrativesPermission(editMode)) {
            this.getDocumentActions().put("canSave", "true");
        } else if (this.isBudgetVersionsAction() && (this.hasModifyCompletedBudgetPermission(editMode) || this.hasModifyBudgetPermission(editMode))) {
            this.getDocumentActions().put("canSave", "true");
        }
    }

    @Override
    protected String getLockRegion() {
        String lockRegion = "PROPOSAL DEVELOPMENT";
        if (this.isProposalAction()) {
            lockRegion = "PROPOSAL DEVELOPMENT";
        } else if (this.isNarrativeAction()) {
            lockRegion = "NARRATIVES";
        } else if (this.isBudgetVersionsAction()) {
            lockRegion = "BUDGET";
        }
        return lockRegion;
    }

    private boolean isProposalAction() {
        boolean isProposalAction = false;
        if (StringUtils.isNotBlank((String)this.actionName) && StringUtils.isNotBlank((String)this.getMethodToCall()) && this.actionName.startsWith("Proposal") && !this.actionName.contains("AbstractsAttachments") && !this.actionName.contains("BudgetVersions") && StringUtils.isEmpty((String)this.navigateTo) && !this.getMethodToCall().equalsIgnoreCase("headerTab")) {
            isProposalAction = true;
        } else if (StringUtils.isNotEmpty((String)this.navigateTo) && (this.navigateTo.equalsIgnoreCase("proposal") || this.navigateTo.equalsIgnoreCase("specialReview") || this.navigateTo.equalsIgnoreCase("customData") || this.navigateTo.equalsIgnoreCase("keyPersonnel") || this.navigateTo.equalsIgnoreCase("permissions") || this.navigateTo.equalsIgnoreCase("questions") || this.navigateTo.equalsIgnoreCase("grantsGov") || this.navigateTo.equalsIgnoreCase("actions"))) {
            isProposalAction = true;
        }
        return isProposalAction;
    }

    private boolean isNarrativeAction() {
        boolean isNarrativeAction = false;
        if (StringUtils.isNotBlank((String)this.actionName) && StringUtils.isNotBlank((String)this.getMethodToCall()) && this.actionName.contains("AbstractsAttachments") && StringUtils.isEmpty((String)this.navigateTo) && !this.getMethodToCall().equalsIgnoreCase("headerTab")) {
            isNarrativeAction = true;
        } else if (StringUtils.isNotEmpty((String)this.navigateTo) && this.navigateTo.equalsIgnoreCase("abstractsAttachments")) {
            isNarrativeAction = true;
        }
        return isNarrativeAction;
    }

    private boolean isBudgetVersionsAction() {
        boolean isBudgetVersionsAction = false;
        if (StringUtils.isNotBlank((String)this.actionName) && this.actionName.contains("BudgetVersions") && StringUtils.isNotBlank((String)this.getMethodToCall()) && StringUtils.isEmpty((String)this.navigateTo) && !this.getMethodToCall().equalsIgnoreCase("headerTab")) {
            isBudgetVersionsAction = true;
        } else if (StringUtils.isNotEmpty((String)this.navigateTo) && (this.navigateTo.equalsIgnoreCase("versions") || this.navigateTo.equalsIgnoreCase("budgetVersions"))) {
            isBudgetVersionsAction = true;
        }
        return isBudgetVersionsAction;
    }

    public boolean isInWorkflow() {
        return KraServiceLocator.getService(KraWorkflowService.class).isInWorkflow(this.getDocument());
    }

    public ProposalDevelopmentDocument getProposalDevelopmentDocument() {
        return (ProposalDevelopmentDocument)super.getDocument();
    }

    public String getNewHierarchyProposalNumber() {
        return this.newHierarchyProposalNumber;
    }

    public void setNewHierarchyProposalNumber(String newHierarchyProposalNumber) {
        this.newHierarchyProposalNumber = newHierarchyProposalNumber;
    }

    public String getNewHierarchyChildProposalNumber() {
        return this.newHierarchyChildProposalNumber;
    }

    public void setNewHierarchyChildProposalNumber(String newHierarchyChildProposalNumber) {
        this.newHierarchyChildProposalNumber = newHierarchyChildProposalNumber;
    }

    public void setHierarchyProposalSummaries(List<HierarchyProposalSummary> hierarchyProposalSummaries) {
        this.hierarchyProposalSummaries = hierarchyProposalSummaries;
    }

    public List<HierarchyProposalSummary> getHierarchyProposalSummaries() {
        return this.hierarchyProposalSummaries;
    }

    public void setNewHierarchyBudgetTypeCode(String newHierarchyBudgetTypeCode) {
        this.newHierarchyBudgetTypeCode = newHierarchyBudgetTypeCode;
    }

    public String getNewHierarchyBudgetTypeCode() {
        return this.newHierarchyBudgetTypeCode;
    }

    public HeaderNavigation[] getHeaderNavigationTabs() {
        HeaderNavigation[] tabs = super.getHeaderNavigationTabs();
        ArrayList<HeaderNavigation> newTabs = new ArrayList<HeaderNavigation>();
        DevelopmentProposal devProposal = this.getProposalDevelopmentDocument().getDevelopmentProposal();
        boolean showHierarchy = devProposal.isInHierarchy();
        boolean disableGrantsGov = !this.isGrantsGovEnabled();
        boolean showProposalSummary = true;
        Parameter proposalSummaryIndicatorParam = this.getParameterService().getParameter("KC-PD", "Document", PROPOSAL_SUMMARY_TAB_INDICATOR);
        if (proposalSummaryIndicatorParam != null && "N".equalsIgnoreCase(proposalSummaryIndicatorParam.getValue())) {
            showProposalSummary = false;
        }
        for (HeaderNavigation tab : tabs) {
            if (tab.getHeaderTabNavigateTo().equals("grantsGov")) {
                tab.setDisabled(disableGrantsGov);
            }
            if (!showHierarchy && tab.getHeaderTabNavigateTo().equals("hierarchy") || tab.getHeaderTabNavigateTo().toUpperCase().equals("APPROVERVIEW") && !showProposalSummary && !this.canPerformWorkflowAction()) continue;
            newTabs.add(tab);
        }
        tabs = newTabs.toArray(new HeaderNavigation[newTabs.size()]);
        return tabs;
    }

    public boolean canPerformWorkflowAction() {
        if (!this.getProposalDevelopmentDocument().getDocumentHeader().hasWorkflowDocument()) {
            return false;
        }
        KcTransactionalDocumentAuthorizerBase documentAuthorizer = (KcTransactionalDocumentAuthorizerBase)KNSServiceLocator.getDocumentHelperService().getDocumentAuthorizer(this.getDocument());
        Person user = GlobalVariables.getUserSession().getPerson();
        Set<String> documentActions = documentAuthorizer.getDocumentActions(this.getDocument(), user, null);
        boolean canApprove = documentActions.contains("canApprove");
        boolean canAck = documentActions.contains("canAcknowledge");
        boolean canDisapprove = documentActions.contains("canDisapprove");
        return canApprove || canAck || canDisapprove;
    }

    public boolean isGrantsGovEnabled() {
        return KraServiceLocator.getService(ProposalDevelopmentService.class).isGrantsGovEnabledForProposal(this.getProposalDevelopmentDocument().getDevelopmentProposal());
    }

    public boolean isGrantsGovAuditActivated() {
        return this.grantsGovAuditActivated;
    }

    public void setGrantsGovAuditActivated(boolean grantsGovAuditActivated) {
        this.grantsGovAuditActivated = grantsGovAuditActivated;
    }

    public String getResubmissionOption() {
        return this.resubmissionOption;
    }

    public void setResubmissionOption(String resubmissionOption) {
        this.resubmissionOption = resubmissionOption;
    }

    public String getInstitutionalProposalToVersion() {
        return this.institutionalProposalToVersion;
    }

    public void setInstitutionalProposalToVersion(String institutionalProposalToVersion) {
        this.institutionalProposalToVersion = institutionalProposalToVersion;
    }

    public MedusaBean getMedusaBean() {
        return this.medusaBean;
    }

    public void setMedusaBean(MedusaBean medusaBean) {
        this.medusaBean = medusaBean;
    }

    @Override
    public ReportHelperBean getReportHelperBean() {
        return this.reportHelperBean;
    }

    public List<String> getProposalDataOverrideMethodToCalls() {
        return this.proposalDataOverrideMethodToCalls;
    }

    public void setProposalDataOverrideMethodToCalls(List<String> proposalDataOverrideMethodToCalls) {
        this.proposalDataOverrideMethodToCalls = proposalDataOverrideMethodToCalls;
    }

    public void setProposalToSummarize(DevelopmentProposal proposalToSummarize) {
        this.proposalToSummarize = proposalToSummarize;
    }

    public DevelopmentProposal getProposalToSummarize() {
        return this.proposalToSummarize;
    }

    public void setBudgetToSummarize(Budget budgetToSummarize) {
        this.budgetToSummarize = budgetToSummarize;
    }

    public Budget getBudgetToSummarize() {
        return this.budgetToSummarize;
    }

    public void setProposalNumberToSummarize(String proposalNumberToSummarize) {
        this.proposalNumberToSummarize = proposalNumberToSummarize;
    }

    public String getProposalNumberToSummarize() {
        return this.proposalNumberToSummarize;
    }

    public void setBudgetNumberToSummarize(String budgetNumberToSummarize) {
        this.budgetNumberToSummarize = budgetNumberToSummarize;
    }

    public String getBudgetNumberToSummarize() {
        return this.budgetNumberToSummarize;
    }

    public boolean isShowSubmissionDetails() {
        return this.showSubmissionDetails;
    }

    public void setShowSubmissionDetails(boolean showSubmissionDetails) {
        this.showSubmissionDetails = showSubmissionDetails;
    }

    public boolean isGrantsGovSubmitFlag() {
        return this.grantsGovSubmitFlag;
    }

    public void setGrantsGovSubmitFlag(boolean grantsGovSubmitFlag) {
        this.grantsGovSubmitFlag = grantsGovSubmitFlag;
    }

    public boolean isSaveXmlPermission() {
        return this.saveXmlPermission;
    }

    public void setSaveXmlPermission(boolean saveXmlPermission) {
        this.saveXmlPermission = saveXmlPermission;
    }

    public boolean isGrantsGovSelectFlag() {
        return this.grantsGovSelectFlag;
    }

    public void setGrantsGovSelectFlag(boolean grantsGovSelectFlag) {
        this.grantsGovSelectFlag = grantsGovSelectFlag;
    }

    private boolean isAuthorizedToCreateProposal() {
        ApplicationTask task = new ApplicationTask("createProposal");
        TaskAuthorizationService taskAuthenticationService = KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task);
    }

    public boolean isCanCreateProposal() {
        return this.canCreateProposal;
    }

    public void setCanCreateProposal(boolean canCreateProposal) {
        this.canCreateProposal = canCreateProposal;
    }

    public boolean getViewFundingSource() {
        return this.viewFundingSource;
    }

    public void setViewFundingSource(boolean viewFundingSource) {
        this.viewFundingSource = viewFundingSource;
    }

    public ProposalDevelopmentRejectionBean getProposalDevelopmentRejectionBean() {
        return this.proposalDevelopmentRejectionBean;
    }

    public void setProposalDevelopmentRejectionBean(ProposalDevelopmentRejectionBean proposalDevelopmentRejectionBean) {
        this.proposalDevelopmentRejectionBean = proposalDevelopmentRejectionBean;
    }

    public boolean isShowRejectionConfirmation() {
        return this.showRejectionConfirmation;
    }

    public void setShowRejectionConfirmation(boolean showRejectionConfirmation) {
        this.showRejectionConfirmation = showRejectionConfirmation;
    }

    public NotificationHelper<ProposalDevelopmentNotificationContext> getNotificationHelper() {
        return this.notificationHelper;
    }

    public void setNotificationHelper(NotificationHelper<ProposalDevelopmentNotificationContext> notificationHelper) {
        this.notificationHelper = notificationHelper;
    }

    public ProposalDevelopmentQuestionnaireHelper getQuestionnaireHelper() {
        return this.proposalDevelopmentQuestionnaireHelper;
    }

    public void setQuestionnaireHelper(ProposalDevelopmentQuestionnaireHelper proposalDevelopmentQuestionnaireHelper) {
        this.proposalDevelopmentQuestionnaireHelper = proposalDevelopmentQuestionnaireHelper;
    }

    public ProposalDevelopmentQuestionnaireHelper getS2sQuestionnaireHelper() {
        return this.proposalDevelopmentS2sQuestionnaireHelper;
    }

    public void setS2sQuestionnaireHelper(ProposalDevelopmentS2sQuestionnaireHelper proposalDevelopmentS2sQuestionnaireHelper) {
        this.proposalDevelopmentS2sQuestionnaireHelper = proposalDevelopmentS2sQuestionnaireHelper;
    }

    private void initAnswerList(HttpServletRequest request) {
    }

    private QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return KraServiceLocator.getService(QuestionnaireAnswerService.class);
    }

    public List<ProposalPersonQuestionnaireHelper> getProposalPersonQuestionnaireHelpers() {
        return this.proposalPersonQuestionnaireHelpers;
    }

    public void setProposalPersonQuestionnaireHelpers(List<ProposalPersonQuestionnaireHelper> proposalPersonQuestionnaireHelpers) {
        this.proposalPersonQuestionnaireHelpers = proposalPersonQuestionnaireHelpers;
    }

    public List<AnswerHeader> getAnswerHeadersToDelete() {
        return this.answerHeadersToDelete;
    }

    @Override
    public String getModuleCode() {
        return "3";
    }

    public List<ProposalPerson> getProposalPersonsToDelete() {
        return this.proposalPersonsToDelete;
    }

    public void setPropsoalPersonsToDelete(List<ProposalPerson> proposalPersonsToDelete) {
        this.proposalPersonsToDelete = proposalPersonsToDelete;
    }

    public void setS2sOpportunity(S2sOpportunity s2sOpportunity) {
        this.s2sOpportunity = s2sOpportunity;
    }

    public S2sOpportunity getS2sOpportunity() {
        return this.s2sOpportunity;
    }

    @Override
    public String[] getQuestionnaireFieldStarters() {
        String[] starters = new String[]{"proposalPersonQuestionnaireHelpers[", "s2sQuestionnaireHelper", "questionnaireHelper"};
        return starters;
    }

    @Override
    public String[] getQuestionnaireFieldMiddles() {
        String[] middles = new String[]{"].answers[", "].answers[", "].answers["};
        return middles;
    }

    @Override
    public String[] getQuestionnaireFieldEnds() {
        String[] ends = new String[]{"].answer", "].answer", "].answer"};
        return ends;
    }

    public void setNewBudgetChangedData(BudgetChangedData newBudgetChangedData) {
        this.newBudgetChangedData = newBudgetChangedData;
    }

    public BudgetChangedData getNewBudgetChangedData() {
        return this.newBudgetChangedData;
    }

    public String[] getSelectedBudgetPrint() {
        return this.selectedBudgetPrint;
    }

    public void setSelectedBudgetPrint(String[] selectedBudgetPrint) {
        this.selectedBudgetPrint = selectedBudgetPrint;
    }

    public void setBudgetDataOverrideMethodToCalls(List<String> budgetDataOverrideMethodToCalls) {
        this.BudgetDataOverrideMethodToCalls = budgetDataOverrideMethodToCalls;
    }

    public List<String> getBudgetDataOverrideMethodToCalls() {
        return this.BudgetDataOverrideMethodToCalls;
    }

    private void setApproverViewTabTitle() {
        HeaderNavigation[] headerNavigationTabs;
        for (HeaderNavigation headerNavigation : headerNavigationTabs = super.getHeaderNavigationTabs()) {
            if (!headerNavigation.getHeaderTabNavigateTo().equalsIgnoreCase("approverView")) continue;
            String approverViewTabTitle = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.approver.view.title");
            if (StringUtils.isEmpty((String)approverViewTabTitle)) {
                approverViewTabTitle = "Proposal Summary";
            }
            headerNavigation.setHeaderTabDisplayName(approverViewTabTitle);
            break;
        }
    }

    public String getCurrentPersonCountryCode() {
        return this.currentPersonCountryCode;
    }

    public void setCurrentPersonCountryCode(String pCurrentPersonCountryCode) {
        this.currentPersonCountryCode = pCurrentPersonCountryCode;
    }

    public String getValueFinderResultDoNotCache() {
        if (this.getActionFormUtilMap() instanceof ActionFormUtilMap) {
            ((ActionFormUtilMap)this.getActionFormUtilMap()).setCacheValueFinderResults(false);
        }
        return "";
    }

    public String getValueFinderResultCache() {
        if (this.getActionFormUtilMap() instanceof ActionFormUtilMap) {
            ((ActionFormUtilMap)this.getActionFormUtilMap()).setCacheValueFinderResults(true);
        }
        return "";
    }

    public Collection<NarrativeType> getAllNarrativeTypes() {
        return this.getBusinessObjectService().findAll(NarrativeType.class);
    }

    public boolean isHidePropDevDocDescriptionPanel() {
        return this.getProposalDevelopmentDocument().isDefaultDocumentDescription();
    }

    @Override
    public ProposalDevelopmentCustomDataHelper getCustomDataHelper() {
        return this.customDataHelper;
    }

    public void setCustomDataHelper(ProposalDevelopmentCustomDataHelper customDataHelper) {
        this.customDataHelper = customDataHelper;
    }

    public HierarchyProposalSummary getProposalSummary() {
        return this.proposalSummary;
    }

    public void setProposalSummary(HierarchyProposalSummary proposalSummary) {
        this.proposalSummary = proposalSummary;
    }

    protected PermissionService getKimPermissionService() {
        return (PermissionService)KraServiceLocator.getService("kimPermissionService");
    }
}

