/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.service.KcPersonService;

public class ProtocolReviewerBase
extends KraPersistableBusinessObjectBase {
    private Long protocolIdFk;
    private Long submissionIdFk;
    private boolean nonEmployeeFlag;
    private String personId;
    private Integer rolodexId;
    private Rolodex rolodex;
    private ProtocolBase protocol;
    private ProtocolSubmissionBase protocolSubmission;
    private transient KcPersonService kcPersonService;
    private transient KcPerson kcPerson;

    public Long getProtocolIdFk() {
        return this.protocolIdFk;
    }

    public void setProtocolIdFk(Long protocolIdFk) {
        this.protocolIdFk = protocolIdFk;
    }

    public Long getSubmissionIdFk() {
        return this.submissionIdFk;
    }

    public void setSubmissionIdFk(Long submissionIdFk) {
        this.submissionIdFk = submissionIdFk;
    }

    public boolean getNonEmployeeFlag() {
        return this.nonEmployeeFlag;
    }

    public void setNonEmployeeFlag(boolean nonEmployeeFlag) {
        this.nonEmployeeFlag = nonEmployeeFlag;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public Rolodex getRolodex() {
        return this.rolodex;
    }

    public void setRolodex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public ProtocolBase getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolBase protocol) {
        this.protocol = protocol;
    }

    public ProtocolSubmissionBase getProtocolSubmission() {
        return this.protocolSubmission;
    }

    public void setProtocolSubmission(ProtocolSubmissionBase protocolSubmission) {
        this.protocolSubmission = protocolSubmission;
    }

    public KcPerson getPerson() {
        if (this.kcPerson == null) {
            this.kcPerson = this.getKcPersonService().getKcPersonByPersonId(this.personId);
        }
        return this.kcPerson;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    @Override
    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public boolean isProtocolReviewerFromCommitteeMembership(CommitteeMembershipBase member) {
        boolean isMatched = false;
        if (!this.getNonEmployeeFlag() && StringUtils.equals((String)member.getPersonId(), (String)this.getPersonId())) {
            isMatched = true;
        } else if (this.getNonEmployeeFlag() && ObjectUtils.equals((Object)member.getRolodexId(), (Object)this.getRolodexId())) {
            isMatched = true;
        }
        return isMatched;
    }

    public boolean isPersonIdProtocolReviewer(String personId, boolean nonEmployeeFlag) {
        boolean result = false;
        if (nonEmployeeFlag == this.getNonEmployeeFlag() && (this.getNonEmployeeFlag() && StringUtils.equals((String)(this.getRolodexId() == null ? null : this.getRolodexId().toString()), (String)personId) && this.getNonEmployeeFlag() == nonEmployeeFlag || !this.getNonEmployeeFlag() && StringUtils.equals((String)personId, (String)this.personId))) {
            result = true;
        }
        return result;
    }

    public String getFullName() {
        if (this.nonEmployeeFlag && this.getRolodex() != null) {
            return this.getRolodex().getFullName();
        }
        if (this.getPerson() != null) {
            return this.getPerson().getFullName();
        }
        return null;
    }
}

