/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolSubmissionLookupableHelperServiceImplBase
extends KraLookupableHelperServiceImpl {
    protected static final String COMMITTEE_ID = "committeeId";
    protected static final String COMMITTEE_SCHEDULE_SCHEDULE_DATE = "committeeSchedule.scheduledDate";
    protected static final String PROTOCOL_TITLE = "protocol.title";
    protected static final String PROTOCOL_NUMBER = "protocolNumber";
    protected static final String DOC_TYPE_NAME_PARAM = "&docTypeName=";
    protected KraAuthorizationService kraAuthorizationService;
    protected KcPersonService kcPersonService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected HtmlData.AnchorHtmlData getViewLink(ProtocolSubmissionBase protocolSubmission) {
        HtmlData.AnchorHtmlData viewHtmlData = super.getViewLink((Document)protocolSubmission.getProtocol().getProtocolDocument());
        String submissionIdParam = "&submissionId=" + protocolSubmission.getSubmissionId();
        String href = viewHtmlData.getHref();
        href = href.replace(DOC_TYPE_NAME_PARAM, submissionIdParam + DOC_TYPE_NAME_PARAM);
        viewHtmlData.setHref(href);
        return viewHtmlData;
    }

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    @Override
    protected String getHtmlAction() {
        return "protocolProtocol.do";
    }

    @Override
    protected String getDocumentTypeName() {
        return "ProtocolDocumentBase";
    }

    @Override
    protected String getKeyFieldName() {
        return PROTOCOL_NUMBER;
    }

    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        Object inqBo = bo;
        String inqPropertyName = propertyName;
        HtmlData.AnchorHtmlData inqUrl = new HtmlData.AnchorHtmlData();
        if (!COMMITTEE_SCHEDULE_SCHEDULE_DATE.equals(propertyName) && !PROTOCOL_TITLE.equals(propertyName)) {
            ProtocolBase protocol;
            ProtocolPersonBase principalInvestigator;
            if (PROTOCOL_NUMBER.equals(propertyName)) {
                inqBo = ((ProtocolSubmissionBase)bo).getProtocol();
            } else if (propertyName.equals(COMMITTEE_ID)) {
                inqBo = ((ProtocolSubmissionBase)bo).getCommittee();
                System.out.println("inqBo ===============> " + inqBo);
            } else if ("piName".equals(propertyName) && (principalInvestigator = (protocol = ((ProtocolSubmissionBase)bo).getProtocol()).getPrincipalInvestigator()) != null) {
                if (StringUtils.isNotBlank((String)principalInvestigator.getPersonId())) {
                    inqBo = this.kcPersonService.getKcPersonByPersonId(principalInvestigator.getPersonId());
                    inqPropertyName = "personId";
                } else if (principalInvestigator.getRolodexId() != null) {
                    inqBo = new Rolodex();
                    ((Rolodex)inqBo).setRolodexId(principalInvestigator.getRolodexId());
                    inqPropertyName = "rolodexId";
                }
            }
            if (inqBo != null) {
                inqUrl = super.getInquiryUrl(inqBo, inqPropertyName);
                System.out.println("inqUrl ===============> " + inqUrl);
            }
        }
        return inqUrl;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!PROTOCOL_TITLE.equals(field.getPropertyName()) && !COMMITTEE_SCHEDULE_SCHEDULE_DATE.equals(field.getPropertyName())) continue;
                field.setQuickFinderClassNameImpl("");
            }
        }
        return rows;
    }
}

