/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolVersionService;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.questionnaire.ProtocolModuleQuestionnaireBeanBase;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.service.VersioningService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.service.SessionDocumentService;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;

public abstract class ProtocolVersionServiceImplBase
implements ProtocolVersionService {
    private DocumentService documentService;
    protected BusinessObjectService businessObjectService;
    protected VersioningService versioningService;
    private QuestionnaireAnswerService questionnaireAnswerService;
    private SequenceAccessorService sequenceAccessorService;
    private SessionDocumentService sessionDocumentService;
    private WorkflowDocumentService workflowDocumentService;

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setSessionDocumentService(SessionDocumentService sessionDocumentService) {
        this.sessionDocumentService = sessionDocumentService;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    protected abstract String getProtocolDocumentTypeHook();

    protected ProtocolDocumentBase getNewProtocolDocument() throws Exception {
        ProtocolDocumentBase newDoc = null;
        try {
            WorkflowDocument workflowDocument = this.workflowDocumentService.createWorkflowDocument(this.getProtocolDocumentTypeHook(), GlobalVariables.getUserSession().getPerson());
            this.sessionDocumentService.addDocumentToUserSession(GlobalVariables.getUserSession(), workflowDocument);
            DocumentHeader documentHeader = new DocumentHeader();
            documentHeader.setWorkflowDocument(workflowDocument);
            documentHeader.setDocumentNumber(workflowDocument.getDocumentId().toString());
            newDoc = this.createNewProtocolDocumentInstanceHook();
            newDoc.setDocumentHeader(documentHeader);
            newDoc.setDocumentNumber(documentHeader.getDocumentNumber());
        }
        catch (WorkflowException x) {
            throw new RuntimeException("Error creating new document: " + (Object)((Object)x));
        }
        return newDoc;
    }

    protected abstract ProtocolDocumentBase createNewProtocolDocumentInstanceHook();

    protected abstract ProtocolBase createProtocolNewVersionHook(ProtocolBase var1) throws Exception;

    @Override
    public ProtocolDocumentBase versionProtocolDocument(ProtocolDocumentBase protocolDocument) throws Exception {
        this.materializeCollections(protocolDocument.getProtocol());
        ProtocolBase newProtocol = this.createProtocolNewVersionHook(protocolDocument.getProtocol());
        this.removeDeletedAttachment(newProtocol);
        ProtocolDocumentBase newProtocolDocument = this.getNewProtocolDocument();
        newProtocolDocument.getDocumentHeader().setDocumentDescription(protocolDocument.getDocumentHeader().getDocumentDescription());
        this.copyCustomDataAttributeValues(protocolDocument, newProtocolDocument);
        this.fixNextValues(protocolDocument, newProtocolDocument);
        this.fixActionSequenceNumbers(protocolDocument.getProtocol(), newProtocol);
        Long nextProtocolId = this.sequenceAccessorService.getNextAvailableSequenceNumber(this.getProtocolSequenceIdHook());
        newProtocol.setProtocolId(nextProtocolId);
        for (ProtocolPersonBase person : newProtocol.getProtocolPersons()) {
            for (ProtocolAttachmentPersonnelBase attachment : person.getAttachmentPersonnels()) {
                attachment.setProtocolId(newProtocol.getProtocolId());
            }
        }
        newProtocolDocument.setProtocol(newProtocol);
        newProtocol.setProtocolDocument(newProtocolDocument);
        protocolDocument.getProtocol().setActive(false);
        this.finalizeAttachmentProtocol(protocolDocument.getProtocol());
        newProtocol.resetPersistenceStateForNotifications();
        this.businessObjectService.save((PersistableBusinessObject)protocolDocument.getProtocol());
        this.documentService.saveDocument((Document)newProtocolDocument);
        newProtocol.resetForeignKeys();
        newProtocol.resetPersistenceStateForNotifications();
        this.finalizeAttachmentProtocol(newProtocol);
        this.businessObjectService.save((PersistableBusinessObject)newProtocol);
        List<AnswerHeader> newAnswerHeaders = this.questionnaireAnswerService.versioningQuestionnaireAnswer(this.getNewInstanceProtocolModuleQuestionnaireBeanHook(protocolDocument.getProtocol()), newProtocol.getSequenceNumber());
        if (newProtocol.isAmendment() || newProtocol.isRenewal() && !newProtocol.isRenewalWithoutAmendment()) {
            ProtocolModuleQuestionnaireBeanBase moduleBean = this.getNewInstanceProtocolModuleQuestionnaireBeanHook(protocolDocument.getProtocol());
            moduleBean.setModuleSubItemCode("0");
            List<AnswerHeader> newAmendAnswerHeaders = this.questionnaireAnswerService.versioningQuestionnaireAnswer(moduleBean, newProtocol.getSequenceNumber());
            if (!newAmendAnswerHeaders.isEmpty()) {
                newAnswerHeaders.addAll(newAmendAnswerHeaders);
            }
        }
        if (!newAnswerHeaders.isEmpty()) {
            this.businessObjectService.save(newAnswerHeaders);
        }
        return newProtocolDocument;
    }

    protected abstract String getProtocolSequenceIdHook();

    private void removeDeletedAttachment(ProtocolBase protocol) {
        ArrayList<Integer> documentIds = new ArrayList<Integer>();
        ArrayList<ProtocolAttachmentProtocolBase> attachments = new ArrayList<ProtocolAttachmentProtocolBase>();
        ArrayList<ProtocolAttachmentProtocolBase> delAttachments = new ArrayList<ProtocolAttachmentProtocolBase>();
        for (ProtocolAttachmentProtocolBase attachment : protocol.getAttachmentProtocols()) {
            attachment.setProtocol(protocol);
            if (!"3".equals(attachment.getDocumentStatusCode())) continue;
            documentIds.add(attachment.getDocumentId());
        }
        if (!documentIds.isEmpty()) {
            for (ProtocolAttachmentProtocolBase attachment : protocol.getAttachmentProtocols()) {
                attachment.setProtocol(protocol);
                if (!documentIds.contains(attachment.getDocumentId())) {
                    attachments.add(attachment);
                    continue;
                }
                delAttachments.add(attachment);
            }
            protocol.setAttachmentProtocols(attachments);
        }
    }

    protected void materializeCollections(ProtocolBase protocol) {
        this.checkCollection(protocol.getAttachmentProtocols());
        this.checkCollection(protocol.getProtocolLocations());
        this.checkCollection(protocol.getProtocolAmendRenewals());
        for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
            this.checkCollection(person.getAttachmentPersonnels());
            this.checkCollection(person.getProtocolUnits());
        }
    }

    protected void checkCollection(List<? extends PersistableBusinessObject> bos) {
        if (!bos.isEmpty()) {
            bos.get(0);
        }
    }

    protected void finalizeAttachmentProtocol(ProtocolBase protocol) {
        for (ProtocolAttachmentProtocolBase attachment : protocol.getAttachmentProtocols()) {
            attachment.setProtocol(protocol);
            if (!"1".equals(attachment.getDocumentStatusCode())) continue;
            attachment.setDocumentStatusCode("2");
        }
    }

    protected void copyCustomDataAttributeValues(ProtocolDocumentBase protocolDocument, ProtocolDocumentBase newProtocolDocument) {
        newProtocolDocument.initialize();
        if (protocolDocument.getCustomAttributeDocuments().isEmpty()) {
            protocolDocument.initialize();
        }
        for (Map.Entry<String, CustomAttributeDocument> entry : newProtocolDocument.getCustomAttributeDocuments().entrySet()) {
            CustomAttributeDocument cad = protocolDocument.getCustomAttributeDocuments().get(entry.getKey());
            if (cad == null) continue;
            entry.getValue().getCustomAttribute().setValue(cad.getCustomAttribute().getValue());
        }
    }

    protected void fixActionSequenceNumbers(ProtocolBase protocol, ProtocolBase newProtocol) {
        for (int i = 0; i < protocol.getProtocolActions().size(); ++i) {
            newProtocol.getProtocolActions().get(i).setSequenceNumber(protocol.getProtocolActions().get(i).getSequenceNumber());
        }
    }

    protected void fixNextValues(ProtocolDocumentBase oldDoc, ProtocolDocumentBase newDoc) {
        ArrayList<DocumentNextvalue> newNextValues = new ArrayList<DocumentNextvalue>();
        List<DocumentNextvalue> oldNextValues = oldDoc.getDocumentNextvalues();
        for (DocumentNextvalue oldNextValue : oldNextValues) {
            DocumentNextvalue newNextValue = new DocumentNextvalue();
            newNextValue.setPropertyName(oldNextValue.getPropertyName());
            newNextValue.setNextValue(oldNextValue.getNextValue());
            newNextValue.setDocumentKey(newDoc.getDocumentNumber());
            newNextValues.add(newNextValue);
        }
        newDoc.setDocumentNextvalues(newNextValues);
    }

    @Override
    public ProtocolBase getProtocolVersion(String protocolNumber, Integer sequenceNumber) {
        ProtocolBase protocol = null;
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("protocolNumber", protocolNumber);
        fields.put("sequenceNumber", sequenceNumber);
        Collection protocols = this.businessObjectService.findMatching(this.getProtocolBOClassHook(), fields);
        if (protocols.size() == 1) {
            protocol = (ProtocolBase)protocols.iterator().next();
        }
        return protocol;
    }

    protected abstract Class<? extends ProtocolBase> getProtocolBOClassHook();

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    protected abstract ProtocolModuleQuestionnaireBeanBase getNewInstanceProtocolModuleQuestionnaireBeanHook(ProtocolBase var1);
}

