/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.meeting.ProtocolVoteAbstaineeBase;
import org.kuali.kra.common.committee.meeting.ProtocolVoteRecusedBase;
import org.kuali.kra.common.committee.service.CommitteeScheduleServiceBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.ProtocolVersionService;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolActionBean;
import org.kuali.kra.protocol.actions.ProtocolEditableBean;
import org.kuali.kra.protocol.actions.ProtocolSubmissionDocBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewService;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewalBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.kra.protocol.actions.approve.ProtocolApproveBean;
import org.kuali.kra.protocol.actions.assignagenda.ProtocolAssignToAgendaBean;
import org.kuali.kra.protocol.actions.correction.AdminCorrectionBean;
import org.kuali.kra.protocol.actions.decision.CommitteeDecision;
import org.kuali.kra.protocol.actions.decision.CommitteeDecisionService;
import org.kuali.kra.protocol.actions.delete.ProtocolDeleteBean;
import org.kuali.kra.protocol.actions.followup.FollowupActionService;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.protocol.actions.notifycommittee.ProtocolNotifyCommitteeBean;
import org.kuali.kra.protocol.actions.print.ProtocolQuestionnairePrintingService;
import org.kuali.kra.protocol.actions.print.ProtocolSummaryPrintOptions;
import org.kuali.kra.protocol.actions.print.QuestionnairePrintOption;
import org.kuali.kra.protocol.actions.request.ProtocolRequestBean;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.protocol.actions.submit.ValidProtocolActionActionBase;
import org.kuali.kra.protocol.actions.undo.UndoLastActionBean;
import org.kuali.kra.protocol.actions.withdraw.ProtocolAdministrativelyIncompleteBean;
import org.kuali.kra.protocol.actions.withdraw.ProtocolAdministrativelyWithdrawBean;
import org.kuali.kra.protocol.actions.withdraw.ProtocolWithdrawBean;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewAttachmentBase;
import org.kuali.kra.protocol.questionnaire.ProtocolModuleQuestionnaireBeanBase;
import org.kuali.kra.protocol.questionnaire.ProtocolSubmissionQuestionnaireHelper;
import org.kuali.kra.protocol.summary.ProtocolSummary;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.util.DateUtils;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class ActionHelperBase
implements Serializable {
    protected static final long ONE_DAY = 86400000L;
    protected static final String NAMESPACE = "KC-UNT";
    protected transient QuestionnaireAnswerService questionnaireAnswerService;
    protected ProtocolFormBase form;
    protected boolean canSubmitProtocol = false;
    protected boolean canSubmitProtocolUnavailable = false;
    protected String submissionConstraint;
    protected boolean canReturnToPI = false;
    protected boolean canReturnToPIUnavailable = false;
    protected boolean canCreateAmendment = false;
    protected boolean canCreateAmendmentUnavailable = false;
    protected boolean canModifyAmendmentSections = false;
    protected boolean canModifyAmendmentSectionsUnavailable = false;
    protected boolean canCreateRenewal = false;
    protected boolean canCreateRenewalUnavailable = false;
    protected boolean canNotifyCommittee = false;
    protected boolean canNotifyCommitteeUnavailable = false;
    protected boolean canWithdraw = false;
    protected boolean canWithdrawUnavailable = false;
    protected boolean canRequestClose = false;
    protected boolean canRequestCloseUnavailable = false;
    protected boolean canRequestSuspension = false;
    protected boolean canRequestSuspensionUnavailable = false;
    protected boolean canRequestTerminate = false;
    protected boolean canRequestTerminateUnavailable = false;
    protected boolean canDeleteProtocolAmendRenew = false;
    protected boolean canDeleteProtocolAmendRenewUnavailable = false;
    protected boolean canAssignToAgenda = false;
    protected boolean canAssignToAgendaUnavailable = false;
    protected boolean canAssignCmtSched = false;
    protected boolean canAssignCmtSchedUnavailable = false;
    protected boolean canRemoveFromToAgenda = false;
    protected boolean canRemoveFromAgendaUnavailable = false;
    protected boolean canAssignReviewers = false;
    protected boolean canAssignReviewersCmtSel = false;
    protected boolean canAssignReviewersUnavailable = false;
    protected boolean canApproveFull = false;
    protected boolean canApproveFullUnavailable = false;
    protected boolean canApproveResponse = false;
    protected boolean canApproveResponseUnavailable = false;
    protected boolean canDisapprove = false;
    protected boolean canDisapproveUnavailable = false;
    protected boolean canReturnForSMR = false;
    protected boolean canReturnForSMRUnavailable = false;
    protected boolean canReturnForSRR = false;
    protected boolean canReturnForSRRUnavailable = false;
    protected boolean canSuspend = false;
    protected boolean canSuspendUnavailable = false;
    protected boolean canClose = false;
    protected boolean canCloseUnavailable = false;
    protected boolean canExpire = false;
    protected boolean canExpireUnavailable = false;
    protected boolean canTerminate = false;
    protected boolean canTerminateUnavailable = false;
    protected boolean canMakeAdminCorrection = false;
    protected boolean canMakeAdminCorrectionUnavailable = false;
    protected boolean canRecordCommitteeDecision = false;
    protected boolean canRecordCommitteeDecisionUnavailable = false;
    protected boolean canUndoLastAction = false;
    protected boolean canUndoLastActionUnavailable = false;
    protected boolean canModifyProtocolSubmission = false;
    protected boolean canModifyProtocolSubmissionUnavailable = false;
    protected boolean canManageReviewComments = false;
    protected boolean canManageReviewCommentsUnavailable = false;
    protected boolean canApproveOther = false;
    protected boolean canManageNotes = false;
    protected boolean canManageNotesUnavailable = false;
    protected boolean canAbandon = false;
    protected List<? extends ValidProtocolActionActionBase> followupActionActions;
    protected boolean canViewOnlineReviewers;
    protected boolean canViewOnlineReviewerComments;
    protected boolean canAddCloseReviewerComments;
    protected boolean canAddSuspendReviewerComments;
    protected boolean canAddTerminateReviewerComments;
    private boolean canPerformAdminDetermination;
    private boolean canPerformAdminDeterminationUnavailable;
    private boolean canAdministrativelyApprove;
    private boolean canAdministrativelyApproveUnavailable;
    private boolean canAdministrativelyMarkIncomplete;
    private boolean canAdministrativelyMarkIncompleteUnavailable;
    private boolean canAdministrativelyWithdraw;
    private boolean canAdministrativelyWithdrawUnavailable;
    protected ProtocolSubmitAction protocolSubmitAction;
    protected ProtocolWithdrawBean protocolWithdrawBean;
    protected ProtocolRequestBean protocolCloseRequestBean;
    protected ProtocolRequestBean protocolSuspendRequestBean;
    protected ProtocolRequestBean protocolTerminateRequestBean;
    protected ProtocolNotifyCommitteeBean protocolNotifyCommitteeBean;
    protected ProtocolAmendmentBean protocolAmendmentBean;
    protected ProtocolAmendmentBean protocolRenewAmendmentBean;
    protected ProtocolDeleteBean protocolDeleteBean;
    protected ProtocolAssignToAgendaBean assignToAgendaBean;
    private ProtocolApproveBean protocolFullApprovalBean;
    private ProtocolApproveBean protocolAdminApprovalBean;
    private ProtocolAdministrativelyWithdrawBean protocolAdminWithdrawBean;
    private ProtocolAdministrativelyIncompleteBean protocolAdminIncompleteBean;
    protected ProtocolGenericActionBean protocolDisapproveBean;
    protected ProtocolGenericActionBean protocolSMRBean;
    protected ProtocolGenericActionBean protocolSRRBean;
    protected ProtocolGenericActionBean protocolSuspendBean;
    protected ProtocolGenericActionBean protocolCloseBean;
    protected ProtocolGenericActionBean protocolExpireBean;
    protected ProtocolGenericActionBean protocolTerminateBean;
    protected ProtocolGenericActionBean protocolReturnToPIBean;
    protected AdminCorrectionBean protocolAdminCorrectionBean;
    protected UndoLastActionBean undoLastActionBean;
    protected CommitteeDecision<?> committeeDecision;
    protected ProtocolGenericActionBean protocolManageReviewCommentsBean;
    protected ProtocolGenericActionBean protocolAbandonBean;
    protected String currentTaskName = "";
    protected boolean prevDisabled;
    protected boolean nextDisabled;
    protected transient ParameterService parameterService;
    protected transient TaskAuthorizationService taskAuthorizationService;
    protected transient ProtocolAmendRenewService protocolAmendRenewService;
    protected transient ProtocolVersionService protocolVersionService;
    protected boolean hasAmendments;
    protected boolean hasRenewals;
    protected boolean submissionHasNoAmendmentDetails;
    protected Boolean summaryReport;
    protected Boolean fullReport;
    protected Boolean historyReport;
    protected Boolean reviewCommentsReport;
    protected ProtocolSummary protocolSummary;
    protected ProtocolSummary prevProtocolSummary;
    protected int currentSequenceNumber = -1;
    protected String selectedHistoryItem;
    protected Date filteredHistoryStartDate;
    protected Date filteredHistoryEndDate;
    protected ProtocolSubmissionBase selectedSubmission;
    protected List<CommitteeScheduleMinuteBase> reviewComments;
    protected List<? extends ProtocolReviewAttachmentBase> reviewAttachments;
    protected List<ProtocolVoteAbstaineeBase> abstainees;
    protected List<ProtocolVoteRecusedBase> recusers;
    protected List<ProtocolReviewer> currentReviewers = new ArrayList<ProtocolReviewer>();
    private HashMap<String, ProtocolOnlineReviewBase> onlineReviewsMap = new HashMap();
    protected int currentSubmissionNumber;
    protected String renewalSummary;
    protected transient CommitteeScheduleServiceBase committeeScheduleService;
    protected transient KcPersonService kcPersonService;
    protected transient KraAuthorizationService kraAuthorizationService;
    protected transient BusinessObjectService businessObjectService;
    protected transient FollowupActionService<?> followupActionService;
    protected Map<String, Boolean> followupActionMap = new HashMap<String, Boolean>();
    protected Map<String, ProtocolActionBean> actionBeanTaskMap = new HashMap<String, ProtocolActionBean>();
    protected ProtocolSummaryPrintOptions protocolSummaryPrintOptions;
    protected ProtocolSummaryPrintOptions protocolPrintOption = new ProtocolSummaryPrintOptions();
    protected List<QuestionnairePrintOption> questionnairesToPrints;
    protected boolean summaryQuestionnaireExist;
    protected boolean hideReviewerName;
    protected boolean hideSubmissionReviewerName;
    protected boolean hideReviewerNameForAttachment;
    protected ProtocolCorrespondence protocolCorrespondence;
    protected boolean submissionQuestionnaireExist;
    protected boolean toAnswerSubmissionQuestionnaire;
    protected ProtocolSubmissionQuestionnaireHelper protocolSubmissionQuestionnaireHelper;

    public ActionHelperBase(ProtocolFormBase form) throws Exception {
        this.form = form;
        this.protocolSubmitAction = this.getNewProtocolSubmitActionInstanceHook(this);
        this.protocolWithdrawBean = this.getNewProtocolWithdrawBeanInstanceHook(this);
        this.createAmendmentBean();
        this.protocolNotifyCommitteeBean = this.getNewProtocolNotifyCommitteeBeanInstanceHook(this);
        this.protocolDeleteBean = this.getNewProtocolDeleteBeanInstanceHook(this);
        this.assignToAgendaBean = this.getNewProtocolAssignToAgendaBeanInstanceHook(this);
        this.assignToAgendaBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolFullApprovalBean = this.buildProtocolApproveBean(this.getFullApprovalProtocolActionTypeHook(), "actionHelper.protocolFullApprovalBean");
        this.protocolAdminApprovalBean = this.buildProtocolApproveBean(this.getAdminApprovalProtocolActionTypeHook(), "actionHelper.protocolAdminApprovalBean");
        this.protocolAdminWithdrawBean = this.getNewProtocolAdminWithdrawBeanInstanceHook(this);
        this.protocolAdminIncompleteBean = this.getNewProtocolAdminIncompleteBeanInstanceHook(this);
        this.protocolDisapproveBean = this.buildProtocolGenericActionBean(this.getDisapprovedProtocolActionTypeHook(), "actionHelper.protocolDisapproveBean");
        this.protocolSMRBean = this.buildProtocolGenericActionBean(this.getSMRProtocolActionTypeHook(), "actionHelper.protocolSMRBean");
        this.protocolSRRBean = this.buildProtocolGenericActionBean(this.getSRRProtocolActionTypeHook(), "actionHelper.protocolSRRBean");
        this.protocolReturnToPIBean = this.buildProtocolGenericActionBean(this.getReturnToPIActionTypeHook(), "actionHelper.protocolReturnToPIBean");
        this.protocolSuspendBean = this.buildProtocolGenericActionBean(this.getSuspendKeyHook(), "actionHelper.protocolSuspendBean");
        this.protocolExpireBean = this.buildProtocolGenericActionBean(this.getExpireKeyHook(), "actionHelper.protocolExpireBean");
        this.protocolTerminateBean = this.buildProtocolGenericActionBean(this.getTerminateKeyHook(), "actionHelper.protocolTerminateBean");
        this.protocolAbandonBean = this.buildProtocolGenericActionBean(this.getAbandonActionTypeHook(), this.getAbandonPropertyKeyHook());
        this.protocolAdminCorrectionBean = this.createAdminCorrectionBean();
        this.undoLastActionBean = this.getNewUndoLastActionBeanInstanceHook();
        this.committeeDecision = this.getNewCommitteeDecisionInstanceHook(this);
        this.committeeDecision.init();
        this.committeeDecision.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolManageReviewCommentsBean = this.buildProtocolGenericActionBean(this.getProtocolActionTypeCodeForManageReviewCommentsHook(), "actionHelper.protocolManageReviewCommentsBean");
        this.getProtocol().getProtocolSubmission().refreshReferenceObject("reviewAttachments");
        this.protocolManageReviewCommentsBean.getReviewAttachmentsBean().setReviewAttachments(this.getProtocol().getProtocolSubmission().getReviewAttachments());
        if (CollectionUtils.isNotEmpty(this.protocolManageReviewCommentsBean.getReviewAttachmentsBean().getReviewAttachments())) {
            this.protocolManageReviewCommentsBean.getReviewAttachmentsBean().setHideReviewerName(this.getReviewerCommentsService().setHideReviewerName(this.protocolManageReviewCommentsBean.getReviewAttachmentsBean().getReviewAttachments()));
        }
        this.initActionBeanTaskMap();
    }

    protected abstract String getSRRProtocolActionTypeHook();

    protected abstract String getSMRProtocolActionTypeHook();

    protected abstract String getReturnToPIActionTypeHook();

    protected abstract String getDisapprovedProtocolActionTypeHook();

    protected abstract String getProtocolActionTypeCodeForManageReviewCommentsHook();

    protected abstract CommitteeDecision<?> getNewCommitteeDecisionInstanceHook(ActionHelperBase var1);

    protected abstract ProtocolAssignToAgendaBean getNewProtocolAssignToAgendaBeanInstanceHook(ActionHelperBase var1);

    protected abstract ProtocolAdministrativelyWithdrawBean getNewProtocolAdminWithdrawBeanInstanceHook(ActionHelperBase var1);

    protected abstract ProtocolAdministrativelyIncompleteBean getNewProtocolAdminIncompleteBeanInstanceHook(ActionHelperBase var1);

    protected abstract String getAdminApprovalProtocolActionTypeHook();

    protected abstract String getFullApprovalProtocolActionTypeHook();

    protected abstract ProtocolWithdrawBean getNewProtocolWithdrawBeanInstanceHook(ActionHelperBase var1);

    protected abstract ProtocolAmendmentBean getNewProtocolAmendmentBeanInstanceHook(ActionHelperBase var1);

    protected abstract ProtocolNotifyCommitteeBean getNewProtocolNotifyCommitteeBeanInstanceHook(ActionHelperBase var1);

    protected abstract ProtocolSubmitAction getNewProtocolSubmitActionInstanceHook(ActionHelperBase var1);

    protected abstract ProtocolDeleteBean getNewProtocolDeleteBeanInstanceHook(ActionHelperBase var1);

    protected abstract AdminCorrectionBean getNewAdminCorrectionBeanInstanceHook(ActionHelperBase var1);

    protected abstract UndoLastActionBean getNewUndoLastActionBeanInstanceHook();

    protected void initActionBeanTaskMap() {
        this.actionBeanTaskMap.put("protocolAdminCorrection", this.protocolAdminCorrectionBean);
        this.actionBeanTaskMap.put("createAmendment", this.protocolAmendmentBean);
        this.actionBeanTaskMap.put("createRenewal", this.protocolRenewAmendmentBean);
        this.actionBeanTaskMap.put("protocolApprove", this.protocolFullApprovalBean);
        this.actionBeanTaskMap.put("protocolAssignToAgenda", this.assignToAgendaBean);
        this.actionBeanTaskMap.put("protocolRecordCommitteeDecision", this.committeeDecision);
        this.actionBeanTaskMap.put("protocolAmendRenewDelete", this.protocolDeleteBean);
        this.actionBeanTaskMap.put("protocolDisapprove", this.protocolDisapproveBean);
        this.actionBeanTaskMap.put("protocolExpire", this.protocolExpireBean);
        this.actionBeanTaskMap.put("protocolManageReviewComments", this.protocolManageReviewCommentsBean);
        this.actionBeanTaskMap.put("protocolReturnForSMR", this.protocolSMRBean);
        this.actionBeanTaskMap.put("protocolReturnForSRR", this.protocolSRRBean);
        this.actionBeanTaskMap.put("protocolReturnToPI", this.protocolReturnToPIBean);
        this.actionBeanTaskMap.put("submitProtocol", this.protocolSubmitAction);
        this.actionBeanTaskMap.put("protocolSuspend", this.protocolSuspendBean);
        this.actionBeanTaskMap.put("protocolTerminate", this.protocolTerminateBean);
        this.actionBeanTaskMap.put("protocolUndoLastAction", this.undoLastActionBean);
        this.actionBeanTaskMap.put("protocolWithdraw", this.protocolWithdrawBean);
        this.actionBeanTaskMap.put("adminApproveProtocol", this.protocolAdminApprovalBean);
        this.actionBeanTaskMap.put("adminWithdrawProtocol", this.protocolAdminWithdrawBean);
        this.actionBeanTaskMap.put("adminMarkIncompleteProtocol", this.protocolAdminIncompleteBean);
    }

    protected abstract String getAbandonActionTypeHook();

    protected abstract String getAbandonPropertyKeyHook();

    protected abstract String getExpireKeyHook();

    protected abstract String getTerminateKeyHook();

    protected abstract String getSuspendKeyHook();

    protected abstract ProtocolGenericActionBean buildProtocolGenericActionBean(String var1, String var2);

    protected ReviewCommentsService getReviewCommentsService() {
        return KraServiceLocator.getService(this.getReviewCommentsServiceClassHook());
    }

    protected abstract Class<? extends ReviewCommentsService> getReviewCommentsServiceClassHook();

    protected ProtocolApproveBean buildProtocolApproveBean(String actionTypeCode, String errorPropertyKey) throws Exception {
        ProtocolApproveBean bean = this.getNewProtocolApproveBeanInstanceHook(this, errorPropertyKey);
        bean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        ProtocolActionBase protocolAction = this.findProtocolAction(actionTypeCode, this.getProtocol().getProtocolActions(), this.getProtocol().getProtocolSubmission());
        if (protocolAction != null) {
            bean.setComments(protocolAction.getComments());
            bean.setActionDate(new Date(protocolAction.getActionDate().getTime()));
        }
        bean.setApprovalDate(this.buildApprovalDate(this.getProtocol()));
        bean.setExpirationDate(this.buildExpirationDate(this.getProtocol(), bean.getApprovalDate()));
        return bean;
    }

    protected abstract ProtocolApproveBean getNewProtocolApproveBeanInstanceHook(ActionHelperBase var1, String var2);

    protected Date buildApprovalDate(ProtocolBase protocol) {
        Date approvalDate = protocol.getApprovalDate();
        if (approvalDate == null || protocol.isNew() || protocol.isRenewal()) {
            CommitteeScheduleBase committeeSchedule = protocol.getProtocolSubmission().getCommitteeSchedule();
            approvalDate = committeeSchedule != null ? committeeSchedule.getScheduledDate() : new Date(System.currentTimeMillis());
        }
        return approvalDate;
    }

    protected Date buildExpirationDate(ProtocolBase protocol, Date approvalDate) {
        Date expirationDate = protocol.getExpirationDate();
        if (expirationDate == null || protocol.isNew() || protocol.isRenewal()) {
            java.util.Date newExpirationDate = DateUtils.addYears((java.util.Date)approvalDate, (int)1);
            newExpirationDate = DateUtils.addDays((java.util.Date)newExpirationDate, (int)-1);
            expirationDate = DateUtils.convertToSqlDate(newExpirationDate);
        }
        return expirationDate;
    }

    protected ProtocolActionBase findProtocolAction(String actionTypeCode, List<ProtocolActionBase> protocolActions, ProtocolSubmissionBase currentSubmission) {
        for (ProtocolActionBase pa : protocolActions) {
            if (!pa.getProtocolActionType().getProtocolActionTypeCode().equals(actionTypeCode) || pa.getProtocolSubmission() != null && !pa.getProtocolSubmission().equals(currentSubmission)) continue;
            return pa;
        }
        return null;
    }

    public void initAmendmentBeans(boolean forceReset) throws Exception {
        if (this.protocolAmendmentBean == null || forceReset) {
            this.protocolAmendmentBean = this.createAmendmentBean();
        }
        if (this.protocolRenewAmendmentBean == null || forceReset) {
            this.protocolRenewAmendmentBean = this.createAmendmentBean();
        }
    }

    protected ProtocolAmendmentBean createAmendmentBean() throws Exception {
        this.protocolAmendmentBean = this.getNewProtocolAmendmentBeanInstanceHook(this);
        this.protocolRenewAmendmentBean = this.getNewProtocolAmendmentBeanInstanceHook(this);
        this.configureAmendmentBean(this.protocolAmendmentBean);
        this.configureAmendmentBean(this.protocolRenewAmendmentBean);
        return this.protocolAmendmentBean;
    }

    protected ProtocolAmendmentBean configureAmendmentBean(ProtocolAmendmentBean amendmentBean) throws Exception {
        List<String> moduleTypeCodes;
        if (StringUtils.isNotEmpty((String)this.getProtocol().getProtocolNumber()) && (this.getProtocol().isAmendment() || this.getProtocol().isRenewal())) {
            moduleTypeCodes = this.getProtocolAmendRenewServiceHook().getAvailableModules(this.getProtocol().getAmendedProtocolNumber());
            this.populateExistingAmendmentBean(amendmentBean, moduleTypeCodes);
        } else {
            moduleTypeCodes = this.getProtocolAmendRenewServiceHook().getAvailableModules(this.getProtocol().getProtocolNumber());
        }
        for (String moduleTypeCode : moduleTypeCodes) {
            this.enableModuleOption(moduleTypeCode, amendmentBean);
        }
        return amendmentBean;
    }

    private AdminCorrectionBean createAdminCorrectionBean() throws Exception {
        AdminCorrectionBean adminCorrectionBean = this.getNewAdminCorrectionBeanInstanceHook(this);
        List<String> moduleTypeCodes = this.getProtocolAmendRenewServiceHook().getAvailableModules(this.getProtocol().getProtocolNumber());
        for (String moduleTypeCode : moduleTypeCodes) {
            this.enableModuleOption(moduleTypeCode, adminCorrectionBean);
        }
        return adminCorrectionBean;
    }

    public void prepareView() throws Exception {
        this.protocolSubmitAction.prepareView();
        this.canSubmitProtocol = this.hasSubmitProtocolPermission();
        this.canSubmitProtocolUnavailable = this.hasSubmitProtocolUnavailablePermission();
        this.assignToAgendaBean.prepareView();
        this.canCreateAmendment = this.hasCreateAmendmentPermission();
        this.canCreateAmendmentUnavailable = this.hasCreateAmendmentUnavailablePermission();
        this.canModifyAmendmentSections = this.hasModifyAmendmentSectionsPermission();
        this.canModifyAmendmentSectionsUnavailable = this.hasModifyAmendmentSectionsUnavailablePermission();
        this.canCreateRenewal = this.hasCreateRenewalPermission();
        this.canCreateRenewalUnavailable = this.hasCreateRenewalUnavailablePermission();
        this.canWithdraw = this.hasWithdrawPermission();
        this.canWithdrawUnavailable = this.hasWithdrawUnavailablePermission();
        this.canDeleteProtocolAmendRenew = this.hasDeleteProtocolAmendRenewPermission();
        this.canDeleteProtocolAmendRenewUnavailable = this.hasDeleteProtocolAmendRenewUnavailablePermission();
        this.canAssignToAgenda = this.hasAssignToAgendaPermission();
        this.canAssignToAgendaUnavailable = this.hasAssignToAgendaUnavailablePermission();
        this.canApproveFull = this.hasFullApprovePermission();
        this.canApproveFullUnavailable = this.hasFullApproveUnavailablePermission();
        this.canDisapprove = this.hasDisapprovePermission();
        this.canDisapproveUnavailable = this.hasDisapproveUnavailablePermission();
        this.canReturnForSMR = this.hasReturnForSMRPermission();
        this.canReturnForSMRUnavailable = this.hasReturnForSMRUnavailablePermission();
        this.canReturnForSRR = this.hasReturnForSRRPermission();
        this.canReturnForSRRUnavailable = this.hasReturnForSRRUnavailablePermission();
        this.canSuspend = this.hasSuspendPermission();
        this.canSuspendUnavailable = this.hasSuspendUnavailablePermission();
        this.canExpire = this.hasExpirePermission();
        this.canExpireUnavailable = this.hasExpireUnavailablePermission();
        this.canTerminate = this.hasTerminatePermission();
        this.canTerminateUnavailable = this.hasTerminateUnavailablePermission();
        this.canMakeAdminCorrection = this.hasAdminCorrectionPermission();
        this.canMakeAdminCorrectionUnavailable = this.hasAdminCorrectionUnavailablePermission();
        this.canAdministrativelyApprove = this.hasAdministrativelyApprovePermission();
        this.canAdministrativelyApproveUnavailable = this.hasAdministrativelyApproveUnavailablePermission();
        this.canAdministrativelyWithdraw = this.hasAdministrativelyWithdrawPermission();
        this.canAdministrativelyWithdrawUnavailable = this.hasAdministrativelyWithdrawUnavailablePermission();
        this.canAdministrativelyMarkIncomplete = this.hasAdministrativelyMarkIncompletePermission();
        this.canAdministrativelyMarkIncompleteUnavailable = this.hasAdministrativelyMarkIncompleteUnavailablePermission();
        this.canRecordCommitteeDecision = this.hasRecordCommitteeDecisionPermission();
        this.canRecordCommitteeDecisionUnavailable = this.hasRecordCommitteeDecisionUnavailablePermission();
        this.canUndoLastAction = this.hasUndoLastActionPermission();
        this.canUndoLastActionUnavailable = this.hasUndoLastActionUnavailablePermission();
        this.canModifyProtocolSubmission = this.hasCanModifySubmissionPermission();
        this.canModifyProtocolSubmissionUnavailable = this.hasCanModifySubmissionUnavailablePermission();
        this.canManageReviewComments = this.hasManageReviewCommentsPermission();
        this.canManageReviewCommentsUnavailable = this.hasManageReviewCommentsUnavailablePermission();
        this.canAbandon = this.hasAbandonProtocolPermission();
        this.followupActionActions = this.getFollowupActionService().getFollowupsForProtocol(this.form.getProtocolDocument().getProtocol());
        this.canViewOnlineReviewers = this.hasCanViewOnlineReviewersPermission();
        this.canViewOnlineReviewerComments = this.hasCanViewOnlineReviewerCommentsPermission();
        this.canAddSuspendReviewerComments = this.hasSuspendPermission();
        this.canAddTerminateReviewerComments = this.hasTerminatePermission();
        this.initSubmissionDetails();
        this.initAmendmentBeans(false);
        this.initPrintQuestionnaire();
    }

    protected void populateReviewersAndOnlineReviewsMap() {
        String protocolNum = this.getProtocol().getProtocolNumber();
        this.currentReviewers = this.getReviewerCommentsService().getProtocolReviewers(protocolNum, this.currentSubmissionNumber);
        List<ProtocolOnlineReviewBase> activeReviews = this.getReviewerCommentsService().getProtocolOnlineReviews(protocolNum, this.currentSubmissionNumber);
        for (ProtocolOnlineReviewBase review : activeReviews) {
            this.getOnlineReviewsMap().put(review.getProtocolReviewer().getProtocolReviewerId().toString(), review);
        }
    }

    private boolean hasAdministrativelyApprovePermission() {
        ProtocolTaskBase task = this.getNewAdminApproveProtocolTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewAdminApproveProtocolTaskInstanceHook(ProtocolBase var1);

    private boolean hasAdministrativelyApproveUnavailablePermission() {
        ProtocolTaskBase task = this.getNewAdminApproveUnavailableProtocolTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewAdminApproveUnavailableProtocolTaskInstanceHook(ProtocolBase var1);

    protected boolean hasExpirePermission() {
        ProtocolTaskBase task = this.getExpireTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getExpireTaskInstanceHook(ProtocolBase var1);

    protected boolean hasExpireUnavailablePermission() {
        ProtocolTaskBase task = this.getExpireUnavailableTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getExpireUnavailableTaskInstanceHook(ProtocolBase var1);

    private boolean hasAdministrativelyWithdrawPermission() {
        ProtocolTaskBase task = this.getNewAdminWithdrawProtocolTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewAdminWithdrawProtocolTaskInstanceHook(ProtocolBase var1);

    private boolean hasAdministrativelyWithdrawUnavailablePermission() {
        ProtocolTaskBase task = this.getNewAdminWithdrawUnavailableProtocolTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewAdminWithdrawUnavailableProtocolTaskInstanceHook(ProtocolBase var1);

    private boolean hasAdministrativelyMarkIncompletePermission() {
        ProtocolTaskBase task = this.getNewAdminMarkIncompleteProtocolTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewAdminMarkIncompleteProtocolTaskInstanceHook(ProtocolBase var1);

    private boolean hasAdministrativelyMarkIncompleteUnavailablePermission() {
        ProtocolTaskBase task = this.getNewAdminMarkIncompleteUnavailableProtocolTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewAdminMarkIncompleteUnavailableProtocolTaskInstanceHook(ProtocolBase var1);

    public void prepareCommentsView() {
        this.protocolAdminApprovalBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.assignToAgendaBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolFullApprovalBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolDisapproveBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolSMRBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolSRRBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolSuspendBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolExpireBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolTerminateBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.committeeDecision.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolManageReviewCommentsBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.getProtocol().getProtocolSubmission().refreshReferenceObject("reviewAttachments");
        this.protocolManageReviewCommentsBean.getReviewAttachmentsBean().setReviewAttachments(this.getProtocol().getProtocolSubmission().getReviewAttachments());
        if (CollectionUtils.isNotEmpty(this.protocolManageReviewCommentsBean.getReviewAttachmentsBean().getReviewAttachments())) {
            this.protocolManageReviewCommentsBean.getReviewAttachmentsBean().setHideReviewerName(this.getReviewerCommentsService().setHideReviewerName(this.protocolManageReviewCommentsBean.getReviewAttachmentsBean().getReviewAttachments()));
        }
        this.protocolReturnToPIBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
    }

    protected List<CommitteeScheduleMinuteBase> getCopiedReviewComments() {
        List<CommitteeScheduleMinuteBase> minutes = this.getReviewCommentsUsingScheduleOrSubmission();
        return this.cloneReviewComments(minutes);
    }

    protected List<CommitteeScheduleMinuteBase> getReviewCommentsUsingScheduleOrSubmission() {
        List<CommitteeScheduleMinuteBase> minutes;
        Long scheduleIdFk = this.getProtocol().getProtocolSubmission().getScheduleIdFk();
        if (scheduleIdFk == null) {
            int lastSubmissionNumber = this.getTotalSubmissions();
            minutes = this.getReviewerCommentsService().getReviewerComments(this.getProtocol().getProtocolNumber(), lastSubmissionNumber);
            Collections.sort(minutes, new Comparator<CommitteeScheduleMinuteBase>(){

                @Override
                public int compare(CommitteeScheduleMinuteBase csm1, CommitteeScheduleMinuteBase csm2) {
                    int retVal = 0;
                    if (csm1 != null && csm2 != null && csm1.getEntryNumber() != null && csm2.getEntryNumber() != null) {
                        retVal = csm1.getEntryNumber().compareTo(csm2.getEntryNumber());
                    }
                    return retVal;
                }
            });
        } else {
            minutes = this.getCommitteeScheduleService().getMinutesBySchedule(scheduleIdFk);
        }
        return minutes;
    }

    protected List<CommitteeScheduleMinuteBase> cloneReviewComments(List<CommitteeScheduleMinuteBase> minutes) {
        ArrayList<CommitteeScheduleMinuteBase> clonedMinutes = new ArrayList<CommitteeScheduleMinuteBase>();
        if (CollectionUtils.isNotEmpty(minutes)) {
            for (CommitteeScheduleMinuteBase minute : minutes) {
                clonedMinutes.add((CommitteeScheduleMinuteBase)minute.getCopy());
            }
        }
        return clonedMinutes;
    }

    private CommitteeScheduleServiceBase getCommitteeScheduleService() {
        if (this.committeeScheduleService == null) {
            this.committeeScheduleService = KraServiceLocator.getService(this.getCommitteeScheduleServiceClassHook());
        }
        return this.committeeScheduleService;
    }

    protected abstract Class<? extends CommitteeScheduleServiceBase> getCommitteeScheduleServiceClassHook();

    protected abstract ProtocolVersionService getProtocolVersionService();

    protected String getParameterValue(String parameterName) {
        return this.getParameterService().getParameterValueAsString(this.getProtocolDocumentBOClassHook(), parameterName);
    }

    protected abstract Class<? extends ProtocolDocumentBase> getProtocolDocumentBOClassHook();

    protected boolean hasSubmitProtocolPermission() {
        ProtocolTaskBase task = this.getNewSubmitProtocolTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewSubmitProtocolTaskInstanceHook(ProtocolBase var1);

    protected boolean hasSubmitProtocolUnavailablePermission() {
        ProtocolTaskBase task = this.getNewSubmitProtocolUnavailableTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewSubmitProtocolUnavailableTaskInstanceHook(ProtocolBase var1);

    protected boolean hasCreateAmendmentPermission() {
        ProtocolTaskBase task = this.getNewAmendmentProtocolTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected boolean hasCreateAmendmentUnavailablePermission() {
        ProtocolTaskBase task = this.getNewAmendmentProtocolUnavailableTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewAmendmentProtocolTaskInstanceHook(ProtocolBase var1);

    protected abstract ProtocolTaskBase getNewAmendmentProtocolUnavailableTaskInstanceHook(ProtocolBase var1);

    protected boolean hasModifyAmendmentSectionsPermission() {
        ProtocolTaskBase task = this.getModifyAmendmentSectionsProtocolTaskInstanceHook(this.getProtocol());
        return !this.getProtocol().isRenewalWithoutAmendment() && this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected boolean hasModifyAmendmentSectionsUnavailablePermission() {
        ProtocolTaskBase task = this.getModifyAmendmentSectionsUnavailableProtocolUnavailableTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getModifyAmendmentSectionsProtocolTaskInstanceHook(ProtocolBase var1);

    protected abstract ProtocolTaskBase getModifyAmendmentSectionsUnavailableProtocolUnavailableTaskInstanceHook(ProtocolBase var1);

    protected boolean hasCreateRenewalPermission() {
        ProtocolTaskBase task = this.getNewRenewalProtocolTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected boolean hasCreateRenewalUnavailablePermission() {
        ProtocolTaskBase task = this.getNewRenewalProtocolUnavailableTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewRenewalProtocolTaskInstanceHook(ProtocolBase var1);

    protected abstract ProtocolTaskBase getNewRenewalProtocolUnavailableTaskInstanceHook(ProtocolBase var1);

    protected boolean hasWithdrawPermission() {
        ProtocolTaskBase task = this.getNewWithdrawProtocolTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewWithdrawProtocolTaskInstanceHook(ProtocolBase var1);

    protected boolean hasWithdrawUnavailablePermission() {
        ProtocolTaskBase task = this.getNewWithdrawProtocolUnavailableTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewWithdrawProtocolUnavailableTaskInstanceHook(ProtocolBase var1);

    protected boolean hasDeleteProtocolAmendRenewPermission() {
        ProtocolTaskBase task = this.createNewAmendRenewDeleteTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase createNewAmendRenewDeleteTaskInstanceHook(ProtocolBase var1);

    protected boolean hasDeleteProtocolAmendRenewUnavailablePermission() {
        ProtocolTaskBase task = this.createNewAmendRenewDeleteUnavailableTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase createNewAmendRenewDeleteUnavailableTaskInstanceHook(ProtocolBase var1);

    protected boolean hasAssignToAgendaPermission() {
        ProtocolTaskBase task = this.createNewAssignToAgendaTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase createNewAssignToAgendaTaskInstanceHook(ProtocolBase var1);

    protected boolean hasAssignToAgendaUnavailablePermission() {
        ProtocolTaskBase task = this.createNewAssignToAgendaUnavailableTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase createNewAssignToAgendaUnavailableTaskInstanceHook(ProtocolBase var1);

    protected boolean hasFullApprovePermission() {
        return this.hasPermission("protocolApprove");
    }

    protected boolean hasFullApproveUnavailablePermission() {
        return this.hasPermission("protocolApproveUnavailable");
    }

    protected boolean hasDisapprovePermission() {
        return this.hasPermission("protocolDisapprove");
    }

    protected boolean hasDisapproveUnavailablePermission() {
        return this.hasPermission("protocolDisapproveUnavailable");
    }

    protected boolean hasReturnForSMRPermission() {
        return this.hasPermission("protocolReturnForSMR");
    }

    protected boolean hasReturnForSMRUnavailablePermission() {
        return this.hasPermission("protocolReturnForSMRUnavailable");
    }

    protected boolean hasReturnForSRRPermission() {
        return this.hasPermission("protocolReturnForSRR");
    }

    protected boolean hasReturnForSRRUnavailablePermission() {
        return this.hasPermission("protocolReturnForSRRUnavailable");
    }

    protected boolean hasSuspendPermission() {
        ProtocolTaskBase task = this.getSuspendTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getSuspendTaskInstanceHook(ProtocolBase var1);

    protected boolean hasSuspendUnavailablePermission() {
        ProtocolTaskBase task = this.getSuspendUnavailableTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getSuspendUnavailableTaskInstanceHook(ProtocolBase var1);

    protected boolean hasTerminatePermission() {
        ProtocolTaskBase task = this.getTerminateTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getTerminateTaskInstanceHook(ProtocolBase var1);

    protected boolean hasTerminateUnavailablePermission() {
        ProtocolTaskBase task = this.getTerminateUnavailableTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getTerminateUnavailableTaskInstanceHook(ProtocolBase var1);

    protected boolean hasAdminCorrectionPermission() {
        ProtocolTaskBase task = this.getAdminCorrectionProtocolTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected boolean hasAdminCorrectionUnavailablePermission() {
        ProtocolTaskBase task = this.getAdminCorrectionUnavailableProtocolTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getAdminCorrectionProtocolTaskInstanceHook(ProtocolBase var1);

    protected abstract ProtocolTaskBase getAdminCorrectionUnavailableProtocolTaskInstanceHook(ProtocolBase var1);

    protected boolean hasUndoLastActionPermission() {
        return this.hasPermission("protocolUndoLastAction") && this.undoLastActionBean.canUndoLastAction();
    }

    protected boolean hasUndoLastActionUnavailablePermission() {
        return this.hasPermission("protocolUndoLastAction") && !this.undoLastActionBean.canUndoLastAction();
    }

    protected boolean hasRecordCommitteeDecisionPermission() {
        return this.hasPermission("protocolRecordCommitteeDecision");
    }

    protected boolean hasRecordCommitteeDecisionUnavailablePermission() {
        return this.hasPermission("protocolRecordCommitteeDecisionUnavailable");
    }

    protected boolean hasManageReviewCommentsPermission() {
        return this.hasPermission("protocolManageReviewComments");
    }

    protected boolean hasManageReviewCommentsUnavailablePermission() {
        return this.hasPermission("protocolManageReviewCommentsUnavailable");
    }

    protected boolean hasAbandonProtocolPermission() {
        ProtocolTaskBase task = this.createNewAbandonTaskInstanceHook(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase createNewAbandonTaskInstanceHook(ProtocolBase var1);

    protected abstract boolean hasPermission(String var1);

    protected boolean hasFollowupAction(String actionCode) {
        for (ValidProtocolActionActionBase validProtocolActionActionBase : this.followupActionActions) {
            if (!StringUtils.equals((String)validProtocolActionActionBase.getFollowupActionCode(), (String)actionCode)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasCanViewOnlineReviewersPermission() {
        return this.getReviewerCommentsService().canViewOnlineReviewers(this.getUserIdentifier(), this.getSelectedSubmission());
    }

    protected boolean hasCanViewOnlineReviewerCommentsPermission() {
        return this.getReviewerCommentsService().canViewOnlineReviewerComments(this.getUserIdentifier(), this.getSelectedSubmission());
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        if (this.taskAuthorizationService == null) {
            this.taskAuthorizationService = KraServiceLocator.getService(TaskAuthorizationService.class);
        }
        return this.taskAuthorizationService;
    }

    public ProtocolSubmitAction getProtocolSubmitAction() {
        return this.protocolSubmitAction;
    }

    public ProtocolFormBase getProtocolForm() {
        return this.form;
    }

    public ProtocolBase getProtocol() {
        return this.form.getProtocolDocument().getProtocol();
    }

    public boolean getCanSubmitProtocol() {
        return this.canSubmitProtocol;
    }

    public boolean getCanSubmitProtocolUnavailable() {
        return this.canSubmitProtocolUnavailable;
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public String getSubmissionConstraint() {
        return this.submissionConstraint;
    }

    public ProtocolWithdrawBean getProtocolWithdrawBean() {
        return this.protocolWithdrawBean;
    }

    public ProtocolRequestBean getProtocolCloseRequestBean() {
        return this.protocolCloseRequestBean;
    }

    public ProtocolRequestBean getProtocolSuspendRequestBean() {
        return this.protocolSuspendRequestBean;
    }

    public ProtocolRequestBean getProtocolTerminateRequestBean() {
        return this.protocolTerminateRequestBean;
    }

    public ProtocolNotifyCommitteeBean getProtocolNotifyCommitteeBean() {
        return this.protocolNotifyCommitteeBean;
    }

    public ProtocolAmendmentBean getProtocolAmendmentBean() {
        return this.protocolAmendmentBean;
    }

    public void setProtocolAmendmentBean(ProtocolAmendmentBean protocolAmendmentBean) {
        this.protocolAmendmentBean = protocolAmendmentBean;
    }

    public ProtocolAmendmentBean getProtocolRenewAmendmentBean() {
        return this.protocolRenewAmendmentBean;
    }

    public ProtocolDeleteBean getProtocolDeleteBean() {
        return this.protocolDeleteBean;
    }

    public ProtocolAssignToAgendaBean getAssignToAgendaBean() {
        return this.assignToAgendaBean;
    }

    public ProtocolApproveBean getProtocolFullApprovalBean() {
        return this.protocolFullApprovalBean;
    }

    public ProtocolGenericActionBean getProtocolDisapproveBean() {
        return this.protocolDisapproveBean;
    }

    public ProtocolGenericActionBean getProtocolSMRBean() {
        return this.protocolSMRBean;
    }

    public ProtocolGenericActionBean getProtocolSRRBean() {
        return this.protocolSRRBean;
    }

    public ProtocolGenericActionBean getProtocolSuspendBean() {
        return this.protocolSuspendBean;
    }

    public ProtocolGenericActionBean getProtocolCloseBean() {
        return this.protocolCloseBean;
    }

    public ProtocolGenericActionBean getProtocolExpireBean() {
        return this.protocolExpireBean;
    }

    public ProtocolGenericActionBean getProtocolTerminateBean() {
        return this.protocolTerminateBean;
    }

    public AdminCorrectionBean getProtocolAdminCorrectionBean() {
        return this.protocolAdminCorrectionBean;
    }

    public UndoLastActionBean getUndoLastActionBean() {
        return this.undoLastActionBean;
    }

    public CommitteeDecision<?> getCommitteeDecision() {
        return this.committeeDecision;
    }

    protected abstract ProtocolTaskBase getModifySubmissionAvailableTaskHook();

    protected abstract ProtocolTaskBase getModifySubmissionUnavailableTaskHook();

    protected boolean hasCanModifySubmissionPermission() {
        ProtocolTaskBase task = this.getModifySubmissionAvailableTaskHook();
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected boolean hasCanModifySubmissionUnavailablePermission() {
        ProtocolTaskBase task = this.getModifySubmissionUnavailableTaskHook();
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    public ProtocolGenericActionBean getProtocolManageReviewCommentsBean() {
        return this.protocolManageReviewCommentsBean;
    }

    public boolean getCanCreateAmendment() {
        return this.canCreateAmendment;
    }

    public boolean getCanCreateAmendmentUnavailable() {
        return this.canCreateAmendmentUnavailable;
    }

    public boolean getCanModifyAmendmentSections() {
        return this.canModifyAmendmentSections;
    }

    public boolean getCanModifyAmendmentSectionsUnavailable() {
        return this.canModifyAmendmentSectionsUnavailable;
    }

    public boolean getCanCreateRenewal() {
        return this.canCreateRenewal;
    }

    public boolean getCanCreateRenewalUnavailable() {
        return this.canCreateRenewalUnavailable;
    }

    public boolean getCanNotifyCommittee() {
        return this.canNotifyCommittee;
    }

    public boolean getCanNotifyCommitteeUnavailable() {
        return this.canNotifyCommitteeUnavailable;
    }

    public boolean getCanWithdraw() {
        return this.canWithdraw;
    }

    public boolean getCanWithdrawUnavailable() {
        return this.canWithdrawUnavailable;
    }

    public boolean getCanRequestSuspension() {
        return this.canRequestSuspension;
    }

    public boolean getCanRequestSuspensionUnavailable() {
        return this.canRequestSuspensionUnavailable;
    }

    public boolean getcanRequestTerminate() {
        return this.canRequestTerminate;
    }

    public boolean getcanRequestTerminateUnavailable() {
        return this.canRequestTerminateUnavailable;
    }

    public boolean getCanDeleteProtocolAmendRenew() {
        return this.canDeleteProtocolAmendRenew;
    }

    public boolean getCanDeleteProtocolAmendRenewUnavailable() {
        return this.canDeleteProtocolAmendRenewUnavailable;
    }

    public boolean getCanAssignToAgenda() {
        return this.canAssignToAgenda;
    }

    public boolean getCanAssignToAgendaUnavailable() {
        return this.canAssignToAgendaUnavailable;
    }

    public boolean getCanAssignCmtSched() {
        return this.canAssignCmtSched;
    }

    public boolean getCanAssignCmtSchedUnavailable() {
        return this.canAssignCmtSchedUnavailable;
    }

    public boolean getCanAssignReviewers() {
        return this.canAssignReviewers;
    }

    public boolean getCanAssignReviewersUnavailable() {
        return this.canAssignReviewersUnavailable;
    }

    public boolean getCanAssignReviewersCmtSel() {
        return this.canAssignReviewersCmtSel;
    }

    public boolean getCanApproveFull() {
        return this.canApproveFull;
    }

    public boolean getCanApproveFullUnavailable() {
        return this.canApproveFullUnavailable;
    }

    public boolean getCanApproveResponse() {
        return this.canApproveResponse;
    }

    public boolean getCanApproveResponseUnavailable() {
        return this.canApproveResponseUnavailable;
    }

    public boolean getCanDisapprove() {
        return this.canDisapprove;
    }

    public boolean getCanDisapproveUnavailable() {
        return this.canDisapproveUnavailable;
    }

    public boolean getCanReturnForSMR() {
        return this.canReturnForSMR;
    }

    public boolean getCanReturnForSMRUnavailable() {
        return this.canReturnForSMRUnavailable;
    }

    public boolean getCanReturnForSRR() {
        return this.canReturnForSRR;
    }

    public boolean getCanReturnForSRRUnavailable() {
        return this.canReturnForSRRUnavailable;
    }

    public boolean getCanSuspend() {
        return this.canSuspend;
    }

    public boolean getCanSuspendUnavailable() {
        return this.canSuspendUnavailable;
    }

    public boolean getCanClose() {
        return this.canClose;
    }

    public boolean getCanCloseUnavailable() {
        return this.canCloseUnavailable;
    }

    public boolean getCanExpire() {
        return this.canExpire;
    }

    public boolean getCanExpireUnavailable() {
        return this.canExpireUnavailable;
    }

    public boolean getCanTerminate() {
        return this.canTerminate;
    }

    public boolean getCanTerminateUnavailable() {
        return this.canTerminateUnavailable;
    }

    public boolean getCanPerformAdminDetermination() {
        return this.canPerformAdminDetermination;
    }

    public void setCanPerformAdminDetermination(boolean canPerformAdminDetermination) {
        this.canPerformAdminDetermination = canPerformAdminDetermination;
    }

    public boolean getCanPerformAdminDeterminationUnavailable() {
        return this.canPerformAdminDeterminationUnavailable;
    }

    public void setCanPerformAdminDeterminationUnavailable(boolean canPerformAdminDeterminationUnavailable) {
        this.canPerformAdminDeterminationUnavailable = canPerformAdminDeterminationUnavailable;
    }

    public boolean getCanAdministrativelyApprove() {
        return this.canAdministrativelyApprove;
    }

    public void setCanAdministrativelyApprove(boolean canAdministrativelyApprove) {
        this.canAdministrativelyApprove = canAdministrativelyApprove;
    }

    public boolean getCanAdministrativelyApproveUnavailable() {
        return this.canAdministrativelyApproveUnavailable;
    }

    public void setCanAdministrativelyApproveUnavailable(boolean canAdministrativelyApproveUnavailable) {
        this.canAdministrativelyApproveUnavailable = canAdministrativelyApproveUnavailable;
    }

    public boolean getCanAdministrativelyMarkIncomplete() {
        return this.canAdministrativelyMarkIncomplete;
    }

    public void setCanAdministrativelyMarkIncomplete(boolean canAdministrativelyMarkIncomplete) {
        this.canAdministrativelyMarkIncomplete = canAdministrativelyMarkIncomplete;
    }

    public boolean getCanAdministrativelyMarkIncompleteUnavailable() {
        return this.canAdministrativelyMarkIncompleteUnavailable;
    }

    public void setCanAdministrativelyMarkIncompleteUnavailable(boolean canAdministrativelyMarkIncompleteUnavailable) {
        this.canAdministrativelyMarkIncompleteUnavailable = canAdministrativelyMarkIncompleteUnavailable;
    }

    public boolean getCanAdministrativelyWithdraw() {
        return this.canAdministrativelyWithdraw;
    }

    public void setCanAdministrativelyWithdraw(boolean canAdministrativelyWithdraw) {
        this.canAdministrativelyWithdraw = canAdministrativelyWithdraw;
    }

    public boolean getCanAdministrativelyWithdrawUnavailable() {
        return this.canAdministrativelyWithdrawUnavailable;
    }

    public void setCanAdministrativelyWithdrawUnavailable(boolean canAdministrativelyWithdrawUnavailable) {
        this.canAdministrativelyWithdrawUnavailable = canAdministrativelyWithdrawUnavailable;
    }

    public void setProtocolAdminWithdrawBean(ProtocolAdministrativelyWithdrawBean protocolAdminWithdrawBean) {
        this.protocolAdminWithdrawBean = protocolAdminWithdrawBean;
    }

    public ProtocolAdministrativelyWithdrawBean getProtocolAdminWithdrawBean() {
        return this.protocolAdminWithdrawBean;
    }

    public void setProtocolAdminApprovalBean(ProtocolApproveBean protocolAdminApprovalBean) {
        this.protocolAdminApprovalBean = protocolAdminApprovalBean;
    }

    public ProtocolApproveBean getProtocolAdminApprovalBean() {
        return this.protocolAdminApprovalBean;
    }

    public void setProtocolAdminIncompleteBean(ProtocolAdministrativelyIncompleteBean protocolAdminIncompleteBean) {
        this.protocolAdminIncompleteBean = protocolAdminIncompleteBean;
    }

    public ProtocolAdministrativelyIncompleteBean getProtocolAdminIncompleteBean() {
        return this.protocolAdminIncompleteBean;
    }

    public boolean getCanMakeAdminCorrection() {
        return this.canMakeAdminCorrection;
    }

    public boolean getCanMakeAdminCorrectionUnavailable() {
        return this.canMakeAdminCorrectionUnavailable;
    }

    public boolean getCanUndoLastAction() {
        return this.canUndoLastAction;
    }

    public boolean getCanUndoLastActionUnavailable() {
        return this.canUndoLastActionUnavailable;
    }

    public boolean getCanRecordCommitteeDecision() {
        return this.canRecordCommitteeDecision;
    }

    public boolean getCanRecordCommitteeDecisionUnavailable() {
        return this.canRecordCommitteeDecisionUnavailable;
    }

    public boolean getCanModifyProtocolSubmission() {
        return this.canModifyProtocolSubmission;
    }

    public boolean getCanModifyProtocolSubmissionUnavailable() {
        return this.canModifyProtocolSubmissionUnavailable;
    }

    public boolean getCanManageReviewComments() {
        return this.canManageReviewComments;
    }

    public boolean getCanManageReviewCommentsUnavailable() {
        return this.canManageReviewCommentsUnavailable;
    }

    public boolean getCanApproveOther() {
        return this.canApproveOther;
    }

    public boolean getCanManageNotes() {
        return this.canManageNotes;
    }

    public boolean getCanManageNotesUnavailable() {
        return this.canManageNotesUnavailable;
    }

    public boolean getIsApproveOpenForFollowup() {
        return this.hasFollowupAction(this.getFullApprovalProtocolActionTypeHook());
    }

    public boolean getIsDisapproveOpenForFollowup() {
        return this.hasFollowupAction(this.getDisapprovedProtocolActionTypeHook());
    }

    public boolean getIsReturnForSMROpenForFollowup() {
        return this.hasFollowupAction(this.getSMRProtocolActionTypeHook());
    }

    public boolean getIsReturnForSRROpenForFollowup() {
        return this.hasFollowupAction(this.getSRRProtocolActionTypeHook());
    }

    public boolean isOpenForFollowup() {
        return this.getIsApproveOpenForFollowup() || this.getIsDisapproveOpenForFollowup() || this.getIsReturnForSMROpenForFollowup() || this.getIsReturnForSRROpenForFollowup();
    }

    public Map<String, Boolean> getFollowupActionMap() {
        return this.followupActionMap;
    }

    public boolean getCanViewOnlineReviewers() {
        return this.canViewOnlineReviewers;
    }

    public boolean getCanViewOnlineReviewerComments() {
        return this.canViewOnlineReviewerComments;
    }

    public boolean getCanAddSuspendReviewerComments() {
        return this.canAddSuspendReviewerComments;
    }

    public boolean getCanAddTerminateReviewerComments() {
        return this.canAddTerminateReviewerComments;
    }

    public ProtocolSummary getProtocolSummary() {
        return this.protocolSummary;
    }

    public ProtocolSummary getPrevProtocolSummary() {
        return this.prevProtocolSummary;
    }

    public void setSelectedHistoryItem(String selectedHistoryItem) {
        this.selectedHistoryItem = selectedHistoryItem;
    }

    public String getSelectedHistoryItem() {
        return this.selectedHistoryItem;
    }

    public Date getFilteredHistoryStartDate() {
        return this.filteredHistoryStartDate;
    }

    public void setFilteredHistoryStartDate(Date filteredHistoryStartDate) {
        this.filteredHistoryStartDate = filteredHistoryStartDate;
    }

    public Date getFilteredHistoryEndDate() {
        return this.filteredHistoryEndDate;
    }

    public void setFilteredHistoryEndDate(Date filteredHistoryEndDate) {
        this.filteredHistoryEndDate = filteredHistoryEndDate;
    }

    public ProtocolActionBase getLastPerformedAction() {
        List<ProtocolActionBase> protocolActions = this.form.getProtocolDocument().getProtocol().getProtocolActions();
        Collections.sort(protocolActions, new Comparator<ProtocolActionBase>(){

            @Override
            public int compare(ProtocolActionBase action1, ProtocolActionBase action2) {
                return action2.getActualActionDate().compareTo(action1.getActualActionDate());
            }
        });
        return protocolActions.size() > 0 ? protocolActions.get(0) : null;
    }

    public void initFilterDatesView() {
        java.util.Date dayBeforeStartDate = null;
        java.util.Date dayAfterEndDate = null;
        if (this.filteredHistoryStartDate != null && this.filteredHistoryEndDate != null) {
            dayBeforeStartDate = DateUtils.addDays((java.util.Date)this.filteredHistoryStartDate, (int)-1);
            dayAfterEndDate = DateUtils.addDays((java.util.Date)this.filteredHistoryEndDate, (int)1);
        }
        for (ProtocolActionBase protocolAction : this.getSortedProtocolActions()) {
            Timestamp actionDate = protocolAction.getActionDate();
            if (dayBeforeStartDate != null && dayAfterEndDate != null) {
                protocolAction.setIsInFilterView(actionDate.after(dayBeforeStartDate) && actionDate.before(dayAfterEndDate));
            } else {
                protocolAction.setIsInFilterView(true);
            }
            if (!protocolAction.getIsInFilterView()) continue;
        }
    }

    public List<ProtocolActionBase> getSortedProtocolActions() {
        ArrayList<ProtocolActionBase> protocolActions = new ArrayList<ProtocolActionBase>();
        for (ProtocolActionBase protocolAction : this.form.getProtocolDocument().getProtocol().getProtocolActions()) {
            if (protocolAction.getSubmissionNumber() != null) {
                protocolAction.setProtocolSubmissionDocs(new ArrayList<ProtocolSubmissionDocBase>(this.getSubmissionDocs(protocolAction)));
            }
            protocolActions.add(protocolAction);
        }
        Collections.sort(protocolActions, new Comparator<ProtocolActionBase>(){

            @Override
            public int compare(ProtocolActionBase action1, ProtocolActionBase action2) {
                return action2.getActualActionDate().compareTo(action1.getActualActionDate());
            }
        });
        return protocolActions;
    }

    protected Collection<? extends ProtocolSubmissionDocBase> getSubmissionDocs(ProtocolActionBase protocolAction) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("protocolNumber", protocolAction.getProtocolNumber());
        fieldValues.put("submissionNumber", protocolAction.getSubmissionNumber());
        return this.getBusinessObjectService().findMatchingOrderBy(this.getProtocolSubmissionDocClassHook(), fieldValues, "documentId", true);
    }

    protected abstract Class<? extends ProtocolSubmissionDocBase> getProtocolSubmissionDocClassHook();

    public ProtocolActionBase getSelectedProtocolAction() {
        for (ProtocolActionBase action : this.getProtocol().getProtocolActions()) {
            if (!StringUtils.equals((String)action.getProtocolActionId().toString(), (String)this.selectedHistoryItem)) continue;
            return action;
        }
        return null;
    }

    public void setCurrentSequenceNumber(int currentSequenceNumber) {
        this.currentSequenceNumber = currentSequenceNumber;
    }

    public int getCurrentSequenceNumber() {
        return this.currentSequenceNumber;
    }

    public int getSequenceCount() {
        return this.getProtocol().getSequenceNumber() + 1;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public ProtocolSubmissionBase getSelectedSubmission() {
        ProtocolSubmissionBase protocolSubmission = null;
        if (this.currentSubmissionNumber <= 0) {
            protocolSubmission = this.getProtocol().getProtocolSubmission();
        } else if (this.currentSubmissionNumber > 0) {
            for (ProtocolSubmissionBase submission : this.getProtocol().getProtocolSubmissions()) {
                if (submission.getSubmissionNumber() != this.currentSubmissionNumber) continue;
                protocolSubmission = submission;
                break;
            }
            if (protocolSubmission == null) {
                protocolSubmission = this.getProtocol().getProtocolSubmission();
                this.currentSubmissionNumber = protocolSubmission.getSubmissionNumber();
            }
        }
        return protocolSubmission;
    }

    private CommitteeServiceBase getCommitteeService() {
        return KraServiceLocator.getService(this.getCommitteeServiceClassHook());
    }

    protected abstract Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook();

    public List<CommitteeScheduleMinuteBase> getReviewComments() {
        return this.reviewComments;
    }

    protected void setReviewComments(List<CommitteeScheduleMinuteBase> reviewComments) {
        this.reviewComments = reviewComments;
    }

    public List<ProtocolVoteAbstaineeBase> getAbstainees() {
        return this.abstainees;
    }

    public void setAbstainees(List<ProtocolVoteAbstaineeBase> abstainees) {
        this.abstainees = abstainees;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public FollowupActionService<?> getFollowupActionService() {
        if (this.followupActionService == null) {
            this.followupActionService = KraServiceLocator.getService(this.getFollowupActionServiceClassHook());
        }
        return this.followupActionService;
    }

    protected abstract Class<? extends FollowupActionService<?>> getFollowupActionServiceClassHook();

    protected ReviewCommentsService getReviewerCommentsService() {
        return this.getReviewCommentsService();
    }

    protected abstract CommitteeDecisionService<? extends CommitteeDecision<?>> getCommitteeDecisionService();

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public int getCurrentSubmissionNumber() {
        return this.currentSubmissionNumber;
    }

    public void setCurrentSubmissionNumber(int currentSubmissionNumber) {
        this.currentSubmissionNumber = currentSubmissionNumber;
    }

    public abstract int getTotalSubmissions();

    public void initSummaryDetails() throws Exception {
        if (this.currentSequenceNumber == -1) {
            this.currentSequenceNumber = this.getProtocol().getSequenceNumber();
        } else if (this.currentSequenceNumber > this.getProtocol().getSequenceNumber()) {
            this.currentSequenceNumber = this.getProtocol().getSequenceNumber();
        }
        this.protocolSummary = null;
        String protocolNumber = this.getProtocol().getProtocolNumber();
        ProtocolBase protocol = this.getProtocolVersionService().getProtocolVersion(protocolNumber, this.currentSequenceNumber);
        if (protocol != null) {
            this.protocolSummary = protocol.getProtocolSummary();
        }
        this.prevProtocolSummary = null;
        if (this.currentSequenceNumber > 0 && (protocol = this.getProtocolVersionService().getProtocolVersion(protocolNumber, this.currentSequenceNumber - 1)) != null) {
            this.prevProtocolSummary = protocol.getProtocolSummary();
        }
        if (this.protocolSummary != null && this.prevProtocolSummary != null) {
            this.protocolSummary.compare(this.prevProtocolSummary);
            this.prevProtocolSummary.compare(this.protocolSummary);
        }
        this.setSummaryQuestionnaireExist(this.hasAnsweredQuestionnaire(protocol.isAmendment() || protocol.isRenewal() ? "1" : "0", protocol.getSequenceNumber().toString()));
    }

    public void initSubmissionDetails() {
        if (this.currentSubmissionNumber <= 0) {
            this.currentSubmissionNumber = this.getTotalSubmissions();
        }
        if (CollectionUtils.isNotEmpty(this.getProtocol().getProtocolSubmissions()) && this.getProtocol().getProtocolSubmissions().size() > 1) {
            this.setPrevNextFlag();
        } else {
            this.setPrevDisabled(true);
            this.setNextDisabled(true);
        }
        this.setReviewComments(this.getReviewerCommentsService().getReviewerComments(this.getProtocol().getProtocolNumber(), this.currentSubmissionNumber));
        if (CollectionUtils.isNotEmpty(this.getReviewComments())) {
            if (this.protocolManageReviewCommentsBean.getReviewCommentsBean().getReviewComments().size() == 0 && this.protocolManageReviewCommentsBean.getReviewCommentsBean().getDeletedReviewComments().size() == 0) {
                List<CommitteeScheduleMinuteBase> reviewComments = this.getReviewerCommentsService().getReviewerComments(this.getProtocol().getProtocolNumber(), this.currentSubmissionNumber);
                Collections.sort(reviewComments, new Comparator<CommitteeScheduleMinuteBase>(){

                    @Override
                    public int compare(CommitteeScheduleMinuteBase csm1, CommitteeScheduleMinuteBase csm2) {
                        int retVal = 0;
                        if (csm1 != null && csm2 != null && csm1.getEntryNumber() != null && csm2.getEntryNumber() != null) {
                            retVal = csm1.getEntryNumber().compareTo(csm2.getEntryNumber());
                        }
                        return retVal;
                    }
                });
                this.protocolManageReviewCommentsBean.getReviewCommentsBean().setReviewComments(reviewComments);
                this.getReviewerCommentsService().setHideReviewerName(reviewComments);
            }
            this.getReviewerCommentsService().setHideReviewerName(this.getReviewComments());
        }
        this.setReviewAttachments(this.getReviewerCommentsService().getReviewerAttachments(this.getProtocol().getProtocolNumber(), this.currentSubmissionNumber));
        if (CollectionUtils.isNotEmpty(this.getReviewAttachments())) {
            this.hideReviewerNameForAttachment = this.getReviewerCommentsService().setHideReviewerName(this.getReviewAttachments());
            this.getReviewerCommentsService().setHideViewButton(this.getReviewAttachments());
        }
        this.getProtocol().getProtocolSubmission().refreshReferenceObject("reviewAttachments");
        this.hideSubmissionReviewerName = this.checkToHideSubmissionReviewerName();
        this.populateReviewersAndOnlineReviewsMap();
        this.setAbstainees(this.getCommitteeDecisionService().getAbstainers(this.getProtocol().getProtocolNumber(), this.currentSubmissionNumber));
        this.setRecusers(this.getCommitteeDecisionService().getRecusers(this.getProtocol().getProtocolNumber(), this.currentSubmissionNumber));
        this.protocolSubmissionQuestionnaireHelper = this.getProtocolSubmissionQuestionnaireHelperHook(this.getProtocol(), null, Integer.toString(this.currentSubmissionNumber), true);
        this.protocolSubmissionQuestionnaireHelper.populateAnswers();
        this.setSubmissionQuestionnaireExist(!this.protocolSubmissionQuestionnaireHelper.getAnswerHeaders().isEmpty());
    }

    protected abstract ProtocolSubmissionQuestionnaireHelper getProtocolSubmissionQuestionnaireHelperHook(ProtocolBase var1, String var2, String var3, boolean var4);

    public void setCurrentTask(String currentTaskName) {
        this.currentTaskName = currentTaskName;
    }

    public String getCurrentTask() {
        return this.currentTaskName;
    }

    protected void setAmendmentDetails() throws Exception {
        if (!this.currentTaskName.equalsIgnoreCase("modifyAmendmentSections")) {
            ProtocolAmendmentBean amendmentBean = this.getProtocolAmendmentBean();
            String originalProtocolNumber = this.getProtocol().isAmendment() ? this.getProtocol().getProtocolAmendRenewal().getProtocolNumber() : this.getProtocol().getProtocolNumber();
            List<ProtocolBase> protocols = this.getProtocolAmendRenewServiceHook().getAmendmentAndRenewals(originalProtocolNumber);
            ProtocolAmendRenewalBase correctAmendment = this.getCorrectAmendment(protocols);
            if (ObjectUtils.isNotNull((Object)correctAmendment)) {
                this.setSubmissionHasNoAmendmentDetails(false);
                amendmentBean.setSummary(correctAmendment.getSummary());
                this.enableModuleOption(amendmentBean, correctAmendment);
            } else {
                this.setSubmissionHasNoAmendmentDetails(true);
            }
        }
    }

    public void setSubmissionHasNoAmendmentDetails(boolean submissionHasNoAmendmentDetails) {
        this.submissionHasNoAmendmentDetails = submissionHasNoAmendmentDetails;
    }

    public boolean getSubmissionHasNoAmendmentDetails() {
        return this.submissionHasNoAmendmentDetails;
    }

    protected ProtocolAmendRenewalBase getCorrectAmendment(List<ProtocolBase> protocols) {
        for (ProtocolBase protocol : protocols) {
            if (!protocol.isAmendment() || !ObjectUtils.isNotNull((Object)protocol.getProtocolSubmission().getSubmissionNumber()) || protocol.getProtocolSubmission().getSubmissionNumber() != this.currentSubmissionNumber) continue;
            return protocol.getProtocolAmendRenewal();
        }
        return null;
    }

    protected boolean hasAnsweredQuestionnaire(String moduleSubItemCode, String moduleSubItemKey) {
        return this.getAnswerHeaderCount(moduleSubItemCode, moduleSubItemKey) > 0;
    }

    public int getAnswerHeaderCount(String moduleSubItemCode, String moduleSubItemKey) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleItemCode", this.getCoeusModule());
        fieldValues.put("moduleItemKey", this.getProtocol().getProtocolNumber());
        fieldValues.put("moduleSubItemCode", moduleSubItemCode);
        fieldValues.put("moduleSubItemKey", moduleSubItemKey);
        return this.getBusinessObjectService().countMatching(AnswerHeader.class, fieldValues);
    }

    protected abstract String getCoeusModule();

    protected abstract ModuleQuestionnaireBean getQuestionnaireBean(String var1, String var2, String var3, String var4, boolean var5);

    protected boolean hasSubmissionQuestionnaire() {
        ModuleQuestionnaireBean moduleQuestionnaireBean = this.getQuestionnaireBean(this.getCoeusModule(), this.getProtocolForm().getProtocolDocument().getProtocol().getProtocolNumber(), "2", "999", true);
        return CollectionUtils.isNotEmpty(this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean));
    }

    protected QuestionnaireAnswerService getQuestionnaireAnswerService() {
        if (this.questionnaireAnswerService == null) {
            this.questionnaireAnswerService = KraServiceLocator.getService(QuestionnaireAnswerService.class);
        }
        return this.questionnaireAnswerService;
    }

    public int getPrevSubmissionNumber() {
        Integer submissionNumber;
        List<Integer> submissionNumbers = this.getAvailableSubmissionNumbers();
        if (!submissionNumbers.contains(submissionNumber = Integer.valueOf(this.currentSubmissionNumber - 1))) {
            for (int i = this.currentSubmissionNumber - 1; i > 0; --i) {
                if (!submissionNumbers.contains(i)) continue;
                submissionNumber = i;
                break;
            }
        }
        return submissionNumber;
    }

    public int getNextSubmissionNumber() {
        List<Integer> submissionNumbers = this.getAvailableSubmissionNumbers();
        int maxSubmissionNumber = this.getMaxSubmissionNumber();
        Integer submissionNumber = this.currentSubmissionNumber + 1;
        if (!submissionNumbers.contains(submissionNumber)) {
            for (int i = this.currentSubmissionNumber + 1; i <= maxSubmissionNumber; ++i) {
                if (!submissionNumbers.contains(i)) continue;
                submissionNumber = i;
                break;
            }
        }
        return submissionNumber;
    }

    protected List<Integer> getAvailableSubmissionNumbers() {
        ArrayList<Integer> submissionNumbers = new ArrayList<Integer>();
        for (ProtocolSubmissionBase submission : this.getProtocol().getProtocolSubmissions()) {
            submissionNumbers.add(submission.getSubmissionNumber());
        }
        return submissionNumbers;
    }

    protected int getMaxSubmissionNumber() {
        int maxSubmissionNumber = 0;
        for (Integer submissionNumber : this.getAvailableSubmissionNumbers()) {
            if (submissionNumber <= maxSubmissionNumber) continue;
            maxSubmissionNumber = submissionNumber;
        }
        return maxSubmissionNumber;
    }

    protected void setPrevNextFlag() {
        int maxSubmissionNumber = 0;
        int minSubmissionNumber = 0;
        this.setPrevDisabled(false);
        this.setNextDisabled(false);
        for (ProtocolSubmissionBase submission : this.getProtocol().getProtocolSubmissions()) {
            if (submission.getSubmissionNumber() > maxSubmissionNumber) {
                maxSubmissionNumber = submission.getSubmissionNumber();
            }
            if (submission.getSubmissionNumber() >= minSubmissionNumber && minSubmissionNumber != 0) continue;
            minSubmissionNumber = submission.getSubmissionNumber();
        }
        if (this.currentSubmissionNumber == minSubmissionNumber) {
            this.setPrevDisabled(true);
        }
        if (this.currentSubmissionNumber == maxSubmissionNumber) {
            this.setNextDisabled(true);
        }
    }

    public boolean getHasAmendments() throws Exception {
        List protocols;
        this.hasAmendments = this.getProtocol().isAmendment() ? true : !(protocols = (List)this.getProtocolAmendRenewServiceHook().getAmendments(this.getProtocol().getProtocolNumber())).isEmpty();
        return this.hasAmendments;
    }

    public boolean getHasRenewals() throws Exception {
        List protocols;
        this.hasRenewals = this.getProtocol().isRenewal() ? true : !(protocols = (List)this.getProtocolAmendRenewServiceHook().getRenewals(this.getProtocol().getProtocolNumber())).isEmpty();
        return this.hasRenewals;
    }

    public List<ProtocolVoteRecusedBase> getRecusers() {
        return this.recusers;
    }

    public void setRecusers(List<ProtocolVoteRecusedBase> recusers) {
        this.recusers = recusers;
    }

    public boolean isShowCommittee() {
        return "O".equals(this.getSubmissionConstraint()) || "M".equals(this.getSubmissionConstraint());
    }

    public boolean isPrevDisabled() {
        return this.prevDisabled;
    }

    public void setPrevDisabled(boolean prevDisabled) {
        this.prevDisabled = prevDisabled;
    }

    public boolean isNextDisabled() {
        return this.nextDisabled;
    }

    public void setNextDisabled(boolean nextDisabled) {
        this.nextDisabled = nextDisabled;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public String getRenewalSummary() {
        return this.renewalSummary;
    }

    public void setRenewalSummary(String renewalSummary) {
        this.renewalSummary = renewalSummary;
    }

    public void setProtocolSummaryPrintOptions(ProtocolSummaryPrintOptions protocolSumamryPrintOptions) {
        this.protocolSummaryPrintOptions = protocolSumamryPrintOptions;
    }

    public ProtocolSummaryPrintOptions getProtocolSummaryPrintOptions() {
        return this.protocolSummaryPrintOptions;
    }

    public ProtocolActionBean getActionBean(String taskName) {
        return this.actionBeanTaskMap.get(taskName);
    }

    public Boolean getSummaryReport() {
        return this.summaryReport;
    }

    public void setSummaryReport(Boolean summaryReport) {
        this.summaryReport = summaryReport;
    }

    public Boolean getFullReport() {
        return this.fullReport;
    }

    public void setFullReport(Boolean fullReport) {
        this.fullReport = fullReport;
    }

    public Boolean getHistoryReport() {
        return this.historyReport;
    }

    public void setHistoryReport(Boolean historyReport) {
        this.historyReport = historyReport;
    }

    public Boolean getReviewCommentsReport() {
        return this.reviewCommentsReport;
    }

    public void setReviewCommentsReport(Boolean reviewCommentsReport) {
        this.reviewCommentsReport = reviewCommentsReport;
    }

    public ProtocolSummaryPrintOptions getProtocolPrintOption() {
        return this.protocolPrintOption;
    }

    public void setProtocolPrintOption(ProtocolSummaryPrintOptions protocolPrintOption) {
        this.protocolPrintOption = protocolPrintOption;
    }

    public List<QuestionnairePrintOption> getQuestionnairesToPrints() {
        return this.questionnairesToPrints;
    }

    public void setQuestionnairesToPrints(List<QuestionnairePrintOption> questionnairesToPrints) {
        this.questionnairesToPrints = questionnairesToPrints;
    }

    private void initPrintQuestionnaire() {
        this.setQuestionnairesToPrints(new ArrayList<QuestionnairePrintOption>());
        ProtocolModuleQuestionnaireBeanBase moduleQuestionnaireBean = this.getNewProtocolModuleQuestionnaireBeanInstanceHook(this.getProtocol());
        List<AnswerHeader> answerHeaders = this.getQuestionnaireAnswerService().getAnswerHeadersForProtocol(moduleQuestionnaireBean, this.getProtocol().getProtocolNumber());
        this.setupQnPrintOption(answerHeaders);
    }

    private void setupQnPrintOption(List<AnswerHeader> answerHeaders) {
        this.getProtocolQuestionnairePrintingServiceHook().setupQnPrintOption(answerHeaders, this.getProtocol(), this.getQuestionnairesToPrints());
    }

    protected abstract ProtocolQuestionnairePrintingService getProtocolQuestionnairePrintingServiceHook();

    public boolean isSummaryQuestionnaireExist() {
        return this.summaryQuestionnaireExist;
    }

    public void setSummaryQuestionnaireExist(boolean summaryQuestionnaireExist) {
        this.summaryQuestionnaireExist = summaryQuestionnaireExist;
    }

    public boolean isCanAbandon() {
        return this.canAbandon;
    }

    public void setCanAbandon(boolean canAbandon) {
        this.canAbandon = canAbandon;
    }

    public ProtocolGenericActionBean getProtocolAbandonBean() {
        return this.protocolAbandonBean;
    }

    public void setProtocolAbandonBean(ProtocolGenericActionBean protocolAbandonBean) {
        this.protocolAbandonBean = protocolAbandonBean;
    }

    public boolean isHideReviewerName() {
        return this.hideReviewerName;
    }

    public void setHideReviewerName(boolean hideReviewerName) {
        this.hideReviewerName = hideReviewerName;
    }

    protected boolean checkToHideSubmissionReviewerName() {
        boolean isHide = true;
        for (CommitteeScheduleMinuteBase reviewComment : this.getReviewComments()) {
            if (!reviewComment.isDisplayReviewerName()) continue;
            isHide = false;
            break;
        }
        return isHide;
    }

    protected boolean checkToHideReviewName() {
        boolean isHide = true;
        if (this.getProtocol().getProtocolSubmission().getSubmissionId() != null) {
            isHide = this.getReviewerCommentsService().setHideReviewerName(this.getProtocol(), this.getProtocol().getProtocolSubmission().getSubmissionNumber());
        }
        return isHide;
    }

    public boolean isHideSubmissionReviewerName() {
        return this.hideSubmissionReviewerName;
    }

    public void setHideSubmissionReviewerName(boolean hideSubmissionReviewerName) {
        this.hideSubmissionReviewerName = hideSubmissionReviewerName;
    }

    public List<? extends ProtocolReviewAttachmentBase> getReviewAttachments() {
        return this.reviewAttachments;
    }

    public void setReviewAttachments(List<? extends ProtocolReviewAttachmentBase> reviewAttachments) {
        this.reviewAttachments = reviewAttachments;
    }

    public boolean isHideReviewerNameForAttachment() {
        return this.hideReviewerNameForAttachment;
    }

    public void setHideReviewerNameForAttachment(boolean hideReviewerNameForAttachment) {
        this.hideReviewerNameForAttachment = hideReviewerNameForAttachment;
    }

    public ProtocolCorrespondence getProtocolCorrespondence() {
        return this.protocolCorrespondence;
    }

    public void setProtocolCorrespondence(ProtocolCorrespondence protocolCorrespondence) {
        this.protocolCorrespondence = protocolCorrespondence;
    }

    protected KraAuthorizationService getKraAuthorizationService() {
        if (this.kraAuthorizationService == null) {
            this.kraAuthorizationService = KraServiceLocator.getService(KraAuthorizationService.class);
        }
        return this.kraAuthorizationService;
    }

    protected abstract ProtocolModuleQuestionnaireBeanBase getNewProtocolModuleQuestionnaireBeanInstanceHook(ProtocolBase var1);

    protected abstract ProtocolAmendRenewService getProtocolAmendRenewServiceHook();

    protected abstract void populateExistingAmendmentBean(ProtocolAmendmentBean var1, List<String> var2);

    protected abstract void enableModuleOption(String var1, ProtocolEditableBean var2);

    protected abstract void enableModuleOption(ProtocolAmendmentBean var1, ProtocolAmendRenewalBase var2);

    public ProtocolGenericActionBean getProtocolReturnToPIBean() {
        return this.protocolReturnToPIBean;
    }

    public boolean isCanReturnToPI() {
        return this.canReturnToPI;
    }

    public boolean isCanReturnToPIUnavailable() {
        return this.canReturnToPIUnavailable;
    }

    public int getDefaultExpirationDateDifference() {
        return 1;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public boolean isSubmissionQuestionnaireExist() {
        return this.submissionQuestionnaireExist;
    }

    public void setSubmissionQuestionnaireExist(boolean submissionQuestionnaireExist) {
        this.submissionQuestionnaireExist = submissionQuestionnaireExist;
    }

    public boolean isToAnswerSubmissionQuestionnaire() {
        return this.toAnswerSubmissionQuestionnaire;
    }

    public void setToAnswerSubmissionQuestionnaire(boolean toAnswerSubmissionQuestionnaire) {
        this.toAnswerSubmissionQuestionnaire = toAnswerSubmissionQuestionnaire;
    }

    public ProtocolSubmissionQuestionnaireHelper getProtocolSubmissionQuestionnaireHelper() {
        return this.protocolSubmissionQuestionnaireHelper;
    }

    public void setProtocolSubmissionQuestionnaireHelper(ProtocolSubmissionQuestionnaireHelper protocolSubmissionQuestionnaireHelper) {
        this.protocolSubmissionQuestionnaireHelper = protocolSubmissionQuestionnaireHelper;
    }

    public void populateSubmissionQuestionnaires() {
        for (Map.Entry<String, ProtocolActionBean> entry : this.actionBeanTaskMap.entrySet()) {
            if (!(entry.getValue() instanceof ProtocolRequestBean)) continue;
            ProtocolRequestBean bean = (ProtocolRequestBean)entry.getValue();
            bean.getQuestionnaireHelper().setProtocol(this.getProtocol());
            bean.getQuestionnaireHelper().populateAnswers();
            bean.getQuestionnaireHelper().resetHeaderLabels();
        }
    }

    public void preSaveSubmissionQuestionnaires() {
        for (Map.Entry<String, ProtocolActionBean> entry : this.actionBeanTaskMap.entrySet()) {
            if (!(entry.getValue() instanceof ProtocolRequestBean)) continue;
            ProtocolRequestBean bean = (ProtocolRequestBean)entry.getValue();
            bean.getQuestionnaireHelper().preSave();
            this.getBusinessObjectService().save(bean.getQuestionnaireHelper().getAnswerHeaders());
        }
    }

    public List<ProtocolReviewer> getCurrentReviewers() {
        return this.currentReviewers;
    }

    public HashMap<String, ProtocolOnlineReviewBase> getOnlineReviewsMap() {
        return this.onlineReviewsMap;
    }
}

