/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolAssociateBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionTypeBase;
import org.kuali.kra.protocol.actions.ProtocolSubmissionDocBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.kra.protocol.questionnaire.ProtocolSubmissionQuestionnaireHelper;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolActionBase
extends ProtocolAssociateBase {
    private static final long serialVersionUID = -2148599171919464303L;
    private static final String NEXT_ACTION_ID_KEY = "actionId";
    private transient SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private Long protocolActionId;
    private Integer actionId;
    private Integer submissionNumber;
    private Long submissionIdFk;
    private String protocolActionTypeCode;
    private String comments;
    private Timestamp actualActionDate;
    private Timestamp actionDate;
    private String prevSubmissionStatusCode;
    private String submissionTypeCode;
    private String prevProtocolStatusCode;
    private String followupActionCode;
    @SkipVersioning
    private transient ProtocolSubmissionBase protocolSubmission;
    private ProtocolActionTypeBase protocolActionType;
    private List<ProtocolCorrespondence> protocolCorrespondences;
    private List<KcNotification> protocolNotifications;
    @SkipVersioning
    private transient List<ProtocolSubmissionDocBase> protocolSubmissionDocs;
    private transient boolean isInFilterView = true;
    private ProtocolSubmissionQuestionnaireHelper questionnaireHelper;
    private transient CommitteeServiceBase committeeService;

    public ProtocolActionBase() {
    }

    public ProtocolActionBase(ProtocolBase protocol, ProtocolSubmissionBase protocolSubmission, String protocolActionTypeCode) {
        this.initializeProtocolAction(protocol, protocolActionTypeCode);
        if (protocolSubmission != null) {
            this.setSubmissionIdFk(protocolSubmission.getSubmissionId());
            this.setSubmissionNumber(protocolSubmission.getSubmissionNumber());
        }
    }

    public ProtocolActionBase(ProtocolBase protocol, String protocolActionTypeCode) {
        this.initializeProtocolAction(protocol, protocolActionTypeCode);
    }

    protected void initializeProtocolAction(ProtocolBase protocol, String protocolActionTypeCode) {
        this.setProtocolId(protocol.getProtocolId());
        this.setProtocolNumber(protocol.getProtocolNumber());
        this.setSequenceNumber(0);
        this.setActionId(protocol.getNextValue(NEXT_ACTION_ID_KEY));
        this.setActualActionDate(new Timestamp(System.currentTimeMillis()));
        this.setActionDate(new Timestamp(System.currentTimeMillis()));
        this.setProtocolActionTypeCode(protocolActionTypeCode);
        this.setProtocol(protocol);
    }

    public Long getProtocolActionId() {
        return this.protocolActionId;
    }

    public void setProtocolActionId(Long protocolActionId) {
        this.protocolActionId = protocolActionId;
    }

    public Integer getActionId() {
        return this.actionId;
    }

    public void setActionId(Integer actionId) {
        this.actionId = actionId;
    }

    public String getProtocolActionTypeCode() {
        return this.protocolActionTypeCode;
    }

    public void setProtocolActionTypeCode(String protocolActionTypeCode) {
        this.protocolActionTypeCode = protocolActionTypeCode;
    }

    public void setSubmissionNumber(Integer submissionNumber) {
        this.submissionNumber = submissionNumber;
    }

    public Integer getSubmissionNumber() {
        return this.submissionNumber;
    }

    public Long getSubmissionIdFk() {
        return this.submissionIdFk;
    }

    public void setSubmissionIdFk(Long submissionIdFk) {
        this.submissionIdFk = submissionIdFk;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Timestamp getActualActionDate() {
        return this.actualActionDate;
    }

    public void setActualActionDate(Timestamp actualActionDate) {
        this.actualActionDate = actualActionDate;
    }

    public Timestamp getActionDate() {
        return this.actionDate;
    }

    public void setActionDate(Timestamp actionDate) {
        this.actionDate = actionDate;
    }

    public void setProtocolSubmission(ProtocolSubmissionBase protocolSubmission) {
        this.protocolSubmission = protocolSubmission;
    }

    public ProtocolSubmissionBase getProtocolSubmission() {
        if (this.submissionIdFk == null) {
            this.protocolSubmission = null;
        } else {
            this.refreshReferenceObject("protocolSubmission");
        }
        return this.protocolSubmission;
    }

    public void setProtocolActionType(ProtocolActionTypeBase protocolActionType) {
        this.protocolActionType = protocolActionType;
    }

    public ProtocolActionTypeBase getProtocolActionType() {
        if (StringUtils.isBlank((String)this.protocolActionTypeCode)) {
            this.protocolActionType = null;
        } else {
            this.refreshReferenceObject("protocolActionType");
        }
        return this.protocolActionType;
    }

    public String getActualActionDateString() {
        if (this.getActualActionDate() == null) {
            return "";
        }
        return this.getDateFormat().format(this.getActualActionDate());
    }

    public String getActionDateString() {
        if (this.getActionDate() == null) {
            return "";
        }
        return this.getDateFormat().format(this.getActionDate());
    }

    private SimpleDateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        }
        return this.dateFormat;
    }

    public String getSubmissionStatusString() {
        String status = "";
        if (this.protocolSubmission == null) {
            status = "";
        } else {
            if (this.protocolSubmission.getSubmissionStatus() == null && this.submissionIdFk != null) {
                this.protocolSubmission.refreshReferenceObject("submissionStatus");
            }
            status = this.protocolSubmission.getSubmissionStatus() == null ? "" : (this.protocolSubmission.getSubmissionStatus().getDescription() == null ? "" : this.protocolSubmission.getSubmissionStatus().getDescription());
        }
        return status;
    }

    public String getPrevSubmissionStatusCode() {
        return this.prevSubmissionStatusCode;
    }

    public void setPrevSubmissionStatusCode(String prevSubmissionStatusCode) {
        this.prevSubmissionStatusCode = prevSubmissionStatusCode;
    }

    public String getSubmissionTypeCode() {
        return this.submissionTypeCode;
    }

    public void setSubmissionTypeCode(String submissionTypeCode) {
        this.submissionTypeCode = submissionTypeCode;
    }

    public String getPrevProtocolStatusCode() {
        return this.prevProtocolStatusCode;
    }

    public void setPrevProtocolStatusCode(String prevProtocolStatusCode) {
        this.prevProtocolStatusCode = prevProtocolStatusCode;
    }

    @Override
    public void resetPersistenceState() {
        this.protocolActionId = null;
        this.submissionIdFk = null;
        for (KcNotification notification : this.getProtocolNotifications()) {
            notification.setOwningDocumentIdFk(null);
        }
    }

    public void resetForeignKeys() {
        if (this.protocolSubmission != null) {
            this.submissionIdFk = this.protocolSubmission.getSubmissionId();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.protocolActionId == null ? 0 : this.protocolActionId.hashCode());
        result = 31 * result + (this.protocolActionTypeCode == null ? 0 : this.protocolActionTypeCode.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolActionBase other = (ProtocolActionBase)obj;
        if (this.actionId == null ? other.actionId != null : !this.actionId.equals(other.actionId)) {
            return false;
        }
        return !(this.protocolActionTypeCode == null ? other.protocolActionTypeCode != null : !this.protocolActionTypeCode.equals(other.protocolActionTypeCode));
    }

    public List<ProtocolCorrespondence> getProtocolCorrespondences() {
        return this.protocolCorrespondences;
    }

    public void setProtocolCorrespondences(List<ProtocolCorrespondence> protocolCorrespondences) {
        this.protocolCorrespondences = protocolCorrespondences;
    }

    public List<KcNotification> getProtocolNotifications() {
        if (this.protocolNotifications == null) {
            this.protocolNotifications = new ArrayList<KcNotification>();
        }
        return this.protocolNotifications;
    }

    public void setProtocolNotifications(List<KcNotification> notifications) {
        this.protocolNotifications = notifications;
    }

    public List<KcNotification> getFilteredProtocolNotifications() {
        List<KcNotification> unfilteredList = this.getProtocolNotifications();
        String currentUser = GlobalVariables.getUserSession().getPrincipalName().trim();
        if (!this.getProtocol().isUserNamedInProtocol(currentUser)) {
            return unfilteredList;
        }
        ArrayList<KcNotification> filteredList = new ArrayList<KcNotification>();
        block0: for (KcNotification notification : unfilteredList) {
            if (currentUser.equals(notification.getUpdateUser())) {
                filteredList.add(notification);
                continue;
            }
            for (String recipient : notification.getRecipients().split(",")) {
                if (!currentUser.equals(recipient.trim())) continue;
                filteredList.add(notification);
                continue block0;
            }
        }
        return filteredList;
    }

    public void addProtocolNotification(KcNotification notification) {
        this.getProtocolNotifications().add(notification);
    }

    public List<ProtocolSubmissionDocBase> getProtocolSubmissionDocs() {
        return this.protocolSubmissionDocs;
    }

    public void setProtocolSubmissionDocs(List<ProtocolSubmissionDocBase> protocolSubmissionDocs) {
        this.protocolSubmissionDocs = protocolSubmissionDocs;
    }

    public boolean getIsInFilterView() {
        return this.isInFilterView;
    }

    public void setIsInFilterView(boolean isInFilterView) {
        this.isInFilterView = isInFilterView;
    }

    public String getFollowupActionCode() {
        return this.followupActionCode;
    }

    public void setFollowupActionCode(String followupActionCode) {
        this.followupActionCode = followupActionCode;
    }

    public int getAnswerHeaderCount(String moduleSubItemCode, String moduleItemKey, String moduleSubItemKey) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleItemCode", this.getCoeusModule());
        fieldValues.put("moduleItemKey", moduleItemKey);
        if (!(moduleItemKey.contains("A") || moduleItemKey.contains("R") || this.getProtocol().isAmendment() || this.getProtocol().isRenewal())) {
            fieldValues.put("moduleSubItemCode", moduleSubItemCode);
        }
        fieldValues.put("moduleSubItemKey", moduleSubItemKey);
        return this.getBusinessObjectService().countMatching(AnswerHeader.class, fieldValues);
    }

    protected String getAmendmentRenewalNumber(String comment) {
        String retVal = "";
        retVal = comment.startsWith("Amendment-") ? "A" + comment.substring(10, 13) : "R" + comment.substring(8, 11);
        return retVal;
    }

    public BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    public boolean isActiveCommitteeMember() {
        boolean result = false;
        ProtocolSubmissionBase submission = this.getSubmission();
        List<CommitteeMembershipBase> committeeMembers = this.getCommitteeService().getAvailableMembers(submission.getCommitteeId(), submission.getScheduleId());
        if (CollectionUtils.isNotEmpty(committeeMembers)) {
            for (CommitteeMembershipBase member : committeeMembers) {
                if (!StringUtils.equals((String)GlobalVariables.getUserSession().getPrincipalId(), (String)member.getPersonId())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private ProtocolSubmissionBase getSubmission() {
        ProtocolSubmissionBase submission = null;
        this.refreshReferenceObject("protocolSubmission");
        if (this.protocolSubmission != null) {
            submission = this.protocolSubmission;
        } else {
            for (ProtocolActionBase action : this.getProtocol().getSortedActions()) {
                if (action.getActionId() >= this.actionId || action.getSubmissionNumber() == null) continue;
                submission = this.getSubmissionForAction(action.getSubmissionNumber());
            }
        }
        return submission;
    }

    private ProtocolSubmissionBase getSubmissionForAction(Integer submissionNumber) {
        for (ProtocolSubmissionBase submission : this.getProtocol().getProtocolSubmissions()) {
            if (!submission.getSubmissionNumber().equals(submissionNumber)) continue;
            return submission;
        }
        return null;
    }

    public CommitteeServiceBase getCommitteeService() {
        if (this.committeeService == null) {
            this.committeeService = KraServiceLocator.getService(this.getCommitteeServiceClassHook());
        }
        return this.committeeService;
    }

    protected abstract Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook();

    public void setCommitteeService(CommitteeServiceBase committeeService) {
        this.committeeService = committeeService;
    }

    protected abstract String getCoeusModule();

    protected abstract ProtocolSubmissionQuestionnaireHelper getProtocolSubmissionQuestionnaireHelperHook(ProtocolBase var1, String var2, String var3);

    public void addNotification(KcNotification notification) {
        this.getProtocolNotifications().add(notification);
    }

    public ProtocolSubmissionQuestionnaireHelper getQuestionnaireHelper() {
        if (this.questionnaireHelper == null) {
            this.setQuestionnaireHelper(this.getProtocolSubmissionQuestionnaireHelperHook(this.getProtocol(), this.protocolActionTypeCode, this.submissionNumber == null ? null : this.submissionNumber.toString()));
            this.getQuestionnaireHelper().populateAnswers();
        }
        return this.questionnaireHelper;
    }

    public void setQuestionnaireHelper(ProtocolSubmissionQuestionnaireHelper questionnaireHelper) {
        this.questionnaireHelper = questionnaireHelper;
    }
}

