/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.copy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.copy.ProtocolCopyService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolNotepadBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.protocol.ProtocolNumberServiceBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.SystemAuthorizationService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class ProtocolCopyServiceImplBase<GenericProtocolDocument extends ProtocolDocumentBase>
implements ProtocolCopyService<GenericProtocolDocument> {
    private static final String PROTOCOL_CREATED = "ProtocolBase created";
    private DocumentService documentService;
    private SystemAuthorizationService systemAuthorizationService;
    private KraAuthorizationService kraAuthorizationService;
    private SequenceAccessorService sequenceAccessorService;

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    @Override
    public GenericProtocolDocument copyProtocol(GenericProtocolDocument srcDoc) throws Exception {
        return this.copyProtocol(srcDoc, this.getProtocolNumberServiceHook().generateProtocolNumber(), false);
    }

    public GenericProtocolDocument copyProtocol(GenericProtocolDocument srcDoc, String protocolNumber, boolean isAmendmentRenewal) throws Exception {
        GenericProtocolDocument newDoc = this.createNewProtocol(srcDoc, protocolNumber, isAmendmentRenewal);
        this.documentService.saveDocument(newDoc);
        this.initializeAuthorization(srcDoc, newDoc);
        return newDoc;
    }

    protected GenericProtocolDocument createNewProtocol(GenericProtocolDocument srcDoc, String protocolNumber, boolean isAmendmentRenewal) throws Exception {
        DocumentService docService = KRADServiceLocatorWeb.getDocumentService();
        ProtocolDocumentBase newDoc = (ProtocolDocumentBase)docService.getNewDocument(srcDoc.getClass());
        newDoc.getProtocol().setProtocolNumber(protocolNumber);
        newDoc.getProtocol().setSequenceNumber(0);
        newDoc.getDocumentHeader().setDocumentTemplateNumber(srcDoc.getDocumentNumber());
        Long nextProtocolId = this.sequenceAccessorService.getNextAvailableSequenceNumber(this.getSequenceNumberNameHook());
        newDoc.getProtocol().setProtocolId(nextProtocolId);
        this.copyOverviewProperties(srcDoc, newDoc);
        this.copyRequiredProperties(srcDoc, newDoc);
        this.copyAdditionalProperties(srcDoc, newDoc);
        this.copyProtocolLists(srcDoc, newDoc);
        if (isAmendmentRenewal && !((ProtocolDocumentBase)srcDoc).getProtocol().isAmendment() && !((ProtocolDocumentBase)srcDoc).getProtocol().isAmendment()) {
            this.removeDeletedAttachment(newDoc.getProtocol());
        }
        newDoc.getProtocol().setProtocolNumber(protocolNumber);
        this.copyCustomDataAttributeValues(srcDoc, newDoc);
        ProtocolActionBase protocolAction = this.getProtocolActionNewInstanceHook(newDoc.getProtocol(), null, this.getProtocolActionProtocolCreatedCodeHook());
        protocolAction.setComments(PROTOCOL_CREATED);
        newDoc.getProtocol().getProtocolActions().add(protocolAction);
        if (!isAmendmentRenewal) {
            newDoc.getProtocol().setAttachmentProtocols(new ArrayList<ProtocolAttachmentProtocolBase>());
            newDoc.getProtocol().setNotepads(new ArrayList<ProtocolNotepadBase>());
            if (newDoc.getProtocol().getProtocolPersons() != null) {
                for (ProtocolPersonBase person : newDoc.getProtocol().getProtocolPersons()) {
                    person.setAttachmentPersonnels(new ArrayList<ProtocolAttachmentPersonnelBase>());
                }
            }
        } else {
            this.initPersonId(newDoc.getProtocol());
        }
        this.documentService.saveDocument((Document)newDoc);
        if (isAmendmentRenewal) {
            this.refreshAttachmentsPersonnels(newDoc.getProtocol());
        }
        return (GenericProtocolDocument)newDoc;
    }

    private void removeDeletedAttachment(ProtocolBase protocol) {
        ArrayList<Integer> documentIds = new ArrayList<Integer>();
        ArrayList<ProtocolAttachmentProtocolBase> attachments = new ArrayList<ProtocolAttachmentProtocolBase>();
        for (ProtocolAttachmentProtocolBase attachment : protocol.getAttachmentProtocols()) {
            attachment.setProtocol(protocol);
            if (!"3".equals(attachment.getDocumentStatusCode())) continue;
            documentIds.add(attachment.getDocumentId());
        }
        if (!documentIds.isEmpty()) {
            for (ProtocolAttachmentProtocolBase attachment : protocol.getAttachmentProtocols()) {
                attachment.setProtocol(protocol);
                if (documentIds.contains(attachment.getDocumentId())) continue;
                attachments.add(attachment);
            }
            protocol.setAttachmentProtocols(attachments);
        }
    }

    private void initPersonId(ProtocolBase protocol) {
        for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
            Integer nextPersonId = this.sequenceAccessorService.getNextAvailableSequenceNumber(this.getSequenceNumberNameHook()).intValue();
            person.setProtocolPersonId(nextPersonId);
            for (ProtocolAttachmentPersonnelBase attachment : person.getAttachmentPersonnels()) {
                attachment.setPersonId(person.getProtocolPersonId());
            }
        }
    }

    protected void refreshAttachmentsPersonnels(ProtocolBase protocol) {
        if (protocol.getProtocolPersons() != null) {
            for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
                person.refreshReferenceObject("attachmentPersonnels");
            }
        }
    }

    protected void copyOverviewProperties(GenericProtocolDocument src, GenericProtocolDocument dest) {
        DocumentHeader srcHdr = src.getDocumentHeader();
        DocumentHeader destHdr = dest.getDocumentHeader();
        destHdr.setDocumentDescription(srcHdr.getDocumentDescription());
        destHdr.setExplanation(srcHdr.getExplanation());
        destHdr.setOrganizationDocumentNumber(srcHdr.getOrganizationDocumentNumber());
    }

    protected void copyRequiredProperties(GenericProtocolDocument srcDoc, GenericProtocolDocument destDoc) {
        destDoc.getDocumentHeader().setDocumentDescription(srcDoc.getDocumentHeader().getDocumentDescription());
        ((ProtocolDocumentBase)destDoc).getProtocol().setProtocolTypeCode(((ProtocolDocumentBase)srcDoc).getProtocol().getProtocolTypeCode());
        ((ProtocolDocumentBase)destDoc).getProtocol().setTitle(((ProtocolDocumentBase)srcDoc).getProtocol().getTitle());
        ((ProtocolDocumentBase)destDoc).getProtocol().setLeadUnitNumber(((ProtocolDocumentBase)srcDoc).getProtocol().getLeadUnitNumber());
        ((ProtocolDocumentBase)destDoc).getProtocol().setPrincipalInvestigatorId(((ProtocolDocumentBase)srcDoc).getProtocol().getPrincipalInvestigatorId());
    }

    protected void copyAdditionalProperties(GenericProtocolDocument srcDoc, GenericProtocolDocument destDoc) {
        ((ProtocolDocumentBase)destDoc).getProtocol().setFdaApplicationNumber(((ProtocolDocumentBase)srcDoc).getProtocol().getFdaApplicationNumber());
        ((ProtocolDocumentBase)destDoc).getProtocol().setReferenceNumber1(((ProtocolDocumentBase)srcDoc).getProtocol().getReferenceNumber1());
        ((ProtocolDocumentBase)destDoc).getProtocol().setReferenceNumber2(((ProtocolDocumentBase)srcDoc).getProtocol().getReferenceNumber2());
        ((ProtocolDocumentBase)destDoc).getProtocol().setDescription(((ProtocolDocumentBase)srcDoc).getProtocol().getDescription());
        ((ProtocolDocumentBase)destDoc).getProtocol().setCorrespondentIndicator(((ProtocolDocumentBase)srcDoc).getProtocol().getCorrespondentIndicator());
        ((ProtocolDocumentBase)destDoc).getProtocol().setFundingSourceIndicator(((ProtocolDocumentBase)srcDoc).getProtocol().getFundingSourceIndicator());
        ((ProtocolDocumentBase)destDoc).getProtocol().setKeyStudyPersonIndicator(((ProtocolDocumentBase)srcDoc).getProtocol().getKeyStudyPersonIndicator());
        ((ProtocolDocumentBase)destDoc).getProtocol().setRelatedProjectsIndicator(((ProtocolDocumentBase)srcDoc).getProtocol().getRelatedProjectsIndicator());
        ((ProtocolDocumentBase)destDoc).getProtocol().setReferenceIndicator(((ProtocolDocumentBase)srcDoc).getProtocol().getReferenceIndicator());
        ((ProtocolDocumentBase)destDoc).getProtocol().setSpecialReviewIndicator(((ProtocolDocumentBase)srcDoc).getProtocol().getSpecialReviewIndicator());
    }

    protected void initializeAuthorization(GenericProtocolDocument srcDoc, GenericProtocolDocument destDoc) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        this.kraAuthorizationService.addRole(userId, this.getProtocolAggregatorHook(), ((ProtocolDocumentBase)destDoc).getProtocol());
        this.kraAuthorizationService.addRole(userId, this.getProtocolApproverHook(), ((ProtocolDocumentBase)destDoc).getProtocol());
        List<Role> roles = this.systemAuthorizationService.getRoles(this.getProtocolRoleTypeHook());
        for (Role role : roles) {
            List<KcPerson> persons = this.kraAuthorizationService.getPersonsInRole(((ProtocolDocumentBase)srcDoc).getProtocol(), role.getName());
            for (KcPerson person : persons) {
                if (StringUtils.equals((String)person.getPersonId(), (String)userId)) continue;
                this.kraAuthorizationService.addRole(person.getPersonId(), role.getName(), ((ProtocolDocumentBase)destDoc).getProtocol());
            }
        }
    }

    protected void copyProtocolLists(GenericProtocolDocument srcDoc, GenericProtocolDocument destDoc) {
        ProtocolBase srcProtocol = ((ProtocolDocumentBase)srcDoc).getProtocol();
        ProtocolBase destProtocol = ((ProtocolDocumentBase)destDoc).getProtocol();
        destProtocol.setProtocolResearchAreas((List)this.deepCopy(srcProtocol.getProtocolResearchAreas()));
        destProtocol.setProtocolReferences((List)this.deepCopy(srcProtocol.getProtocolReferences()));
        destProtocol.setProtocolLocations((List)this.deepCopy(srcProtocol.getProtocolLocations()));
        destProtocol.setProtocolFundingSources((List)this.deepCopy(srcProtocol.getProtocolFundingSources()));
        destProtocol.setProtocolPersons((List)this.deepCopy(srcProtocol.getProtocolPersons()));
        destProtocol.setSpecialReviews((List)this.deepCopy(srcProtocol.getSpecialReviews()));
        destProtocol.cleanupSpecialReviews(srcProtocol);
        destProtocol.setAttachmentProtocols((List)this.deepCopy(srcProtocol.getAttachmentProtocols()));
        destProtocol.setNotepads((List)this.deepCopy(srcProtocol.getNotepads()));
    }

    protected Object deepCopy(Object obj) {
        if (obj instanceof Serializable) {
            return ObjectUtils.deepCopy((Serializable)((Serializable)obj));
        }
        return obj;
    }

    protected void copyCustomDataAttributeValues(GenericProtocolDocument srcProtocolDocument, GenericProtocolDocument destProtocolDocument) {
        ((ProtocolDocumentBase)destProtocolDocument).initialize();
        for (Map.Entry<String, CustomAttributeDocument> entry : ((ResearchDocumentBase)((Object)destProtocolDocument)).getCustomAttributeDocuments().entrySet()) {
            CustomAttributeDocument cad = ((ResearchDocumentBase)((Object)srcProtocolDocument)).getCustomAttributeDocuments().get(entry.getKey());
            if (!ObjectUtils.isNotNull((Object)((Object)cad))) continue;
            if (ObjectUtils.isNull((Object)((Object)cad.getCustomAttribute()))) {
                cad.refreshReferenceObject("customAttribute");
            }
            entry.getValue().getCustomAttribute().setValue(cad.getCustomAttribute().getValue());
        }
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    protected abstract Class<? extends ProtocolActionBase> getProtocolActionBOClassHook();

    protected abstract String getProtocolActionProtocolCreatedCodeHook();

    protected abstract String getSequenceNumberNameHook();

    protected abstract ProtocolNumberServiceBase getProtocolNumberServiceHook();

    protected abstract ProtocolActionBase getProtocolActionNewInstanceHook(ProtocolBase var1, ProtocolSubmissionBase var2, String var3);

    protected abstract String getProtocolAggregatorHook();

    protected abstract String getProtocolApproverHook();

    protected abstract String getProtocolRoleTypeHook();
}

