/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.correspondence;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.PrintableAttachment;
import org.kuali.kra.printing.service.PersonSignatureService;
import org.kuali.kra.printing.service.PrintingService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionTypeToCorrespondenceTemplateService;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolActionCorrespondenceGenerationServiceImplBase
implements ProtocolActionCorrespondenceGenerationService {
    private BusinessObjectService businessObjectService;
    private PrintingService printingService;
    private ProtocolActionTypeToCorrespondenceTemplateService protocolActionTypeToCorrespondenceTemplateService;
    private DateTimeService dateTimeService;
    private static final Log LOG = LogFactory.getLog(ProtocolActionCorrespondenceGenerationServiceImplBase.class);

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    protected PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setProtocolActionTypeToCorrespondenceTemplateService(ProtocolActionTypeToCorrespondenceTemplateService protocolActionTypeToCorrespondenceTemplateService) {
        this.protocolActionTypeToCorrespondenceTemplateService = protocolActionTypeToCorrespondenceTemplateService;
    }

    protected abstract ProtocolCorrespondence getNewProtocolCorrespondenceHook();

    protected void buildAndAttachProtocolCorrespondence(ProtocolBase protocol, byte[] data, String correspTypeCode) {
        ProtocolCorrespondence protocolCorrespondence = this.getNewProtocolCorrespondenceHook();
        protocolCorrespondence.setProtocol(protocol);
        protocolCorrespondence.setProtocolId(protocol.getProtocolId());
        protocolCorrespondence.setProtocolNumber(protocol.getProtocolNumber());
        protocolCorrespondence.setSequenceNumber(protocol.getSequenceNumber());
        protocolCorrespondence.setProtoCorrespTypeCode(correspTypeCode);
        ProtocolActionBase lastAction = protocol.getLastProtocolAction();
        protocolCorrespondence.setProtocolAction(lastAction);
        protocolCorrespondence.setActionIdFk(lastAction.getProtocolActionId());
        protocolCorrespondence.setCorrespondence(data);
        protocolCorrespondence.setActionId(lastAction.getActionId());
        protocolCorrespondence.setFinalFlag(false);
        protocolCorrespondence.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
        protocolCorrespondence.setCreateTimestamp(this.dateTimeService.getCurrentTimestamp());
        if (lastAction.getProtocolCorrespondences() == null) {
            ArrayList<ProtocolCorrespondence> correspondences = new ArrayList<ProtocolCorrespondence>();
            correspondences.add(protocolCorrespondence);
            lastAction.setProtocolCorrespondences(correspondences);
            protocol.refreshReferenceObject("protocolSubmissions");
        } else {
            lastAction.getProtocolCorrespondences().add(protocolCorrespondence);
        }
        this.getBusinessObjectService().save((PersistableBusinessObject)protocolCorrespondence);
        this.getBusinessObjectService().save((PersistableBusinessObject)protocol);
    }

    @Override
    public void generateCorrespondenceDocumentAndAttach(ProtocolActionsCorrespondenceBase printableCorrespondence) throws PrintingException {
        if (printableCorrespondence.getXSLTemplates().size() > 0) {
            ProtocolBase protocol = printableCorrespondence.getProtocol();
            AttachmentDataSource ads = this.printingService.print(printableCorrespondence);
            this.applySignatureInDocument(printableCorrespondence, ads);
            if (ads.getContent().length > 0) {
                this.buildAndAttachProtocolCorrespondence(protocol, ads.getContent(), printableCorrespondence.getProtoCorrespTypeCode());
            }
        }
    }

    @Override
    public AttachmentDataSource reGenerateCorrespondenceDocument(ProtocolActionsCorrespondenceBase printableCorrespondence) throws PrintingException {
        if (printableCorrespondence.getXSLTemplates().size() > 0) {
            ProtocolBase protocol = printableCorrespondence.getProtocol();
            AttachmentDataSource ads = this.printingService.print(printableCorrespondence);
            this.applySignatureInDocument(printableCorrespondence, ads);
            return ads;
        }
        return null;
    }

    protected void applySignatureInDocument(ProtocolActionsCorrespondenceBase printableCorrespondence, AttachmentDataSource attachmentDataSource) {
        try {
            PrintableAttachment printablePdf = (PrintableAttachment)attachmentDataSource;
            String leadUnitNumber = printableCorrespondence.getLeadUnitNumber();
            String administratorType = printableCorrespondence.getAdministratorType();
            String moduleNameSpace = printableCorrespondence.getModuleNameSpace();
            byte[] pdfBytes = printablePdf.getContent();
            PersonSignatureService personSignatureService = this.getPersonSignatureService();
            pdfBytes = personSignatureService.applySignature(leadUnitNumber, administratorType, moduleNameSpace, pdfBytes);
            printablePdf.setContent(pdfBytes);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception Occured in ProtocolActionCorrespondenceGenerationServiceImplBase. Person Signature Exception: ", (Throwable)e);
        }
    }

    protected PersonSignatureService getPersonSignatureService() {
        return KraServiceLocator.getService(PersonSignatureService.class);
    }

    @Override
    public List<ProtocolCorrespondenceTemplateBase> getCorrespondenceTemplates(String actionType) {
        List<ProtocolCorrespondenceTemplateBase> templates = this.protocolActionTypeToCorrespondenceTemplateService.getTemplatesByProtocolAction(actionType);
        return templates;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

