/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.genericactions;

import java.sql.Timestamp;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolVersionService;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.assignagenda.ProtocolAssignToAgendaService;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewService;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public abstract class ProtocolGenericActionServiceImplBase
implements ProtocolGenericActionService {
    private static final String PROTOCOL_SUBMISSION = "protocolSubmission";
    private ProtocolActionService protocolActionService;
    private DocumentService documentService;
    private ProtocolActionCorrespondenceGenerationService protocolActionCorrespondenceGenerationService;
    private ProtocolOnlineReviewService protocolOnlineReviewService;
    private ProtocolVersionService protocolVersionService;
    private ProtocolAssignToAgendaService protocolAssignToAgendaService;
    private BusinessObjectService businessObjectService;
    private KcNotificationService kcNotificationService;

    protected void performGenericAction(ProtocolBase protocol, ProtocolGenericActionBean actionBean, String protocolActionType, String newProtocolStatus) throws Exception {
        ProtocolActionBase protocolAction = this.createProtocolActionAndAttach(protocol, actionBean, protocolActionType);
        this.protocolActionService.updateProtocolStatus(protocolAction, protocol);
        protocol.setProtocolStatusCode(newProtocolStatus);
        protocol.refreshReferenceObject("protocolStatus");
        this.documentService.saveDocument((Document)protocol.getProtocolDocument());
        this.createCorrespondenceAndAttach(protocol, protocolActionType);
    }

    protected ProtocolActionBase createProtocolActionAndAttach(ProtocolBase protocol, ProtocolGenericActionBean actionBean, String protocolActionType) {
        protocol.refreshReferenceObject(PROTOCOL_SUBMISSION);
        ProtocolActionBase protocolAction = this.getNewProtocolActionInstanceHook(protocol, null, protocolActionType);
        protocolAction.setComments(actionBean.getComments());
        protocolAction.setActionDate(new Timestamp(actionBean.getActionDate().getTime()));
        protocol.getProtocolActions().add(protocolAction);
        return protocolAction;
    }

    protected abstract ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase var1, ProtocolSubmissionBase var2, String var3);

    protected abstract ProtocolActionsCorrespondenceBase getNewProtocolActionsCorrespondenceHook(String var1);

    protected void createCorrespondenceAndAttach(ProtocolBase protocol, String protocolActionType) throws PrintingException {
        ProtocolActionsCorrespondenceBase correspondence = this.getNewProtocolActionsCorrespondenceHook(protocolActionType);
        correspondence.setPrintableBusinessObject(protocol);
        correspondence.setProtocol(protocol);
        this.protocolActionCorrespondenceGenerationService.generateCorrespondenceDocumentAndAttach(correspondence);
    }

    protected void performDisapprove(ProtocolBase protocol) throws Exception {
        WorkflowDocument currentWorkflowDocument;
        if (protocol.getProtocolDocument() != null && (currentWorkflowDocument = protocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument()) != null) {
            currentWorkflowDocument.disapprove("ProtocolBase document disapproved after committee decision");
        }
    }

    protected ProtocolDocumentBase getReturnedVersionedDocument(ProtocolBase protocol) throws Exception {
        this.documentService.cancelDocument((Document)protocol.getProtocolDocument(), "ProtocolBase document cancelled - protocol has been returned for revisions.");
        return this.getVersionedDocument(protocol);
    }

    @Override
    public void recordDisapprovedInRoutingActionAndUpdateStatuses(ProtocolBase protocol, ActionTakenValue latestCurrentActionTakenVal) {
        ProtocolActionBase protocolAction = this.getNewDisapprovedInRoutingProtocolActionInstanceHook(protocol);
        protocolAction.setComments(latestCurrentActionTakenVal.getAnnotation());
        protocolAction.setActionDate(latestCurrentActionTakenVal.getActionDate());
        protocol.getProtocolActions().add(protocolAction);
        protocol.setProtocolStatusCode(this.getDisapprovedProtocolStatusCodeHook());
        protocol.refreshReferenceObject("protocolStatus");
        protocol.getProtocolSubmission().setSubmissionStatusCode(this.getProtocolSubmissionStatusRejectedInRoutingCodeHook());
        protocol.refreshReferenceObject(PROTOCOL_SUBMISSION);
        this.getBusinessObjectService().save((PersistableBusinessObject)protocol);
    }

    protected abstract String getProtocolSubmissionStatusRejectedInRoutingCodeHook();

    protected abstract String getDisapprovedProtocolStatusCodeHook();

    protected abstract ProtocolActionBase getNewDisapprovedInRoutingProtocolActionInstanceHook(ProtocolBase var1);

    @Override
    public ProtocolDocumentBase versionAfterDisapprovalInRouting(ProtocolBase oldProtocol) throws Exception {
        ProtocolDocumentBase newDocument = this.getVersionedDocument(oldProtocol);
        ProtocolBase newProtocol = newDocument.getProtocol();
        newProtocol.setProtocolStatusCode(this.getProtocolPendingInProgressStatusCodeHook());
        newProtocol.refreshReferenceObject("protocolStatus");
        newProtocol.getProtocolSubmission().setSubmissionStatusCode(this.getProtocolSubmissionStatusRejectedInRoutingCodeHook());
        newProtocol.refreshReferenceObject(PROTOCOL_SUBMISSION);
        this.getBusinessObjectService().save((PersistableBusinessObject)newProtocol);
        this.documentService.saveDocument((Document)newDocument);
        return newDocument;
    }

    protected abstract String getProtocolPendingInProgressStatusCodeHook();

    protected ProtocolDocumentBase getVersionedDocument(ProtocolBase protocol) throws Exception {
        ProtocolDocumentBase newDocument = this.protocolVersionService.versionProtocolDocument(protocol.getProtocolDocument());
        newDocument.getProtocol().setProtocolSubmission(null);
        if (!protocol.isAmendment()) {
            newDocument.getProtocol().setApprovalDate(null);
            newDocument.getProtocol().setLastApprovalDate(null);
            newDocument.getProtocol().setExpirationDate(null);
        }
        newDocument.getProtocol().refreshReferenceObject("protocolStatus");
        newDocument.getProtocol().refreshReferenceObject(PROTOCOL_SUBMISSION);
        this.documentService.saveDocument((Document)newDocument);
        return newDocument;
    }

    protected abstract String getRecallProtocolActionTypeCodeHook();

    @Override
    public void recall(ProtocolBase protocol) {
        ProtocolActionBase protocolAction = this.getNewProtocolActionInstanceHook(protocol, null, this.getRecallProtocolActionTypeCodeHook());
        protocolAction.setComments("Recalled in Routing");
        protocol.getProtocolActions().add(protocolAction);
        this.getProtocolActionService().updateProtocolStatus(protocolAction, protocol);
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setProtocolActionCorrespondenceGenerationService(ProtocolActionCorrespondenceGenerationService protocolActionCorrespondenceGenerationService) {
        this.protocolActionCorrespondenceGenerationService = protocolActionCorrespondenceGenerationService;
    }

    public void setProtocolOnlineReviewService(ProtocolOnlineReviewService protocolOnlineReviewService) {
        this.protocolOnlineReviewService = protocolOnlineReviewService;
    }

    public void setProtocolVersionService(ProtocolVersionService protocolVersionService) {
        this.protocolVersionService = protocolVersionService;
    }

    public void setProtocolAssignToAgendaService(ProtocolAssignToAgendaService protocolAssignToAgendaService) {
        this.protocolAssignToAgendaService = protocolAssignToAgendaService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }

    protected ProtocolActionService getProtocolActionService() {
        return this.protocolActionService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    protected ProtocolActionCorrespondenceGenerationService getProtocolActionCorrespondenceGenerationService() {
        return this.protocolActionCorrespondenceGenerationService;
    }

    protected ProtocolOnlineReviewService getProtocolOnlineReviewService() {
        return this.protocolOnlineReviewService;
    }

    protected ProtocolVersionService getProtocolVersionService() {
        return this.protocolVersionService;
    }

    protected ProtocolAssignToAgendaService getProtocolAssignToAgendaService() {
        return this.protocolAssignToAgendaService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    protected KcNotificationService getKcNotificationService() {
        return this.kcNotificationService;
    }
}

