/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.print;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import org.drools.core.util.StringUtils;
import org.kuali.kra.printing.print.AbstractPrint;
import org.kuali.kra.printing.util.PrintingUtils;
import org.kuali.kra.protocol.actions.print.ProtocolPrintHelper;
import org.kuali.kra.protocol.actions.print.ProtocolPrintWatermarkBase;
import org.kuali.kra.util.watermark.Watermarkable;

public abstract class ProtocolReportPrintBase
extends AbstractPrint {
    private static final long serialVersionUID = 2778568731674597840L;
    private ProtocolPrintHelper printHelper;
    private static final String ERROR_MESSAGE = "Unknown report template.";

    public abstract String getProtocolPrintType();

    @Override
    public List<Source> getXSLTemplates() {
        if (StringUtils.isEmpty((CharSequence)this.getPrintHelper().getTemplate())) {
            throw new IllegalArgumentException(ERROR_MESSAGE);
        }
        ArrayList<Source> sourceList = PrintingUtils.getXSLTforReportTemplate(this.getPrintHelper().getTemplate());
        return sourceList;
    }

    @Override
    public boolean isWatermarkEnabled() {
        return true;
    }

    @Override
    public Watermarkable getWatermarkable() {
        ProtocolPrintWatermarkBase prtocolPrintWatermark = this.getNewProtocolPrintWatermarkInstanceHook();
        prtocolPrintWatermark.setPersistableBusinessObject(this.getPrintableBusinessObject());
        return prtocolPrintWatermark;
    }

    public ProtocolPrintHelper getPrintHelper() {
        return this.printHelper;
    }

    public void setPrintHelper(ProtocolPrintHelper printHelper) {
        this.printHelper = printHelper;
    }

    protected abstract ProtocolPrintWatermarkBase getNewProtocolPrintWatermarkInstanceHook();
}

