/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.submit;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeDecisionMotionType;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.meeting.ProtocolVoteAbstaineeBase;
import org.kuali.kra.common.committee.meeting.ProtocolVoteRecusedBase;
import org.kuali.kra.protocol.ProtocolAssociateBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewTypeBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionQualifierTypeBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionStatusBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionTypeBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewAttachmentBase;

public abstract class ProtocolSubmissionBase
extends ProtocolAssociateBase {
    private static final long serialVersionUID = 2158830045312905591L;
    private Long submissionId;
    private Integer submissionNumber;
    private String scheduleId;
    private String committeeId;
    private Long committeeIdFk;
    private Long scheduleIdFk;
    private String submissionTypeCode;
    private String submissionTypeQualifierCode;
    private String submissionStatusCode;
    private String protocolReviewTypeCode;
    private Date submissionDate;
    private String comments;
    private String committeeDecisionMotionTypeCode;
    private Integer yesVoteCount;
    private Integer noVoteCount;
    private Integer recusedCount;
    private Integer abstainerCount;
    private String votingComments;
    private Boolean billable = false;
    @SkipVersioning
    private transient List<ProtocolOnlineReviewBase> protocolOnlineReviews;
    private ProtocolSubmissionTypeBase protocolSubmissionType;
    protected ProtocolSubmissionQualifierTypeBase protocolSubmissionQualifierType;
    private CommitteeDecisionMotionType committeeDecisionMotionType;
    private List<ProtocolVoteAbstaineeBase> abstainers = new ArrayList<ProtocolVoteAbstaineeBase>();
    private List<ProtocolVoteRecusedBase> recusers = new ArrayList<ProtocolVoteRecusedBase>();
    @SkipVersioning
    private transient CommitteeScheduleBase committeeSchedule;
    @SkipVersioning
    private transient List<CommitteeScheduleMinuteBase> committeeScheduleMinutes;
    @SkipVersioning
    private transient List<ProtocolReviewAttachmentBase> reviewAttachments;
    private ProtocolReviewTypeBase protocolReviewType;
    @SkipVersioning
    private transient CommitteeBase committee;
    private ProtocolSubmissionStatusBase submissionStatus;
    private String piName;

    public Integer getRecusedCount() {
        this.refreshReferenceObject("recusers");
        if (this.recusers == null) {
            return 0;
        }
        return this.recusers.size();
    }

    public void setRecusedCount(Integer recusedCount) {
        this.recusedCount = recusedCount;
    }

    public List<ProtocolVoteAbstaineeBase> getAbstainers() {
        if (this.abstainers == null || this.abstainers.size() == 0) {
            this.refreshReferenceObject("abstainers");
        }
        return this.abstainers;
    }

    public void setAbstainers(List<ProtocolVoteAbstaineeBase> abstainers) {
        this.abstainers = abstainers;
    }

    public List<ProtocolVoteRecusedBase> getRecusers() {
        if (this.recusers == null || this.recusers.size() == 0) {
            this.refreshReferenceObject("recusers");
        }
        return this.recusers;
    }

    public void setRecusers(List<ProtocolVoteRecusedBase> recusers) {
        this.recusers = recusers;
    }

    public Long getSubmissionId() {
        return this.submissionId;
    }

    public void setSubmissionId(Long submissionId) {
        this.submissionId = submissionId;
    }

    public Integer getSubmissionNumber() {
        return this.submissionNumber;
    }

    public void setSubmissionNumber(Integer submissionNumber) {
        this.submissionNumber = submissionNumber;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public String getCommitteeId() {
        return this.committeeId;
    }

    public void setCommitteeId(String committeeId) {
        this.committeeId = committeeId;
    }

    public Long getCommitteeIdFk() {
        return this.committeeIdFk;
    }

    public void setCommitteeIdFk(Long committeeIdFk) {
        this.committeeIdFk = committeeIdFk;
    }

    public Long getScheduleIdFk() {
        return this.scheduleIdFk;
    }

    public void setScheduleIdFk(Long scheduleIdFk) {
        this.scheduleIdFk = scheduleIdFk;
    }

    public String getSubmissionTypeCode() {
        return this.submissionTypeCode;
    }

    public void setSubmissionTypeCode(String submissionTypeCode) {
        this.submissionTypeCode = submissionTypeCode;
    }

    public String getSubmissionTypeQualifierCode() {
        return this.submissionTypeQualifierCode;
    }

    public void setSubmissionTypeQualifierCode(String submissionTypeQualifierCode) {
        this.submissionTypeQualifierCode = submissionTypeQualifierCode;
    }

    public String getSubmissionStatusCode() {
        return this.submissionStatusCode;
    }

    public void setSubmissionStatusCode(String submissionStatusCode) {
        this.submissionStatusCode = submissionStatusCode;
        if (StringUtils.isBlank((String)submissionStatusCode)) {
            this.submissionStatus = null;
        } else if (this.getSubmissionStatus() == null || !submissionStatusCode.equals(this.getSubmissionStatus().getProtocolSubmissionStatusCode())) {
            this.refreshReferenceObject("submissionStatus");
        }
    }

    public String getProtocolReviewTypeCode() {
        return this.protocolReviewTypeCode;
    }

    public void setProtocolReviewTypeCode(String protocolReviewTypeCode) {
        this.protocolReviewTypeCode = protocolReviewTypeCode;
    }

    public Date getSubmissionDate() {
        return this.submissionDate;
    }

    public void setSubmissionDate(Date submissionDate) {
        this.submissionDate = submissionDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getCommitteeDecisionMotionTypeCode() {
        return this.committeeDecisionMotionTypeCode;
    }

    public void setCommitteeDecisionMotionTypeCode(String committeeDecisionMotionTypeCode) {
        this.committeeDecisionMotionTypeCode = committeeDecisionMotionTypeCode;
    }

    public Integer getYesVoteCount() {
        return this.yesVoteCount;
    }

    public void setYesVoteCount(Integer yesVoteCount) {
        this.yesVoteCount = yesVoteCount;
    }

    public Integer getNoVoteCount() {
        return this.noVoteCount;
    }

    public void setNoVoteCount(Integer noVoteCount) {
        this.noVoteCount = noVoteCount;
    }

    public Integer getAbstainerCount() {
        this.refreshReferenceObject("abstainers");
        if (this.abstainers == null) {
            return 0;
        }
        return this.abstainers.size();
    }

    public void setAbstainerCount(Integer abstainerCount) {
        this.abstainerCount = abstainerCount;
    }

    public String getVotingComments() {
        return this.votingComments;
    }

    public void setVotingComments(String votingComments) {
        this.votingComments = votingComments;
    }

    public List<ProtocolOnlineReviewBase> getProtocolOnlineReviews() {
        if (this.protocolOnlineReviews == null) {
            this.refreshReferenceObject("protocolOnlineReviews");
        }
        return this.protocolOnlineReviews;
    }

    public void setProtocolOnlineReviews(List<ProtocolOnlineReviewBase> protocolOnlineReviews) {
        this.protocolOnlineReviews = protocolOnlineReviews;
    }

    public ProtocolReviewTypeBase getProtocolReviewType() {
        return this.protocolReviewType;
    }

    public void setProtocolReviewType(ProtocolReviewTypeBase protocolReviewType) {
        this.protocolReviewType = protocolReviewType;
    }

    public List<ProtocolOnlineReviewBase> getActiveProtocolOnlineReviews() {
        ArrayList<ProtocolOnlineReviewBase> activeReviews = new ArrayList<ProtocolOnlineReviewBase>();
        List<ProtocolOnlineReviewBase> allReviews = this.getProtocolOnlineReviews();
        if (allReviews != null) {
            for (ProtocolOnlineReviewBase review : allReviews) {
                if (!review.isActive()) continue;
                activeReviews.add(review);
            }
        }
        return activeReviews;
    }

    public List<ProtocolReviewer> getProtocolReviewers() {
        ArrayList<ProtocolReviewer> reviewers = new ArrayList<ProtocolReviewer>();
        List<ProtocolOnlineReviewBase> activeReviews = this.getActiveProtocolOnlineReviews();
        for (ProtocolOnlineReviewBase review : activeReviews) {
            reviewers.add(review.getProtocolReviewer());
        }
        return reviewers;
    }

    public CommitteeBase getCommittee() {
        if (this.committeeIdFk != null && this.committee == null) {
            this.refreshReferenceObject("committee");
        }
        return this.committee;
    }

    public void setCommittee(CommitteeBase committee) {
        this.committee = committee;
    }

    public ProtocolSubmissionStatusBase getSubmissionStatus() {
        if (StringUtils.isNotBlank((String)this.submissionStatusCode) && this.submissionStatus == null) {
            this.refreshReferenceObject("submissionStatus");
        }
        return this.submissionStatus;
    }

    public void setSubmissionStatus(ProtocolSubmissionStatusBase submissionStatus) {
        this.submissionStatus = submissionStatus;
    }

    public void setProtocolSubmissionType(ProtocolSubmissionTypeBase protocolSubmissionType) {
        this.protocolSubmissionType = protocolSubmissionType;
    }

    public ProtocolSubmissionTypeBase getProtocolSubmissionType() {
        if (StringUtils.isNotBlank((String)this.submissionTypeCode) && this.protocolSubmissionType == null) {
            this.refreshReferenceObject("protocolSubmissionType");
        }
        return this.protocolSubmissionType;
    }

    public void setProtocolSubmissionQualifierType(ProtocolSubmissionQualifierTypeBase protocolSubmissionQualifierType) {
        this.protocolSubmissionQualifierType = protocolSubmissionQualifierType;
    }

    public ProtocolSubmissionQualifierTypeBase getProtocolSubmissionQualifierType() {
        if (null == this.protocolSubmissionQualifierType) {
            this.protocolSubmissionQualifierType = this.getNewInstanceProtocolSubmissionQualifierTypeHook();
        }
        return this.protocolSubmissionQualifierType;
    }

    protected abstract ProtocolSubmissionQualifierTypeBase getNewInstanceProtocolSubmissionQualifierTypeHook();

    public void setCommitteeDecisionMotionType(CommitteeDecisionMotionType committeeDecisionMotionType) {
        this.committeeDecisionMotionType = committeeDecisionMotionType;
    }

    public CommitteeDecisionMotionType getCommitteeDecisionMotionType() {
        return this.committeeDecisionMotionType;
    }

    public void setCommitteeSchedule(CommitteeScheduleBase committeeSchedule) {
        this.committeeSchedule = committeeSchedule;
    }

    public CommitteeScheduleBase getCommitteeSchedule() {
        if (this.scheduleIdFk != null && this.committeeSchedule == null) {
            this.refreshReferenceObject("committeeSchedule");
        }
        return this.committeeSchedule;
    }

    public List<CommitteeScheduleMinuteBase> getCommitteeScheduleMinutes() {
        this.refreshReferenceObject("committeeScheduleMinutes");
        return this.committeeScheduleMinutes;
    }

    public void setCommitteeScheduleMinutes(List<CommitteeScheduleMinuteBase> committeeScheduleMinutes) {
        this.committeeScheduleMinutes = committeeScheduleMinutes;
    }

    @Override
    public void resetPersistenceState() {
        this.submissionId = null;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.protocolOnlineReviews);
        return managedLists;
    }

    public String getPiName() {
        return this.getProtocol().getPrincipalInvestigator() != null ? this.getProtocol().getPrincipalInvestigator().getPersonName() : "";
    }

    public void setPiName(String piName) {
        this.piName = piName;
    }

    @Override
    public boolean equals(Object o) {
        ProtocolSubmissionBase ps = (ProtocolSubmissionBase)o;
        try {
            return this.getSubmissionId().equals(ps.getSubmissionId());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isBillable() {
        return this.billable == null ? false : this.billable;
    }

    public void setBillable(boolean billable) {
        this.billable = billable;
    }

    public List<ProtocolReviewAttachmentBase> getReviewAttachments() {
        return this.reviewAttachments;
    }

    public void setReviewAttachments(List<ProtocolReviewAttachmentBase> reviewAttachments) {
        this.reviewAttachments = reviewAttachments;
    }
}

