/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.undo;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;

public abstract class UndoLastActionBeanHelperBase
implements Serializable {
    protected static final String AMEND = "A";
    protected static final String RENEW = "R";
    protected static final String AMEND_COMMENT = "Amendment-";
    protected static final String RENEW_COMMENT = "Renewal-";

    protected abstract String[] getNotUndoableActions();

    protected abstract String getApprovedActionTypeCodeHook();

    protected abstract String getDeletedProtocolStatusHook();

    public boolean canUndoLastAction(ProtocolBase protocol) {
        ProtocolActionBase action = this.getLastPerformedAction(protocol.getProtocolActions());
        if (action != null && (StringUtils.isBlank((String)action.getComments()) || !action.getProtocolActionTypeCode().equals(this.getApprovedActionTypeCodeHook()) || !action.getComments().startsWith(RENEW_COMMENT) && !action.getComments().startsWith(AMEND_COMMENT))) {
            return this.isActionUndoable(action.getProtocolActionTypeCode()) || this.isActionProtocolApproval(action, action.getProtocolNumber()) || this.isProtocolDeleted(protocol);
        }
        return false;
    }

    public ProtocolActionBase getLastPerformedAction(List<ProtocolActionBase> actionsPerformed) {
        this.sortActions(actionsPerformed);
        return actionsPerformed.size() > 0 ? actionsPerformed.get(0) : null;
    }

    protected boolean isActionUndoable(String actionTypeCode) {
        for (int i = 0; i < this.getNotUndoableActions().length; ++i) {
            if (!actionTypeCode.equalsIgnoreCase(this.getNotUndoableActions()[i])) continue;
            return false;
        }
        return true;
    }

    protected ProtocolActionBase getPrevToLastPerformedAction(List<ProtocolActionBase> actionsPerformed) {
        this.sortActions(actionsPerformed);
        return actionsPerformed.size() > 1 ? actionsPerformed.get(1) : null;
    }

    protected void sortActions(List<ProtocolActionBase> actionsPerformed) {
        Collections.sort(actionsPerformed, new Comparator<ProtocolActionBase>(){

            @Override
            public int compare(ProtocolActionBase action1, ProtocolActionBase action2) {
                return action2.getActualActionDate().compareTo(action1.getActualActionDate());
            }
        });
    }

    protected boolean isActionProtocolApproval(ProtocolActionBase action, String protocolNumber) {
        String protocolNumberUpper = protocolNumber.toUpperCase();
        boolean amendmentOrRenewal = protocolNumberUpper.contains(AMEND) || protocolNumberUpper.contains(RENEW);
        return this.getApprovedActionTypeCodeHook().equals(action.getProtocolActionTypeCode()) && !amendmentOrRenewal;
    }

    protected boolean isProtocolDeleted(ProtocolBase protocol) {
        return this.getDeletedProtocolStatusHook().equals(protocol.getProtocolStatusCode());
    }
}

